<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; use Hash; class Orders extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_pending_orders') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $account = $request->account; if(empty($request->status)){$request->status = 'pending';} $bookings = DB::table('bookings')->where('branch',$branch_id); if(!empty($request->currency)){ $bookings->where('currency',$request->currency); } if(!empty($request->status)){ $bookings->where('status',$request->status); } if(!empty($request->client)){ $bookings->where('customer',$request->client); } if(!empty($request->from)){ $bookings->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $bookings->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $bookings = json_decode(json_encode($bookings->get()),true); $this->data["pageData"] = $bookings; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["users"] = set_array_keys(fetch_table('users'),'uid'); $this->data["items"] = fetch_table_branch('items'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["status"] = $request->status; $this->data["title"] = print_lang($this->data["app_lang"],'mod_orders_view_title'); $this->data["pageToLoad"] = "orders/view.php"; $this->data["activeLink"] = "orders"; $this->load_view($this->data); } public function processed(Request $request) { if(check_user_access('view_processed_order') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $account = $request->account; $bookings = DB::table('bookings')->where('branch',$branch_id)->where('status','processed'); if(!empty($request->currency)){ $bookings->where('currency',$request->currency); } if(!empty($request->client)){ $bookings->where('customer',$request->client); } if(!empty($request->from)){ $bookings->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $bookings->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $bookings = json_decode(json_encode($bookings->get()),true); $this->data["pageData"] = $bookings; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["users"] = set_array_keys(fetch_table('users'),'uid'); $this->data["items"] = fetch_table_branch('items'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["status"] = $request->status; $this->data["title"] = print_lang($this->data["app_lang"],'mod_orders_view_title'); $this->data["pageToLoad"] = "orders/view_processed.php"; $this->data["activeLink"] = "orders"; $this->load_view($this->data); } public function process(Request $request, $uid) { if(check_user_access('process_order') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('bookings','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/bookings')->send(); } $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_orders_text'); $this->data["pageToLoad"] = "orders/process.php"; $this->data["activeLink"] = "orders"; $this->load_view($this->data); } public function process_add(Request $request) { $items_found = false; $booking_collection_of_items = array(); $booking_collection_of_items_uid = array(); $uid = $request->uid; if(count($request->item) > 0) { $items_count = 0; while($items_count < count($request->item)) { $items_found = true; $item_array = array( 'item' => $request->item[$items_count], 'qty' => (float)$request->qty[$items_count], 'qty_p' => (float)$request->qty_p[$items_count], 'tp' => (float)$request->tp[$items_count], 'memo' => $request->pro_memo[$items_count], 'total' => (float)$request->total_r[$items_count], 'total_p' => (float)$request->total_r_p[$items_count], ); $booking_collection_of_items[] = $item_array; $booking_collection_of_items_uid[] = '-++-'.$request->item[$items_count].'-++-'; $items_count++; } } if($items_found == true) { $db_array = array( 'items_processed' => json_encode($booking_collection_of_items), 'total_p' => (float)$request->total_process, 'status' => 'processed', 'approved_by' => Session::get('user_id'), 'approved_date' => date('Y-m-d H:i:s'), ); update_table('bookings','uid',$uid,$db_array); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_booking'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_processed'), 'url' => '#', 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['total_p']), ); set_activity_alert($_activity_details); $invoice_url = url('/bookings/invoice-process').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'mod_bookings_processed'), 'message_body' => print_lang($this->data["app_lang"],'mod_bookings_processed_successfully'))); } } public function update_status(Request $request) { $uids = $request->uids; $status = $request->status; if(!empty($uids)) { foreach($uids as $uid_r) { $order_data = fetch_table_where('bookings','uid',$uid_r,true); $_activity_details = array( 'module' => 'Bookings', 'activity' => 'order approved', 'url' => NULL, 'details' => 'Order Amount: '.amount_number_format($order_data['total']), ); set_activity_alert($_activity_details); $db_array_r = array( 'status' => $status, 'approved_by' => Session::get('user_id'), 'approved_date' => date('Y-m-d H:i:s'), ); update_table('bookings','uid',$uid_r,$db_array_r); } echo json_encode(array('status' => 'success', 'mode' => 'status_passed')); } else { echo json_encode(array('status' => 'error', 'mode' => 'status_passed', 'message' => 'No Item Selected')); } } }