<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Payment_deductions extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_project_payment_deductions') === FALSE){ Redirect::to('/')->send(); } $payment_deductions = DB::table('payment_deductions'); if(!empty($request->currency)){ $payment_deductions->where('currency',$request->currency); } if(!empty($request->project)){ $payment_deductions->where('project',$request->project); } if(!empty($request->from)){ $payment_deductions->where('pdate','>=',get_true_date($request->from)); } if(!empty($request->to)){ $payment_deductions->where('pdate','<=',get_true_date($request->to)); } $this->data["pageData"] = json_decode(json_encode($payment_deductions->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["projects"] = set_array_keys(fetch_table_branch('projects'),'uid'); $this->data["users"] = set_array_keys(fetch_branch_users(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_project"] = $request->project; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'payment_deductions'); $this->data["pageToLoad"] = "payment_deductions/view.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_project_payment_deductions') === FALSE){ Redirect::to('/')->send(); } $this->data["projects"] = set_array_keys(fetch_table_where_branch('projects','status','pending'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'add_payment_deduction'); $this->data["pageToLoad"] = "payment_deductions/add.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'amount' => 'required', 'pdate' => 'required', 'project' => 'required', 'from_account' => 'required', 'to_account' => 'required', ]); $validator->validate(); $uid = getUniqueId('PPDT', 'payment_deductions', 'uid'); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $request->currency, 'currency_usd_equalance' => $currency_data['usd_equalance'], 'amount' => $request->amount, 'pdate' => get_true_date($request->pdate), 'project' => $request->project, 'project_according_amount' => $request->project_according_amount, 'from_account' => $request->from_account, 'to_account' => $request->to_account, 'comments' => $request->comments, 'user' => Session::get('user_id'), ); if($request->hasFile('scan_copy')) { $file = $request->file('scan_copy'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('PPDI'); $fileNamePrefix = db_unique_id('payment_deductions',$fileNamePrefix); $scan_copy = $fileNamePrefix.'.'.$extension; $file->move('uploads/payment-deductions/',$scan_copy); $db_array['scan_copy'] = $scan_copy; } insert_table('payment_deductions',$db_array); _handle_payment_deduction_ledger_effects(['uid' => $uid, 'state' => 'new']); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'deduction_saved'), 'message_body' => print_lang($this->data["app_lang"],'deduction_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_project_payment_deductions') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('payment_deductions','uid',$uid,true); $this->data["projects"] = set_array_keys(fetch_table_where_branch('projects','status','pending'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_payment_deduction'); $this->data["pageToLoad"] = "payment_deductions/edit.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'amount' => 'required', 'pdate' => 'required', 'project' => 'required', 'from_account' => 'required', 'to_account' => 'required', ]); $validator->validate(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'currency' => $request->currency, 'currency_usd_equalance' => $currency_data['usd_equalance'], 'amount' => $request->amount, 'pdate' => get_true_date($request->pdate), 'project' => $request->project, 'project_according_amount' => $request->project_according_amount, 'from_account' => $request->from_account, 'to_account' => $request->to_account, 'comments' => $request->comments, ); $project_data = fetch_table_where('payment_deductions','uid',$uid,TRUE); if($request->hasFile('scan_copy')) { $file = $request->file('scan_copy'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('PIMG'); $fileNamePrefix = db_unique_id('payment_deductions',$fileNamePrefix); $scan_copy = $fileNamePrefix.'.'.$extension; $file->move('uploads/payment-deductions/',$scan_copy); $db_array['scan_copy'] = $scan_copy; File::delete('uploads/payment-deductions/'.$project_data["scan_copy"]); } update_table('payment_deductions','uid',$uid,$db_array); _handle_payment_deduction_ledger_effects(['uid' => $uid, 'state' => 'update']); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'deduction_updated'), 'message_body' => print_lang($this->data["app_lang"],'deduction_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_project_payment_deductions') === FALSE){ Redirect::to('/')->send(); } $project = fetch_table_where('payment_deductions','uid',$uid,TRUE); if(!empty($project["scan_copy"])){ File::delete('uploads/payment-deductions/'.$project["scan_copy"]); } delete_table('payment_deductions','uid',$uid); _handle_payment_deduction_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }