<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Payslips extends Setup { public function __construct() { parent::__construct(); } public function paid_salaries(Request $request) { if(check_user_access('paid_salaries') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $payslips = DB::table('payslips')->where('branch',$branch_id)->where('status','confirm'); $this->data["pageData"] = json_decode(json_encode($payslips->get()),true); $this->data["employees"] = set_array_keys(fetch_table_branch('employees'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'paid_salaries'); $this->data["pageToLoad"] = "payslips/paid_salaries.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function view(Request $request) { if(check_user_access('view_payslips') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $payslips = DB::table('payslips')->where('branch',$branch_id)->where('status','pending'); $this->data["pageData"] = json_decode(json_encode($payslips->get()),true); $this->data["employees"] = set_array_keys(fetch_table_branch('employees'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'payslips'); $this->data["pageToLoad"] = "payslips/view.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_payslips') === FALSE){ Redirect::to('/')->send(); } $this->data["employees"] = embed_employees_salaries(fetch_table_branch('employees')); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'new_payslip'); $this->data["pageToLoad"] = "payslips/add.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'pay_date' => 'required', 'employee' => 'required', 'account' => 'required', ]); $validator->validate(); $currency = NULL; $employee = fetch_table_where("employees","uid",$request->employee,true); $currency = $employee['currency']; $date_of_payslip = $request->pay_date; $day = date("d",strtotime($date_of_payslip)); $month = date('n',strtotime($date_of_payslip)); $year = date("Y",strtotime($date_of_payslip)); $persian_day = get_persian_date_day($date_of_payslip); $persian_month = get_persian_date_month($date_of_payslip); $persian_year = get_persian_date_year($date_of_payslip); $calander_db = fetch_calander_name(); if($calander_db == 'persian') { $if_payslip_exist = DB::table('payslips')->where('branch',active_branch_id())->where('employee',$request->employee)->where('p_pay_month',$persian_month)->where('p_pay_year',$persian_year)->count(); } else { $if_payslip_exist = DB::table('payslips')->where('branch',active_branch_id())->where('employee',$request->employee)->where('pay_month',$month)->where('pay_year',$year)->count(); } if($if_payslip_exist > 0) { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'payslip_exist'), 'message_body' => print_lang($this->data["app_lang"],'payslip_exist_message'))); die; } $uid = getUniqueId('EPAY', 'payslips', 'uid'); $earnings_details = array(); $ecount = 0; $earnings_names = $request->earning_name; $earnings_names[] = NULL; $earnings_amounts = $request->earning_amount; $earnings_amounts[] = NULL; foreach($earnings_names as $erow) { if(!empty($earnings_names[$ecount])) { $earnings_details[] = array('name' => $earnings_names[$ecount], 'amount' => $earnings_amounts[$ecount]); } $ecount++; } $deductions_details = array(); $dcount = 0; $deductions_names = $request->deduction_name; $deductions_names[] = NULL; $deductions_amounts = $request->deduction_amount; $deductions_amounts[] = NULL; foreach($earnings_names as $erow) { if(!empty($deductions_names[$dcount])) { $deductions_details[] = array('name' => $deductions_names[$dcount], 'amount' => $deductions_amounts[$dcount]); } $dcount++; } $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'pay_date' => $request->pay_date, 'pay_month' => $month, 'p_pay_month' => $persian_month, 'currency' => $currency, 'pay_year' => $year, 'p_pay_year' => $persian_year, 'employee' => $request->employee, 'basic_salary' => $request->basic_salary, 'earnings' => json_encode($earnings_details), 'advance_amount' => $request->advance_amount, 'deductions' => json_encode($deductions_details), 'total_earning' => $request->total_earning, 'total_deduction' => $request->total_deduction, 'total_month_days' => $request->total_month_days, 'total_absents' => $request->total_absents, 'total_deduction_absents' => $request->total_deduction_absents, 'net_salary' => $request->net_salary, 'account' => $request->account, 'narration' => $request->narration, ); insert_table('payslips',$db_array); $employees = set_array_keys(fetch_table_branch('employees'),'uid'); $employee_name = array_key_exists($db_array['employee'],$employees) ? $employees[$db_array['employee']]['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_payslips'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/payslips/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_employee').': '.$employee_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_salary').': '.amount_number_format($db_array['net_salary']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'payslip_created'), 'message_body' => print_lang($this->data["app_lang"],'payslip_created_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_payslips') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('payslips','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/payslips')->send(); } $this->data["employees"] = embed_employees_salaries(fetch_table_branch('employees')); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_payslip'); $this->data["pageToLoad"] = "payslips/edit.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'pay_date' => 'required', 'employee' => 'required', 'account' => 'required', ]); $validator->validate(); $currency = NULL; $employee = fetch_table_where("employees","uid",$request->employee,true); $currency = $employee['currency']; $date_of_payslip = $request->pay_date; $day = date("d",strtotime($date_of_payslip)); $month = date('n',strtotime($date_of_payslip)); $year = date("Y",strtotime($date_of_payslip)); $persian_day = get_persian_date_day($date_of_payslip); $persian_month = get_persian_date_month($date_of_payslip); $persian_year = get_persian_date_year($date_of_payslip); $earnings_details = array(); $ecount = 0; $earnings_names = $request->earning_name; $earnings_names[] = NULL; $earnings_amounts = $request->earning_amount; $earnings_amounts[] = NULL; foreach($earnings_names as $erow) { if(!empty($earnings_names[$ecount])) { $earnings_details[] = array('name' => $earnings_names[$ecount], 'amount' => $earnings_amounts[$ecount]); } $ecount++; } $deductions_details = array(); $dcount = 0; $deductions_names = $request->deduction_name; $deductions_names[] = NULL; $deductions_amounts = $request->deduction_amount; $deductions_amounts[] = NULL; foreach($earnings_names as $erow) { if(!empty($deductions_names[$dcount])) { $deductions_details[] = array('name' => $deductions_names[$dcount], 'amount' => $deductions_amounts[$dcount]); } $dcount++; } $db_array = array( 'pay_date' => $request->pay_date, 'pay_month' => $month, 'p_pay_month' => $persian_month, 'currency' => $currency, 'pay_year' => $year, 'p_pay_year' => $persian_year, 'employee' => $request->employee, 'basic_salary' => $request->basic_salary, 'earnings' => json_encode($earnings_details), 'advance_amount' => $request->advance_amount, 'deductions' => json_encode($deductions_details), 'total_earning' => $request->total_earning, 'total_deduction' => $request->total_deduction, 'net_salary' => $request->net_salary, 'account' => $request->account, 'narration' => $request->narration, ); update_table('payslips','uid',$uid,$db_array); $employees = set_array_keys(fetch_table_branch('employees'),'uid'); $employee_name = array_key_exists($db_array['employee'],$employees) ? $employees[$db_array['employee']]['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_payslips'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/payslips/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_employee').': '.$employee_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_salary').': '.amount_number_format($db_array['net_salary']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'payslip_updated'), 'message_body' => print_lang($this->data["app_lang"],'payslip_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_payslips') === FALSE){ Redirect::to('/')->send(); } $payslip_data = fetch_table_where('payslips','uid',$uid,true); $employees = set_array_keys(fetch_table_branch('employees'),'uid'); $employee_name = array_key_exists($payslip_data['employee'],$employees) ? $employees[$payslip_data['employee']]['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_payslips'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_employee').': '.$employee_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_salary').': '.amount_number_format($payslip_data['net_salary']), ); set_activity_alert($_activity_details); delete_table('payslips','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function confirm($uid) { if(check_user_access('confirm_payslips') === FALSE){ Redirect::to('/')->send(); } $payslip_data = fetch_table_where('payslips','uid',$uid,true); $employees = set_array_keys(fetch_table_branch('employees'),'uid'); $employee_name = array_key_exists($payslip_data['employee'],$employees) ? $employees[$payslip_data['employee']]['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_payslips'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_confirmed'), 'url' => '/payslips/paid-salaries', 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_employee').': '.$employee_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_salary').': '.amount_number_format($payslip_data['net_salary']), ); set_activity_alert($_activity_details); $db_array = array('status' => 'confirm'); update_table('payslips','uid',$uid,$db_array); _handle_payslips_ledger_effects(['uid' => $uid, 'state' => 'new']); echo json_encode(array('status' => 'success', 'mode' => 'confirmed')); } public function get_holidays_deductions(Request $request) { $branch_id = active_branch_id(); $employee = $request->employee; $salary = $request->salary; $salary_date = $request->salary_date; $year = date('Y',strtotime($salary_date)); $month = date('n',strtotime($salary_date)); $day = date('j',strtotime($salary_date)); $month_days=get_month_days($year,$month); $one_day_salary = 0; $presents = array(); $absents = array(); $sick = array(); $leave = array(); $holidays = array(); $attendence = set_array_keys(std_obj_to_array(DB::table("attendence")->where("branch_id",$branch_id)->where("employee",$employee)->where("year",$year)->where("month",$month)->get()), 'day'); if(empty($attendence)) { echo json_encode(array('status' => 'error', 'message' => 'Employee attendence not found')); die; } else { $one_day_salary = $salary / $month_days; for($i=1; $i <= $month_days; $i++) { if(array_key_exists($i, $attendence)) { $status = $attendence[$i]['status']; } else { $status = 'absent'; } if($status == 'present'){ $presents[] = 1; } if($status == 'absent'){ $absents[] = 1; } if($status == 'sick'){ $sick[] = 1; } if($status == 'leave'){ $leave[] = 1; } if($status == 'holiday'){ $holidays[] = 1; } } $total_presents = array_sum($presents); $total_absent = array_sum($absents); $total_sick = array_sum($sick); $total_leave = array_sum($leave); $total_holiday = array_sum($holidays); if($total_sick > 2){ $total_absent = $total_absent + $total_sick - 2; } if($total_leave > 2){ $total_absent = $total_absent + $total_leave - 2; } $total_deduction = (float)$total_absent * (float)$one_day_salary; echo json_encode(array('status' => 'success', 'total_days' => $month_days, 'total_presents' => $total_presents, 'total_sick' => $total_sick, 'total_leave' => $total_leave, 'total_absent' => $total_absent, 'total_holiday' => $total_holiday, 'total_deduction' => $total_deduction,)); } } }