<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; class Pending_sales extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_sale') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $sales = DB::table('sales')->where('branch',$branch_id)->where('delivery_type','pending'); if(!empty($request->currency)){ $sales->where('currency',$request->currency); } if(!empty($request->client)){ $sales->where('client',$request->client); } if(!empty($request->from)){ $sales->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $sales->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } if(!empty($request->_search)) { $sales->where(function($query) use ($request) { $query->where('invoice','like','%'.$request->_search.'%'); $query->orWhere('sales_total','like','%'.$request->_search.'%'); $query->orWhere('total_discount_amount','like','%'.$request->_search.'%'); $query->orWhere('sub_total','like','%'.$request->_search.'%'); $query->orWhere('cash_received','like','%'.$request->_search.'%'); $query->orWhere('remaining_amount','like','%'.$request->_search.'%'); $query->orWhere('trans_expense','like','%'.$request->_search.'%'); $query->orWhere('total_profit_amount','like','%'.$request->_search.'%'); $query->orWhere('memo','like','%'.$request->_search.'%'); }); } $sales = $sales->paginate($this->data['rows_per_page']); $pagination = $sales->appends(request()->except(['page','search_type']))->links(); $sales = json_decode(json_encode($sales),true); $this->data["pageData"] = $sales['data']; $this->data["pagination"] = $pagination; $this->data["records"] = array('from' => $sales['from'], 'to' => $sales['to'], 'total' => $sales['total']); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); if($request->search_type == 'live_search') { $this->data["live_search_data"] = 'yes'; $view_records = (string)View::make('user.sales.view',$this->data); $stats = "Showing ".(float)$this->data["records"]['from'].' - '.(float)$this->data["records"]['to'].' of '.(float)$this->data["records"]['total']; $output_array = array('records' => $view_records, 'stats' => $stats, 'pagination' => (string)$pagination); echo json_encode($output_array); } else { $this->data["live_search_data"] = 'no'; $this->data["_search"] = $request->_search; $this->data["search_currency"] = $request->currency; $this->data["search_convert_currency"] = $request->convert_currency; $this->data["search_client"] = $request->client; $this->data["search_marketer"] = $request->marketer; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sales'); $this->data["pageToLoad"] = "sales/pending.php"; $this->data["activeLink"] = "pending_sales"; $this->data["_datatable_pagination"] = false; $this->load_view($this->data); } } public function add(Request $request, $uid) { if(check_user_access('edit_sale') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('sales','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/sales')->send(); } $balance = get_account_balance($this->data["editing_data"]['client'],$this->data["editing_data"]['currency']); $this->data["currencies"] = fetch_currencies(); $this->data["balance"] = $balance; $this->data["batch"] = set_array_keys(fetch_table_branch('batch'),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["sales_man"] = set_array_keys(fetch_table_branch('sales_man'),'uid'); $this->data["items"] = fetch_table_branch('items'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["expenses"] = fetch_table_where_branch('accounts','type','expense'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'out_sales'); $this->data["pageToLoad"] = "sales/pending_add.php"; $this->data["activeLink"] = "pending_sales"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_details = array(); $sic = 0; while($sic < count($request->item)) { if(empty($request->item[$sic])){ $sic++; continue; } $items_details[] = array( 'agent' => $request->agent[$sic], 'plate' => $request->plate[$sic], 'item' => $request->item[$sic], 'item_uqid' => $request->item_uqid[$sic], 'warehouse' => $request->warehouse[$sic], 'batch' => $request->batch[$sic], 'mfg' => $request->mfg[$sic], 'expiry' => $request->expiry[$sic], 'narration' => $request->narration[$sic], 'cost' => (float)$request->cost[$sic], 'sale_price' => (float)$request->sale_price[$sic], 'bundle' => (float)$request->bundle[$sic], 'toop' => (float)$request->toop[$sic], 'qty' => (float)$request->qty[$sic], 'out_qty' => (float)$request->out_qty[$sic] + (float)$request->out[$sic], 'out' => (float)$request->out[$sic], 'bonus' => (float)$request->bonus[$sic], 'm2' => (float)$request->m2[$sic], 'width' => (float)$request->width[$sic], 'height' => (float)$request->height[$sic], 'unit' => $request->unit[$sic], 'discount' => (float)$request->discount[$sic], 'discount_2' => (float)$request->discount_2[$sic], 'profit' => (float)$request->profit[$sic], 'item_total' => (float)$request->item_total[$sic], ); $sic++; } update_table('sales','uid',$uid,['items_details' => json_encode($items_details)]); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'sale_updated'), 'message_body' => print_lang($this->data["app_lang"],'sale_updated_successfully'))); } }