<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; class Production extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_production') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $production = DB::table('production')->where('branch',$branch_id); if(!empty($request->currency)){ $production->where('currency',$request->currency); } if(!empty($request->item)){ $production->where('item',$request->item); } if(!empty($request->from)){ $production->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $production->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $production = $production->get(); $production = json_decode(json_encode($production),true); $this->data["pageData"] = $production; $this->data["currencies"] = fetch_currencies(); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_item"] = $request->item; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'mod_production_view_title'); $this->data["pageToLoad"] = "production/view.php"; $this->data["activeLink"] = "production"; $this->load_view($this->data); } public function invoice(Request $request, $uid) { if(check_user_access('add_production') === FALSE){ Redirect::to('/')->send(); } $raw_details = std_obj_to_array(DB::table('production_details')->where('branch',active_branch_id())->where('pro_type','raw')->where('production_id',$uid)->get()); $produced_details = std_obj_to_array(DB::table('production_details')->where('branch',active_branch_id())->where('pro_type','produced')->where('production_id',$uid)->get()); $this->data["raw_details"] = $raw_details; $this->data["produced_details"] = $produced_details; $this->data["invoice_data"] = fetch_table_where('production','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["expenses"] = set_array_keys(fetch_table_where_branch('accounts','type','expense'),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'production_invoice'); $this->data["pageToLoad"] = "production/invoice.php"; $this->data["activeLink"] = "production"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_production') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_counter"] = get_production_invoice_number(); $this->data["currencies"] = fetch_currencies(); $this->data["items"] = fetch_table_branch('items'); $this->data["warehouses"] = fetch_table_branch('warehouse'); $this->data["items_relation"] = std_obj_to_array(DB::table('production_relation')->where('branch',active_branch_id())->pluck('item')->toArray()); $this->data["title"] = print_lang($this->data["app_lang"],'mod_production_add_title'); $this->data["pageToLoad"] = "production/add.php"; $this->data["activeLink"] = "production"; $this->load_view($this->data); } public function get_relational_items(Request $request) { $item = $request->item; $currency = $request->currency; $this->data["production_currency"] = fetch_table_where('currency','uid',$currency,true); $this->data["warehouses"] = fetch_table_branch('warehouse'); $this->data["currencies"] = fetch_currencies(); $this->data["items_relation_entry"] = fetch_table_where('production_relation','item',$item,true); $this->data["items_produced_relation"] = std_obj_to_array(DB::table('production_relation_details')->where('branch',active_branch_id())->where('item_type','produced')->where('module_uid',$this->data["items_relation_entry"]['uid'])->get()); $this->data["items_raw_relation"] = std_obj_to_array(DB::table('production_relation_details')->where('branch',active_branch_id())->where('item_type','raw')->where('module_uid',$this->data["items_relation_entry"]['uid'])->get()); $item_data = (string)View::make('user.production.get_form_appended_data',$this->data); echo json_encode(array('status' => 'success', 'html' => $item_data)); } public function save(Request $request) { $pcurrency = $request->currency; $pcurrency_data = fetch_table_where('currency','uid','usd',true); $uid = getUniqueId('PROI', 'production', 'uid'); $item_data = fetch_table_where('items','uid',$request->item,true); $warehouse_data = fetch_table_where('warehouse','uid',$request->warehouse,true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $warehouse_name = isset($warehouse_data['name']) ? $warehouse_data['name'] : null; $created_at = date('Y-m-d H:i:s'); $db_array = [ 'uid' => $uid, 'branch' => active_branch_id(), 'serial_id' => get_serial_id('production'), 'item' => $item_data['uid'], 'item_name' => $item_name, 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_name, 'currency' => $pcurrency, 'currency_usd_equalance' => $pcurrency_data['usd_equalance'], 'invoice' => get_production_invoice_number(), 'total_expenses' => $request->total_expenses, 'total_raw_cost' => $request->total_raw_cost, 'total_real_cost' => $request->total_real_cost, 'produced_per_item_cost' => $request->produced_per_item_cost, 'cost' => $request->cost, 'total_produced_qty' => $request->total_produced_qty, 'qty' => $request->qty, 'total_system_expenses' => $request->total_system_expenses, ]; insert_table('production',$db_array); if(!empty($request->raw_item)) { foreach($request->raw_item as $key => $ritem) { $item_data = fetch_table_where('items','uid',$ritem,true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $uid_raw = getUniqueId('PROIR', 'production_details', 'uid'); $db_array_raw = [ 'uid' => $uid_raw, 'branch' => active_branch_id(), 'production_id' => $uid, 'pro_type' => 'raw', 'event_date' => $created_at, 'currency' => $pcurrency, 'currency_usd_equalance' => $pcurrency_data['usd_equalance'], 'invoice' => $db_array['invoice'], 'warehouse' => isset($request->raw_warehouse[$key]) ? $request->raw_warehouse[$key] : null, 'item' => $ritem, 'batch' => env('APP_BATCH'), 'qty' => $request->raw_qty[$key], 'rel_qty' => $request->raw_rel_qty[$key], 'unit' => 'purchase', 'rel_cost' => $request->raw_item_cost[$key], 'cost' => $request->raw_item_cost[$key], 'real_cost' => (float)$request->raw_item_cost[$key], 'profit' => 0, 'sale_price' => (float)$request->raw_item_cost[$key], 'total' => (float)$request->raw_item_cost[$key] * (float)$request->raw_qty[$key], ]; insert_table('production_details',$db_array_raw); } } $item_data = fetch_table_where('items','uid',$request->item,true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $warehouse_data = fetch_table_where('warehouse','uid',$request->warehouse,true); $warehouse_name = isset($warehouse_data['name']) ? $warehouse_data['name'] : null; $uid_produced = getUniqueId('PROIPR', 'production_details', 'uid'); $db_array_general_item = [ 'uid' => $uid_produced, 'branch' => active_branch_id(), 'production_id' => $uid, 'pro_type' => 'produced', 'event_date' => $created_at, 'currency' => $pcurrency, 'currency_usd_equalance' => $pcurrency_data['usd_equalance'], 'invoice' => $db_array['invoice'], 'warehouse' => $warehouse_data['uid'], 'item' => $request->item, 'batch' => env('APP_BATCH'), 'qty' => $request->qty, 'rel_qty' => $request->qty, 'unit' => 'purchase', 'rel_cost' => $request->cost, 'cost' => $request->cost, 'real_cost' => $request->cost, 'profit' => 0, 'sale_price' => (float)$request->cost, 'total' => (float)$request->cost * (float)$request->qty, 'general' => 'yes', ]; insert_table('production_details',$db_array_general_item); if(!empty($request->produced_item)) { foreach($request->produced_item as $key => $pitem) { $item_data = fetch_table_where('items','uid',$pitem,true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $uid_produced = getUniqueId('PROIPR', 'production_details', 'uid'); $db_array_produced = [ 'uid' => $uid_produced, 'branch' => active_branch_id(), 'production_id' => $uid, 'pro_type' => 'produced', 'event_date' => $created_at, 'currency' => $pcurrency, 'currency_usd_equalance' => $pcurrency_data['usd_equalance'], 'invoice' => $db_array['invoice'], 'warehouse' => isset($request->produced_warehouse[$key]) ? $request->produced_warehouse[$key] : null, 'item' => $pitem, 'batch' => env('APP_BATCH'), 'qty' => $request->produced_qty[$key], 'rel_qty' => $request->produced_rel_qty[$key], 'unit' => 'purchase', 'rel_cost' => $request->produced_item_cost[$key], 'cost' => $request->produced_item_cost[$key], 'produced_item_cost_percentage' => $request->produced_item_cost_percentage[$key], 'profit' => 0, 'sale_price' => (float)$request->produced_item_cost[$key], 'total' => (float)$request->produced_item_cost[$key] * $request->produced_qty[$key], ]; insert_table('production_details',$db_array_produced); } } _handle_items_inventory_stats_from_production(['uid' => $uid, 'entry_status' => 'new']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_production'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/production/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['total_raw_cost']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mode_production_added'), 'message_body' => print_lang($this->data["app_lang"],'mode_production_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_production') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('production','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/production')->send(); } $this->data["production_currency"] = fetch_table_where('currency','uid',$this->data["editing_data"]['currency'],true); $this->data["currencies"] = fetch_currencies(); $this->data["warehouses"] = fetch_table_branch('warehouse'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["items_relation"] = std_obj_to_array(DB::table('production_relation')->where('branch',active_branch_id())->pluck('item')->toArray()); $this->data["title"] = print_lang($this->data["app_lang"],'mode_production_edit_title'); $this->data["pageToLoad"] = "production/edit.php"; $this->data["activeLink"] = "production"; $this->load_view($this->data); } public function update(Request $request, $uid) { $pcurrency = $request->currency; $production_data = fetch_table_where('production','uid',$uid,true); $created_at = $production_data['created_at']; $pcurrency_data = fetch_table_where('currency','uid','usd',true); $item_data = fetch_table_where('items','uid',$request->item,true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $warehouse_data = fetch_table_where('warehouse','uid',$request->warehouse,true); $warehouse_name = isset($warehouse_data['name']) ? $warehouse_data['name'] : null; $db_array = [ 'item' => $item_data['uid'], 'item_name' => $item_name, 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_name, 'currency' => $pcurrency, 'invoice' => $production_data['invoice'], 'currency_usd_equalance' => $pcurrency_data['usd_equalance'], 'total_expenses' => $request->total_expenses, 'total_raw_cost' => $request->total_raw_cost, 'total_real_cost' => $request->total_real_cost, 'produced_per_item_cost' => $request->produced_per_item_cost, 'cost' => $request->cost, 'total_produced_qty' => $request->total_produced_qty, 'qty' => $request->qty, 'total_system_expenses' => $request->total_system_expenses, ]; update_table('production','uid',$uid,$db_array); delete_table('production_details','production_id',$uid); if(!empty($request->raw_item)) { foreach($request->raw_item as $key => $ritem) { $item_data = fetch_table_where('items','uid',$ritem,true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $uid_raw = getUniqueId('PROIR', 'production_details', 'uid'); $db_array_raw = [ 'uid' => $uid_raw, 'branch' => active_branch_id(), 'production_id' => $uid, 'pro_type' => 'raw', 'event_date' => $created_at, 'currency' => $pcurrency, 'currency_usd_equalance' => $pcurrency_data['usd_equalance'], 'invoice' => $db_array['invoice'], 'warehouse' => isset($request->raw_warehouse[$key]) ? $request->raw_warehouse[$key] : null, 'item' => $ritem, 'batch' => env('APP_BATCH'), 'qty' => $request->raw_qty[$key], 'rel_qty' => $request->raw_rel_qty[$key], 'unit' => 'purchase', 'rel_cost' => $request->raw_item_cost[$key], 'cost' => $request->raw_item_cost[$key], 'real_cost' => (float)$request->raw_item_cost[$key], 'profit' => 0, 'sale_price' => (float)$request->raw_item_cost[$key], 'total' => (float)$request->raw_item_cost[$key] * (float)$request->raw_qty[$key], ]; insert_table('production_details',$db_array_raw); } } $item_data = fetch_table_where('items','uid',$request->item,true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $warehouse_data = fetch_table_where('warehouse','uid',$request->warehouse,true); $warehouse_name = isset($warehouse_data['name']) ? $warehouse_data['name'] : null; $uid_produced = getUniqueId('PROIPR', 'production_details', 'uid'); $db_array_general_item = [ 'uid' => $uid_produced, 'branch' => active_branch_id(), 'production_id' => $uid, 'pro_type' => 'produced', 'event_date' => $created_at, 'currency' => $pcurrency, 'currency_usd_equalance' => $pcurrency_data['usd_equalance'], 'invoice' => $db_array['invoice'], 'warehouse' => $warehouse_data['uid'], 'item' => $request->item, 'batch' => env('APP_BATCH'), 'qty' => $request->qty, 'rel_qty' => $request->qty, 'unit' => 'purchase', 'rel_cost' => $request->cost, 'cost' => $request->cost, 'real_cost' => $request->cost, 'profit' => 0, 'sale_price' => (float)$request->cost, 'total' => (float)$request->cost * (float)$request->qty, 'general' => 'yes', ]; insert_table('production_details',$db_array_general_item); if(!empty($request->produced_item)) { foreach($request->produced_item as $key => $pitem) { $item_data = fetch_table_where('items','uid',$pitem,true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $uid_produced = getUniqueId('PROIPR', 'production_details', 'uid'); $db_array_produced = [ 'uid' => $uid_produced, 'branch' => active_branch_id(), 'production_id' => $uid, 'pro_type' => 'produced', 'event_date' => $created_at, 'currency' => $pcurrency, 'currency_usd_equalance' => $pcurrency_data['usd_equalance'], 'invoice' => $db_array['invoice'], 'warehouse' => isset($request->produced_warehouse[$key]) ? $request->produced_warehouse[$key] : null, 'item' => $pitem, 'batch' => env('APP_BATCH'), 'qty' => $request->produced_qty[$key], 'rel_qty' => $request->produced_rel_qty[$key], 'unit' => 'purchase', 'rel_cost' => $request->produced_item_cost[$key], 'cost' => $request->produced_item_cost[$key], 'produced_item_cost_percentage' => $request->produced_item_cost_percentage[$key], 'profit' => 0, 'sale_price' => (float)$request->produced_item_cost[$key], 'total' => (float)$request->produced_item_cost[$key] * $request->produced_qty[$key], ]; insert_table('production_details',$db_array_produced); } } _handle_items_inventory_stats_from_production(['uid' => $uid, 'entry_status' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_production'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/production/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['total_raw_cost']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mode_production_update'), 'message_body' => print_lang($this->data["app_lang"],'mode_production_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_production') === FALSE){ Redirect::to('/')->send(); } $_deleting_data = fetch_table_where('production','uid',$uid,true); $_deleting_data_details = fetch_table_where('production_details','production_id',$uid); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_production'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$_deleting_data['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($_deleting_data['total_raw_cost']), ); set_activity_alert($_activity_details); delete_table('production','uid',$uid); delete_table('production_details','production_id',$uid); _handle_items_inventory_stats_from_production(['uid' => $uid, 'entry_status' => 'delete']); _calculate_item_wise_stats(['item' => $_deleting_data['item']]); if(!empty($_deleting_data_details)) { foreach($_deleting_data_details as $row) { _calculate_item_wise_stats(['item' => $row['item']]); } } echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function item_details(Request $request) { $item = $request->item; $avail_units = $request->avail_units; $avg_cost = $request->avg_cost; $first_cost = $request->first_cost; $output_array = array( 'status' => 'success', 'avail_units' => 0, 'avg_cost' => 0, 'first_cost' => 0, ); $item_data = fetch_table_where('items','uid',$item,true); if($avail_units == 'yes') { $output_array['avail_units'] = unit_based_conversion($item_data,'production',get_item_avail_units($item)); } if($avg_cost == 'yes') { $output_array['avg_cost'] = unit_based_conversion($item_data,'production',get_item_avg_cost($item)); } if($first_cost == 'yes') { $output_array['first_cost'] = unit_based_conversion($item_data,'production',get_item_first_cost($item)); } echo json_encode($output_array); } public function get_produced_item_ava_qty(Request $request) { $item = $request->item; $warehouse = $request->warehouse; $batch = $request->batch; $unit = $request->unit; $qty = items_warehouse_batch_unit_qty($item,$warehouse,$batch,$unit); echo json_encode(array('qty' => $qty)); } }