<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; class Production_new extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_production') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $production = DB::table('new_production')->where('branch',$branch_id); if(!empty($request->currency)){ $production->where('currency',$request->currency); } if(!empty($request->item)){ $production->where('item',$request->item); } if(!empty($request->from)){ $production->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $production->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $production = $production->get(); $production = json_decode(json_encode($production),true); $this->data["pageData"] = $production; $this->data["currencies"] = fetch_currencies(); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_item"] = $request->item; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'mod_production_new_view_title'); $this->data["pageToLoad"] = "new_production/view.php"; $this->data["activeLink"] = "new_production"; $this->load_view($this->data); } public function invoice(Request $request, $uid) { if(check_user_access('add_production') === FALSE){ Redirect::to('/')->send(); } $raw_details = std_obj_to_array(DB::table('production_details')->where('branch',active_branch_id())->where('pro_type','raw')->where('production_id',$uid)->get()); $produced_details = std_obj_to_array(DB::table('production_details')->where('branch',active_branch_id())->where('pro_type','produced')->where('production_id',$uid)->get()); $this->data["raw_details"] = $raw_details; $this->data["produced_details"] = $produced_details; $this->data["invoice_data"] = fetch_table_where('production','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["expenses"] = set_array_keys(fetch_table_where_branch('accounts','type','expense'),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'production_invoice'); $this->data["pageToLoad"] = "production/invoice.php"; $this->data["activeLink"] = "production"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_production') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["items"] = fetch_table_branch('items'); $this->data["warehouses"] = fetch_table_branch('warehouse'); $this->data["items_formula"] = std_obj_to_array(DB::table('new_production_formula')->where('branch',active_branch_id())->get()); $this->data["title"] = print_lang($this->data["app_lang"],'mod_production_new_add_title'); $this->data["pageToLoad"] = "new_production/add.php"; $this->data["activeLink"] = "new_production"; $this->load_view($this->data); } public function get_items_data(Request $request) { $formula = $request->formula; $currency = $request->currency; $this->data["production_currency"] = fetch_table_where('currency','uid',$currency,true); $this->data["branch_items"] = fetch_table_branch('items'); $this->data["warehouses"] = fetch_table_branch('warehouse'); $this->data["currencies"] = fetch_currencies(); $this->data["items_formula"] = fetch_table_where('new_production_formula','uid',$formula,true); $item_data = (string)View::make('user.new_production.get_form_appended_data',$this->data); echo json_encode(array('status' => 'success', 'html' => $item_data)); } public function save(Request $request) { $pcurrency = $request->currency; $pcurrency_data = fetch_table_where('currency','uid','usd',true); $item_data = fetch_table_where('items','uid',$request->item,true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $warehouse_data = fetch_table_where('warehouse','uid',$request->warehouse,true); $warehouse_name = isset($warehouse_data['name']) ? $warehouse_data['name'] : null; $formula_data = fetch_table_where('new_production_formula','uid',$request->formula,true); $formula_name = isset($formula_data['name']) ? $formula_data['name'] : null; $created_at = date('Y-m-d H:i:s'); $uid = getUniqueId('PROI', 'new_production', 'uid'); $db_array = [ 'uid' => $uid, 'branch' => active_branch_id(), 'serial_id' => get_serial_id('new_production'), 'formula' => $request->formula, 'formula_name' => $formula_name, 'item' => $item_data['uid'], 'item_name' => $item_name, 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_name, 'currency' => $pcurrency, 'currency_name' => $pcurrency_data['name'], 'currency_symbol' => $pcurrency_data['symbol'], 'usd_equalance' => $pcurrency_data['usd_equalance'], 'unit' => 'purchase', 'qty' => $request->qty, 'weight' => $request->weight, 'total_weight' => $request->total_weight, 'system_expenses' => $request->total_system_expenses, 'used_expenses' => $request->used_expenses, 'total_cost' => $request->total_cost, 'total_real_cost' => $request->total_real_cost, 'per_item_cost' => $request->per_item_cost, ]; insert_table('new_production',$db_array); if(!empty($request->raw_item)) { $uid_produced = getUniqueId('PROIR', 'new_production_details', 'uid'); $db_array_raw = [ 'uid' => $uid_produced, 'branch' => active_branch_id(), 'production_id' => $uid, 'pro_type' => 'produced', 'event_date' => $created_at, 'currency' => $pcurrency, 'currency_usd_equalance' => $pcurrency_data['usd_equalance'], 'invoice' => $db_array['serial_id'], 'warehouse' => $warehouse_data['uid'], 'item' => $item_data['uid'], 'batch' => env('APP_BATCH'), 'qty' => $request->qty, 'percentage' => 100, 'unit' => 'purchase', 'cost' => $request->per_item_cost, 'real_cost' => (float)$request->per_item_cost, 'profit' => 0, 'sale_price' => (float)$request->per_item_cost, 'total' => (float)$request->per_item_cost * (float)$request->qty, ]; insert_table('new_production_details',$db_array_raw); } if(!empty($request->raw_item)) { foreach($request->raw_item as $key => $ritem) { $item_data = fetch_table_where('items','uid',$ritem,true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $uid_raw = getUniqueId('PROIR', 'new_production_details', 'uid'); $db_array_raw = [ 'uid' => $uid_raw, 'branch' => active_branch_id(), 'production_id' => $uid, 'pro_type' => 'raw', 'event_date' => $created_at, 'currency' => $pcurrency, 'currency_usd_equalance' => $pcurrency_data['usd_equalance'], 'invoice' => $db_array['serial_id'], 'warehouse' => isset($request->raw_warehouse[$key]) ? $request->raw_warehouse[$key] : null, 'item' => $ritem, 'batch' => env('APP_BATCH'), 'qty' => $request->raw_qty[$key], 'percentage' => $request->raw_percentage[$key], 'unit' => 'purchase', 'cost' => $request->raw_cost[$key], 'real_cost' => (float)$request->raw_cost[$key], 'profit' => 0, 'sale_price' => (float)$request->raw_cost[$key], 'total' => (float)$request->raw_cost[$key] * (float)$request->raw_qty[$key], ]; insert_table('new_production_details',$db_array_raw); } } _handle_items_inventory_stats_from_production_new(['uid' => $uid, 'entry_status' => 'new']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_production'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/production/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['serial_id'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['total_cost']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_production_new_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_production_new_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_production') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('new_production','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/new-production')->send(); } $this->data["editing_data_details"] = fetch_table_where('new_production_details','production_id',$uid); $this->data["production_currency"] = fetch_table_where('currency','uid',$this->data["editing_data"]['currency'],true); $this->data["currencies"] = fetch_currencies(); $this->data["warehouses"] = fetch_table_branch('warehouse'); $this->data["items_formula"] = fetch_table_branch('new_production_formula'); $this->data["branch_items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_production_new_edit_title'); $this->data["pageToLoad"] = "new_production/edit.php"; $this->data["activeLink"] = "new_production"; $this->load_view($this->data); } public function update(Request $request, $uid) { $_production_data = fetch_table_where('new_production','uid',$uid,true); $pcurrency = $request->currency; $pcurrency_data = fetch_table_where('currency','uid','usd',true); $item_data = fetch_table_where('items','uid',$request->item,true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $warehouse_data = fetch_table_where('warehouse','uid',$request->warehouse,true); $warehouse_name = isset($warehouse_data['name']) ? $warehouse_data['name'] : null; $formula_data = fetch_table_where('new_production_formula','uid',$request->formula,true); $formula_name = isset($formula_data['name']) ? $formula_data['name'] : null; $db_array = [ 'item' => $item_data['uid'], 'item_name' => $item_name, 'warehouse' => $warehouse_data['uid'], 'warehouse_name' => $warehouse_name, 'currency' => $pcurrency, 'currency_name' => $pcurrency_data['name'], 'currency_symbol' => $pcurrency_data['symbol'], 'usd_equalance' => $pcurrency_data['usd_equalance'], 'unit' => 'purchase', 'qty' => $request->qty, 'weight' => $request->weight, 'total_weight' => $request->total_weight, 'system_expenses' => $request->total_system_expenses, 'used_expenses' => $request->used_expenses, 'total_cost' => $request->total_cost, 'total_real_cost' => $request->total_real_cost, 'per_item_cost' => $request->per_item_cost, ]; update_table('new_production','uid',$uid,$db_array); delete_table('new_production_details','production_id',$uid); if(!empty($request->raw_item)) { $uid_produced = getUniqueId('PROIR', 'new_production_details', 'uid'); $db_array_raw = [ 'uid' => $uid_produced, 'branch' => active_branch_id(), 'production_id' => $uid, 'pro_type' => 'produced', 'event_date' => $_production_data['created_at'], 'currency' => $pcurrency, 'currency_usd_equalance' => $pcurrency_data['usd_equalance'], 'invoice' => $_production_data['serial_id'], 'warehouse' => $warehouse_data['uid'], 'item' => $item_data['uid'], 'batch' => env('APP_BATCH'), 'qty' => $request->qty, 'percentage' => 100, 'unit' => 'purchase', 'cost' => $request->per_item_cost, 'real_cost' => (float)$request->per_item_cost, 'profit' => 0, 'sale_price' => (float)$request->per_item_cost, 'total' => (float)$request->per_item_cost * (float)$request->qty, ]; insert_table('new_production_details',$db_array_raw); } if(!empty($request->raw_item)) { foreach($request->raw_item as $key => $ritem) { $item_data = fetch_table_where('items','uid',$ritem,true); $item_name = isset($item_data['name']) ? $item_data['name'] : null; $uid_raw = getUniqueId('PROIR', 'new_production_details', 'uid'); $db_array_raw = [ 'uid' => $uid_raw, 'branch' => active_branch_id(), 'production_id' => $uid, 'pro_type' => 'raw', 'event_date' => $_production_data['created_at'], 'currency' => $pcurrency, 'currency_usd_equalance' => $pcurrency_data['usd_equalance'], 'invoice' => $_production_data['serial_id'], 'warehouse' => isset($request->raw_warehouse[$key]) ? $request->raw_warehouse[$key] : null, 'item' => $ritem, 'batch' => env('APP_BATCH'), 'qty' => $request->raw_qty[$key], 'percentage' => $request->raw_percentage[$key], 'unit' => 'purchase', 'cost' => $request->raw_cost[$key], 'real_cost' => (float)$request->raw_cost[$key], 'profit' => 0, 'sale_price' => (float)$request->raw_cost[$key], 'total' => (float)$request->raw_cost[$key] * (float)$request->raw_qty[$key], ]; insert_table('new_production_details',$db_array_raw); } } _handle_items_inventory_stats_from_production_new(['uid' => $uid, 'entry_status' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_production'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/production/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$_production_data['serial_id'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['total_cost']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_production_new_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_production_new_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_production') === FALSE){ Redirect::to('/')->send(); } $_deleting_data = fetch_table_where('new_production','uid',$uid,true); $_deleting_data_details = fetch_table_where('new_production_details','production_id',$uid); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_production'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$_deleting_data['serial_id'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($_deleting_data['total_cost']), ); set_activity_alert($_activity_details); delete_table('new_production','uid',$uid); delete_table('new_production_details','production_id',$uid); _handle_items_inventory_stats_from_production_new(['uid' => $uid, 'entry_status' => 'delete']); _calculate_item_wise_stats(['item' => $_deleting_data['item']]); if(!empty($_deleting_data_details)) { foreach($_deleting_data_details as $row) { _calculate_item_wise_stats(['item' => $row['item']]); } } echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }