<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; use Hash; class Project extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_project_projects') === FALSE){ Redirect::to('/')->send(); } $projects = DB::table('projects'); if(!empty($request->currency)){ $projects->where('currency',$request->currency); } if(!empty($request->client)){ $projects->where('client',$request->client); } if(!empty($request->project)){ $projects->where('uid',$request->project); } if(!empty($request->from)){ $projects->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $projects->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($projects->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["projects"] = set_array_keys(fetch_table_branch('projects'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_project"] = $request->project; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'projects'); $this->data["pageToLoad"] = "project/view.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_project_projects') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'add_project'); $this->data["pageToLoad"] = "project/add.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'address' => 'required', 'company' => 'required', 'client' => 'required', 'currency' => 'required', 'cost' => 'required', 'cash_paid_account' => 'required', 'cash_paid' => 'required', 'start_date' => 'required', 'end_date' => 'required', 'username' => 'required|min:3|unique:users', 'password' => 'required|min:3|same:confirm_password', 'confirm_password' => 'required', ]); $validator->validate(); $uid = getUniqueId('PJCT', 'projects', 'uid'); $active_branch_id = active_branch_id(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'uid' => $uid, 'branch' => $active_branch_id, 'name' => $request->name, 'address' => $request->address, 'contact_person' => $request->contact_person, 'contact_number' => $request->contact_number, 'company' => $request->company, 'client' => $request->client, 'currency' => $request->currency, 'currency_usd_equalance' => $currency_data['usd_equalance'], 'cost' => $request->cost, 'cash_paid_account' => $request->cash_paid_account, 'cash_paid' => $request->cash_paid, 'pending_amount' => $request->pending_amount, 'start_date' => get_true_date($request->start_date), 'end_date' => get_true_date($request->end_date), 'comments' => $request->comments, 'username' => $request->username, 'password' => base64_encode($request->password), 'user' => Session::get('user_id'), ); if($request->hasFile('image')) { $file = $request->file('image'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('PIMG'); $fileNamePrefix = db_unique_id('projects',$fileNamePrefix); $project_image = $fileNamePrefix.'.'.$extension; $file->move('uploads/projects/',$project_image); $db_array['image'] = $project_image; } insert_table('projects',$db_array); _handle_project_ledger_effects(['uid' => $uid, 'state' => 'new']); $user_db_array = array( 'uid' => 'USR'.$db_array['uid'], 'name' => $db_array['name'], 'email' => NULL, 'phone' => NULL, 'branch' => $active_branch_id, 'username' => $db_array['username'], 'password' => Hash::make($request->password), 'address' => NULL, 'role' => 'USER', 'rights' => json_encode(array()), 'is_project' => 'yes', ); insert_table('users',$user_db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'project_saved'), 'message_body' => print_lang($this->data["app_lang"],'new_project_created_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_project_projects') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('projects','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_project'); $this->data["pageToLoad"] = "project/edit.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function update(Request $request, $uid) { $project_user_uid = 'USR'.$uid; $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'address' => 'required', 'company' => 'required', 'client' => 'required', 'currency' => 'required', 'cost' => 'required', 'cash_paid_account' => 'required', 'cash_paid' => 'required', 'start_date' => 'required', 'end_date' => 'required', 'username' => ['required','min:3',Rule::unique('users')->ignore($project_user_uid, 'uid')], ]); $validator->sometimes('password',['min:3','same:confirm_password'],function($input){ return !empty($input->password); } ); $validator->validate(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'name' => $request->name, 'address' => $request->address, 'contact_person' => $request->contact_person, 'contact_number' => $request->contact_number, 'company' => $request->company, 'client' => $request->client, 'currency' => $request->currency, 'currency_usd_equalance' => $currency_data['usd_equalance'], 'cost' => $request->cost, 'cash_paid_account' => $request->cash_paid_account, 'cash_paid' => $request->cash_paid, 'pending_amount' => $request->pending_amount, 'start_date' => get_true_date($request->start_date), 'end_date' => get_true_date($request->end_date), 'comments' => $request->comments, 'username' => $request->username, ); if(!empty($request->password)) { $db_array['password'] = base64_encode($request->password); } $project_data = fetch_table_where('projects','uid',$uid,TRUE); if($request->hasFile('image')) { $file = $request->file('image'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('PIMG'); $fileNamePrefix = db_unique_id('projects',$fileNamePrefix); $project_image = $fileNamePrefix.'.'.$extension; $file->move('uploads/projects/',$project_image); $db_array['image'] = $project_image; File::delete('uploads/projects/'.$project_data["image"]); } update_table('projects','uid',$uid,$db_array); _handle_project_ledger_effects(['uid' => $uid, 'state' => 'update']); _handle_project_dependent_ledger_effects(['uid' => $uid]); $user_db_array = array( 'name' => $db_array['name'], 'username' => $db_array['username'], ); if(!empty($request->password)){ $user_db_array['password'] = Hash::make($request->password); } update_table('users','uid',$project_user_uid,$user_db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'project_updated'), 'message_body' => print_lang($this->data["app_lang"],'project_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_project_projects') === FALSE){ Redirect::to('/')->send(); } $project = fetch_table_where('projects','uid',$uid,TRUE); if(!empty($project["image"])){ File::delete('uploads/projects/'.$project["image"]); } delete_table('projects','uid',$uid); _handle_project_ledger_effects(['uid' => $uid, 'state' => 'delete']); $project_payments = fetch_table_where_branch('project_payments','project',$uid); foreach($project_payments as $row) { _handle_project_payment_ledger_effects(['uid' => $row['uid'], 'state' => 'delete']); } delete_table('project_payments','project',$uid); $expenses_deductions = fetch_table_where_branch('expenses_deductions','project',$uid); foreach($expenses_deductions as $row) { _handle_expense_deduction_ledger_effects(['uid' => $row['uid'], 'state' => 'delete']); } delete_table('expenses_deductions','project',$uid); $payment_deductions = fetch_table_where_branch('payment_deductions','project',$uid); foreach($payment_deductions as $row) { _handle_payment_deduction_ledger_effects(['uid' => $row['uid'], 'state' => 'delete']); } delete_table('payment_deductions','project',$uid); $projects_assign = fetch_table_where_branch('projects_assign','project',$uid); foreach($projects_assign as $row) { _handle_project_contract_assigned_ledger_effects(['uid' => $row['uid'], 'state' => 'delete']); } delete_table('projects_assign','project',$uid); delete_table('projects_reports','project',$uid); delete_table('users','uid','USR'.$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function view_in_process(Request $request) { if(check_user_access('view_project_inprocess_projects') === FALSE){ Redirect::to('/')->send(); } $projects = DB::table('projects')->where('status','pending'); if(!empty($request->currency)){ $projects->where('currency',$request->currency); } if(!empty($request->client)){ $projects->where('client',$request->client); } if(!empty($request->from)){ $projects->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $projects->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($projects->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'in_process_projects'); $this->data["pageToLoad"] = "project/view_in_process.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function process_details(Request $request, $uid) { if(check_user_access('project_inprocess_projects_process_details') === FALSE AND check_user_access('project_completed_projects_process_details') === FALSE){ Redirect::to('/')->send(); } $project = DB::table('projects')->where('uid',$uid); $payment_deductions = DB::table('payment_deductions')->where('project',$uid); $expenses_deductions = DB::table('expenses_deductions')->where('status','approved')->where('project',$uid); $projects_assign = DB::table('projects_assign')->where('project',$uid); if(!empty($request->item)){ $expenses_deductions->where('item',$request->item); } if(!empty($request->supervisor)) { $payment_deductions->where('user',$request->supervisor); $expenses_deductions->where('user',$request->supervisor); $projects_assign->where('user',$request->supervisor); } if(!empty($request->type)){ $expenses_deductions->where('expenses_mood',$request->type); } if(!empty($request->from)) { $payment_deductions->where('pdate','>=',get_true_date($request->from)); $expenses_deductions->where('edate','>=',get_true_date($request->from)); $projects_assign->where('created_at','>=',get_true_date($request->from)." 00:00:00"); } if(!empty($request->to)) { $payment_deductions->where('pdate','<=',get_true_date($request->to)); $expenses_deductions->where('edate','<=',get_true_date($request->to)); $projects_assign->where('created_at','<=',get_true_date($request->to." 23:23:59")); } $project = json_decode(json_encode($project->get()->first()),true); $payment_deductions = json_decode(json_encode($payment_deductions->get()),true); $expenses_deductions = json_decode(json_encode($expenses_deductions->get()),true); $projects_assign = json_decode(json_encode($projects_assign->get()),true); $this->data["page_data"] = get_project_process_details($project,$payment_deductions,$expenses_deductions,$projects_assign); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["users"] = set_array_keys(fetch_branch_users(),'uid'); $this->data["project_uid"] = $uid; $this->data["search_item"] = $request->item; $this->data["search_supervisor"] = $request->supervisor; $this->data["search_type"] = $request->type; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'process_details'); $this->data["pageToLoad"] = "project/process_details.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function complete($uid) { if(check_user_access('project_inprocess_projects_complete') === FALSE){ Redirect::to('/')->send(); } update_table('projects','uid',$uid,array('status' => 'completed')); echo json_encode(array('status' => 'success', 'mode' => 'completed')); } public function view_completed(Request $request) { if(check_user_access('view_project_completed_projects') === FALSE){ Redirect::to('/')->send(); } $projects = DB::table('projects')->where('status','completed'); if(!empty($request->currency)){ $projects->where('currency',$request->currency); } if(!empty($request->client)){ $projects->where('client',$request->client); } if(!empty($request->from)){ $projects->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $projects->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($projects->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'completed_projects'); $this->data["pageToLoad"] = "project/view_completed.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function back_to_process($uid) { if(check_user_access('project_completed_projects_incomplete') === FALSE){ Redirect::to('/')->send(); } update_table('projects','uid',$uid,array('status' => 'pending')); echo json_encode(array('status' => 'success', 'mode' => 'pending')); } public function project_assign_report(Request $request) { if(check_user_access('view_project_assign_report') === FALSE){ Redirect::to('/')->send(); } $projects_assign = DB::table('projects_assign')->where('status','passed'); if(!empty($request->project)){ $projects_assign->where('project',$request->project); } if(!empty($request->item)){ $projects_assign->where('item',$request->item); } if(!empty($request->machinery)){ $projects_assign->where('machinery',$request->machinery); } if(!empty($request->employee)){ $projects_assign->where('employee',$request->employee); } if(!empty($request->from)){ $projects_assign->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $projects_assign->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($projects_assign->get()),true); $employees = get_project_assign_employees(); $this->data["employees"] = $employees; $this->data["projects"] = set_array_keys(fetch_table_branch('projects'),'uid'); $this->data["machinery"] = set_array_keys(fetch_table_where_branch('ccontracts','contract_type','machinery'),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('citems'),'uid'); $this->data["accounts"] = set_array_keys(fetch_table_where_branch('accounts','type','employee'),'uid'); $this->data["search_project"] = $request->project; $this->data["search_item"] = $request->item; $this->data["search_machinery"] = $request->machinery; $this->data["search_employee"] = $request->employee; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'project_assigning_report_title'); $this->data["pageToLoad"] = "projects_assigning/projects_assign_report.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } }