<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Project_expenses_deductions extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { $user_uid = Session::get('user_id'); $project_uid = str_replace('USR', '', $user_uid); $expenses_deductions = DB::table('expenses_deductions')->where('status','pending')->where('user_type','project_user')->where('project',$project_uid); if(!empty($request->currency)){ $expenses_deductions->where('currency',$request->currency); } if(!empty($request->deduction_type)){ $expenses_deductions->where('deduction_type',$request->deduction_type); } if(!empty($request->details)){ $expenses_deductions->where('comments','like','%'.$request->details.'%'); } if(!empty($request->from)){ $expenses_deductions->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $expenses_deductions->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($expenses_deductions->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_deduction_type"] = $request->deduction_type; $this->data["search_details"] = $request->details; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'expenses_deductions'); $this->data["pageToLoad"] = "project_expenses_deductions/view.php"; $this->data["activeLink"] = "project-expenses-deductions"; $this->load_view($this->data); } public function approved_view(Request $request) { $user_uid = Session::get('user_id'); $project_uid = str_replace('USR', '', $user_uid); $expenses_deductions = DB::table('expenses_deductions')->where('status','approved')->where('user_type','project_user')->where('project',$project_uid); if(!empty($request->currency)){ $expenses_deductions->where('currency',$request->currency); } if(!empty($request->deduction_type)){ $expenses_deductions->where('deduction_type',$request->deduction_type); } if(!empty($request->details)){ $expenses_deductions->where('comments','like','%'.$request->details.'%'); } if(!empty($request->from)){ $expenses_deductions->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $expenses_deductions->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($expenses_deductions->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_deduction_type"] = $request->deduction_type; $this->data["search_details"] = $request->details; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'approved_expenses_deductions'); $this->data["pageToLoad"] = "project_expenses_deductions/approved_view.php"; $this->data["activeLink"] = "project-expenses-deductions-approved"; $this->load_view($this->data); } public function add(Request $request) { $user_uid = Session::get('user_id'); $project_uid = str_replace('USR', '', $user_uid); $project_data = DB::table('projects')->where('uid',$project_uid); $expenses_deductions = DB::table('expenses_deductions')->where('user_type','project_user')->where('project',$project_uid); $project_payments = DB::table('project_payments')->where('payment_type','project')->where('project',$project_uid); $project_data = json_decode(json_encode($project_data->get()->first()),true); $expenses_deductions = json_decode(json_encode($expenses_deductions->get()),true); $project_payments = json_decode(json_encode($project_payments->get()),true); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["project"] = $project_data; $project_received_money = get_received_money_data(array('project' => $project_data, 'expenses_deductions' => $expenses_deductions, 'project_payments' => $project_payments, 'accounts' => $this->data["accounts"])); $project_received_money_credit = array_sum( array_column($project_received_money, 'credit') ); $project_received_money_debit = array_sum( array_column($project_received_money, 'debit') ); $this->data["project_received_money_balance"] = $project_received_money_credit - $project_received_money_debit; $this->data["title"] = print_lang($this->data["app_lang"],'add_expense_deduction'); $this->data["pageToLoad"] = "project_expenses_deductions/add.php"; $this->data["activeLink"] = "project-expenses-deductions"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'deduction_type' => 'required', 'currency' => 'required', 'amount' => 'required', 'cash_date' => 'required', 'payment_type' => 'required', ]); $validator->validate(); $uid = getUniqueId('PEDT', 'expenses_deductions', 'uid'); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'expenses_mood' => 'cash_expenses', 'currency' => $request->currency, 'currency_usd_equalance' => (float)$currency_data['usd_equalance'], 'amount' => $request->amount, 'edate' => $request->cash_date, 'project' => $request->project, 'project_according_amount' => $request->project_according_amount, 'deduction_type' => $request->deduction_type, 'payment_type' => $request->payment_type, 'user' => Session::get('user_id'), 'user_type' => 'project_user', 'comments' => $request->comments, ); if($request->hasFile('scan_copy')) { $file = $request->file('scan_copy'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('PPDI'); $fileNamePrefix = db_unique_id('expenses_deductions',$fileNamePrefix); $scan_copy = $fileNamePrefix.'.'.$extension; $file->move('uploads/expenses-deductions/',$scan_copy); $db_array['scan_copy'] = $scan_copy; } insert_table('expenses_deductions',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'deduction_saved'), 'message_body' => print_lang($this->data["app_lang"],'deduction_saved_successfully'))); } public function edit(Request $request, $uid) { $this->data["editing_data"] = fetch_table_where('expenses_deductions','uid',$uid,true); $user_uid = Session::get('user_id'); $project_uid = str_replace('USR', '', $user_uid); $this->data["project"] = fetch_table_where('projects','uid',$project_uid,true); $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_expense_deduction'); $this->data["pageToLoad"] = "project_expenses_deductions/edit.php"; $this->data["activeLink"] = "project-expenses-deductions"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'deduction_type' => 'required', 'currency' => 'required', 'amount' => 'required', 'cash_date' => 'required', 'payment_type' => 'required', ]); $validator->validate(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'currency' => $request->currency, 'currency_usd_equalance' => (float)$currency_data['usd_equalance'], 'amount' => $request->amount, 'edate' => $request->cash_date, 'project' => $request->project, 'project_according_amount' => $request->project_according_amount, 'deduction_type' => $request->deduction_type, 'payment_type' => $request->payment_type, 'comments' => $request->comments, ); $project_data = fetch_table_where('expenses_deductions','uid',$uid,TRUE); if($request->hasFile('scan_copy')) { $file = $request->file('scan_copy'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('PIMG'); $fileNamePrefix = db_unique_id('expenses_deductions',$fileNamePrefix); $scan_copy = $fileNamePrefix.'.'.$extension; $file->move('uploads/expenses-deductions/',$scan_copy); $db_array['scan_copy'] = $scan_copy; File::delete('uploads/expenses-deductions/'.$project_data["scan_copy"]); } update_table('expenses_deductions','uid',$uid,$db_array); _handle_expense_deduction_ledger_effects(['uid' => $uid, 'state' => 'update']); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'deduction_updated'), 'message_body' => print_lang($this->data["app_lang"],'deduction_updated_successfully'))); } public function delete($uid) { $project = fetch_table_where('expenses_deductions','uid',$uid,TRUE); if(!empty($project["scan_copy"])){ File::delete('uploads/expenses-deductions/'.$project["scan_copy"]); } delete_table('expenses_deductions','uid',$uid); _handle_expense_deduction_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function delete_all(Request $request) { $uids = $request->uids; $uids = explode(',',$uids); foreach($uids as $uid) { $project = fetch_table_where('expenses_deductions','uid',$uid,TRUE); if(!empty($project["scan_copy"])){ File::delete('uploads/expenses-deductions/'.$project["scan_copy"]); } delete_table('expenses_deductions','uid',$uid); _handle_expense_deduction_ledger_effects(['uid' => $uid, 'state' => 'delete']); } echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }