<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Project_loans extends Setup { public function __construct() { parent::__construct(); } public function received_money(Request $request) { $user_uid = Session::get('user_id'); $project_uid = str_replace('USR', '', $user_uid); $project_data = DB::table('projects')->where('uid',$project_uid); $expenses_deductions = DB::table('expenses_deductions')->where('user_type','project_user')->where('project',$project_uid); $project_payments = DB::table('project_payments')->where('payment_type','project')->where('project',$project_uid); $project_data = json_decode(json_encode($project_data->get()->first()),true); $expenses_deductions = json_decode(json_encode($expenses_deductions->get()),true); $project_payments = json_decode(json_encode($project_payments->get()),true); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["project_data"] = $project_data; $this->data["pageData"] = get_received_money_data(array('project' => $project_data, 'expenses_deductions' => $expenses_deductions, 'project_payments' => $project_payments, 'accounts' => $this->data["accounts"])); $this->data["title"] = print_lang($this->data["app_lang"],'received_money'); $this->data["pageToLoad"] = "project_loans/received_money.php"; $this->data["activeLink"] = "project-received-money"; $this->load_view($this->data); } public function view(Request $request) { $user_uid = Session::get('user_id'); $project_uid = str_replace('USR', '', $user_uid); $expenses_deductions = DB::table('expenses_deductions')->where('user_type','project_user')->where('project',$project_uid); if(!empty($request->currency)){ $expenses_deductions->where('currency',$request->currency); } if(!empty($request->from)){ $expenses_deductions->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $expenses_deductions->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($expenses_deductions->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'loans'); $this->data["pageToLoad"] = "project_loans/view.php"; $this->data["activeLink"] = "project-loans"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'cash_paid' => 'required', ]); $validator->validate(); $db_array = array( 'loan_cash_paid' => (float)$request->cash_paid, 'loan_pending_amount' => (float)$request->pending_amount, 'loan_details' => $request->details, ); $project_data = fetch_table_where('expenses_deductions','uid',$uid,TRUE); $attachment_link = false; if($request->hasFile('receipt')) { $file = $request->file('receipt'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('PLRT'); $fileNamePrefix = db_unique_id('expenses_deductions',$fileNamePrefix); $receipt = $fileNamePrefix.'.'.$extension; $file->move('uploads/project-loans/',$receipt); $db_array['loan_receipt'] = $receipt; if(!empty($project_data["loan_receipt"])) { File::delete('uploads/project-loans/'.$project_data["loan_receipt"]); } $attachment_link = '<a class="btn btn-primary btn-xs" target="_blank" href="'.url('/').'/uploads/project-loans/'.$receipt.'">'.print_lang($this->data["app_lang"],'preview').'</a>'; } if($attachment_link == false) { if(!empty($project_data["loan_receipt"])) { $attachment_link = '<a class="btn btn-primary btn-xs" target="_blank" href="'.url('/').'/uploads/project-loans/'.$project_data['loan_receipt'].'">'.print_lang($this->data["app_lang"],'preview').'</a>'; } else { $attachment_link = '<span class="label label-info">'.print_lang($this->data["app_lang"],'no_image').'</span>'; } } $output_array = array( 'uid' => $uid, 'cash_paid' => $db_array['loan_cash_paid'], 'pending_amount' => $db_array['loan_pending_amount'], 'details' => $db_array['loan_details'], 'receipt' => $attachment_link, ); update_table('expenses_deductions','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'output' => $output_array, 'message_head' => print_lang($this->data["app_lang"],'project_loan_updated'), 'message_body' => print_lang($this->data["app_lang"],'project_loan_updated_successfully'))); } }