<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Project_payments extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_project_projects_payments') === FALSE){ Redirect::to('/')->send(); } $project_payments = DB::table('project_payments'); if(!empty($request->currency)){ $project_payments->where('currency',$request->currency); } if(!empty($request->project)){ $project_payments->where('project',$request->project); } if(!empty($request->from)){ $project_payments->where('pdate','>=',get_true_date($request->from)); } if(!empty($request->to)){ $project_payments->where('pdate','<=',get_true_date($request->to)); } $this->data["pageData"] = json_decode(json_encode($project_payments->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["projects"] = set_array_keys(fetch_table_branch('projects'),'uid'); $this->data["users"] = set_array_keys(fetch_branch_users(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_project"] = $request->project; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'project_payments'); $this->data["pageToLoad"] = "project_payments/view.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_project_projects_payments') === FALSE){ Redirect::to('/')->send(); } $this->data["projects"] = set_array_keys(fetch_table_where_branch('projects','status','pending'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["users"] = fetch_branch_users(); $this->data["title"] = print_lang($this->data["app_lang"],'new_project_payment'); $this->data["pageToLoad"] = "project_payments/add.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'amount' => 'required', 'pdate' => 'required', 'project' => 'required', 'account' => 'required', 'payment_type' => 'required', 'user' => 'required', ]); $validator->validate(); $uid = getUniqueId('PPAY', 'project_payments', 'uid'); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $request->currency, 'currency_usd_equalance' => $currency_data['usd_equalance'], 'amount' => $request->amount, 'pdate' => get_true_date($request->pdate), 'project' => $request->project, 'project_according_amount' => $request->project_according_amount, 'account' => $request->account, 'payment_type' => $request->payment_type, 'user' => $request->user, 'comments' => $request->comments, ); if($request->hasFile('scan_copy')) { $file = $request->file('scan_copy'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('PPDI'); $fileNamePrefix = db_unique_id('project_payments',$fileNamePrefix); $scan_copy = $fileNamePrefix.'.'.$extension; $file->move('uploads/project-payments/',$scan_copy); $db_array['scan_copy'] = $scan_copy; } insert_table('project_payments',$db_array); _handle_project_payment_ledger_effects(['uid' => $uid, 'state' => 'new']); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'project_payment_saved'), 'message_body' => print_lang($this->data["app_lang"],'project_payment_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_project_projects_payments') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('project_payments','uid',$uid,true); $this->data["projects"] = set_array_keys(fetch_table_where_branch('projects','status','pending'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["users"] = fetch_branch_users(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_project_payment'); $this->data["pageToLoad"] = "project_payments/edit.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'amount' => 'required', 'pdate' => 'required', 'project' => 'required', 'account' => 'required', 'payment_type' => 'required', 'user' => 'required', ]); $validator->validate(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'currency' => $request->currency, 'currency_usd_equalance' => $currency_data['usd_equalance'], 'amount' => $request->amount, 'pdate' => get_true_date($request->pdate), 'project' => $request->project, 'project_according_amount' => $request->project_according_amount, 'account' => $request->account, 'payment_type' => $request->payment_type, 'user' => $request->user, 'comments' => $request->comments, ); $project_data = fetch_table_where('project_payments','uid',$uid,TRUE); if($request->hasFile('scan_copy')) { $file = $request->file('scan_copy'); $extension = $file->getClientOriginalExtension(); $fileNamePrefix = get_simple_unique_id('PIMG'); $fileNamePrefix = db_unique_id('project_payments',$fileNamePrefix); $scan_copy = $fileNamePrefix.'.'.$extension; $file->move('uploads/project-payments/',$scan_copy); $db_array['scan_copy'] = $scan_copy; File::delete('uploads/project-payments/'.$project_data["scan_copy"]); } update_table('project_payments','uid',$uid,$db_array); _handle_project_payment_ledger_effects(['uid' => $uid, 'state' => 'update']); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'project_payment_updated'), 'message_body' => print_lang($this->data["app_lang"],'project_payment_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_project_projects_payments') === FALSE){ Redirect::to('/')->send(); } $project = fetch_table_where('project_payments','uid',$uid,TRUE); if(!empty($project["scan_copy"])){ File::delete('uploads/payment-deductions/'.$project["scan_copy"]); } delete_table('project_payments','uid',$uid); _handle_project_payment_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }