<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Project_report extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_project_projects_reports') === FALSE){ Redirect::to('/')->send(); } $projects_reports = DB::table('projects_reports'); if(!empty($request->project)){ $projects_reports->where('project',$request->project); } if(!empty($request->from)){ $projects_reports->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $projects_reports->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($projects_reports->get()),true); $this->data["projects"] = set_array_keys(fetch_table_branch('projects'),'uid'); $this->data["users"] = set_array_keys(fetch_branch_users(),'uid'); $this->data["search_project"] = $request->project; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'projects_reports'); $this->data["pageToLoad"] = "project_report/view.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function view_single(Request $request, $uid) { if(check_user_access('view_project_projects_reports_details') === FALSE){ Redirect::to('/')->send(); } $this->data["report_data"] = fetch_table_where('projects_reports','uid',$uid,true); $this->data["title"] = print_lang($this->data["app_lang"],'project_report'); $this->data["pageToLoad"] = "project_report/single.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_project_projects_reports') === FALSE){ Redirect::to('/')->send(); } $this->data["projects"] = fetch_table_branch('projects'); $this->data["title"] = print_lang($this->data["app_lang"],'add_project_report'); $this->data["pageToLoad"] = "project_report/add.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'title' => 'required', 'project' => 'required', ]); $validator->validate(); $uid = getUniqueId('PREP', 'projects_reports', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'title' => $request->title, 'project' => $request->project, 'content' => $request->content, 'user' => Session::get('user_id'), ); insert_table('projects_reports',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'project_report_saved'), 'message_body' => print_lang($this->data["app_lang"],'project_report_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_project_projects_reports') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('projects_reports','uid',$uid,true); $this->data["projects"] = fetch_table_branch('projects'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_project'); $this->data["pageToLoad"] = "project_report/edit.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'title' => 'required', 'project' => 'required', ]); $validator->validate(); $db_array = array( 'title' => $request->title, 'project' => $request->project, 'content' => $request->content, ); update_table('projects_reports','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'project_report_updated'), 'message_body' => print_lang($this->data["app_lang"],'project_report_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_project_projects_reports') === FALSE){ Redirect::to('/')->send(); } delete_table('projects_reports','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }