<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Projects_assign extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_project_assigning') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $projects_assign = DB::table('projects_assign')->where('branch',$branch_id); if(!empty($request->type)){ $projects_assign->where('assign_type',$request->type); } if(!empty($request->from)){ $projects_assign->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $projects_assign->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($projects_assign->get()),true); $this->data["projects"] = set_array_keys(fetch_table_branch('projects'),'uid'); $this->data["ccontracts"] = set_array_keys(fetch_table_branch('ccontracts'),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('citems'),'uid'); $this->data["employees"] = set_array_keys(fetch_table_where_branch('accounts','type','employee'),'uid'); $this->data["search_type"] = $request->type; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'projects_assigning'); $this->data["pageToLoad"] = "projects_assigning/view.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function print_view(Request $request) { if(check_user_access('view_project_assigning') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $projects_assign = DB::table('projects_assign')->where('branch',$branch_id); if(!empty($request->type)){ $projects_assign->where('assign_type',$request->type); } if(!empty($request->from)){ $projects_assign->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $projects_assign->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($projects_assign->get()),true); $this->data["projects"] = set_array_keys(fetch_table_branch('projects'),'uid'); $this->data["ccontracts"] = set_array_keys(fetch_table_branch('ccontracts'),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('citems'),'uid'); $this->data["employees"] = set_array_keys(fetch_table_where_branch('accounts','type','employee'),'uid'); $this->data["search_type"] = $request->type; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'projects_assigning'); $this->data["pageToLoad"] = "projects_assigning/print.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_project_assigning') === FALSE){ Redirect::to('/')->send(); } $this->data["projects"] = fetch_table_where_branch('projects','status','pending'); $this->data["machinery"] = fetch_table_where_branch('ccontracts','contract_type','machinery'); $this->data["employees"] = fetch_table_where_branch('ccontracts','contract_type','employee'); $this->data["warehouses"] = fetch_table_branch('cwarehouses'); $this->data["items"] = fetch_table_branch('citems'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'new_project_assigning'); $this->data["pageToLoad"] = "projects_assigning/add.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'project' => 'required', 'assign_type' => 'required', ]); $validator->validate(); $project_data = fetch_table_where_branch('projects','uid',$request->project,true); $item_cost = 0; $item_total = 0; $supplier = NULL; $project_currency = 'usd'; $project_currency_usd_equalance = 1; if($request->assign_type == 'material') { $last_cost = DB::table("cpurchases")->where("item",$request->item)->orderBy('id','desc')->get()->first(); $last_cost = json_decode(json_encode($last_cost),true); if(isset($last_cost['rate'])) { $item_cost = (float)$last_cost['rate']; $item_total = $item_cost * (float)$request->qty; $project_currency = $last_cost['currency']; $project_currency_usd_equalance = (float)$last_cost['currency_usd_equalance']; } } else if($request->assign_type == 'machinery') { $machinery_data = fetch_table_where_branch('ccontracts','uid',$request->machinery,true); $project_currency = $machinery_data['currency']; $project_currency_usd_equalance = (float)$machinery_data['currency_usd_equalance']; } else { $employee_contract_data = fetch_table_where_branch('ccontracts','uid',$request->employee,true); $project_currency = $employee_contract_data['currency']; $project_currency_usd_equalance = (float)$employee_contract_data['currency_usd_equalance']; } if(isset($machinery_data['supplier'])) { $supplier = $machinery_data['supplier']; } $uid = getUniqueId('CPAS', 'projects_assign', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'project' => $request->project, 'project_currency' => $project_currency, 'project_currency_usd_equalance' => $project_currency_usd_equalance, 'assign_type' => $request->assign_type, 'employee' => $request->employee, 'num_of_duration' => $request->num_of_duration, 'employee_comments' => $request->employee_comments, 'machinery' => $request->machinery, 'supplier' => $supplier, 'number_of_hours' => $request->number_of_hours, 'machinery_comments' => $request->machinery_comments, 'warehouse' => $request->warehouse, 'item' => $request->item, 'qty' => $request->qty, 'rate' => $item_cost, 'item_total' => $item_total, 'material_comments' => $request->material_comments, 'user' => Session::get('user_id'), ); insert_table('projects_assign',$db_array); _handle_project_contract_assigned_ledger_effects(['uid' => $uid, 'state' => 'new']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_project_assign'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/projects-assign/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_project_assigned').', '.print_lang($this->data["app_lang"],'dashboard_activities_text_assign_type').': '.$db_array['assign_type'], ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'project_assigning_saved'), 'message_body' => print_lang($this->data["app_lang"],'project_assigning_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_project_assigning') === FALSE){ Redirect::to('/')->send(); } $editing_data = fetch_table_where('projects_assign','uid',$uid,true); $this->data["editing_data"] = $editing_data; if(!is_array($this->data["editing_data"])){ Redirect::to('/projects-assign')->send(); } $this->data["projects"] = fetch_table_where_branch('projects','status','pending'); $this->data["machinery"] = fetch_table_where_branch('ccontracts','contract_type','machinery'); $this->data["employees"] = fetch_table_where_branch('ccontracts','contract_type','employee'); $this->data["warehouses"] = fetch_table_branch('cwarehouses'); $this->data["items"] = fetch_table_where_branch('citems','uid',$editing_data['item']); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_project_assigning'); $this->data["pageToLoad"] = "projects_assigning/edit.php"; $this->data["activeLink"] = "projects"; $this->load_view($this->data); } public function status(Request $request, $uid) { if(check_user_access('edit_purchase') === FALSE){ Redirect::to('/')->send(); } $db_array = array( 'status' => 'passed', ); update_table('projects_assign','uid',$uid,$db_array); _handle_project_contract_assigned_ledger_effects(['uid' => $uid, 'state' => 'new']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_project_assign'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_status_update'), 'url' => '/projects-assign/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_assigning_approved'), ); set_activity_alert($_activity_details); return redirect('/projects-assign'); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'project' => 'required', 'assign_type' => 'required', ]); $validator->validate(); $project_data = fetch_table_where_branch('projects','uid',$request->project,true); $item_cost = 0; $item_total = 0; $supplier = NULL; $project_currency = 'usd'; $project_currency_usd_equalance = 1; if($request->assign_type == 'material') { $last_cost = DB::table("cpurchases")->where("item",$request->item)->orderBy('id','desc')->get()->first(); $last_cost = json_decode(json_encode($last_cost),true); if(isset($last_cost['rate'])) { $item_cost = (float)$last_cost['rate']; $item_total = $item_cost * (float)$request->qty; $project_currency = $last_cost['currency']; $project_currency_usd_equalance = (float)$last_cost['currency_usd_equalance']; } } else if($request->assign_type == 'machinery') { $machinery_data = fetch_table_where_branch('ccontracts','uid',$request->machinery,true); $project_currency = $machinery_data['currency']; $project_currency_usd_equalance = (float)$machinery_data['currency_usd_equalance']; } else { $employee_contract_data = fetch_table_where_branch('ccontracts','uid',$request->employee,true); $project_currency = $employee_contract_data['currency']; $project_currency_usd_equalance = (float)$employee_contract_data['currency_usd_equalance']; } if(isset($machinery_data['supplier'])) { $supplier = $machinery_data['supplier']; } $db_array = array( 'project' => $request->project, 'project_currency' => $project_currency, 'project_currency_usd_equalance' => $project_currency_usd_equalance, 'assign_type' => $request->assign_type, 'employee' => $request->employee, 'num_of_duration' => $request->num_of_duration, 'employee_comments' => $request->employee_comments, 'machinery' => $request->machinery, 'supplier' => $supplier, 'number_of_hours' => $request->number_of_hours, 'machinery_comments' => $request->machinery_comments, 'warehouse' => $request->warehouse, 'item' => $request->item, 'qty' => $request->qty, 'rate' => $item_cost, 'item_total' => $item_total, 'material_comments' => $request->material_comments, ); update_table('projects_assign','uid',$uid,$db_array); _handle_project_contract_assigned_ledger_effects(['uid' => $uid, 'state' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_project_assign'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/projects-assign/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_project_assigned').', '.print_lang($this->data["app_lang"],'dashboard_activities_text_assign_type').': '.$db_array['assign_type'], ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'project_assigning_updated'), 'message_body' => print_lang($this->data["app_lang"],'project_assigning_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_project_assigning') === FALSE){ Redirect::to('/')->send(); } $delete_data = fetch_table_where('projects_assign','uid',$uid,TRUE); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_project_assign'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_project_assigned').', '.print_lang($this->data["app_lang"],'dashboard_activities_text_assign_type').': '.$delete_data['assign_type'], ); set_activity_alert($_activity_details); delete_table('projects_assign','uid',$uid); _handle_project_contract_assigned_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function warehouse_items(Request $request) { $options = '<option value="" disabled="" selected="">-- Select --</option>'; $warehouse = $request->warehouse; $items = get_warehouse_items($warehouse); foreach($items as $item) { $options .= '<option value="'.$item['uid'].'">'.$item['name'].'</option>'; } echo json_encode(array('status' => 'success', 'options' => $options)); } }