<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Purchases extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_purchase') === FALSE){ Redirect::to('/')->send(); } if(empty($request->status)){ $request->status = 'passed'; } $branch_id = active_branch_id(); $purchases = DB::table('purchases')->where('branch',$branch_id); if(!empty($request->currency)){ $purchases->where('currency',$request->currency); } if(!empty($request->supplier)){ $purchases->where('supplier',$request->supplier); } if(!empty($request->user)){ $purchases->where('user',$request->user); } if(!empty($request->from)){ $purchases->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $purchases->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $purchases->where(function($query) use ($request){ $query->where('main_approval','pending')->orWhere('main_approval','approved'); }); $purchases = json_decode(json_encode($purchases->get()),true); $this->data["pageData"] = $purchases; $this->data["users"] = std_obj_to_array(DB::table('users')->where('branch',active_branch_id())->orWhere('role','SUPERADMIN')->get()); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_status"] = $request->status; $this->data["search_currency"] = $request->currency; $this->data["search_convert_currency"] = $request->convert_currency; $this->data["search_supplier"] = $request->supplier; $this->data["search_user"] = $request->user; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'purchases'); $this->data["pageToLoad"] = "purchases/view.php"; $this->data["activeLink"] = "purchases"; $this->load_view($this->data); } public function invoice(Request $request,$uid) { if(is_customer_user() === false){ if(check_user_access('add_purchase') === FALSE){ Redirect::to('/')->send(); } } $this->data["invoice_data"] = fetch_table_where('purchases','uid',$uid,true); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'purchase_invoice'); $this->data["pageToLoad"] = "purchases/invoice.php"; $this->data["activeLink"] = "purchases"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_purchase') === FALSE){ Redirect::to('/')->send(); } $batch_valid = array(); $batch_wise_stock = std_obj_to_array(DB::table('batch_wise_stock')->select('batch','item')->distinct()->get()); foreach($batch_wise_stock as $_batch) { $batch_valid[$_batch['batch']] = $_batch['item']; } $batch_valid = json_encode($batch_valid); $this->data["batch_valid"] = $batch_valid; $this->data["items"] = fetch_table_branch('items'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["warehouse"] = fetch_table_branch('warehouse'); $this->data["batch"] = fetch_table_branch('batch'); $this->data["suppliers"] = fetch_table_where_branch('accounts','type','supplier'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $transits = fetch_table_branch('transit'); $this->data["transits"] = fetch_transits_with_stats($transits); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'add_purchase'); $this->data["pageToLoad"] = "purchases/add.php"; $this->data["activeLink"] = "purchases"; $this->load_view($this->data); } public function save(Request $request) { $items_found = false; $active_branch_id = active_branch_id(); $_items_effected = array(); $purchase_collection_of_items = array(); $purchase_collection_of_items_uid = array(); $purchase_collection_of_warehouses_uid = array(); $purchase_collection_of_batch_uid = array(); $purchase_collection_of_expense_uid = array(); $purchase_collection_of_transport_expenses = array(); $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); if(count($request->item) > 0) { $items_count = 0; while($items_count < count($request->item)) { if(empty($request->item[$items_count])){ continue; } $mfg_item = NULL; if(!empty($request->mfg[$items_count]) AND $request->mfg[$items_count] != 'undefined') { $mfg_item = get_true_date($request->mfg[$items_count]); } $expiry_item = NULL; if(!empty($request->expiry[$items_count]) AND $request->expiry[$items_count] != 'undefined') { $expiry_item = get_true_date($request->expiry[$items_count]); } $items_found = true; $item_array = array( 'item' => $request->item[$items_count], 'warehouse' => $request->warehouse[$items_count], 'cost' => (float)$request->cost[$items_count], 'real_cost' => (float)$request->real_cost[$items_count], 'qty' => (float)$request->qty[$items_count], 'bonus' => (float)$request->bonus[$items_count], 'm2' => (float)$request->m2[$items_count], 'width' => (float)$request->width[$items_count], 'height' => (float)$request->height[$items_count], 'unit' => $request->unit[$items_count], 'profit' => (float)$request->profit[$items_count], 'tp' => isset($request->sale_price[$items_count]) ? (float)$request->sale_price[$items_count] : 0, 'bundle' => isset($request->bundle[$items_count]) ? (float)$request->bundle[$items_count] : 0, 'toop' => isset($request->toop[$items_count]) ? (float)$request->toop[$items_count] : 0, 'token_rate' => isset($request->token_rate[$items_count]) ? (float)$request->token_rate[$items_count] : 0, 'item_token' => isset($request->item_token[$items_count]) ? (float)$request->item_token[$items_count] : 0, 'discount' => (float)$request->discount[$items_count], 'batch' => empty($request->batch[$items_count]) ? env('APP_BATCH') : $request->batch[$items_count], 'mfg' => $mfg_item, 'expiry' => $expiry_item, 'sale_price' => (float)$request->sale_price[$items_count], 'transport_expense' => (float)$request->transport_expense[$items_count], 'expense' => $request->expense[$items_count], 'total' => (float)$request->total[$items_count], ); $purchase_collection_of_items[] = $item_array; $purchase_collection_of_items_uid[] = '-++-'.$request->item[$items_count].'-++-'; $_items_effected[] = $request->item[$items_count]; $purchase_collection_of_warehouses_uid[] = '-++-'.$request->warehouse[$items_count].'-++-'; $purchase_collection_of_batch_uid[] = '-++-'.$request->batch[$items_count].'-++-'; $purchase_collection_of_expense_uid[] = '-++-'.$request->expense[$items_count].'-++-'; $purchase_collection_of_transport_expenses[] = (float)$request->transport_expense[$items_count]; $items_count++; } } if($items_found == true) { $supplier_old_balance = get_account_balance($request->supplier[0],$request->currency[0]); $uid = getUniqueId('PRCH', 'purchases', 'uid'); $created_at = get_true_date( empty($request->pdate[0]) ? date('Y-m-d') : $request->pdate[0] ); $time_cr = date('H:i:s'); $created_at = $created_at." ".$time_cr; $db_array = array( 'uid' => $uid, 'branch' => $active_branch_id, 'serial_id' => get_serial_id('purchases'), 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'supplier' => $request->supplier[0], 'old_balance' => $supplier_old_balance, 'invoice' => $request->invoice[0], 'memo' => $request->memo[0], 'grand_total' => $request->grand_total, 'discount_amount' => $request->discount_amount, 'sub_total_amount' => $request->sub_total_amount, 'paid_amount' => $request->paid_amount, 'pending_amount' => $request->pending_amount, 'cash_paid_account' => $request->cash_paid_account, 'transport_expense' => array_sum($purchase_collection_of_transport_expenses), 'items' => json_encode($purchase_collection_of_items), 'items_uid' => implode(',', $purchase_collection_of_items_uid), 'warehouses_uid' => implode(',', $purchase_collection_of_warehouses_uid), 'batch_uid' => implode(',', $purchase_collection_of_batch_uid), 'expense_uid' => implode(',', $purchase_collection_of_expense_uid), 'created_at' => $created_at, 'user' => Session::get('user_id'), 'user_name' => Session::get('user_name'), 'status' => 'passed', 'sub_approval' => user_approval_info('sub_approval'), 'sub_approval_user' => user_approval_info('sub_approval_user'), 'sub_approval_user_name' => user_approval_info('sub_approval_user_name'), 'main_approval' => user_approval_info('main_approval'), 'main_approval_user' => user_approval_info('main_approval_user'), 'main_approval_user_name' => user_approval_info('main_approval_user_name'), ); insert_table('purchases',$db_array); if(user_approval_info('main_approval') == 'approved') { _handle_purchases_ledger_effects(['uid' => $uid, 'state' => 'new']); _handle_items_inventory_stats_from_purchases(['uid' => $uid, 'entry_status' => 'new']); } $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_purchases'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/purchases/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['sub_total_amount']), ); set_activity_alert($_activity_details); $invoice_url = url('/purchases/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'purchase_added'), 'message_body' => print_lang($this->data["app_lang"],'new_purchase_added_successfully'))); } else { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'item_not_found'), 'message_body' => print_lang($this->data["app_lang"],'add_items_to_proceed'))); } } public function edit(Request $request, $uid) { if(check_user_access('edit_purchase') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('purchases','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/purchases')->send(); } $batch_valid = array(); $batch_wise_stock = std_obj_to_array(DB::table('batch_wise_stock')->select('batch','item')->distinct()->get()); foreach($batch_wise_stock as $_batch) { $batch_valid[$_batch['batch']] = $_batch['item']; } $batch_valid = json_encode($batch_valid); $this->data["batch_valid"] = $batch_valid; $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["currencies"] = fetch_currencies(); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["batch"] = set_array_keys(fetch_table_branch('batch'),'uid'); $this->data["suppliers"] = fetch_table_where_branch('accounts','type','supplier'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $transits = fetch_table_branch('transit'); $this->data["transits"] = fetch_transits_with_stats($transits); $this->data["title"] = print_lang($this->data["app_lang"],'edit_purchase'); $this->data["pageToLoad"] = "purchases/edit.php"; $this->data["activeLink"] = "purchases"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_found = false; $active_branch_id = active_branch_id(); $_items_effected = array(); $purchase_collection_of_items = array(); $purchase_collection_of_items_uid = array(); $purchase_collection_of_warehouses_uid = array(); $purchase_collection_of_batch_uid = array(); $purchase_collection_of_expense_uid = array(); $purchase_collection_of_transport_expenses = array(); $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); if(count($request->item) > 0) { $items_count = 0; while($items_count < count($request->item)) { if(empty($request->item[$items_count])){ continue; } $items_found = true; $mfg_item = NULL; if(!empty($request->mfg[$items_count]) AND $request->mfg[$items_count] != 'undefined') { $mfg_item = get_true_date($request->mfg[$items_count]); } $expiry_item = NULL; if(!empty($request->expiry[$items_count]) AND $request->expiry[$items_count] != 'undefined') { $expiry_item = get_true_date($request->expiry[$items_count]); } $item_array = array( 'item' => $request->item[$items_count], 'warehouse' => $request->warehouse[$items_count], 'cost' => (float)$request->cost[$items_count], 'real_cost' => (float)$request->real_cost[$items_count], 'qty' => (float)$request->qty[$items_count], 'bonus' => (float)$request->bonus[$items_count], 'm2' => (float)$request->m2[$items_count], 'width' => (float)$request->width[$items_count], 'height' => (float)$request->height[$items_count], 'unit' => $request->unit[$items_count], 'profit' => (float)$request->profit[$items_count], 'tp' => isset($request->sale_price[$items_count]) ? (float)$request->sale_price[$items_count] : 0, 'bundle' => isset($request->bundle[$items_count]) ? (float)$request->bundle[$items_count] : 0, 'toop' => isset($request->toop[$items_count]) ? (float)$request->toop[$items_count] : 0, 'token_rate' => isset($request->token_rate[$items_count]) ? (float)$request->token_rate[$items_count] : 0, 'item_token' => isset($request->item_token[$items_count]) ? (float)$request->item_token[$items_count] : 0, 'discount' => (float)$request->discount[$items_count], 'batch' => empty($request->batch[$items_count]) ? env('APP_BATCH') : $request->batch[$items_count], 'mfg' => $mfg_item, 'expiry' => $expiry_item, 'sale_price' => (float)$request->sale_price[$items_count], 'transport_expense' => (float)$request->transport_expense[$items_count], 'expense' => $request->expense[$items_count], 'total' => (float)$request->total[$items_count], ); $purchase_collection_of_items[] = $item_array; $purchase_collection_of_items_uid[] = '-++-'.$request->item[$items_count].'-++-'; $_items_effected[] = $request->item[$items_count]; $purchase_collection_of_warehouses_uid[] = '-++-'.$request->warehouse[$items_count].'-++-'; $purchase_collection_of_batch_uid[] = '-++-'.$request->batch[$items_count].'-++-'; $purchase_collection_of_expense_uid[] = '-++-'.$request->expense[$items_count].'-++-'; $purchase_collection_of_transport_expenses[] = (float)$request->transport_expense[$items_count]; $items_count++; } } if($items_found == true) { $last_purchase = fetch_table_where('purchases','uid',$uid,true); $last_created_at = $last_purchase['created_at']; $last_time = date("H:i:s",strtotime($last_created_at)); $created_at = get_true_date( empty($request->pdate[0]) ? date('Y-m-d') : $request->pdate[0] ); $created_at = $created_at." ".$last_time; $db_array = array( 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'supplier' => $request->supplier[0], 'invoice' => $request->invoice[0], 'memo' => $request->memo[0], 'grand_total' => $request->grand_total, 'discount_amount' => $request->discount_amount, 'sub_total_amount' => $request->sub_total_amount, 'paid_amount' => $request->paid_amount, 'cash_paid_account' => $request->cash_paid_account, 'pending_amount' => $request->pending_amount, 'transport_expense' => array_sum($purchase_collection_of_transport_expenses), 'items' => json_encode($purchase_collection_of_items), 'items_uid' => implode(',', $purchase_collection_of_items_uid), 'warehouses_uid' => implode(',', $purchase_collection_of_warehouses_uid), 'batch_uid' => implode(',', $purchase_collection_of_batch_uid), 'expense_uid' => implode(',', $purchase_collection_of_expense_uid), 'created_at' => $created_at, ); $purchase_before_update = fetch_table_where('purchases','uid',$uid,true); update_table('purchases','uid',$uid,$db_array); _handle_purchases_ledger_effects(['uid' => $uid, 'state' => 'update']); if($purchase_before_update['status'] == 'passed') { _handle_items_inventory_stats_from_purchases(['uid' => $uid, 'entry_status' => 'update']); } $purchase_items_before_update = empty($purchase_before_update['items']) ? array() : json_decode($purchase_before_update['items'],true); if(!empty($purchase_items_before_update)) { foreach($purchase_items_before_update as $old_item) { if(!empty($old_item['item'])) { _calculate_item_wise_stats(['item' => $old_item['item']]); } } } $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_purchases'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/purchases/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['sub_total_amount']), ); set_activity_alert($_activity_details); $invoice_url = url('/purchases/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'update', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'purchase_updated'), 'message_body' => print_lang($this->data["app_lang"],'purchase_updated_successfully'))); } else { echo json_encode(array('status' => 'error', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'item_not_found'), 'message_body' => print_lang($this->data["app_lang"],'add_items_to_proceed'))); } } public function delete($uid) { if(check_user_access('delete_purchase') === FALSE){ Redirect::to('/')->send(); } $purchase_data = fetch_table_where('purchases','uid',$uid,true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_purchases'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$purchase_data['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($purchase_data['sub_total_amount']), ); set_activity_alert($_activity_details); delete_table('purchases','uid',$uid); _handle_purchases_ledger_effects(['uid' => $uid, 'state' => 'delete']); _handle_items_inventory_stats_from_purchases(['uid' => $uid, 'entry_status' => 'delete']); $purchase_items_before_update = empty($purchase_data['items']) ? array() : json_decode($purchase_data['items'],true); if(!empty($purchase_items_before_update)) { foreach($purchase_items_before_update as $old_item) { if(!empty($old_item['item'])) { _calculate_item_wise_stats(['item' => $old_item['item']]); } } } echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function update_status($uid) { if(check_user_access('edit_purchase') === FALSE){ Redirect::to('/')->send(); } $purchase_data = fetch_table_where('purchases','uid',$uid,true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_purchases'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_purchase_passed'), 'url' => '/purchases/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$purchase_data['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($purchase_data['sub_total_amount']), ); set_activity_alert($_activity_details); $db_array = array('status' => 'passed'); update_table('purchases','uid',$uid,$db_array); _handle_items_inventory_stats_from_purchases(['uid' => $uid, 'entry_status' => 'update']); echo json_encode(array('status' => 'success', 'mode' => 'status_passed')); } public function save_cbm_weight(Request $request) { $db_array = [ 'item_width' => $request->width, 'item_length' => $request->length, 'item_height' => $request->height, 'cbm' => $request->cbm, 'weight' => $request->weight ]; update_table('items','uid',$request->item,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'item' => $request->item, 'width' => $request->width, 'length' => $request->length, 'height' => $request->height, 'cbm' => $request->cbm, 'weight' => $request->weight, 'message_head' => print_lang($this->data["app_lang"],'purchase_cbm_popup_update_msg_head'), 'message_body' => print_lang($this->data["app_lang"],'purchase_cbm_popup_update_msg_body'))); } }