<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Quotation extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_quotation') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $quotations = DB::table('quotations')->where('branch',$branch_id)->where('status','pending'); if(!empty($request->currency)){ $quotations->where('currency',$request->currency); } if(!empty($request->client)){ $quotations->where('client',$request->client); } if(!empty($request->from)){ $quotations->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $quotations->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($quotations->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'quotations'); $this->data["pageToLoad"] = "quotation/view.php"; $this->data["activeLink"] = "quotations"; $this->load_view($this->data); } public function converted(Request $request) { if(check_user_access('view_converted_quotation') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $quotations = DB::table('quotations')->where('branch',$branch_id)->where('status','converted'); if(!empty($request->currency)){ $quotations->where('currency',$request->currency); } if(!empty($request->client)){ $quotations->where('client',$request->client); } if(!empty($request->from)){ $quotations->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $quotations->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($quotations->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["sales"] = set_array_keys(fetch_table_branch('sales'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'quotations'); $this->data["pageToLoad"] = "quotation/converted.php"; $this->data["activeLink"] = "quotations_converted"; $this->load_view($this->data); } public function invoice(Request $request, $uid) { if(check_user_access('add_quotation') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('quotations','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(get_warehouse_wise_items(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'quotation_invoice'); $this->data["pageToLoad"] = "quotation/invoice.php"; $this->data["activeLink"] = "quotations"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_quotation') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_number"] = get_quotation_quotation_number(); $this->data["currencies"] = fetch_currencies(); $this->data["batch"] = fetch_table_branch('batch'); $this->data["items"] = get_items_for_sale(); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["clients"] = fetch_all_clients(); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'add_quotation'); $this->data["pageToLoad"] = "quotation/add.php"; $this->data["activeLink"] = "quotations"; $this->load_view($this->data); } public function save(Request $request) { $items_details = array(); $items = array(); $warehouse = array(); $batch = array(); $sic = 0; $invoice_num = (int)$request->invoice[0]; $invoice_num_exist = DB::table('quotations')->where('invoice',$invoice_num)->get(); if($invoice_num_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => 'Invoice Exist', 'message_body' => 'This invoice number already exist.')); die; } while($sic < count($request->item)) { if(empty($request->item[$sic])){ $sic++; continue; } $items_details[] = array( 'item' => $request->item[$sic], 'warehouse' => $request->warehouse[$sic], 'batch' => $request->batch[$sic], 'narration' => $request->narration[$sic], 'cost' => (float)$request->cost[$sic], 'sale_price' => (float)$request->sale_price[$sic], 'qty' => (float)$request->qty[$sic], 'm2' => (float)$request->m2[$sic], 'width' => (float)$request->width[$sic], 'height' => (float)$request->height[$sic], 'unit' => $request->unit[$sic], 'discount' => (float)$request->discount[$sic], 'profit' => (float)$request->profit[$sic], 'item_total' => (float)$request->item_total[$sic], ); $items[] = '-++-'.$request->item[$sic].'-++-'; $warehouse[] = '-++-'.$request->warehouse[$sic].'-++-'; $batch[] = '-++-'.$request->batch[$sic].'-++-'; $sic++; } if(!empty($request->cash_client_name)) { $cash_client_name = $request->cash_client_name[0]; } else { $cash_client_name = ''; } if(!empty($request->cash_client_mobile)) { $cash_client_mobile = $request->cash_client_mobile[0]; } else { $cash_client_mobile = ''; } $uid = getUniqueId('QUTE', 'quotations', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $request->currency[0], 'client' => $request->client[0], 'cash_client_name' => $cash_client_name, 'cash_client_mobile' => $cash_client_mobile, 'invoice' => $invoice_num, 'memo' => $request->memo[0], 'items_details' => json_encode($items_details), 'sale_items' => implode(',', $items), 'sale_warehouse' => implode(',', $warehouse), 'sale_batch' => implode(',', $batch), 'total_sales_amount' => (float)$request->total_sales_amount, 'total_discount_amount' => (float)$request->total_discount_amount, 'gross_total_amount' => (float)$request->gross_total_amount, 'total_profit_amount' => (float)$request->total_profit_amount, ); insert_table('quotations',$db_array); $invoice_url = url('/quotations/invoice').'/'.$uid; $invoice_number = get_quotation_quotation_number(); echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_number' => $invoice_number, 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'quotation_saved'), 'message_body' => print_lang($this->data["app_lang"],'quotation_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_quotation') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('quotations','uid',$uid,true); $this->data["currencies"] = fetch_currencies(); $this->data["batch"] = set_array_keys(fetch_table_branch('batch'),'uid'); $this->data["items"] = set_array_keys(get_items_for_sale(),'uid'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_quotation'); $this->data["pageToLoad"] = "quotation/edit.php"; $this->data["activeLink"] = "quotations"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_details = array(); $items = array(); $warehouse = array(); $batch = array(); $sic = 0; $invoice_num = (int)$request->invoice[0]; $invoice_num_exist = DB::table('quotations')->where('uid','!=',$uid)->where('invoice',$invoice_num)->get(); if($invoice_num_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'update', 'message_head' => 'Quotation Exist', 'message_body' => 'This quotation number already exist.')); die; } while($sic < count($request->item)) { if(empty($request->item[$sic])){ $sic++; continue; } $items_details[] = array( 'item' => $request->item[$sic], 'warehouse' => $request->warehouse[$sic], 'batch' => $request->batch[$sic], 'narration' => $request->narration[$sic], 'cost' => (float)$request->cost[$sic], 'sale_price' => (float)$request->sale_price[$sic], 'qty' => (float)$request->qty[$sic], 'm2' => (float)$request->m2[$sic], 'width' => (float)$request->width[$sic], 'height' => (float)$request->height[$sic], 'unit' => $request->unit[$sic], 'discount' => (float)$request->discount[$sic], 'profit' => (float)$request->profit[$sic], 'item_total' => (float)$request->item_total[$sic], ); $items[] = '-++-'.$request->item[$sic].'-++-'; $warehouse[] = '-++-'.$request->warehouse[$sic].'-++-'; $batch[] = '-++-'.$request->batch[$sic].'-++-'; $sic++; } if(!empty($request->cash_client_name)) { $cash_client_name = $request->cash_client_name[0]; } else { $cash_client_name = ''; } if(!empty($request->cash_client_mobile)) { $cash_client_mobile = $request->cash_client_mobile[0]; } else { $cash_client_mobile = ''; } $db_array = array( 'currency' => $request->currency[0], 'client' => $request->client[0], 'cash_client_name' => $cash_client_name, 'cash_client_mobile' => $cash_client_mobile, 'invoice' => (int)$request->invoice[0], 'memo' => $request->memo[0], 'items_details' => json_encode($items_details), 'sale_items' => implode(',', $items), 'sale_warehouse' => implode(',', $warehouse), 'sale_batch' => implode(',', $batch), 'total_sales_amount' => (float)$request->total_sales_amount, 'total_discount_amount' => (float)$request->total_discount_amount, 'gross_total_amount' => (float)$request->gross_total_amount, 'total_profit_amount' => (float)$request->total_profit_amount, ); update_table('quotations','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'quotation_updated'), 'message_body' => print_lang($this->data["app_lang"],'quotation_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_quotation') === FALSE){ Redirect::to('/')->send(); } delete_table('quotations','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function delivery_note(Request $request, $uid) { if(check_user_access('add_sale') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('quotations','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(get_warehouse_wise_items(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'quotation_invoice'); $this->data["pageToLoad"] = "quotation/delivery_note.php"; $this->data["activeLink"] = "quotations"; $this->load_view($this->data); } }