<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; use View; class Reports extends Setup { public function __construct() { parent::__construct(); } public function reports_menu(Request $request) { if(is_customer_user() === true){ Redirect::to('/')->send(); } $this->data["root_accounts"] = fetch_root_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'reports'); $this->data["pageToLoad"] = "reports/menu.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function financial_menu(Request $request) { if(is_customer_user('view_financial_accounts_ledger') === true){ Redirect::to('/')->send(); } $this->data["root_accounts"] = fetch_root_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'reports'); $this->data["pageToLoad"] = "reports/financial_menu.php"; $this->data["activeLink"] = "financial_accounts_ledger"; $this->load_view($this->data); } public function financial_view(Request $request) { if(is_customer_user() === true){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $accounts_types = DB::table('accounts')->where('branch', $branch_id)->where('type', $request->type)->get(); $this->data["pageData"] = std_obj_to_array($accounts_types); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'reports'); $this->data["pageToLoad"] = "reports/financial_view.php"; $this->data["activeLink"] = "financial_accounts_ledger"; $this->load_view($this->data); } public function balance_summary(Request $request) { if(check_user_access('balance_summary_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $currencies = set_array_keys(fetch_currencies(),'uid'); $_stats = array(); $_stats["opening_stock"] = _calculate_system_opening_stock(['currencies' => $currencies]); $_stats["purchases_amount"] = _calculate_system_purchases_amount(['currencies' => $currencies]); $_stats["total_stock"] = _calculate_system_total_stock(['_stats' => $_stats, 'currencies' => $currencies]); $_stats["sales_amount"] = _calculate_system_sales_amount(['currencies' => $currencies]); $_stats["damage_stock"] = _calculate_system_damage_stock(['currencies' => $currencies]); $_stats["current_stock"] = _calculate_system_current_stock(['currencies' => $currencies]); if(env('client') != 'pharmaone') { $_stats["profit_amount"] = _calculate_system_profit_amount(['currencies' => $currencies]); } else { $_stats["profit_amount"] = _calculate_system_profit_amount_pharmaone(['currencies' => $currencies]); } $_stats["bank_amount"] = _calculate_system_account_type_balance(['currencies' => $currencies, 'type' => 'bank']); $_stats["receivable_amount"] = _calculate_system_account_type_balance(['currencies' => $currencies, 'type' => 'client']); $_stats["type_current_amount"] = _calculate_system_account_type_balance(['currencies' => $currencies, 'type' => 'current_account']); $_stats["type_employee_amount"] = _calculate_system_account_type_balance(['currencies' => $currencies, 'type' => 'employee']); $_stats["supplier_due_amount"] = _calculate_system_account_type_balance(['currencies' => $currencies, 'type' => 'supplier']); $_stats["transit_due_amount"] = _calculate_system_account_type_balance(['currencies' => $currencies, 'type' => 'transit']); $_stats["cash_amount"] = _calculate_system_account_type_balance(['currencies' => $currencies, 'type' => 'cashbook']); $_stats["expenses_amount"] = _calculate_system_expenses_amount(['currencies' => $currencies]); $_stats["fixed_assets"] = _calculate_system_fixed_assets(['currencies' => $currencies]); $_stats["other_accounts"] = _calculate_system_other_accounts_balance(['currencies' => $currencies]); $_stats["current_assets"] = _calculate_system_current_assets(['_stats' => $_stats, 'currencies' => $currencies]); $_stats["liability_amount"] = _calculate_system_liability_amount(['_stats' => $_stats, 'currencies' => $currencies]); $_stats["projects_cost"] = _calculate_system_construction_projects_cost(['currencies' => $currencies]); $_stats["projects_pending_amount"] = _calculate_system_construction_projects_pending_amount(['currencies' => $currencies]); $_stats["projects_expenses"] = _calculate_system_construction_projects_expenses(['currencies' => $currencies]); $_stats["projects_profit"] = _calculate_system_construction_projects_profit(['_stats' => $_stats, 'currencies' => $currencies]); $_stats["equity_amount"] = _calculate_system_equity_amount(['_stats' => $_stats, 'currencies' => $currencies]); $_stats["services_amount"] = _calculate_system_services_amount(['currencies' => $currencies]); $this->data["currencies"] = $currencies; $this->data["_stats"] = $_stats; $this->data["title"] = print_lang($this->data["app_lang"],'balance_summary'); $this->data["pageToLoad"] = "reports/balance_summary.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function shareholder_ledger(Request $request) { if(check_user_access('shareholder_ledger') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $shareholder_led = DB::table('shareholder_ledger')->where('branch',$branch_id); if(!empty($request->currency)){ $shareholder_led->where('currency',$request->currency); } if(!empty($request->shareholder)){ $shareholder_led->where('shareholder',$request->shareholder); } if(!empty($request->from)){ $shareholder_led->where('event_date','>=',get_true_date($request->from)); } if(!empty($request->to)){ $shareholder_led->where('event_date','<=',get_true_date($request->to)); } $shareholder_led = $shareholder_led->get(); $shareholder_led = json_decode(json_encode($shareholder_led),true); $this->data["pageData"] = $shareholder_led; $this->data["currencies"] = fetch_currencies(); $this->data["shareholder"] = fetch_table_branch('shareholder'); $this->data["search_currency"] = $request->currency; $this->data["search_shareholder"] = $request->shareholder; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'shareholder_report'); $this->data["pageToLoad"] = "reports/shareholder_ledger.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function salary_report_yearly(Request $request) { if(check_user_access('hrm_reports_yearly') === FALSE){ Redirect::to('/')->send(); } if(empty($request->currency)){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); if(empty($request->from)){ $request->from = 1; } if(empty($request->to)){ $request->to = 12; } if(empty($request->year)){ $request->year = date('Y'); } $month_start = $request->from; $month_end = $request->to; $year = $request->year; $month_wise_data = array(); $calander_db = fetch_calander_name(); while($month_start <= $month_end) { $month_payslips = DB::table('payslips')->where('branch',$branch_id)->where('status','confirm')->where('pay_month',$month_start)->where('pay_year',$year); $month_wise_data[$month_start] = json_decode(json_encode($month_payslips->get()),true); $month_start++; } $this->data["pageData"] = $month_wise_data; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["employees"] = set_array_keys(fetch_table_branch('employees'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["search_year"] = $request->year; $this->data["title"] = print_lang($this->data["app_lang"],'salary_yearly_report'); $this->data["pageToLoad"] = "reports/salary_yearly.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function salary_report_monthly(Request $request) { if(check_user_access('hrm_reports_monthly') === FALSE){ Redirect::to('/')->send(); } if(empty($request->currency)){ Redirect::to('/')->send(); } if(empty($request->month)){ Redirect::to('/')->send(); } if(empty($request->year)){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $month_payslips = DB::table('payslips')->where('branch',$branch_id)->where('status','confirm')->where('pay_month',$request->month)->where('pay_year',$request->year); $month_payslips = json_decode(json_encode($month_payslips->get()),true); $this->data["pageData"] = $month_payslips; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["employees"] = set_array_keys(fetch_table_branch('employees'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_month"] = $request->month; $this->data["search_year"] = $request->year; $this->data["title"] = print_lang($this->data["app_lang"],'salary_monthly_report'); $this->data["pageToLoad"] = "reports/salary_monthly.php"; $this->data["activeLink"] = "hrm"; $this->load_view($this->data); } public function expenses(Request $request) { if(check_user_access('expense_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $expenses = DB::table('expenses')->where('branch',$branch_id)->where('main_approval','approved'); if(!empty($request->currency)){ $expenses->where('currency',$request->currency); } if(!empty($request->type)){ $expenses->where('type',$request->type); } if(!empty($request->from)){ $expenses->where('exp_date','>=',$request->from); } if(!empty($request->to)){ $expenses->where('exp_date','<=',$request->to); } $expenses = $expenses->get(); $expenses = json_decode(json_encode($expenses),true); $this->data["pageData"] = $expenses; $this->data["expenses_types"] = set_array_keys(fetch_table_branch('expenses_types'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_type"] = $request->type; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'expenses_report'); $this->data["pageToLoad"] = "reports/expenses.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function save_accounts_cross_check(Request $request) { if(empty($request->uid)){ echo json_encode(array('status' => 'error')); } $active_branch_id = active_branch_id(); $db_array = array( 'is_checked' => $request->is_checked, 'color' => $request->color, 'remarks' => $request->remarks, ); if(DB::table('accounts_cross_checks')->where('uid',$request->uid)->count() > 0) { update_table('accounts_cross_checks','uid',$request->uid,$db_array); } else { $db_array['uid'] = $request->uid; $db_array['branch'] = $active_branch_id; insert_table('accounts_cross_checks',$db_array); } echo json_encode(array('status' => 'success')); } public function all_accounts(Request $request) { $branch_id = active_branch_id(); $right_value = $request->type; $shared_currencies = array(); $start_filter = 'no'; $before_filter_balance = ['debit'=>0, 'credit'=>0, 'balance'=>0]; if(empty($request->ledger_type)){$request->ledger_type = 'general';} if(is_customer_user() === FALSE) { if(is_sales_man_user() === true) { $sales_man = get_active_sales_man(); $sales_man_data = fetch_table_where('sales_man','uid',$sales_man,true); if(empty($request->account)) { if(!empty($sales_man_data['account'])) { $account_data = fetch_table_where('accounts','uid',$sales_man_data['account'],true); $request->account = $account_data['uid']; $request->type = $account_data['type']; } else { Redirect::to('/')->send(); } } } else { if(empty($request->type)){ Redirect::to('/')->send(); } if(check_user_access($right_value) === FALSE){ Redirect::to('/')->send(); } } } else { if(empty($request->account)) { if(empty($request->type)){ Redirect::to('/')->send(); } if(check_user_access($right_value) === FALSE){ Redirect::to('/')->send(); } } else { if($request->account != get_active_customer()) { if(empty($request->type)){ Redirect::to('/')->send(); } if(check_user_access($right_value) === FALSE){ Redirect::to('/')->send(); } } } } $_item_settings = get_item_settings(); $shared_uids_accounts = DB::table('accounts')->where('branch',active_branch_id()); if($request->type != 'all_accounts_statement') { $shared_uids_accounts->where('type',$request->type); } $shared_uids_accounts = std_obj_to_array($shared_uids_accounts->pluck('uid')->toArray()); $currency = $request->currency; $currency_data = fetch_table_where('currency','uid',$request->currency,true); $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency_data['branch_equalance'])->pluck('uid')->toArray()); $accounts_ledger = DB::table('accounts_ledger'); $total_accounts_ledger = DB::table('accounts_ledger'); if($request->type != 'all_accounts_statement') { $accounts_ledger->where('account_type',$request->type); $total_accounts_ledger->where('account_type',$request->type); } if(!empty($request->account)) { $accounts_ledger->where('account_uid',$request->account); $total_accounts_ledger->where('account_uid',$request->account); } else { $accounts_ledger->whereIn('account_uid',$shared_uids_accounts); $total_accounts_ledger->whereIn('account_uid',$shared_uids_accounts); } if(!empty($request->currency)) { $accounts_ledger->whereIn('currency',$shared_uids_currencies); $total_accounts_ledger->whereIn('currency',$shared_uids_currencies); } if(!empty($request->from)) { $accounts_ledger->where('aldate','>=',get_true_date($request->from).' 00:00:00'); $start_filter = 'yes'; $before_filter_balance = DB::table('accounts_ledger')->select((DB::raw('sum(debit) - sum(credit) as balance, sum(debit) as debit, sum(credit) as credit'))); if(!empty($request->currency)) { $before_filter_balance->whereIn('currency',$shared_uids_currencies); } if(!empty($request->account)) { $before_filter_balance->where('account_uid',$request->account); } else { $before_filter_balance->whereIn('account_uid',$shared_uids_accounts); } $before_filter_balance->where('aldate','<',get_true_date($request->from).' 00:00:00'); $before_filter_balance = std_obj_to_array($before_filter_balance->get()->first()); } if(!empty($request->to)){ $accounts_ledger->where('aldate','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = std_obj_to_array($accounts_ledger->orderBy('aldate','asc')->get()); $this->data["totals_Data"] = array( 'debit' => ($_item_settings['item_measurements'] == 'get') ? $total_accounts_ledger->sum('wim_debit') : $total_accounts_ledger->sum('debit'), 'credit' => ($_item_settings['item_measurements'] == 'get') ? $total_accounts_ledger->sum('wim_credit') : $total_accounts_ledger->sum('credit'), ); $accounts_for_filter = DB::table('accounts')->where('branch',$branch_id); if($request->type != 'all_accounts_statement') { $accounts_for_filter->where('type',$request->type); } if(is_sales_man_user() === true) { $accounts_for_filter = $accounts_for_filter->where('sales_man',$sales_man); } $accounts_for_filter = std_obj_to_array($accounts_for_filter->get()); $this->data["_item_settings"] = $_item_settings; $this->data["start_filter"] = $start_filter; $this->data["before_filter_balance"] = $before_filter_balance; $this->data["accounts"] = set_array_keys($accounts_for_filter,'uid'); $this->data["accounts_data"] = set_array_keys(fetch_table('accounts'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["branches"] = set_array_keys(fetch_table('branches'),'uid'); $this->data["journals"] = set_array_keys(fetch_table('journal'),'uid'); $this->data["money_receipts"] = set_array_keys(fetch_table('money_receipts'),'uid'); $this->data["search_type"] = $request->type; $this->data["search_currency"] = $request->currency; $this->data["search_account"] = $request->account; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["search_ledger_type"] = $request->ledger_type; $this->data["title"] = print_lang($this->data['app_lang'],'builtin_account_'.$request->type)." ".print_lang($this->data['app_lang'],'report'); $this->data["breadcrums_title"] = print_lang($this->data['app_lang'],'builtin_account_'.$request->type)." ".print_lang($this->data['app_lang'],'report'); if($request->ledger_type == 'detailed') { $this->data["pageToLoad"] = "reports/all_accounts_detailed.php"; } else { $this->data["pageToLoad"] = "reports/all_accounts.php"; } $this->data["activeLink"] = "reports-all-accounts"; $this->load_view($this->data); } public function all_accounts_print(Request $request) { if(empty($request->ledger_type)){$request->ledger_type = 'general';} $branch_id = active_branch_id(); $right_value = $request->type; $shared_currencies = array(); $start_filter = 'no'; $before_filter_balance = ['debit'=>0, 'credit'=>0, 'balance'=>0]; if(is_customer_user() === FALSE) { if(is_sales_man_user() === true) { $sales_man = get_active_sales_man(); $sales_man_data = fetch_table_where('sales_man','uid',$sales_man,true); if(empty($request->account)) { if(!empty($sales_man_data['account'])) { $account_data = fetch_table_where('accounts','uid',$sales_man_data['account'],true); $request->account = $account_data['uid']; $request->type = $account_data['type']; } else { Redirect::to('/')->send(); } } } else { if(empty($request->type)){ Redirect::to('/')->send(); } if(check_user_access($right_value) === FALSE){ Redirect::to('/')->send(); } } } else { if(empty($request->account)) { if(empty($request->type)){ Redirect::to('/')->send(); } if(check_user_access($right_value) === FALSE){ Redirect::to('/')->send(); } } else { if($request->account != get_active_customer()) { if(empty($request->type)){ Redirect::to('/')->send(); } if(check_user_access($right_value) === FALSE){ Redirect::to('/')->send(); } } } } $_item_settings = get_item_settings(); $shared_uids_accounts = DB::table('accounts')->where('branch',active_branch_id()); if($request->type != 'all_accounts_statement') { $shared_uids_accounts->where('type',$request->type); } $shared_uids_accounts = std_obj_to_array($shared_uids_accounts->pluck('uid')->toArray()); $currency = $request->currency; $currency_data = fetch_table_where('currency','uid',$request->currency,true); $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency_data['branch_equalance'])->pluck('uid')->toArray()); $accounts_ledger = DB::table('accounts_ledger'); $total_accounts_ledger = DB::table('accounts_ledger'); if($request->type != 'all_accounts_statement') { $accounts_ledger->where('account_type',$request->type); $total_accounts_ledger->where('account_type',$request->type); } if(!empty($request->account)) { $accounts_ledger->where('account_uid',$request->account); $total_accounts_ledger->where('account_uid',$request->account); } else { $accounts_ledger->whereIn('account_uid',$shared_uids_accounts); $total_accounts_ledger->whereIn('account_uid',$shared_uids_accounts); } if(!empty($request->currency)) { $accounts_ledger->whereIn('currency',$shared_uids_currencies); $total_accounts_ledger->whereIn('currency',$shared_uids_currencies); } if(!empty($request->from)) { $accounts_ledger->where('aldate','>=',get_true_date($request->from).' 00:00:00'); $start_filter = 'yes'; $before_filter_balance = DB::table('accounts_ledger')->select((DB::raw('sum(debit) - sum(credit) as balance, sum(debit) as debit, sum(credit) as credit'))); if(!empty($request->currency)) { $before_filter_balance->whereIn('currency',$shared_uids_currencies); } if(!empty($request->account)) { $before_filter_balance->where('account_uid',$request->account); } else { $before_filter_balance->whereIn('account_uid',$shared_uids_accounts); } $before_filter_balance->where('aldate','<',get_true_date($request->from).' 00:00:00'); $before_filter_balance = std_obj_to_array($before_filter_balance->get()->first()); } if(!empty($request->to)){ $accounts_ledger->where('aldate','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = std_obj_to_array($accounts_ledger->orderBy('aldate','asc')->get()); $this->data["totals_Data"] = array( 'debit' => ($_item_settings['item_measurements'] == 'get') ? $total_accounts_ledger->sum('wim_debit') : $total_accounts_ledger->sum('debit'), 'credit' => ($_item_settings['item_measurements'] == 'get') ? $total_accounts_ledger->sum('wim_credit') : $total_accounts_ledger->sum('credit'), ); $this->data["_item_settings"] = $_item_settings; $this->data["start_filter"] = $start_filter; $this->data["before_filter_balance"] = $before_filter_balance; $this->data["accounts"] = std_obj_to_array( DB::table('accounts')->where('branch',$branch_id)->where('type',$request->type)->get() ); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["branches"] = set_array_keys(fetch_table('branches'),'uid'); $this->data["journals"] = set_array_keys(fetch_table('journal'),'uid'); $this->data["money_receipts"] = set_array_keys(fetch_table('money_receipts'),'uid'); $this->data["accounts_data"] = set_array_keys(fetch_table('accounts'),'uid'); $this->data["search_type"] = $request->type; $this->data["search_currency"] = $request->currency; $this->data["search_account"] = $request->account; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["search_ledger_type"] = $request->ledger_type; $this->data["title"] = print_lang($this->data['app_lang'],'builtin_account_'.$request->type)." ".print_lang($this->data['app_lang'],'report'); $this->data["breadcrums_title"] = print_lang($this->data['app_lang'],'builtin_account_'.$request->type)." ".print_lang($this->data['app_lang'],'report'); if($request->ledger_type == 'detailed') { $this->data["pageToLoad"] = "reports/all_accounts_detailed_print.php"; } else { $this->data["pageToLoad"] = "reports/all_accounts_print.php"; } $this->data["activeLink"] = "reports-all-accounts"; $this->load_view($this->data); } public function raw_warehouses(Request $request) { if(check_user_access('raw_warehouse_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $item_inventory_query = DB::table('items_inventory_stats')->where('branch',$branch_id); $item_inventory_query->select( 'item', 'item_name', DB::raw('
                    sum(case when 
                    module_name = "items"
                    then purchase_unit_stock_in END) as opening_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_stock_in END) as purchase_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_bonus_in END) as purchase_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_in"
                    then purchase_unit_stock_in END) as production_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_out"
                    then purchase_unit_stock_out END) as production_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_stock_out END) as sale_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_bonus_out END) as sale_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_stock_in END) as sale_return_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_bonus_in END) as sale_return_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_to_branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_to_branch_transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "damage"
                    then purchase_unit_stock_in END) as damage_units' ), DB::raw('
                    sum(case when 
                    module_name = "expenses_deductions"
                    then purchase_unit_stock_in END) as expenses_deductions_units' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_bonus_in END) as transfer_in_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_bonus_out END) as transfer_out_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_transfer_out_units' ), DB::raw('
                    sum(purchase_unit_stock_in) as total_stock_in' ), DB::raw('
                    sum(purchase_unit_stock_out) as total_stock_out' ), ); $item_inventory_query->groupBy('item'); $item_inventory_query->groupBy('item_name'); if(!empty($request->from)){ $item_inventory_query->where('event_date','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $item_inventory_query->where('event_date','<=',get_true_date($request->to).' 23:59:59'); } $item_inventory_query = std_obj_to_array($item_inventory_query->get()); $items = DB::table('items')->where('branch',$branch_id)->where('type','raw'); $items = std_obj_to_array($items->get()); $this->data["pageData"] = set_array_keys($items,'uid'); $this->data["item_inventory_query"] = set_array_keys($item_inventory_query,'item'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["product_categories"] = set_array_keys(fetch_table_branch('product_category'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_unit"] = $request->unit; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'raw_warehouse_report'); $this->data["pageToLoad"] = "reports/raw_warehouses.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function sales_warehouses(Request $request) { if(check_user_access('sales_warehouse_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $item_inventory_query = DB::table('items_inventory_stats')->where('branch',$branch_id); $item_inventory_query->select( 'item', 'item_name', DB::raw('
                    sum(case when 
                    module_name = "items"
                    then purchase_unit_stock_in END) as opening_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_stock_in END) as purchase_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_bonus_in END) as purchase_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_in"
                    then purchase_unit_stock_in END) as production_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_out"
                    then purchase_unit_stock_out END) as production_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_stock_out END) as sale_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_bonus_out END) as sale_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_stock_in END) as sale_return_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_bonus_in END) as sale_return_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_to_branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_to_branch_transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "damage"
                    then purchase_unit_stock_in END) as damage_units' ), DB::raw('
                    sum(case when 
                    module_name = "expenses_deductions"
                    then purchase_unit_stock_in END) as expenses_deductions_units' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_bonus_in END) as transfer_in_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_bonus_out END) as transfer_out_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_transfer_out_units' ), DB::raw('
                    sum(purchase_unit_stock_in) as total_stock_in' ), DB::raw('
                    sum(purchase_unit_stock_out) as total_stock_out' ), ); $item_inventory_query->groupBy('item'); $item_inventory_query->groupBy('item_name'); if(!empty($request->from)){ $item_inventory_query->where('event_date','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $item_inventory_query->where('event_date','<=',get_true_date($request->to).' 23:59:59'); } $item_inventory_query = std_obj_to_array($item_inventory_query->get()); $items = DB::table('items')->where('branch',$branch_id)->where('type','sales'); $items = std_obj_to_array($items->get()); $this->data["pageData"] = set_array_keys($items,'uid'); $this->data["item_inventory_query"] = set_array_keys($item_inventory_query,'item'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["product_categories"] = set_array_keys(fetch_table_branch('product_category'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_unit"] = $request->unit; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sale_warehouse_report'); $this->data["pageToLoad"] = "reports/sales_warehouses.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function damage_items(Request $request) { if(check_user_access('damage_stock_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $damage = DB::table('damage')->where('branch',$branch_id); if(!empty($request->warehouse)){ $damage->where('warehouse',$request->warehouse); } if(!empty($request->from)){ $damage->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $damage->where('created_at','<=',$request->to.' 23:59:59'); } $damage = $damage->get(); $damage = json_decode(json_encode($damage),true); $this->data["pageData"] = $damage; $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["batch"] = set_array_keys(fetch_table_branch('batch'),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["search_warehouse"] = $request->warehouse; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'damage_items_report'); $this->data["pageToLoad"] = "reports/damage_items.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function sales(Request $request) { if(check_user_access('sales_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $sales = DB::table('sales')->where('branch',$branch_id)->where('main_approval','approved'); if(!empty($request->currency)){ $sales->where('currency',$request->currency); } if(!empty($request->client)){ $sales->where('client',$request->client); } if(!empty($request->from)){ $sales->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $sales->where('created_at','<=',$request->to.' 23:59:59'); } $sales = $sales->get(); $sales = json_decode(json_encode($sales),true); $this->data["pageData"] = $sales; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sales_reports'); $this->data["pageToLoad"] = "reports/sales.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function sales_and_return(Request $request) { if(check_user_access('sales_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $sales = DB::table('sales')->where('branch',$branch_id)->where('main_approval','approved'); if(empty($request->currency)) { $request->currency = 'usd'; } if(empty($request->client)) { $account_client = std_obj_to_array(DB::table('accounts')->where('branch',$branch_id)->where('type','client')->get()->first()); if(!empty($account_client)) { $request->client = $account_client['uid']; } } if(!empty($request->currency)){ $sales->where('currency',$request->currency); } if(!empty($request->client)){ $sales->where('client',$request->client); } if(!empty($request->from)){ $sales->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $sales->where('created_at','<=',$request->to.' 23:59:59'); } $sales = $sales->get(); $sales = json_decode(json_encode($sales),true); $sales_return = DB::table('sales_return')->where('branch',$branch_id); if(!empty($request->currency)){ $sales_return->where('currency',$request->currency); } if(!empty($request->client)){ $sales_return->where('client',$request->client); } if(!empty($request->from)){ $sales_return->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $sales_return->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $sales_return = $sales_return->get(); $sales_return = json_decode(json_encode($sales_return),true); $report_records = array_merge($sales,$sales_return); $report_records = sort_data_date_wise($report_records,'created_at'); $this->data["pageData"] = $report_records; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sales_reports'); $this->data["pageToLoad"] = "reports/sales_and_return.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function all_bonuses(Request $request) { if(check_user_access('all_bonuses') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $from_filter = NULL; $to_filter = NULL; if(!empty($request->from)){ $from_filter = 'AND i.entry_date >= "'.get_true_date($request->from).' 00:00:00"'; } if(!empty($request->to)){ $to_filter = 'AND i.entry_date <= "'.get_true_date($request->to).' 23:59:59"'; } $stats = DB::select( "SELECT 
            it.uid,
            it.name,
            it._avg_cost,
            it.sale_price,
            i.batch,
            SUM(i.purchase_bonus_in) AS purchase_bonuses,
            SUM(i.sales_bonus_out) AS sales_bonuses,
            SUM(i.return_bonus_in) AS return_bonuses,
            SUM(i.transfer_bonus_in) AS transfer_in_bonuses,
            SUM(i.transfer_bonus_out) AS transfer_out_bonuses
            FROM items as it
            LEFT JOIN item_inventory as i ON it.uid = i.item
            WHERE it.branch = '".active_branch_id()."'
            ".$from_filter."
            ".$to_filter."
            GROUP BY it.uid, it.name, it._avg_cost, it.sale_price, i.batch" ); $stats = std_obj_to_array($stats); $this->data["pageData"] = $stats; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'mod_all_bonuses_rep_title'); $this->data["pageToLoad"] = "reports/all_bonuses.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function sales_items(Request $request) { if(check_user_access('sales_item_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $sales = DB::table('sales')->where('branch',$branch_id)->where('main_approval','approved'); if(!empty($request->currency)){ $sales->where('currency',$request->currency); } if(!empty($request->client)){ $sales->where('client',$request->client); } if(!empty($request->marketer)){ $sales->where('marketer',$request->marketer); } if(!empty($request->item)){ $sales->where('sale_items','like','%-++-'.$request->item.'-++-%'); } if(!empty($request->from)){ $sales->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $sales->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $sales = $sales->get(); $sales = json_decode(json_encode($sales),true); $graph_data = array('months' => [1,2,3,4,5,6], 'qty' => [0,0,0,0,0,0]); if(!empty($request->item)) { $last_month_date_for_graph = date('Y-m-d'); if(!empty($request->to)){ $last_month_date_for_graph = get_true_date($request->to); } $graph_data = get_item_graph_data($request->item,$request->currency,$request->client,$last_month_date_for_graph); } $this->data["pageData"] = $sales; $this->data["graph_data"] = $graph_data; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["batch"] = set_array_keys(fetch_table_branch('batch'),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["warehouses"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["product_categories"] = set_array_keys(fetch_table_branch('product_category'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_item"] = $request->item; $this->data["search_client"] = $request->client; $this->data["search_marketer"] = $request->marketer; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sales_item_report'); $this->data["pageToLoad"] = "reports/sales_items.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function purchases(Request $request) { if(check_user_access('purchase_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $purchases = DB::table('purchases')->where('branch',$branch_id)->where('main_approval','approved'); if(!empty($request->currency)){ $purchases->where('currency',$request->currency); } if(!empty($request->supplier)){ $purchases->where('supplier',$request->supplier); } if(!empty($request->from)){ $purchases->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $purchases->where('created_at','<=',$request->to.' 23:59:59'); } $purchases = $purchases->get(); $purchases = json_decode(json_encode($purchases),true); $this->data["pageData"] = $purchases; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["accounts_filteration"] = set_array_keys(fetch_table('accounts'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_supplier"] = $request->supplier; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'purchases_reports'); $this->data["pageToLoad"] = "reports/purchases.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function purchases_items(Request $request) { if(check_user_access('purchase_item_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $purchases = DB::table('purchases')->where('branch',$branch_id)->where('main_approval','approved'); if(!empty($request->currency)){ $purchases->where('currency',$request->currency); } if(!empty($request->supplier)){ $purchases->where('supplier',$request->supplier); } if(!empty($request->item)){ $purchases->where('items_uid','like','%-++-'.$request->item.'-++-%'); } if(!empty($request->from)){ $purchases->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $purchases->where('created_at','<=',$request->to.' 23:59:59'); } $purchases = $purchases->get(); $purchases = json_decode(json_encode($purchases),true); $this->data["pageData"] = $purchases; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["batch"] = set_array_keys(fetch_table_branch('batch'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["warehouses"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["accounts_filteration"] = set_array_keys(fetch_table('accounts'),'uid'); $this->data["product_categories"] = set_array_keys(fetch_table_branch('product_category'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_item"] = $request->item; $this->data["search_supplier"] = $request->supplier; $this->data["search_type"] = $request->type; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'purchases_items_reports'); $this->data["pageToLoad"] = "reports/purchases_items.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function client_items(Request $request) { if(check_user_access('client_item_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $sales = DB::table('sales')->where('branch',$branch_id)->where('main_approval','approved'); if(!empty($request->currency)){ $sales->where('currency',$request->currency); } if(!empty($request->client)){ $sales->where('client',$request->client); } if(!empty($request->from)){ $sales->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $sales->where('created_at','<=',$request->to.' 23:59:59'); } $sales = $sales->get(); $sales = json_decode(json_encode($sales),true); $this->data["pageData"] = $sales; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["batch"] = set_array_keys(fetch_table_branch('batch'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["product_categories"] = set_array_keys(fetch_table_branch('product_category'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'client_items_report'); $this->data["pageToLoad"] = "reports/client_items.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function production(Request $request) { if(check_user_access('production_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $production = DB::table('production')->where('branch',$branch_id); if(!empty($request->currency)){ $production->where('currency',$request->currency); } if(!empty($request->from)){ $production->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $production->where('created_at','<=',$request->to.' 23:59:59'); } $production = $production->get(); $production = json_decode(json_encode($production),true); $this->data["pageData"] = $production; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["batch"] = set_array_keys(fetch_table_branch('batch'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'production_report'); $this->data["pageToLoad"] = "reports/production.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function purchase_expenses(Request $request) { if(check_user_access('purchase_expense_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $purchases = DB::table('purchases')->where('branch',$branch_id)->where('main_approval','approved'); if(!empty($request->currency)){ $purchases->where('currency',$request->currency); } if(!empty($request->supplier)){ $purchases->where('supplier',$request->supplier); } if(!empty($request->from)){ $purchases->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $purchases->where('created_at','<=',$request->to.' 23:59:59'); } $purchases = $purchases->get(); $purchases = json_decode(json_encode($purchases),true); $this->data["pageData"] = $purchases; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_supplier"] = $request->supplier; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'purchase_expenses_report'); $this->data["pageToLoad"] = "reports/purchase_expenses.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function sale_expenses(Request $request) { if(check_user_access('sale_expense_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $sales = DB::table('sales')->where('branch',$branch_id)->where('main_approval','approved'); if(!empty($request->currency)){ $sales->where('currency',$request->currency); } if(!empty($request->client)){ $sales->where('client',$request->client); } if(!empty($request->from)){ $sales->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $sales->where('created_at','<=',$request->to.' 23:59:59'); } $sales = $sales->get(); $sales = json_decode(json_encode($sales),true); $this->data["pageData"] = $sales; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["expenses"] = set_array_keys(fetch_table_where_branch('accounts','type','expense'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sales_expenses_report'); $this->data["pageToLoad"] = "reports/sale_expenses.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function production_expenses(Request $request) { if(check_user_access('production_expense_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $production = DB::table('production')->where('branch',$branch_id); if(!empty($request->currency)){ $production->where('currency',$request->currency); } if(!empty($request->from)){ $production->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $production->where('created_at','<=',$request->to.' 23:59:59'); } $production = $production->get(); $production = json_decode(json_encode($production),true); $this->data["pageData"] = $production; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["batch"] = set_array_keys(fetch_table_branch('batch'),'uid'); $this->data["expenses"] = set_array_keys(fetch_table_where_branch('accounts','type','expense'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'production_expenses_report'); $this->data["pageToLoad"] = "reports/production_expenses.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function warehouse_transfer(Request $request) { if(check_user_access('warehouse_transfer_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $transfer = DB::table('transfer')->where('branch',$branch_id); if(!empty($request->item)){ $transfer->where('item',$request->item); } if(!empty($request->warehouse)){ $transfer->where(function($query) use ($request){ $query->where('sending_warehouse',$request->warehouse)->orWhere('receiving_warehouse',$request->warehouse); }); } if(!empty($request->from)){ $transfer->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $transfer->where('created_at','<=',$request->to.' 23:59:59'); } $transfer = $transfer->get(); $transfer = json_decode(json_encode($transfer),true); $this->data["pageData"] = $transfer; $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["search_item"] = $request->item; $this->data["search_warehouse"] = $request->warehouse; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'warehouse_transfer_report'); $this->data["pageToLoad"] = "reports/warehouse_transfer.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function sale_discount(Request $request) { if(check_user_access('sale_discount_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $currency_filter = NULL; $client_filter = NULL; $from_filter = NULL; $to_filter = NULL; $sales = DB::table('sales')->where('branch',$branch_id)->where('main_approval','approved'); if(!empty($request->currency)){ $sales->where('currency',$request->currency); $currency_filter = 'AND sales.currency = "'.$request->currency.'"'; } if(!empty($request->client)){ $sales->where('client',$request->client); $client_filter = 'AND client = "'.$request->client.'"'; } if(!empty($request->from)){ $sales->where('created_at','>=',get_true_date($request->from).' 00:00:00'); $from_filter = 'AND created_at >= "'.get_true_date($request->from).' 00:00:00"'; } if(!empty($request->to)){ $sales->where('created_at','<=',get_true_date($request->to).' 23:59:59'); $to_filter = 'AND created_at <= "'.get_true_date($request->to).' 23:59:59"'; } $sales = $sales->get(); $sales = json_decode(json_encode($sales),true); $returns = DB::select( "SELECT 
            sale_id,
            SUM(return_discount_amount_1) as return_discount_total,
            SUM(refund_total) as return_refund_total
            FROM sales_return
            WHERE uid IS Not NULL
            ".$client_filter."
            ".$from_filter."
            ".$to_filter."
            GROUP BY sale_id" ); $returns = set_array_keys(std_obj_to_array($returns),'sale_id'); $this->data["pageData"] = $sales; $this->data["returns"] = $returns; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sales_discount_report'); $this->data["pageToLoad"] = "reports/sale_discount.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function sale_discount_2(Request $request) { if(check_user_access('sale_discount_report_2') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $currency_filter = NULL; $client_filter = NULL; $from_filter = NULL; $to_filter = NULL; $sales = DB::table('sales')->where('branch',$branch_id)->where('main_approval','approved'); if(!empty($request->currency)){ $sales->where('currency',$request->currency); $currency_filter = 'AND sales.currency = "'.$request->currency.'"'; } if(!empty($request->client)){ $sales->where('client',$request->client); $client_filter = 'AND client = "'.$request->client.'"'; } if(!empty($request->from)){ $sales->where('created_at','>=',get_true_date($request->from).' 00:00:00'); $from_filter = 'AND created_at >= "'.get_true_date($request->from).' 00:00:00"'; } if(!empty($request->to)){ $sales->where('created_at','<=',get_true_date($request->to).' 23:59:59'); $to_filter = 'AND created_at <= "'.get_true_date($request->to).' 23:59:59"'; } $sales = $sales->get(); $sales = json_decode(json_encode($sales),true); $returns = DB::select( "SELECT 
            sale_id,
            SUM(return_discount_amount_2) as return_discount_total,
            SUM(refund_total) as return_refund_total
            FROM sales_return
            WHERE uid IS Not NULL
            ".$client_filter."
            ".$from_filter."
            ".$to_filter."
            GROUP BY sale_id" ); $returns = set_array_keys(std_obj_to_array($returns),'sale_id'); $this->data["pageData"] = $sales; $this->data["returns"] = $returns; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sales_discount_report_2'); $this->data["pageToLoad"] = "reports/sale_discount_2.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function purchase_discount(Request $request) { if(check_user_access('purchase_discount_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $purchases = DB::table('purchases')->where('branch',$branch_id)->where('main_approval','approved'); if(!empty($request->currency)){ $purchases->where('currency',$request->currency); } if(!empty($request->supplier)){ $purchases->where('supplier',$request->supplier); } if(!empty($request->from)){ $purchases->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $purchases->where('created_at','<=',$request->to.' 23:59:59'); } $purchases = $purchases->get(); $purchases = json_decode(json_encode($purchases),true); $this->data["pageData"] = $purchases; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_supplier"] = $request->supplier; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'purchases_discount_report'); $this->data["pageToLoad"] = "reports/purchase_discount.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function transfer_in_discount_1(Request $request) { if(check_user_access('transfer_in_discount_1') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $transfer_in = DB::table('transfer_in')->where('branch',$branch_id); if(!empty($request->currency)){ $transfer_in->where('currency',$request->currency); } if(!empty($request->client)){ $transfer_in->where('client',$request->client); } if(!empty($request->from)){ $transfer_in->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $transfer_in->where('created_at','<=',$request->to.' 23:59:59'); } $transfer_in = $transfer_in->get(); $transfer_in = json_decode(json_encode($transfer_in),true); $this->data["pageData"] = $transfer_in; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'mod_transfer_in_dis_1_rep_title'); $this->data["pageToLoad"] = "reports/trans_in_discount_1.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function transfer_out_discount_1(Request $request) { if(check_user_access('transfer_out_discount_1') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $transfer_out = DB::table('transfer_out')->where('branch',$branch_id); if(!empty($request->currency)){ $transfer_out->where('currency',$request->currency); } if(!empty($request->client)){ $transfer_out->where('client',$request->client); } if(!empty($request->from)){ $transfer_out->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $transfer_out->where('created_at','<=',$request->to.' 23:59:59'); } $transfer_out = $transfer_out->get(); $transfer_out = json_decode(json_encode($transfer_out),true); $this->data["pageData"] = $transfer_out; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'mod_transfer_out_dis_1_rep_title'); $this->data["pageToLoad"] = "reports/trans_out_discount_1.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function transfer_in_discount_2(Request $request) { if(check_user_access('transfer_in_discount_2') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $transfer_in = DB::table('transfer_in')->where('branch',$branch_id); if(!empty($request->currency)){ $transfer_in->where('currency',$request->currency); } if(!empty($request->client)){ $transfer_in->where('client',$request->client); } if(!empty($request->from)){ $transfer_in->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $transfer_in->where('created_at','<=',$request->to.' 23:59:59'); } $transfer_in = $transfer_in->get(); $transfer_in = json_decode(json_encode($transfer_in),true); $this->data["pageData"] = $transfer_in; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'mod_transfer_in_dis_2_rep_title'); $this->data["pageToLoad"] = "reports/trans_in_discount_2.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function transfer_out_discount_2(Request $request) { if(check_user_access('transfer_out_discount_2') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $transfer_out = DB::table('transfer_out')->where('branch',$branch_id); if(!empty($request->currency)){ $transfer_out->where('currency',$request->currency); } if(!empty($request->client)){ $transfer_out->where('client',$request->client); } if(!empty($request->from)){ $transfer_out->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $transfer_out->where('created_at','<=',$request->to.' 23:59:59'); } $transfer_out = $transfer_out->get(); $transfer_out = json_decode(json_encode($transfer_out),true); $this->data["pageData"] = $transfer_out; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'mod_transfer_out_dis_2_rep_title'); $this->data["pageToLoad"] = "reports/trans_out_discount_2.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function items_ledger(Request $request) { if(check_user_access('items_ledger_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $before_filter_query = []; if(!empty($request->from)) { $before_filter_query = DB::table('items_inventory_stats')->where('branch',$branch_id)->where('event_date','<',get_true_date($request->from).' 00:00:00'); $before_filter_query->select( 'item', 'item_name', DB::raw('
                        sum(purchase_unit_stock_in) as total_stock_in' ), DB::raw('
                        sum(purchase_unit_bonus_in) as total_bonus_in' ), DB::raw('
                        sum(purchase_unit_stock_out) as total_stock_out' ), DB::raw('
                        sum(purchase_unit_bonus_out) as total_bonus_out' ), ); $before_filter_query->groupBy('item'); $before_filter_query->groupBy('item_name'); if(!empty($request->category)){ $before_filter_query->where('item_category',$request->category); } $before_filter_query = std_obj_to_array($before_filter_query->get()); } $item_inventory_query = DB::table('items_inventory_stats')->where('branch',$branch_id); $item_inventory_query->select( 'item', 'item_name', DB::raw('
                    sum(case when 
                    module_name = "items"
                    then purchase_unit_stock_in END) as opening_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_stock_in END) as purchase_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_bonus_in END) as purchase_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_in"
                    then purchase_unit_stock_in END) as production_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_out"
                    then purchase_unit_stock_out END) as production_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_stock_out END) as sale_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_bonus_out END) as sale_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_stock_in END) as sale_return_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_bonus_in END) as sale_return_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_to_branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_to_branch_transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "damage"
                    then purchase_unit_stock_in END) as damage_units' ), DB::raw('
                    sum(case when 
                    module_name = "expenses_deductions"
                    then purchase_unit_stock_in END) as expenses_deductions_units' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_bonus_in END) as transfer_in_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_bonus_out END) as transfer_out_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_transfer_out_units' ), DB::raw('
                    sum(purchase_unit_stock_in) as total_stock_in' ), DB::raw('
                    sum(purchase_unit_stock_out) as total_stock_out' ), ); $item_inventory_query->groupBy('item'); $item_inventory_query->groupBy('item_name'); if(!empty($request->from)){ $item_inventory_query->where('event_date','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $item_inventory_query->where('event_date','<=',get_true_date($request->to).' 23:59:59'); } if(!empty($request->category)){ $item_inventory_query->where('item_category',$request->category); } $item_inventory_query = std_obj_to_array($item_inventory_query->get()); $items = DB::table('items')->where('branch',$branch_id); if(!empty($request->category)){ $items->where('category',$request->category); } if(!empty($request->item)){ $items->where('uid',$request->item); } $items = std_obj_to_array($items->get()); $this->data["pageData"] = set_array_keys($items,'uid'); $this->data["item_inventory_query"] = set_array_keys($item_inventory_query,'item'); $this->data["before_filter_query"] = set_array_keys($before_filter_query,'item'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["batch"] = set_array_keys(fetch_table_branch('batch'),'uid'); $this->data["items"] = fetch_table_branch('items'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_item"] = $request->item; $this->data["search_unit"] = $request->unit; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'items_ledger'); $this->data["pageToLoad"] = "reports/items_ledger.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function inventory(Request $request) { if(check_user_access('inventory_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $before_filter_query = []; if(!empty($request->from)) { $before_filter_query = DB::table('items_inventory_stats')->where('branch',$branch_id)->where('event_date','<',get_true_date($request->from).' 00:00:00'); $before_filter_query->select( 'item', 'item_name', DB::raw('
                        sum(purchase_unit_stock_in) as total_stock_in' ), DB::raw('
                        sum(purchase_unit_bonus_in) as total_bonus_in' ), DB::raw('
                        sum(purchase_unit_stock_out) as total_stock_out' ), DB::raw('
                        sum(purchase_unit_bonus_out) as total_bonus_out' ), ); $before_filter_query->groupBy('item'); $before_filter_query->groupBy('item_name'); if(!empty($request->category)){ $before_filter_query->where('item_category',$request->category); } $before_filter_query = std_obj_to_array($before_filter_query->get()); } $item_inventory_query = DB::table('items_inventory_stats')->where('branch',$branch_id); $item_inventory_query->select( 'item', 'item_name', DB::raw('
                    sum(case when 
                    module_name = "items"
                    then purchase_unit_stock_in END) as opening_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_stock_in END) as purchase_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_bonus_in END) as purchase_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_in"
                    then purchase_unit_stock_in END) as production_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_out"
                    then purchase_unit_stock_out END) as production_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_stock_out END) as sale_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_bonus_out END) as sale_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_stock_in END) as sale_return_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_bonus_in END) as sale_return_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_to_branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_to_branch_transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "damage"
                    then purchase_unit_stock_in END) as damage_units' ), DB::raw('
                    sum(case when 
                    module_name = "expenses_deductions"
                    then purchase_unit_stock_in END) as expenses_deductions_units' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_bonus_in END) as transfer_in_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_bonus_out END) as transfer_out_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_transfer_out_units' ), DB::raw('
                    sum(purchase_unit_stock_in) as total_stock_in' ), DB::raw('
                    sum(purchase_unit_stock_out) as total_stock_out' ), ); $item_inventory_query->groupBy('item'); $item_inventory_query->groupBy('item_name'); if(!empty($request->from)){ $item_inventory_query->where('event_date','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $item_inventory_query->where('event_date','<=',get_true_date($request->to).' 23:59:59'); } if(!empty($request->category)){ $item_inventory_query->where('item_category',$request->category); } $item_inventory_query = std_obj_to_array($item_inventory_query->get()); $items = DB::table('items')->where('branch',$branch_id); if(!empty($request->category)){ $items->where('category',$request->category); } $items = std_obj_to_array($items->get()); $this->data["item_inventory_query"] = set_array_keys($item_inventory_query,'item'); $this->data["opening_stock_units"] = null; $this->data["before_filter_query"] = set_array_keys($before_filter_query,'item'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["items"] = set_array_keys($items,'uid'); $this->data["product_categories"] = set_array_keys(fetch_table_branch('product_category'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_category"] = $request->category; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["search_tpcp"] = $request->tpcp; $this->data["title"] = print_lang($this->data["app_lang"],'inventory'); $this->data["pageToLoad"] = "reports/inventory.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function sale_stock_report(Request $request) { if(check_user_access('sale_stock_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $items = DB::table('items')->where('branch',$branch_id); if(!empty($request->category)){ $items->where('category',$request->category); } $items = std_obj_to_array($items->get()); $marketers = array(); if(!empty($request->marketer)) { $marketers = $request->marketer; $marketers = explode(',', $marketers); } $before_filter_query = []; if(!empty($request->from)) { $before_filter_query = DB::table('items_inventory_stats')->where('branch',$branch_id)->where('event_date','<',get_true_date($request->from).' 00:00:00'); $before_filter_query->select( 'item', 'item_name', DB::raw('
                        sum(purchase_unit_stock_in) as total_stock_in' ), DB::raw('
                        sum(purchase_unit_bonus_in) as total_bonus_in' ), DB::raw('
                        sum(purchase_unit_stock_out) as total_stock_out' ), DB::raw('
                        sum(purchase_unit_bonus_out) as total_bonus_out' ), ); $before_filter_query->groupBy('item'); $before_filter_query->groupBy('item_name'); if(!empty($request->category)){ $before_filter_query->where('item_category',$request->category); } $before_filter_query = std_obj_to_array($before_filter_query->get()); } $item_inventory_query = DB::table('items_inventory_stats')->where('branch',$branch_id); $item_inventory_query->select( 'item', 'item_name', DB::raw('
                    sum(case when 
                    module_name = "items"
                    then purchase_unit_stock_in END) as opening_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_stock_in END) as purchase_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_bonus_in END) as purchase_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_in"
                    then purchase_unit_stock_in END) as production_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_out"
                    then purchase_unit_stock_out END) as production_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_stock_out END) as sale_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_bonus_out END) as sale_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_stock_in END) as sale_return_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_bonus_in END) as sale_return_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_to_branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_to_branch_transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "damage"
                    then purchase_unit_stock_in END) as damage_units' ), DB::raw('
                    sum(case when 
                    module_name = "expenses_deductions"
                    then purchase_unit_stock_in END) as expenses_deductions_units' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_bonus_in END) as transfer_in_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_bonus_out END) as transfer_out_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_transfer_out_units' ), DB::raw('
                    sum(purchase_unit_stock_in) as total_stock_in' ), DB::raw('
                    sum(purchase_unit_stock_out) as total_stock_out' ), ); $item_inventory_query->groupBy('item'); $item_inventory_query->groupBy('item_name'); if(!empty($request->from)){ $item_inventory_query->where('event_date','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $item_inventory_query->where('event_date','<=',get_true_date($request->to).' 23:59:59'); } if(!empty($request->category)){ $item_inventory_query->where('item_category',$request->category); } $item_inventory_query = std_obj_to_array($item_inventory_query->get()); if(empty($request->tpcp)){$request->tpcp = 'tp';} $this->data["pageData"] = set_array_keys($items,'uid'); $this->data["item_inventory_query"] = set_array_keys($item_inventory_query,'item'); $this->data["before_filter_query"] = set_array_keys($before_filter_query,'item'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["product_categories"] = set_array_keys(fetch_table_branch('product_category'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_marketer"] = $marketers; $this->data["search_category"] = $request->category; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["search_tpcp"] = $request->tpcp; $this->data["title"] = print_lang($this->data["app_lang"],'mod_sale_stock_rep_title'); $this->data["pageToLoad"] = "reports/sale_stock_new.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function item_stock_report(Request $request) { if(check_user_access('item_stock_report') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $item = $request->item; $item_stock = []; $purchases = DB::table('purchases')->where('branch',$branch_id)->where('main_approval','approved')->where('status','passed')->where('items_uid','like','%-++-'.$item.'-++-%'); $sales = DB::table('sales')->where('branch',$branch_id)->where('main_approval','approved')->where('sale_items','like','%-++-'.$item.'-++-%'); $sales_return = DB::table('sales_return')->where('branch',$branch_id)->where('sale_items','like','%-++-'.$item.'-++-%'); $transfer_in = DB::table('transfer_in')->where('branch',$branch_id)->where('items_uid','like','%-++-'.$item.'-++-%'); $transfer_out = DB::table('transfer_out')->where('branch',$branch_id)->where('items_uid','like','%-++-'.$item.'-++-%'); $damage = DB::table('damage')->where('branch',$branch_id)->where('item',$item); if(!empty($request->from)) { $purchases->where('created_at','>=',$request->from.' 00:00:00'); $sales->where('created_at','>=',$request->from.' 00:00:00'); $sales_return->where('created_at','>=',$request->from.' 00:00:00'); $transfer_in->where('created_at','>=',$request->from.' 00:00:00'); $transfer_out->where('created_at','>=',$request->from.' 00:00:00'); $damage->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)) { $purchases->where('created_at','<=',$request->to.' 00:00:00'); $sales->where('created_at','<=',$request->to.' 00:00:00'); $sales_return->where('created_at','<=',$request->to.' 00:00:00'); $transfer_in->where('created_at','<=',$request->to.' 00:00:00'); $transfer_out->where('created_at','<=',$request->to.' 00:00:00'); $damage->where('created_at','<=',$request->to.' 00:00:00'); } $purchases = json_decode(json_encode($purchases->get()),true); $sales = json_decode(json_encode($sales->get()),true); $sales_return = json_decode(json_encode($sales_return->get()),true); $transfer_in = json_decode(json_encode($transfer_in->get()),true); $transfer_out = json_decode(json_encode($transfer_out->get()),true); $damage = json_decode(json_encode($damage->get()),true); if(!empty($request->source)) { if($request->source == 'purchases') { $sales = array(); $sales_return = array(); $transfer_in = array(); $transfer_out = array(); $damage = array(); } if($request->source == 'sales') { $purchases = array(); $sales_return = array(); $transfer_in = array(); $transfer_out = array(); $damage = array(); } if($request->source == 'sales_return') { $purchases = array(); $sales = array(); $transfer_in = array(); $transfer_out = array(); $damage = array(); } if($request->source == 'transfer_in') { $purchases = array(); $sales = array(); $sales_return = array(); $transfer_out = array(); $damage = array(); } if($request->source == 'transfer_out') { $purchases = array(); $sales = array(); $sales_return = array(); $transfer_in = array(); $damage = array(); } if($request->source == 'damage') { $purchases = array(); $sales = array(); $sales_return = array(); $transfer_in = array(); $transfer_out = array(); } } if(!empty($item)) { $item_stock = process_item_stock_report($item,$purchases,$sales,$sales_return,$transfer_in,$transfer_out,$damage); } $this->data["pageData"] = $item_stock; $this->data["item_data"] = fetch_table_where('items','uid',$item,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["search_item"] = $request->item; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["search_source"] = $request->source; $this->data["title"] = print_lang($this->data["app_lang"],'mod_item_stock_rep_title'); $this->data["pageToLoad"] = "reports/item_stock.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function sale_service(Request $request) { if(check_user_access('sale_services_report_rights') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $sales = DB::table('sales')->where('branch',$branch_id)->where('main_approval','approved')->where('sale_items','like','%MITNAME_%'); if(!empty($request->from)){$sales->where('created_at','>=',get_true_date($request->from).' 00:00:00');} if(!empty($request->to)){$sales->where('created_at','<=',get_true_date($request->to).' 23:59:59');} if(!empty($request->client)){$sales->where('client',$request->client);} if(!empty($request->currency)){$sales->where('currency',$request->currency);} $sales = json_decode(json_encode($sales->get()),true); $sales = get_sales_service($sales); $this->data["pageData"] = $sales; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sale_service'); $this->data["pageToLoad"] = "reports/sale_service.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function services(Request $request) { if(check_user_access('services_sales_reports_rights') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $services = DB::table('services')->where('branch',$branch_id); if(!empty($request->currency)){ $services->where('currency',$request->currency); } if(!empty($request->client)){ $services->where('client',$request->client); } if(!empty($request->from)){ $services->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $services->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $services = json_decode(json_encode($services->get()),true); $this->data["pageData"] = $services; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'services_mod_breadcrumb_title'); $this->data["pageToLoad"] = "reports/services.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function services_items(Request $request) { if(check_user_access('services_items_reports_rights') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $services = DB::table('services')->where('branch',$branch_id)->where("type","registered"); if(!empty($request->currency)){ $services->where('currency',$request->currency); } if(!empty($request->client)){ $services->where('client',$request->client); } if(!empty($request->service)){ $services->where('service_ids','like','%-++-'.$request->service.'-++-%'); } if(!empty($request->from)){ $services->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $services->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $services = $services->get(); $services = json_decode(json_encode($services),true); $this->data["pageData"] = $services; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["services_cat"] = set_array_keys(fetch_table_branch('services_cat'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_service"] = $request->service; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'services_items_report'); $this->data["pageToLoad"] = "reports/services_items.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function marketers(Request $request) { if(check_user_access('marketers_report_rights') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $sales = DB::table('sales')->where('branch',$branch_id)->where('main_approval','approved')->whereNotNull('marketer')->where('marketer','!=','null'); if(!empty($request->currency)){ $sales->where('currency',$request->currency); } if(!empty($request->marketer)){ $sales->where('marketer',$request->marketer); } if(!empty($request->from)){ $sales->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $sales->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $sales = $sales->get(); $sales = json_decode(json_encode($sales),true); $services = DB::table('services')->where('branch',$branch_id)->whereNotNull('marketer')->where('marketer','!=','null'); if(!empty($request->currency)){ $services->where('currency',$request->currency); } if(!empty($request->marketer)){ $services->where('marketer',$request->marketer); } if(!empty($request->from)){ $services->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $services->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $services = $services->get(); $services = json_decode(json_encode($services),true); $records = get_marketers_report($sales,$services); $this->data["pageData"] = $records; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_marketer"] = $request->marketer; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'marketers_rep_view_title'); $this->data["pageToLoad"] = "reports/marketers.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function sales_return(Request $request) { if(check_user_access('sale_return_report_rights') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $sales_return = DB::table('sales_return')->where('branch',$branch_id); if(!empty($request->currency)){ $sales_return->where('currency',$request->currency); } if(!empty($request->client)){ $sales_return->where('client',$request->client); } if(!empty($request->marketer)){ $sales_return->where('marketer',$request->marketer); } if(!empty($request->from)){ $sales_return->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $sales_return->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $sales_return = json_decode(json_encode($sales_return->get()),true); $this->data["pageData"] = $sales_return; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_convert_currency"] = $request->convert_currency; $this->data["search_client"] = $request->client; $this->data["search_marketer"] = $request->marketer; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sales_return_view_title'); $this->data["pageToLoad"] = "reports/sales_return.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function batch_wise_stock(Request $request) { if(check_user_access('batch_stock_report_rights') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $item_inventory_query = DB::table('items_inventory_stats')->where('branch',$branch_id); $item_inventory_query->select( 'item', 'item_name', 'batch', 'mfg', 'expiry', DB::raw('
                    sum(case when 
                    module_name = "items"
                    then purchase_unit_stock_in END) as opening_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_stock_in END) as purchase_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_bonus_in END) as purchase_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_in"
                    then purchase_unit_stock_in END) as production_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_out"
                    then purchase_unit_stock_out END) as production_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_stock_out END) as sale_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_bonus_out END) as sale_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_stock_in END) as sale_return_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_bonus_in END) as sale_return_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_to_branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_to_branch_transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "damage"
                    then purchase_unit_stock_in END) as damage_units' ), DB::raw('
                    sum(case when 
                    module_name = "expenses_deductions"
                    then purchase_unit_stock_in END) as expenses_deductions_units' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_bonus_in END) as transfer_in_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_bonus_out END) as transfer_out_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_transfer_out_units' ), DB::raw('
                    sum(purchase_unit_stock_in) as total_stock_in' ), DB::raw('
                    sum(purchase_unit_stock_out) as total_stock_out' ), ); $item_inventory_query->groupBy('item'); $item_inventory_query->groupBy('item_name'); $item_inventory_query->groupBy('batch'); $item_inventory_query = std_obj_to_array($item_inventory_query->get()); $this->data["item_inventory_query"] = $item_inventory_query; $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'batch_rep_view_title'); $this->data["pageToLoad"] = "reports/batch_wise_stock.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function near_expiry_stock(Request $request) { if(check_user_access('near_expiry_report_rights') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $item_inventory_query = DB::table('items_inventory_stats')->where('branch',$branch_id); $item_inventory_query->select( 'item', 'item_name', 'batch', 'mfg', 'expiry', DB::raw('
                    sum(case when 
                    module_name = "items"
                    then purchase_unit_stock_in END) as opening_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_stock_in END) as purchase_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_bonus_in END) as purchase_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_in"
                    then purchase_unit_stock_in END) as production_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_out"
                    then purchase_unit_stock_out END) as production_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_stock_out END) as sale_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_bonus_out END) as sale_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_stock_in END) as sale_return_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_bonus_in END) as sale_return_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_to_branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_to_branch_transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "damage"
                    then purchase_unit_stock_in END) as damage_units' ), DB::raw('
                    sum(case when 
                    module_name = "expenses_deductions"
                    then purchase_unit_stock_in END) as expenses_deductions_units' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_bonus_in END) as transfer_in_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_bonus_out END) as transfer_out_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_transfer_out_units' ), DB::raw('
                    sum(purchase_unit_stock_in) as total_stock_in' ), DB::raw('
                    sum(purchase_unit_stock_out) as total_stock_out' ), ); $item_inventory_query->groupBy('item'); $item_inventory_query->groupBy('item_name'); $item_inventory_query->groupBy('batch'); $item_inventory_query = std_obj_to_array($item_inventory_query->get()); $this->data["item_inventory_query"] = $item_inventory_query; $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["product_categories"] = set_array_keys(fetch_table_branch('product_category'),'uid'); $this->data["search_type"] = $request->type; $this->data["search_category"] = $request->category; $this->data["search_currency"] = $request->currency; $this->data["search_unit"] = $request->unit; $this->data["_search"] = $request->_search; $this->data["title"] = print_lang($this->data["app_lang"],'expiry_report_title'); $this->data["pageToLoad"] = "reports/near_expiry.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function expired_stock(Request $request) { if(check_user_access('expired_report_rights') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $item_inventory_query = DB::table('items_inventory_stats')->where('branch',$branch_id); $item_inventory_query->select( 'item', 'item_name', 'batch', 'mfg', 'expiry', DB::raw('
                    sum(case when 
                    module_name = "items"
                    then purchase_unit_stock_in END) as opening_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_stock_in END) as purchase_units' ), DB::raw('
                    sum(case when 
                    module_name = "purchases"
                    then purchase_unit_bonus_in END) as purchase_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_in"
                    then purchase_unit_stock_in END) as production_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "production_out"
                    then purchase_unit_stock_out END) as production_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_stock_out END) as sale_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales"
                    then purchase_unit_bonus_out END) as sale_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_stock_in END) as sale_return_units' ), DB::raw('
                    sum(case when 
                    module_name = "sales_return"
                    then purchase_unit_bonus_in END) as sale_return_bonus_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_to_branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_to_branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_to_branch_transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "damage"
                    then purchase_unit_stock_in END) as damage_units' ), DB::raw('
                    sum(case when 
                    module_name = "expenses_deductions"
                    then purchase_unit_stock_in END) as expenses_deductions_units' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_in"
                    then purchase_unit_bonus_in END) as transfer_in_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_pharma' ), DB::raw('
                    sum(case when 
                    module_name = "transfer_out"
                    then purchase_unit_bonus_out END) as transfer_out_pharma_bonus' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_in"
                    then purchase_unit_stock_in END) as transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "warehouse_transfer_out"
                    then purchase_unit_stock_out END) as transfer_out_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_in"
                    then purchase_unit_stock_in END) as branch_transfer_in_units' ), DB::raw('
                    sum(case when 
                    module_name = "branch_transfer_out"
                    then purchase_unit_stock_out END) as branch_transfer_out_units' ), DB::raw('
                    sum(purchase_unit_stock_in) as total_stock_in' ), DB::raw('
                    sum(purchase_unit_stock_out) as total_stock_out' ), ); $item_inventory_query->groupBy('item'); $item_inventory_query->groupBy('item_name'); $item_inventory_query->groupBy('batch'); $item_inventory_query = std_obj_to_array($item_inventory_query->get()); $this->data["item_inventory_query"] = $item_inventory_query; $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["product_categories"] = set_array_keys(fetch_table_branch('product_category'),'uid'); $this->data["search_type"] = $request->type; $this->data["search_category"] = $request->category; $this->data["search_currency"] = $request->currency; $this->data["search_unit"] = $request->unit; $this->data["_search"] = $request->_search; $this->data["title"] = print_lang($this->data["app_lang"],'expired_report_title'); $this->data["pageToLoad"] = "reports/expired.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function shortage_stock(Request $request) { if(check_user_access('shortage_report_rights') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $items = std_obj_to_array(DB::table('items')->where('branch',$branch_id)->orderBy('name','asc')->get()); $this->data["pageData"] = $items; $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["product_categories"] = set_array_keys(fetch_table_branch('product_category'),'uid'); $this->data["search_type"] = $request->type; $this->data["search_category"] = $request->category; $this->data["search_currency"] = $request->currency; $this->data["search_unit"] = $request->unit; $this->data["_search"] = $request->_search; $this->data["title"] = print_lang($this->data["app_lang"],'shortage_report_title'); $this->data["pageToLoad"] = "reports/shortage.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function bundle_toop(Request $request) { if(check_user_access('bundle_toop') === FALSE){ Redirect::to('/')->send(); } $items_stats = std_obj_to_array( DB::select("
                SELECT
                item_name,
                item,
                SUM(bundle_stock_in) bundle_stock_in_total,
                SUM(bundle_stock_out) bundle_stock_out_total,
                SUM(toop_stock_in) toop_stock_in_total,
                SUM(toop_stock_out) toop_stock_out_total
                FROM items_inventory_stats
                GROUP BY item, item_name
            ") ); $this->data["pageData"] = $items_stats; $this->data["title"] = print_lang($this->data["app_lang"],'bundle_item_report_title'); $this->data["pageToLoad"] = "reports/bundle_toop.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function stock_general_ledger(Request $request) { if(check_user_access('stock_general_ledger') === FALSE){ Redirect::to('/')->send(); } $stats = std_obj_to_array(DB::table('items_inventory_stats')->where('branch',active_branch_id())->where('item',$request->item)->orderBy('event_date','asc')->get()); $this->data["stats"] = $stats; $this->data["search_item_data"] = fetch_table_where('items','uid',$request->item,true); $this->data["search_item"] = $request->item; $this->data["search_unit"] = $request->unit; $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'stock_general_ledger_report_title'); $this->data["pageToLoad"] = "reports/stock_general_ledger.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function items_by_warehouse(Request $request) { if(check_user_access('items_by_warehouse') === FALSE){ Redirect::to('/')->send(); } $this->data["search_unit"] = $request->unit; $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["warehouses"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'items_by_warehouse_report_title'); $this->data["pageToLoad"] = "reports/items_by_warehouse.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function items_token(Request $request) { if(check_user_access('items_token') === FALSE){ Redirect::to('/')->send(); } $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'items_token_report_title'); $this->data["pageToLoad"] = "reports/items_token.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } public function audit(Request $request) { if(check_user_access('audit_report') === FALSE){ Redirect::to('/')->send(); } if(empty($request->from)) { $request->from = date('Y-m-d'); if(fetch_calander_name() == 'persian') { $request->from = get_persian_date($request->from); } } if(empty($request->to)) { $request->to = date('Y-m-d'); if(fetch_calander_name() == 'persian') { $request->to = get_persian_date($request->to); } } $records = DB::table('activity_alerts')->where('branch',active_branch_id()); if(!empty($request->from)){ $records->where('activity_time','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $records->where('activity_time','<=',get_true_date($request->to).' 23:59:59'); } $records = $records->orderBy('activity_time','asc')->get(); $this->data["records"] = std_obj_to_array($records); $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'audit_report_title'); $this->data["pageToLoad"] = "reports/audit_report.php"; $this->data["activeLink"] = "reports"; $this->load_view($this->data); } }