<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; class Sales extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_sale') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $sales = DB::table('sales')->where('branch',$branch_id); if(!empty($request->currency)){ $sales->where('currency',$request->currency); } if(!empty($request->client)){ $sales->where('client',$request->client); } if(!empty($request->marketer)){ $sales->where('marketer',$request->marketer); } if(!empty($request->user)){ $sales->where('user',$request->user); } if(!empty($request->from)){ $sales->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $sales->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $sales->where(function($query) use ($request){ $query->where('main_approval','pending')->orWhere('main_approval','approved'); }); if(!empty($request->_search)) { $sales->where(function($query) use ($request) { $query->where('invoice','like','%'.$request->_search.'%'); $query->orWhere('sales_total','like','%'.$request->_search.'%'); $query->orWhere('total_discount_amount','like','%'.$request->_search.'%'); $query->orWhere('sub_total','like','%'.$request->_search.'%'); $query->orWhere('cash_received','like','%'.$request->_search.'%'); $query->orWhere('remaining_amount','like','%'.$request->_search.'%'); $query->orWhere('trans_expense','like','%'.$request->_search.'%'); $query->orWhere('total_profit_amount','like','%'.$request->_search.'%'); $query->orWhere('memo','like','%'.$request->_search.'%'); }); } $sales = $sales->paginate($this->data['rows_per_page']); $pagination = $sales->appends(request()->except(['page','search_type']))->links(); $sales = json_decode(json_encode($sales),true); $this->data["pageData"] = $sales['data']; $this->data["pagination"] = $pagination; $this->data["records"] = array('from' => $sales['from'], 'to' => $sales['to'], 'total' => $sales['total']); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["users"] = std_obj_to_array(DB::table('users')->where('branch',active_branch_id())->orWhere('role','SUPERADMIN')->get()); if($request->search_type == 'live_search') { $this->data["live_search_data"] = 'yes'; $view_records = (string)View::make('user.sales.view',$this->data); $stats = "Showing ".(float)$this->data["records"]['from'].' - '.(float)$this->data["records"]['to'].' of '.(float)$this->data["records"]['total']; $output_array = array('records' => $view_records, 'stats' => $stats, 'pagination' => (string)$pagination); echo json_encode($output_array); } else { $this->data["live_search_data"] = 'no'; $this->data["_search"] = $request->_search; $this->data["search_currency"] = $request->currency; $this->data["search_convert_currency"] = $request->convert_currency; $this->data["search_client"] = $request->client; $this->data["search_marketer"] = $request->marketer; $this->data["search_user"] = $request->user; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sales'); $this->data["pageToLoad"] = "sales/view.php"; $this->data["activeLink"] = "sales"; $this->data["_datatable_pagination"] = false; $this->load_view($this->data); } } public function view_all(Request $request) { if(check_user_access('view_sale') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $sales = DB::table('sales')->where('branch',$branch_id); if(!empty($request->_search)) { $sales->where(function($query) use ($request) { $query->where('invoice','like','%'.$request->_search.'%'); $query->orWhere('sales_total','like','%'.$request->_search.'%'); $query->orWhere('total_discount_amount','like','%'.$request->_search.'%'); $query->orWhere('sub_total','like','%'.$request->_search.'%'); $query->orWhere('cash_received','like','%'.$request->_search.'%'); $query->orWhere('remaining_amount','like','%'.$request->_search.'%'); $query->orWhere('trans_expense','like','%'.$request->_search.'%'); $query->orWhere('total_profit_amount','like','%'.$request->_search.'%'); $query->orWhere('memo','like','%'.$request->_search.'%'); }); } if(!empty($request->currency)){ $sales->where('currency',$request->currency); } if(!empty($request->client)){ $sales->where('client',$request->client); } if(!empty($request->marketer)){ $sales->where('marketer',$request->marketer); } if(!empty($request->from)){ $sales->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $sales->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $sales = json_decode(json_encode($sales->get()),true); $this->data["pageData"] = $sales; $this->data["_search"] = $request->_search; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_convert_currency"] = $request->convert_currency; $this->data["search_client"] = $request->client; $this->data["search_marketer"] = $request->marketer; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sales'); $this->data["pageToLoad"] = "sales/view_all.php"; $this->data["activeLink"] = "sales"; $this->load_view($this->data); } public function view_junk(Request $request) { $branch_id = user_branch_id(); $currency = NULL; $start_date = NULL; $end_date = NULL; $start_date_que = $start_date; $end_date_que = date('Y-m-d'); $journals = DB::table('journal')->where('branch_id',$branch_id); if(!empty($request->_search)) { $journals->where(function($query) use ($request) { $query->where('journal_type','like','%'.$request->_search.'%'); $query->orWhere('transaction_type','like','%'.$request->_search.'%'); $query->orWhere('account_name','like','%'.$request->_search.'%'); $query->orWhere('paid_currency_symbol','like','%'.$request->_search.'%'); $query->orWhere('paid_currency_name','like','%'.$request->_search.'%'); $query->orWhere('recieved_currency_symbol','like','%'.$request->_search.'%'); $query->orWhere('recieved_currency_name','like','%'.$request->_search.'%'); $query->orWhere('rate','like','%'.$request->_search.'%'); $query->orWhere('paid_amount','like','%'.$request->_search.'%'); $query->orWhere('recieved_amount','like','%'.$request->_search.'%'); $query->orWhere('description','like','%'.$request->_search.'%'); }); } if(!Input::get('page')) { $page = $journals->paginate($this->data['rows_per_page'])->lastPage(); $journals = $journals->paginate($this->data['rows_per_page'],['*'],'page',$page); } else { $journals = $journals->paginate($this->data['rows_per_page']); } $pagination = $journals->appends(request()->except(['page','search_type']))->links(); $journals = json_decode(json_encode($journals),true); $this->data["pageData"] = $journals['data']; $this->data["pagination"] = $pagination; $this->data["records"] = array('from' => $journals['from'], 'to' => $journals['to'], 'total' => $journals['total']); $this->data["datatable_pagination"] = 'disable'; $this->data["currencies"] = fetch_table("currencies"); if($request->search_type == 'live_search') { $this->data["live_search_data"] = 'yes'; $view_records = (string)View::make('journal.view',$this->data); $stats = "Showing ".(float)$this->data["records"]['from'].' - '.(float)$this->data["records"]['to'].' of '.(float)$this->data["records"]['total']; $output_array = array('records' => $view_records, 'stats' => $stats, 'pagination' => (string)$pagination); echo json_encode($output_array); } else { $this->data["_search"] = $request->_search; $this->data["currency_id"] = $currency; $this->data["start_date"] = $start_date; $this->data["end_date"] = $end_date; $this->data["title"] = "Journal"; $this->data["pageToLoad"] = "journal/view.php"; $this->data["breadcrumbs"] = '<li class="breadcrumb-item active">Journal</li>'; $this->data["activeLink"] = "journal"; $this->load_view($this->data); } } public function invoice(Request $request, $uid) { if(is_marketer_user() === false AND is_sales_man_user() === false AND is_customer_user() === false){ if(check_user_access('add_sale') === FALSE){ Redirect::to('/')->send(); } } $this->data["invoice_data"] = fetch_table_where('sales','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["accounts"] = array_merge($this->data["clients"],$this->data["suppliers"]); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'sales_invoice'); $item_settings = get_item_settings(); $page_to_load = 'sales/invoice.php'; if($item_settings['sale_invoice'] == 'sales_invoice_1'){$page_to_load = 'sales/invoice.php';} if($item_settings['sale_invoice'] == 'sales_invoice_2'){$page_to_load = 'sales/sales_new.php';} if($item_settings['sale_invoice'] == 'sales_invoice_3'){$page_to_load = 'sales/sales_invoice.php';} if($item_settings['sale_invoice'] == 'sales_invoice_4'){$page_to_load = 'sales/sales_invoice_4.php';} $this->data["pageToLoad"] = $page_to_load; $this->data["activeLink"] = "sales"; $this->load_view($this->data); } public function delivery_note(Request $request, $uid) { if(check_user_access('add_sale') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('sales','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'sales_invoice'); $this->data["pageToLoad"] = "sales/delivery_note.php"; $this->data["activeLink"] = "sales"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_sale') === FALSE){ Redirect::to('/')->send(); } $quotation_uid = $request->quotation; if(empty($quotation_uid)) { $quotation_data = array( 'uid' => NULL, 'currency' => NULL, 'client' => NULL, 'invoice' => NULL, 'memo' => NULL, 'items_details' => json_encode(array()), 'total_sales_amount' => NULL, 'total_discount_amount' => NULL, 'gross_total_amount' => NULL, 'total_profit_amount' => NULL, 'cash_client_name' => NULL, 'cash_client_mobile' => NULL, ); } else { $quotation_data = DB::table('quotations')->where('uid',$quotation_uid)->get(); if($quotation_data->count() > 0) { $quotation_data = json_decode(json_encode($quotation_data[0]),true); } else { $quotation_data = array( 'uid' => NULL, 'currency' => NULL, 'client' => NULL, 'invoice' => NULL, 'memo' => NULL, 'items_details' => json_encode(array()), 'total_sales_amount' => NULL, 'total_discount_amount' => NULL, 'gross_total_amount' => NULL, 'total_profit_amount' => NULL, 'cash_client_name' => NULL, 'cash_client_mobile' => NULL, ); } } $this->data["quotation_data"] = $quotation_data; $this->data["is_marketer"] = get_active_marketer(); $this->data["invoice_number"] = get_sale_invoice_number(); $this->data["currencies"] = fetch_currencies(); $this->data["batch"] = fetch_table_branch('batch'); $this->data["marketers"] = fetch_table_branch('marketers'); $this->data["sets"] = fetch_table_branch('sets'); $this->data["sales_man"] = fetch_table_branch('sales_man'); $this->data["items"] = fetch_table_branch('items'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["clients"] = fetch_all_clients(); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["expenses"] = fetch_table_where_branch('accounts','type','expense'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'add_sale'); $this->data["pageToLoad"] = "sales/add.php"; $this->data["activeLink"] = "sales"; $this->load_view($this->data); } public function get_sets_appended_data(Request $request) { $set_uid = $request->set_value; $set_data = fetch_table_where('sets','uid',$set_uid,true); $this->data["set_data"] = $set_data; $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["editing_data"] = $request->all(); $appended_view = (string)View::make('user.sales.sets_appended_view',$this->data); echo json_encode(array('status' => 'success', 'html' => $appended_view)); } public function save(Request $request) { $items_details = array(); $_items_effected = array(); $items = array(); $warehouse = array(); $batch = array(); $sic = 0; $invoice_num = (int)$request->invoice[0]; $invoice_num_exist = DB::table('sales')->where('branch',active_branch_id())->where('invoice',$invoice_num)->get(); while($sic < count($request->item)) { if(empty($request->item[$sic])){ $sic++; continue; } $items_details[] = array( 'agent' => $request->agent[$sic], 'plate' => $request->plate[$sic], 'item' => $request->item[$sic], 'item_uqid' => $request->item_uqid[$sic], 'warehouse' => $request->warehouse[$sic], 'batch' => $request->batch[$sic], 'mfg' => $request->mfg[$sic], 'expiry' => $request->expiry[$sic], 'narration' => $request->narration[$sic], 'cost' => (float)$request->cost[$sic], 'sale_price' => (float)$request->sale_price[$sic], 'bundle' => isset($request->bundle[$sic]) ? (float)$request->bundle[$sic] : 0, 'toop' => isset($request->toop[$sic]) ? (float)$request->toop[$sic] : 0, 'item_token' => isset($request->item_token[$sic]) ? (float)$request->item_token[$sic] : 0, 'qty' => (float)$request->qty[$sic], 'out_qty' => (float)$request->out_qty[$sic], 'out' => (float)$request->out[$sic], 'bonus' => (float)$request->bonus[$sic], 'm2' => (float)$request->m2[$sic], 'width' => (float)$request->width[$sic], 'height' => (float)$request->height[$sic], 'unit' => $request->unit[$sic], 'discount' => (float)$request->discount[$sic], 'discount_2' => isset($request->discount_2[$sic]) ? (float)$request->discount_2[$sic] : 0, 'profit' => (float)$request->profit[$sic], 'item_total' => (float)$request->item_total[$sic], 'set_name' => isset($request->set_name[$sic]) ? $request->set_name[$sic] : 0, 'set_uid' => isset($request->set_uid[$sic]) ? $request->set_uid[$sic] : 0, ); $_items_effected[] = $request->item[$sic]; $items[] = '-++-'.$request->item[$sic].'-++-'; $warehouse[] = '-++-'.$request->warehouse[$sic].'-++-'; $batch[] = '-++-'.$request->batch[$sic].'-++-'; $sic++; } $uid = getUniqueId('SALE', 'sales', 'uid'); $client_old_balance = get_account_balance($request->client[0],$request->currency[0]); $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); $marketer_db_data = fetch_table_where('marketers','uid',$request->marketer[0],true); if(!empty($request->cash_client_name)) { $cash_client_name = $request->cash_client_name[0]; } else { $cash_client_name = ''; } if(!empty($request->cash_client_mobile)) { $cash_client_mobile = $request->cash_client_mobile[0]; } else { $cash_client_mobile = ''; } $created_at = get_true_date( empty($request->sdate[0]) ? date('y-m-d') : $request->sdate[0] ); $time_cr = date('H:i:s'); $created_at = $created_at." ".$time_cr; $sales_man = NULL; $client_db_data = fetch_table_where('accounts','uid',$request->client[0],true); if(!empty($client_db_data)){$sales_man = $client_db_data['sales_man'];} $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'serial_id' => get_serial_id('sales'), 'quotation' => $request->quotation_id, 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->client[0], 'marketer' => $request->marketer[0], 'sales_man' => $sales_man, 'commission_type' => empty($marketer_db_data['commission_type']) ? NULL : $marketer_db_data['commission_type'], 'marketer_commission' => (float)empty($marketer_db_data['commission']) ? NULL : $marketer_db_data['commission'], 'cash_client_name' => $cash_client_name, 'cash_client_mobile' => $cash_client_mobile, 'old_balance' => $client_old_balance, 'invoice' => $invoice_num, 'memo' => $request->memo[0], 'sales_total' => (float)$request->sales_total, 'trans_expense' => (float)$request->trans_expense, 'expense_account' => $request->expense_account, 'sub_total' => (float)$request->sub_total, 'cash_received' => (float)$request->cash_received, 'remaining_amount' => (float)$request->remaining_amount, 'items_details' => json_encode($items_details), 'sale_items' => implode(',', $items), 'sale_warehouse' => implode(',', $warehouse), 'sale_batch' => implode(',', $batch), 'total_sales_amount' => (float)$request->total_sales_amount, 'total_discount_amount' => (float)$request->total_discount_amount, 'total_discount_amount_1' => (float)$request->total_discount_amount_1, 'total_discount_amount_2' => (float)$request->total_discount_amount_2, 'gross_total_amount' => (float)$request->gross_total_amount, 'total_profit_amount' => (float)$request->total_profit_amount, 'cash_received_account' => $request->cash_received_account, 'delivery_type' => $request->delivery_type, 'created_at' => $created_at, 'user' => Session::get('user_id'), 'user_name' => Session::get('user_name'), 'sub_approval' => user_approval_info('sub_approval'), 'sub_approval_user' => user_approval_info('sub_approval_user'), 'sub_approval_user_name' => user_approval_info('sub_approval_user_name'), 'main_approval' => user_approval_info('main_approval'), 'main_approval_user' => user_approval_info('main_approval_user'), 'main_approval_user_name' => user_approval_info('main_approval_user_name'), ); insert_table('sales',$db_array); if(user_approval_info('main_approval') == 'approved') { _handle_sales_ledger_effects(['uid' => $uid, 'state' => 'new']); _handle_items_inventory_stats_from_sales(['uid' => $uid, 'entry_status' => 'new']); message_from_sales($uid); } if(!empty($request->quotation_id)) { $qdb_array = array('status' => 'converted', 'sale_id' => $uid); update_table('quotations','uid',$request->quotation_id,$qdb_array); } $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_sales'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/sales/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['sub_total']), ); set_activity_alert($_activity_details); $invoice_url = url('/sales/invoice').'/'.$uid; $deliver_note = url('/sales/deliver-note').'/'.$uid; $invoice_number = get_sale_invoice_number(); echo json_encode(array('status' => 'success', 'mood' => 'new', 'deliver_note' => $deliver_note, 'invoice_number' => $invoice_number, 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'sale_added'), 'message_body' => print_lang($this->data["app_lang"],'new_sale_added_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_sale') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('sales','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/sales')->send(); } $balance = get_account_balance($this->data["editing_data"]['client'],$this->data["editing_data"]['currency']); $this->data["currencies"] = fetch_currencies(); $this->data["balance"] = $balance; $this->data["batch"] = set_array_keys(fetch_table_branch('batch'),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["sales_man"] = set_array_keys(fetch_table_branch('sales_man'),'uid'); $this->data["sets"] = fetch_table_branch('sets'); $this->data["items"] = fetch_table_branch('items'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["expenses"] = fetch_table_where_branch('accounts','type','expense'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_sale'); $this->data["pageToLoad"] = "sales/edit.php"; $this->data["activeLink"] = "sales"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_details = array(); $_items_effected = array(); $items = array(); $warehouse = array(); $batch = array(); $sic = 0; $commission_type = NULL; $marketer_commission = NULL; $invoice_num = (int)$request->invoice[0]; $invoice_num_exist = DB::table('sales')->where('branch',active_branch_id())->where('uid','!=',$uid)->where('invoice',$invoice_num)->get(); if($invoice_num_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'update', 'message_head' => 'Invoice Exist', 'message_body' => 'This invoice number already exist.')); die; } while($sic < count($request->item)) { if(empty($request->item[$sic])){ $sic++; continue; } $items_details[] = array( 'agent' => $request->agent[$sic], 'plate' => $request->plate[$sic], 'item' => $request->item[$sic], 'item_uqid' => $request->item_uqid[$sic], 'warehouse' => $request->warehouse[$sic], 'batch' => $request->batch[$sic], 'mfg' => $request->mfg[$sic], 'expiry' => $request->expiry[$sic], 'narration' => $request->narration[$sic], 'cost' => (float)$request->cost[$sic], 'sale_price' => (float)$request->sale_price[$sic], 'bundle' => isset($request->bundle[$sic]) ? (float)$request->bundle[$sic] : 0, 'toop' => isset($request->toop[$sic]) ? (float)$request->toop[$sic] : 0, 'item_token' => isset($request->item_token[$sic]) ? (float)$request->item_token[$sic] : 0, 'qty' => (float)$request->qty[$sic], 'out_qty' => (float)$request->out_qty[$sic], 'out' => (float)$request->out[$sic], 'bonus' => (float)$request->bonus[$sic], 'm2' => (float)$request->m2[$sic], 'width' => (float)$request->width[$sic], 'height' => (float)$request->height[$sic], 'unit' => $request->unit[$sic], 'discount' => (float)$request->discount[$sic], 'discount_2' => isset($request->discount_2[$sic]) ? (float)$request->discount_2[$sic] : 0, 'profit' => (float)$request->profit[$sic], 'item_total' => (float)$request->item_total[$sic], 'set_name' => isset($request->set_name[$sic]) ? $request->set_name[$sic] : 0, 'set_uid' => isset($request->set_uid[$sic]) ? $request->set_uid[$sic] : 0, ); $_items_effected[] = $request->item[$sic]; $items[] = '-++-'.$request->item[$sic].'-++-'; $warehouse[] = '-++-'.$request->warehouse[$sic].'-++-'; $batch[] = '-++-'.$request->batch[$sic].'-++-'; $sic++; } if(!empty($request->cash_client_name)) { $cash_client_name = $request->cash_client_name[0]; } else { $cash_client_name = ''; } if(!empty($request->cash_client_mobile)) { $cash_client_mobile = $request->cash_client_mobile[0]; } else { $cash_client_mobile = ''; } $last_sale = fetch_table_where('sales','uid',$uid,true); $last_created_at = $last_sale['created_at']; $last_time = date("H:i:s",strtotime($last_created_at)); $created_at = get_true_date( empty($request->sdate[0]) ? date('Y-m-d') : $request->sdate[0] ); $created_at = $created_at." ".$last_time; $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); if($request->marketer[0] == $last_sale['marketer']) { $commission_type = $last_sale['commission_type']; $marketer_commission = (float)$last_sale['marketer_commission']; } else { $marketer_db_data = fetch_table_where('marketers','uid',$request->marketer[0],true); if(!empty($marketer_db_data)) { $commission_type = $marketer_db_data['commission_type']; $marketer_commission = (float)$marketer_db_data['commission']; } } $sales_man = NULL; $client_db_data = fetch_table_where('accounts','uid',$request->client[0],true); if(!empty($client_db_data)){$sales_man = $client_db_data['sales_man'];} $db_array = array( 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->client[0], 'marketer' => $request->marketer[0], 'sales_man' => $sales_man, 'commission_type' => $commission_type, 'marketer_commission' => $marketer_commission, 'cash_client_name' => $cash_client_name, 'cash_client_mobile' => $cash_client_mobile, 'invoice' => (int)$request->invoice[0], 'memo' => $request->memo[0], 'sales_total' => (float)$request->sales_total, 'trans_expense' => (float)$request->trans_expense, 'expense_account' => $request->expense_account, 'sub_total' => (float)$request->sub_total, 'cash_received' => (float)$request->cash_received, 'remaining_amount' => (float)$request->remaining_amount, 'items_details' => json_encode($items_details), 'sale_items' => implode(',', $items), 'sale_warehouse' => implode(',', $warehouse), 'sale_batch' => implode(',', $batch), 'total_sales_amount' => (float)$request->total_sales_amount, 'total_discount_amount' => (float)$request->total_discount_amount, 'total_discount_amount_1' => (float)$request->total_discount_amount_1, 'total_discount_amount_2' => (float)$request->total_discount_amount_2, 'gross_total_amount' => (float)$request->gross_total_amount, 'total_profit_amount' => (float)$request->total_profit_amount, 'cash_received_account' => $request->cash_received_account, 'delivery_type' => $request->delivery_type, 'created_at' => $created_at, ); $data_before_update = fetch_table_where('sales','uid',$uid,true); update_table('sales','uid',$uid,$db_array); _handle_sales_ledger_effects(['uid' => $uid, 'state' => 'update']); _handle_items_inventory_stats_from_sales(['uid' => $uid, 'entry_status' => 'update']); $sale_items_before_update = empty($data_before_update['items_details']) ? array() : json_decode($data_before_update['items_details'],true); if(!empty($sale_items_before_update)) { foreach($sale_items_before_update as $old_item) { if(!empty($old_item['item'])) { _calculate_item_wise_stats(['item' => $old_item['item']]); } } } $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_sales'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/sales/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['sub_total']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'sale_updated'), 'message_body' => print_lang($this->data["app_lang"],'sale_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_sale') === FALSE){ Redirect::to('/')->send(); } $sale_data = fetch_table_where('sales','uid',$uid,true); if(!empty($sale_data['quotation'])) { $qdb_array = array('status' => 'pending', 'sale_id' => NULL); update_table('quotations','uid',$sale_data['quotation'],$qdb_array); } $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_sales'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$sale_data['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($sale_data['sub_total']), ); set_activity_alert($_activity_details); delete_table('sales','uid',$uid); _handle_sales_ledger_effects(['uid' => $uid, 'state' => 'delete']); _handle_items_inventory_stats_from_sales(['uid' => $uid, 'entry_status' => 'delete']); $sale_items_before_update = empty($sale_data['items_details']) ? array() : json_decode($sale_data['items_details'],true); if(!empty($sale_items_before_update)) { foreach($sale_items_before_update as $old_item) { if(!empty($old_item['item'])) { _calculate_item_wise_stats(['item' => $old_item['item']]); } } } echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function get_items_batch(Request $request) { $uid = $request->item; $item_data = fetch_table_where('items','uid',$uid,true); $item_stats = json_decode($item_data['stats'],true); $item_currency = $item_data['currency']; $item_currency_usd_equalance = (float)$item_data['currency_usd_equalance']; $active_branch_id = active_branch_id(); $warehouse = $request->warehouse; $batch_array = array(); $batch = std_obj_to_array(DB::table("items_inventory_stats")->where('item',$uid)->where('warehouse',$warehouse)->select('batch')->distinct()->get()); foreach($batch as $row) { $batch_array[$row['batch']] = $row['batch']; } $batch_array = array_unique($batch_array); $options_snippet = ''; foreach($batch_array as $ba) { $items_inventory = std_obj_to_array( DB::select("
                    SELECT 
                    sum(purchase_unit_stock_in) stock_in, 
                    sum(purchase_unit_bonus_in) bonus_in, 
                    sum(purchase_unit_stock_out) stock_out,
                    sum(purchase_unit_bonus_out) bonus_out
                    FROM items_inventory_stats
                    where batch = '".$ba."' AND item = '".$uid."' AND warehouse = '".$warehouse."'
                    ") ); $stock_ava = ($items_inventory[0]['stock_in'] + $items_inventory[0]['bonus_in']) - ($items_inventory[0]['stock_out'] + $items_inventory[0]['bonus_out']); $mfg_date = null; $expiry_date = null; $module = 'items'; $mfg_query = DB::table('items_inventory_stats')->where('item',$uid)->where('batch',$ba)->where(function($query) use ($module){ $query->where('module_name','items'); $query->orWhere('module_name','purchases'); $query->orWhere('module_name','branch_transfer_in'); $query->orWhere('module_name','transfer_in'); $query->orWhere('module_name','production_in'); $query->orWhere('module_name','branch_to_branch_transfer_in'); }); $mfg_query = std_obj_to_array($mfg_query->whereNotNull('mfg')->orderBy('event_date','desc')->get()->first()); if(!empty($mfg_query)){ $mfg_date = $mfg_query['mfg']; } $expiry_query = DB::table('items_inventory_stats')->where('item',$uid)->where('batch',$ba)->where(function($query) use ($module){ $query->where('module_name','items'); $query->orWhere('module_name','purchases'); $query->orWhere('module_name','branch_transfer_in'); $query->orWhere('module_name','transfer_in'); $query->orWhere('module_name','production_in'); $query->orWhere('module_name','branch_to_branch_transfer_in'); }); $expiry_query = std_obj_to_array($expiry_query->whereNotNull('expiry')->orderBy('event_date','desc')->get()->first()); if(!empty($expiry_query)){ $expiry_date = $expiry_query['expiry']; } $sale_price = (float)$item_stats['avg_cost'] + (float)$item_stats['last_profit']; $profit = (float)$item_stats['last_profit']; $option_show = $ba.'- ('.display_true_date($expiry_date).')'.'- (ava-'.$stock_ava.')'; $options_snippet .= '<option value="'.$ba.'" data-profit="'.$profit.'" data-ava-units="'.$stock_ava.'" data-sale-price="'.$sale_price.'" data-expiry="'.$expiry_date.'" data-mfg="'.$mfg_date.'">'.$option_show.'</option>'; } echo $options_snippet; } public function get_items_batch_json(Request $request) { $uid = $request->item; $item_data = fetch_table_where('items','uid',$uid,true); $item_stats = json_decode($item_data['stats'],true); $item_currency = $item_data['currency']; $item_currency_usd_equalance = (float)$item_data['currency_usd_equalance']; $active_branch_id = active_branch_id(); $warehouse = $request->warehouse; $batch_array = array(); $batch = std_obj_to_array(DB::table("items_inventory_stats")->where('item',$uid)->where('warehouse',$warehouse)->select('batch')->distinct()->get()); foreach($batch as $row) { $batch_array[$row['batch']] = $row['batch']; } $batch_array = array_unique($batch_array); $options_snippet = ''; foreach($batch_array as $ba) { $items_inventory = std_obj_to_array( DB::select("
                    SELECT 
                    sum(purchase_unit_stock_in) stock_in, 
                    sum(purchase_unit_bonus_in) bonus_in, 
                    sum(purchase_unit_stock_out) stock_out,
                    sum(purchase_unit_bonus_out) bonus_out
                    FROM items_inventory_stats
                    where batch = '".$ba."' AND item = '".$uid."' AND warehouse = '".$warehouse."'
                    ") ); $stock_ava = ($items_inventory[0]['stock_in'] + $items_inventory[0]['bonus_in']) - ($items_inventory[0]['stock_out'] + $items_inventory[0]['bonus_out']); $mfg_date = null; $expiry_date = null; $module = 'items'; $mfg_query = DB::table('items_inventory_stats')->where('item',$uid)->where('batch',$ba)->where(function($query) use ($module){ $query->where('module_name','items'); $query->orWhere('module_name','purchases'); $query->orWhere('module_name','branch_transfer_in'); $query->orWhere('module_name','transfer_in'); $query->orWhere('module_name','production_in'); $query->orWhere('module_name','branch_to_branch_transfer_in'); }); $mfg_query = std_obj_to_array($mfg_query->whereNotNull('mfg')->orderBy('event_date','desc')->get()->first()); if(!empty($mfg_query)){ $mfg_date = $mfg_query['mfg']; } $expiry_query = DB::table('items_inventory_stats')->where('item',$uid)->where('batch',$ba)->where(function($query) use ($module){ $query->where('module_name','items'); $query->orWhere('module_name','purchases'); $query->orWhere('module_name','branch_transfer_in'); $query->orWhere('module_name','transfer_in'); $query->orWhere('module_name','production_in'); $query->orWhere('module_name','branch_to_branch_transfer_in'); }); $expiry_query = std_obj_to_array($expiry_query->whereNotNull('expiry')->orderBy('event_date','desc')->get()->first()); if(!empty($expiry_query)){ $expiry_date = $expiry_query['expiry']; } $sale_price = (float)$item_stats['avg_cost'] + (float)$item_stats['last_profit']; $profit = (float)$item_stats['last_profit']; $option_show = $ba.'- ('.display_true_date($expiry_date).')'.'- (ava-'.$stock_ava.')'; $options_snippet .= '<option value="'.$ba.'" data-profit="'.$profit.'" data-ava-units="'.$stock_ava.'" data-sale-price="'.$sale_price.'" data-expiry="'.$expiry_date.'" data-mfg="'.$mfg_date.'">'.$option_show.'</option>'; } echo json_encode(array('status' => 'success', 'options_snippet' => $options_snippet)); } public function get_items_batch_json_before(Request $request) { $uid = $request->item; $item_data = fetch_table_where('items','uid',$uid,true); $item_currency = $item_data['currency']; $item_currency_usd_equalance = (float)$item_data['currency_usd_equalance']; $active_branch_id = active_branch_id(); $warehouse = $request->warehouse; $batch_array = array(); $batch = std_obj_to_array(DB::table("batch_wise_stock")->where('item',$uid)->where('warehouse',$warehouse)->where("module",'!=','sales')->where("module",'!=','transfer_out')->where("module",'!=','damage')->where('status','passed')->get()); foreach($batch as $row) { $batch_array[$row['batch']] = $row['batch']; } $batch_array = array_unique($batch_array); $options_snippet = ''; foreach($batch_array as $ba) { $items_inventory = std_obj_to_array( DB::select("
                    SELECT 
                    sum(items_in) items_registration, 
                    sum(purchase_in) items_purchases,
                    sum(purchase_bonus_in) items_purchases_bonus,
                    sum(production_in) items_production_in,
                    sum(transfer_in) items_transfer_in,
                    sum(transfer_bonus_in) items_transfer_in_bonus,
                    sum(return_in) items_sales_return,
                    sum(return_bonus_in) items_sales_return_bonus,
                    sum(sales_out) items_sales,
                    sum(sales_bonus_out) items_sales_bonus,
                    sum(transfer_out) items_transfer_out,
                    sum(transfer_bonus_out) items_transfer_out_bonus,
                    sum(b_to_b_in) items_b_to_b_in,
                    sum(b_to_b_out) items_b_to_b_out,
                    sum(damage) items_damage
                    FROM item_inventory
                    where batch = '".$ba."' AND item = '".$uid."' AND warehouse = '".$warehouse."' AND status = 'passed'
                    ") ); $stock_ava = ($items_inventory[0]['items_registration'] + $items_inventory[0]['items_purchases'] + $items_inventory[0]['items_purchases_bonus'] + $items_inventory[0]['items_production_in'] + $items_inventory[0]['items_transfer_in'] + $items_inventory[0]['items_transfer_in_bonus'] + $items_inventory[0]['items_sales_return'] + $items_inventory[0]['items_sales_return_bonus'] + $items_inventory[0]['items_b_to_b_in']) - ($items_inventory[0]['items_sales'] + $items_inventory[0]['items_sales_bonus'] + $items_inventory[0]['items_transfer_out'] + $items_inventory[0]['items_transfer_out_bonus'] + $items_inventory[0]['items_damage'] + $items_inventory[0]['items_b_to_b_out']); $batch_data = std_obj_to_array(DB::table('batch_wise_items_stock')->where('branch',$active_branch_id)->where('item',$uid)->where('batch',$ba)->get()->first()); $sale_price = (float)$batch_data['tp']; $expiry_date = $batch_data['expiry']; $mfg_date = $batch_data['mfg']; $profit = (float)$batch_data['tp'] - (float)$batch_data['avg_cost'];; $option_show = $ba.'- ('.display_true_date($expiry_date).')'.'- (ava-'.$stock_ava.')'; $options_snippet .= '<option value="'.$ba.'" data-profit="'.$profit.'" data-ava-units="'.$stock_ava.'" data-sale-price="'.$sale_price.'" data-expiry="'.$expiry_date.'" data-mfg="'.$mfg_date.'">'.$option_show.'</option>'; } echo json_encode(array('status' => 'success', 'options_snippet' => $options_snippet)); } public function get_items_batch11(Request $request) { $uid = $request->item; $item_data = fetch_table_where('items','uid',$uid,true); $item_currency = $item_data['currency']; $item_currency_usd_equalance = (float)$item_data['currency_usd_equalance']; $active_branch_id = active_branch_id(); $warehouse = $request->warehouse; $batch_array = array(); $batch = std_obj_to_array(DB::table("batch_wise_stock")->where('item',$uid)->where('warehouse',$warehouse)->where("module",'!=','sales')->where("module",'!=','transfer_out')->where("module",'!=','damage')->where('status','passed')->get()); foreach($batch as $row) { $batch_array[$row['batch']] = $row['batch']; } $batch_array = array_unique($batch_array); $options_snippet = '<option value="">-- Batch --</option>'; foreach($batch_array as $ba) { $stock_in = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$uid)->where('warehouse',$warehouse)->where('batch',$ba)->where('status','passed')->sum('stock_in'); $bonus_in = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$uid)->where('warehouse',$warehouse)->where('batch',$ba)->where('status','passed')->sum('bonus_in'); $stock_out = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$uid)->where('warehouse',$warehouse)->where('batch',$ba)->where('status','passed')->sum('stock_out'); $bonus_out = DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$uid)->where('warehouse',$warehouse)->where('batch',$ba)->where('status','passed')->sum('bonus_out'); $stock_in_total = (float)$stock_in + (float)$bonus_in; $stock_out_total = (float)$stock_out + (float)$bonus_out; $stock_ava = $stock_in_total - $stock_out_total; $batch_profit_last = std_obj_to_array(DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$uid)->where('warehouse',$warehouse)->where('module','!=','sales')->where('status','passed')->where('module','!=','transfer_out')->where('module','!=','damage')->where('batch',$ba)->whereNotNull('profit')->get()->first()); $profit = (float)$batch_profit_last['profit']; $batch_sale_price_last = std_obj_to_array(DB::table('batch_wise_stock')->where('branch',$active_branch_id)->where('item',$uid)->where('warehouse',$warehouse)->where('module','!=','sales')->where('status','passed')->where('module','!=','transfer_out')->where('module','!=','damage')->where('batch',$ba)->whereNotNull('sale_price')->orderBy('module_created_at','desc')->orderBy('id','desc')->get()->first()); $sale_price = (float)$batch_sale_price_last['sale_price']; $batch_currency = $batch_sale_price_last['currency']; $batch_currency_equalance = (float)$batch_sale_price_last['currency_usd_equalance']; if($batch_sale_price_last['unit'] == 'purchase'){ $sale_price = $sale_price * (float)$item_data['purchase_unit_equalance']; } if($batch_sale_price_last['unit'] == 'sale'){ $sale_price = $sale_price * (float)$item_data['sale_unit_equalance']; } if($batch_sale_price_last['unit'] == 'production'){ $sale_price = $sale_price * (float)$item_data['production_unit_equalance']; } if($batch_currency == $item_currency) { $sale_price = $sale_price; } else { $sale_price = amount_conversion($sale_price, $batch_currency_equalance, $item_currency_usd_equalance); } $expiry = std_obj_to_array(DB::table("batch_wise_stock")->where('branch',$active_branch_id)->where('item',$uid)->where('batch',$ba)->where('module','!=','sales')->where('module','!=','transfer_out')->where('module','!=','damage')->where('status','passed')->whereNotNull('expiry_date')->orderBy('module_created_at','desc')->get()->first()); $mfg = std_obj_to_array(DB::table("batch_wise_stock")->where('branch',$active_branch_id)->where('item',$uid)->where('batch',$ba)->where('status','passed')->where('module','!=','sales')->where('module','!=','transfer_out')->where('module','!=','damage')->where('status','passed')->whereNotNull('mfg_date')->orderBy('module_created_at','desc')->get()->first()); if(empty($expiry['expiry_date'])){ $expiry_date = ''; }else{ $expiry_date = $expiry['expiry_date']; } if(empty($mfg['mfg_date'])){ $mfg_date = ''; }else{ $mfg_date = $mfg['mfg_date']; } $option_show = $ba.'- ('.display_true_date($expiry_date).')'.'- (ava-'.$stock_ava.')'; if($stock_ava > 0){ $options_snippet .= '<option value="'.$ba.'" data-profit="'.$profit.'" data-ava-units="'.$stock_ava.'" data-sale-price="'.$sale_price.'" data-expiry="'.$expiry_date.'" data-mfg="'.$mfg_date.'">'.$option_show.'</option>'; } } echo $options_snippet; } }