<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; use Hash; class Sales_man extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_sales_man') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $sales_man = DB::table('sales_man')->where('branch',$branch_id); if(!empty($request->currency)){ $sales_man->where('currency',$request->currency); } if(!empty($request->from)){ $sales_man->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $sales_man->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $sales_man = json_decode(json_encode($sales_man->get()),true); $this->data["pageData"] = $sales_man; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sales_man_view_title'); $this->data["pageToLoad"] = "sales_man/view.php"; $this->data["activeLink"] = "sales_man"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_sales_man') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'sales_man_add_title'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["pageToLoad"] = "sales_man/add.php"; $this->data["activeLink"] = "sales_man"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'account' => 'required', 'last_name' => 'required', 'mobile' => 'required|numeric', 'address' => 'required', 'cnic' => 'required', 'username' => 'required|min:3|unique:users', 'password' => 'required|min:3', ]); $validator->validate(); $uid = getUniqueId('SLSMN', 'sales_man', 'uid'); $uid_user = getUniqueId('USR', 'users', 'uid'); $active_branch_id = active_branch_id(); $hashed_password = Hash::make($request->password); $users_array = array( 'uid' => $uid_user, 'name' => $request->name." ".$request->last_name, 'phone' => $request->mobile, 'branch' => $active_branch_id, 'username' => $request->username, 'password' => $hashed_password, 'role' => 'USER', 'sales_man' => $uid, 'is_sales_man' => 'yes', 'rights' => '[]', ); $user_insert = insert_table('users',$users_array); $db_array = array( 'uid' => $uid, 'branch' => $active_branch_id, 'name' => $request->name, 'last_name' => $request->last_name, 'mobile' => $request->mobile, 'address' => $request->address, 'cnic' => $request->cnic, 'username' => $request->username, 'password' => $request->password, 'account' => $request->account, ); insert_table('sales_man',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'marketers_service_added'), 'message_body' => print_lang($this->data["app_lang"],'marketers_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_sales_man') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('sales_man','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/sales_man')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'sales_man_edit_title'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["pageToLoad"] = "sales_man/edit.php"; $this->data["activeLink"] = "sales_man"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'account' => 'required', 'last_name' => 'required', 'username' => ['required','min:3',Rule::unique('users')->ignore($uid, 'sales_man')], 'mobile' => 'required|numeric', 'address' => 'required', 'cnic' => 'required', ]); $validator->sometimes('update_password','min:3',function($input){ return !empty($input->update_password); } ); $validator->validate(); $active_branch_id = active_branch_id(); $users_array = array( 'name' => $request->name." ".$request->last_name, 'phone' => $request->mobile, 'username' => $request->username, ); if(!empty($request->update_password)){ $users_array['password'] = Hash::make($request->update_password); } update_table('users','sales_man',$uid,$users_array); $db_array = array( 'name' => $request->name, 'last_name' => $request->last_name, 'mobile' => $request->mobile, 'address' => $request->address, 'cnic' => $request->cnic, 'username' => $request->username, 'account' => $request->account, ); if(!empty($request->update_password)){ $db_array['password'] = Hash::make($request->update_password); } update_table('sales_man','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'marketers_update'), 'message_body' => print_lang($this->data["app_lang"],'marketers_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_sales_man') === FALSE){ Redirect::to('/')->send(); } delete_table('sales_man','uid',$uid); delete_table('users','sales_man',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function report(Request $request, $uid) { if(check_user_access('view_report_sales_man') === FALSE){ Redirect::to('/')->send(); } $from = '1970-01-01'; $to = date("Y-m-d"); if(empty($request->currency)){$request->currency = 'usd';} if(!empty($request->from)){$from = get_true_date($request->from);} if(!empty($request->to)){$to = get_true_date($request->to);} $currency = $request->currency; $query = std_obj_to_array(DB::select( "SELECT 
            a.name as 'sales_name', 
            a.uid AS 'sales_uid',
            b.name,
            b.mobile,
            b.uid AS 'client_uid',
            c.currency AS 'currency',
            SUM(c.sales_total) AS 'sales',
            SUM(c.cash_received) AS 'received',
            SUM(c.remaining_amount) AS 'remaining'
            FROM sales_man AS a
            LEFT JOIN accounts AS b
            ON a.uid = b.sales_man
            LEFT JOIN sales AS c
            ON c.client = b.uid
            WHERE a.uid = '".$uid."' 
            AND c.currency = '".$currency."' 
            AND c.created_at BETWEEN '".$from."' AND '".$to."' 
            GROUP BY b.uid" )); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $currency_symbol = $currency_data['symbol']; $this->data["uid"] = $uid; $this->data["pageData"] = $query; $this->data["currency_symbol"] = $currency_symbol; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sales_man_rep_view_title'); $this->data["pageToLoad"] = "sales_man/report.php"; $this->data["activeLink"] = "sales_man"; $this->load_view($this->data); } public function sales(Request $request, $uid) { if(check_user_access('sales_report_sales_man') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $sales = DB::table('sales')->where('branch',$branch_id)->where('sales_man',$uid); if(!empty($request->currency)){ $sales->where('currency',$request->currency); } if(!empty($request->client)){ $sales->where('client',$request->client); } if(!empty($request->from)){ $sales->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $sales->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $sales = json_decode(json_encode($sales->get()),true); $clients = std_obj_to_array(DB::table('accounts')->where('sales_man',$uid)->get()); $this->data["uid"] = $uid; $this->data["pageData"] = $sales; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys($clients,'uid'); $this->data["search_convert_currency"] = $request->convert_currency; $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sales_man_sales_view_title'); $this->data["pageToLoad"] = "sales_man/sales.php"; $this->data["activeLink"] = "sales_man"; $this->load_view($this->data); } }