<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; class Sales_return extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { $item_settings = get_item_settings(); if(check_user_access('view_sales_return') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $sales_return = DB::table('sales_return')->where('branch',$branch_id); if(!empty($request->currency)){ $sales_return->where('currency',$request->currency); } if(!empty($request->client)){ $sales_return->where('client',$request->client); } if(!empty($request->marketer)){ $sales_return->where('marketer',$request->marketer); } if(!empty($request->from)){ $sales_return->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $sales_return->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $sales_return = json_decode(json_encode($sales_return->get()),true); $this->data["pageData"] = $sales_return; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_convert_currency"] = $request->convert_currency; $this->data["search_client"] = $request->client; $this->data["search_marketer"] = $request->marketer; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'sales_return_view_title'); $this->data["pageToLoad"] = "sales_return/view.php"; $this->data["activeLink"] = "sales_return"; $this->load_view($this->data); } public function invoice(Request $request, $uid) { $item_settings = get_item_settings(); if(is_customer_user() === false){ if(check_user_access('invoice_sales_return') === FALSE){ Redirect::to('/')->send(); } } $this->data["invoice_data"] = fetch_table_where('sales_return','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'sales_invoice'); $item_settings = get_item_settings(); $this->data["pageToLoad"] = "sales_return/sales_new.php"; $this->data["activeLink"] = "sales"; $this->load_view($this->data); } public function add(Request $request) { $item_settings = get_item_settings(); if(check_user_access('add_sales_return') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $invoices = array(); if(!empty($request->client)) { $invoices = std_obj_to_array(DB::table('sales')->where('branch',$branch_id)->where('client',$request->client)->select('invoice')->distinct()->get()); } $editing_data = std_obj_to_array(DB::table('sales')->where('branch',$branch_id)->where('invoice',$request->invoice)->get()->first()); $old_qty_calculations = array(); if(!empty($request->invoice)) { $sale_id = $editing_data['uid']; $sales_old_returns = fetch_table_where('sales_return','sale_id',$sale_id); if(!empty($sales_old_returns)) { foreach($sales_old_returns as $_sales_return) { if(!empty($_sales_return['items_details'])) { $items_details = json_decode($_sales_return['items_details'],true); foreach($items_details as $_sitem) { if(!array_key_exists($_sitem['item_uqid'],$old_qty_calculations)){ $old_qty_calculations[$_sitem['item_uqid']] = array(); } $old_qty_calculations[$_sitem['item_uqid']]['r_qty'][] = isset($_sitem['r_qty']) ? (float)$_sitem['r_qty'] : 0; $old_qty_calculations[$_sitem['item_uqid']]['r_bonus'][] = isset($_sitem['r_bonus']) ? (float)$_sitem['r_bonus'] : 0; } } } } } $this->data["old_qty_calculations"] = $old_qty_calculations; $this->data["editing_data"] = $editing_data; $this->data["invoices"] = $invoices; $this->data["invoices_return"] = array(); $this->data["search_client"] = $request->client; $this->data["search_invoice"] = $request->invoice; $this->data["is_marketer"] = get_active_marketer(); $this->data["invoice_number"] = get_sale_invoice_number(); $this->data["currencies"] = fetch_currencies(); $this->data["batch"] = fetch_table_branch('batch'); $this->data["marketers"] = fetch_table_branch('marketers'); $this->data["sales_man"] = fetch_table_branch('sales_man'); $this->data["items"] = fetch_table_branch('items'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["clients"] = fetch_all_clients(); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["expenses"] = fetch_table_where_branch('accounts','type','expense'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'sales_return_add_title'); $this->data["pageToLoad"] = "sales_return/add.php"; $this->data["activeLink"] = "sales_return"; $this->load_view($this->data); } public function save(Request $request) { $items_details = array(); $_items_effected = array(); $items = array(); $warehouse = array(); $batch = array(); $sic = 0; $discount_1_amount_return = array(); $discount_2_amount_return = array(); $profit_return = array(); $discount1 = 0; $discount2 = 0; $return_profit = 0; $invoice_num = (int)$request->invoice[0]; while($sic < count($request->item)) { if(empty($request->item[$sic])){ $sic++; continue; } $discount1 = ((float)$request->sale_price[$sic] * (float)$request->discount[$sic]) / 100; $discount2 = (((float)$request->sale_price[$sic] - $discount1) * (float)$request->discount_2[$sic]) / 100; $return_profit = (float)$request->profit[$sic] * (float)$request->return_qty[$sic]; $discount_1_amount_return[] = $discount1 * (float)$request->return_qty[$sic]; $discount_2_amount_return[] = $discount2 * (float)$request->return_qty[$sic]; $profit_return[] = $return_profit; $items_details[] = array( 'agent' => $request->agent[$sic], 'plate' => $request->plate[$sic], 'item' => $request->item[$sic], 'item_uqid' => $request->item_uqid[$sic], 'warehouse' => $request->warehouse[$sic], 'batch' => $request->batch[$sic], 'narration' => $request->narration[$sic], 'cost' => (float)$request->cost[$sic], 'sale_price' => (float)$request->sale_price[$sic], 'qty' => (float)$request->qty[$sic], 'r_qty' => (float)$request->return_qty[$sic], 'bonus' => (float)$request->bonus[$sic], 'r_bonus' => (float)$request->return_qty_bns[$sic], 'm2' => (float)$request->m2[$sic], 'width' => (float)$request->width[$sic], 'height' => (float)$request->height[$sic], 'unit' => $request->unit[$sic], 'discount' => (float)$request->discount[$sic], 'discount_2' => (float)$request->discount_2[$sic], 'profit' => (float)$request->profit[$sic], 'item_total' => (float)$request->item_total[$sic], 'r_item_total' => (float)$request->return_row_amount[$sic], ); $_items_effected[] = $request->item[$sic]; $items[] = '-++-'.$request->item[$sic].'-++-'; $warehouse[] = '-++-'.$request->warehouse[$sic].'-++-'; $batch[] = '-++-'.$request->batch[$sic].'-++-'; $sic++; } $commission_type = null; $marketer_commission = null; $uid = getUniqueId('SALERT', 'sales_return', 'uid'); $client_old_balance = get_account_balance($request->client[0],$request->currency[0]); $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); $marketer_db_data = fetch_table_where('marketers','uid',$request->marketer[0],true); if(!empty($marketer_db_data)) { $commission_type = $marketer_db_data['commission_type']; $marketer_commission = (float)$marketer_db_data['commission']; } if(!empty($request->cash_client_name)) { $cash_client_name = $request->cash_client_name[0]; } else { $cash_client_name = ''; } if(!empty($request->cash_client_mobile)) { $cash_client_mobile = $request->cash_client_mobile[0]; } else { $cash_client_mobile = ''; } $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'serial_id' => get_serial_id('sales_return'), 'quotation' => $request->quotation_id, 'sale_id' => $request->sale_id, 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->client[0], 'marketer' => $request->marketer[0], 'sales_man' => $request->sales_man[0], 'commission_type' => $commission_type, 'marketer_commission' => $marketer_commission, 'cash_client_name' => $cash_client_name, 'cash_client_mobile' => $cash_client_mobile, 'old_balance' => $client_old_balance, 'invoice' => $invoice_num, 'return_invoice' => get_sales_refund_number(), 'memo' => $request->memo[0], 'return_memo' => $request->return_memo, 'sales_total' => (float)$request->sales_total, 'trans_expense' => (float)$request->trans_expense, 'expense_account' => $request->expense_account, 'sub_total' => (float)$request->sub_total, 'cash_received' => (float)$request->cash_received, 'remaining_amount' => (float)$request->remaining_amount, 'items_details' => json_encode($items_details), 'sale_items' => implode(',', $items), 'sale_warehouse' => implode(',', $warehouse), 'sale_batch' => implode(',', $batch), 'total_sales_amount' => (float)$request->total_sales_amount, 'total_discount_amount' => (float)$request->total_discount_amount, 'total_discount_amount_1' => (float)$request->total_discount_amount_1, 'total_discount_amount_2' => (float)$request->total_discount_amount_2, 'gross_total_amount' => (float)$request->gross_total_amount, 'total_profit_amount' => (float)$request->total_profit_amount, 'cash_received_account' => $request->cash_received_account, 'refund_total' => (float)$request->sales_total_return, 'refund_received' => (float)$request->cash_received_return, 'refund_pending' => (float)$request->sales_total_return - (float)$request->cash_received_return, 'refund_account' => $request->cash_received_account_refund, 'return_discount_amount_1' => array_sum($discount_1_amount_return), 'return_discount_amount_2' => array_sum($discount_2_amount_return), 'total_return_discount' => array_sum($discount_1_amount_return) + array_sum($discount_2_amount_return), 'return_profit' => array_sum($profit_return), ); insert_table('sales_return',$db_array); _handle_sales_return_ledger_effects(['uid' => $uid, 'state' => 'new']); _calculate_sales_after_return_amounts($request->sale_id); _handle_items_inventory_stats_from_sales_return(['uid' => $uid, 'entry_status' => 'new']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_sales_return'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/sales-return/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['refund_total']), ); set_activity_alert($_activity_details); $invoice_url = url('/sales-return/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'sales_return_added'), 'message_body' => print_lang($this->data["app_lang"],'sales_return_save_successfully'))); } public function edit(Request $request, $uid) { $item_settings = get_item_settings(); if(check_user_access('edit_sales_return') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $this->data["editing_data"] = fetch_table_where('sales_return','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/sales-return')->send(); } $invoices = std_obj_to_array(DB::table('sales')->where('branch',$branch_id)->where('client',$this->data["editing_data"]['client'])->select('invoice')->distinct()->get()); $this->data["invoices"] = $invoices; $this->data["currencies"] = fetch_currencies(); $this->data["batch"] = set_array_keys(fetch_table_branch('batch'),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["sales_man"] = set_array_keys(fetch_table_branch('sales_man'),'uid'); $this->data["items"] = fetch_table_branch('items'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["expenses"] = fetch_table_where_branch('accounts','type','expense'); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_sale'); $this->data["pageToLoad"] = "sales_return/edit.php"; $this->data["activeLink"] = "sales_return"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_details = array(); $_items_effected = array(); $items = array(); $warehouse = array(); $batch = array(); $sic = 0; $commission_type = NULL; $marketer_commission = NULL; $discount_1_amount_return = array(); $discount_2_amount_return = array(); $profit_return = array(); $discount1 = 0; $discount2 = 0; $return_profit = 0; while($sic < count($request->item)) { if(empty($request->item[$sic])){ $sic++; continue; } $discount1 = ((float)$request->sale_price[$sic] * (float)$request->discount[$sic]) / 100; $discount2 = (((float)$request->sale_price[$sic] - $discount1) * (float)$request->discount_2[$sic]) / 100; $return_profit = (float)$request->profit[$sic] * (float)$request->return_qty[$sic]; $discount_1_amount_return[] = $discount1 * (float)$request->return_qty[$sic]; $discount_2_amount_return[] = $discount2 * (float)$request->return_qty[$sic]; $profit_return[] = $return_profit; $items_details[] = array( 'agent' => $request->agent[$sic], 'plate' => $request->plate[$sic], 'item' => $request->item[$sic], 'item_uqid' => $request->item_uqid[$sic], 'warehouse' => $request->warehouse[$sic], 'batch' => $request->batch[$sic], 'narration' => $request->narration[$sic], 'cost' => (float)$request->cost[$sic], 'sale_price' => (float)$request->sale_price[$sic], 'qty' => (float)$request->qty[$sic], 'r_qty' => (float)$request->return_qty[$sic], 'bonus' => (float)$request->bonus[$sic], 'r_bonus' => (float)$request->return_qty_bns[$sic], 'm2' => (float)$request->m2[$sic], 'width' => (float)$request->width[$sic], 'height' => (float)$request->height[$sic], 'unit' => $request->unit[$sic], 'discount' => (float)$request->discount[$sic], 'discount_2' => (float)$request->discount_2[$sic], 'profit' => (float)$request->profit[$sic], 'item_total' => (float)$request->item_total[$sic], 'r_item_total' => (float)$request->return_row_amount[$sic], ); $_items_effected[] = $request->item[$sic]; $items[] = '-++-'.$request->item[$sic].'-++-'; $warehouse[] = '-++-'.$request->warehouse[$sic].'-++-'; $batch[] = '-++-'.$request->batch[$sic].'-++-'; $sic++; } if(!empty($request->cash_client_name)) { $cash_client_name = $request->cash_client_name[0]; } else { $cash_client_name = ''; } if(!empty($request->cash_client_mobile)) { $cash_client_mobile = $request->cash_client_mobile[0]; } else { $cash_client_mobile = ''; } $last_return = fetch_table_where('sales_return','uid',$uid,true); $last_created_at = $last_return['created_at']; $last_time = date("H:i:s",strtotime($last_created_at)); $created_at = get_true_date( empty($last_created_at) ? date('y-m-d') : $last_created_at ); $created_at = $created_at." ".$last_time; $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); if($request->marketer[0] == $last_return['marketer']) { $commission_type = $last_return['commission_type']; $marketer_commission = (float)$last_return['marketer_commission']; } else { $marketer_db_data = fetch_table_where('marketers','uid',$request->marketer[0],true); if(!empty($marketer_db_data)) { $commission_type = $marketer_db_data['commission_type']; $marketer_commission = (float)$marketer_db_data['commission']; } } $db_array = array( 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->client[0], 'marketer' => $request->marketer[0], 'sales_man' => $request->sales_man[0], 'commission_type' => $commission_type, 'marketer_commission' => $marketer_commission, 'cash_client_name' => $cash_client_name, 'cash_client_mobile' => $cash_client_mobile, 'invoice' => (int)$request->invoice[0], 'memo' => $request->memo[0], 'return_memo' => $request->return_memo, 'sales_total' => (float)$request->sales_total, 'trans_expense' => (float)$request->trans_expense, 'expense_account' => $request->expense_account, 'sub_total' => (float)$request->sub_total, 'cash_received' => (float)$request->cash_received, 'remaining_amount' => (float)$request->remaining_amount, 'items_details' => json_encode($items_details), 'sale_items' => implode(',', $items), 'sale_warehouse' => implode(',', $warehouse), 'sale_batch' => implode(',', $batch), 'total_sales_amount' => (float)$request->total_sales_amount, 'total_discount_amount' => (float)$request->total_discount_amount, 'total_discount_amount_1' => (float)$request->total_discount_amount_1, 'total_discount_amount_2' => (float)$request->total_discount_amount_2, 'gross_total_amount' => (float)$request->gross_total_amount, 'total_profit_amount' => (float)$request->total_profit_amount, 'cash_received_account' => $request->cash_received_account, 'refund_total' => (float)$request->sales_total_return, 'refund_received' => (float)$request->cash_received_return, 'refund_pending' => (float)$request->sales_total_return - (float)$request->cash_received_return, 'refund_account' => $request->cash_received_account_refund, 'return_discount_amount_1' => array_sum($discount_1_amount_return), 'return_discount_amount_2' => array_sum($discount_2_amount_return), 'total_return_discount' => array_sum($discount_1_amount_return) + array_sum($discount_2_amount_return), 'return_profit' => array_sum($profit_return), 'created_at' => $created_at, ); $data_before_update = fetch_table_where('sales_return','uid',$uid,true); update_table('sales_return','uid',$uid,$db_array); _handle_sales_return_ledger_effects(['uid' => $uid, 'state' => 'update']); _calculate_sales_after_return_amounts($last_return['sale_id']); _handle_items_inventory_stats_from_sales_return(['uid' => $uid, 'entry_status' => 'update']); $sale_items_before_update = empty($data_before_update['items_details']) ? array() : json_decode($data_before_update['items_details'],true); if(!empty($sale_items_before_update)) { foreach($sale_items_before_update as $old_item) { if(!empty($old_item['item'])) { _calculate_item_wise_stats(['item' => $old_item['item']]); } } } $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_sales_return'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/sales-return/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['refund_total']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'sales_return_update'), 'message_body' => print_lang($this->data["app_lang"],'sales_return_update_successfully'))); } public function delete($uid) { $item_settings = get_item_settings(); if(check_user_access('delete_sales_return') === FALSE){ Redirect::to('/')->send(); } $sale_data = fetch_table_where('sales_return','uid',$uid,true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_sales_return'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$sale_data['return_invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($sale_data['refund_total']), ); set_activity_alert($_activity_details); delete_table('sales_return','uid',$uid); _handle_sales_return_ledger_effects(['uid' => $uid, 'state' => 'delete']); _calculate_sales_after_return_amounts($sale_data['sale_id']); _handle_items_inventory_stats_from_sales_return(['uid' => $uid, 'entry_status' => 'delete']); $sale_items_before_update = empty($sale_data['items_details']) ? array() : json_decode($sale_data['items_details'],true); if(!empty($sale_items_before_update)) { foreach($sale_items_before_update as $old_item) { if(!empty($old_item['item'])) { _calculate_item_wise_stats(['item' => $old_item['item']]); } } } echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function get_client_invoices(Request $request) { $client = $request->client; $invoices = std_obj_to_array(DB::table('sales')->where('client',$client)->select('invoice')->distinct()->get()); $options = '<option value="">--Select Invoice--</option>'; if(!empty($invoices)) { foreach($invoices as $key => $invoice) { $options .= '<option value="'.$invoice['invoice'].'">'.$invoice['invoice'].'</option>'; } } echo $options; } }