<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; class Services extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_services_sales_rights') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $services = DB::table('services')->where('branch',$branch_id); if(!empty($request->currency)){ $services->where('currency',$request->currency); } if(!empty($request->client)){ $services->where('client',$request->client); } if(!empty($request->marketer)){ $services->where('marketer',$request->marketer); } if(!empty($request->from)){ $services->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $services->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $services = json_decode(json_encode($services->get()),true); $this->data["pageData"] = $services; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(std_obj_to_array(DB::table('accounts')->where('type','client')->where(function($query) use ($branch_id){ $query->where('shared','yes')->orWhere('branch',$branch_id); })->get()),'uid'); $this->data["marketers"] = set_array_keys(fetch_table_branch('marketers'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_convert_currency"] = $request->convert_currency; $this->data["search_client"] = $request->client; $this->data["search_marketer"] = $request->marketer; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'services_mod_breadcrumb_title'); $this->data["pageToLoad"] = "services/view.php"; $this->data["activeLink"] = "services"; $this->load_view($this->data); } public function invoice(Request $request, $uid) { if(check_user_access('invoice_services_sales_rights') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $this->data["invoice_data"] = fetch_table_where('services','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(std_obj_to_array(DB::table('accounts')->where('type','client')->where(function($query) use ($branch_id){ $query->where('shared','yes')->orWhere('branch',$branch_id); })->get()),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'services_mod_invoice_title'); $this->data["pageToLoad"] = "services/invoice.php"; $this->data["activeLink"] = "services"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_services_sales_rights') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $quotation_uid = $request->quotation; if(empty($quotation_uid)) { $quotation_data = array( 'uid' => NULL, 'currency' => NULL, 'client' => NULL, 'invoice' => NULL, 'memo' => NULL, 'details' => json_encode(array()), 'total' => NULL, 'discount' => NULL, 'gross_total' => NULL, 'type' => NULL, ); } else { $quotation_data = DB::table('services_quotation')->where('uid',$quotation_uid)->get(); if($quotation_data->count() > 0) { $quotation_data = json_decode(json_encode($quotation_data[0]),true); } else { $quotation_data = array( 'uid' => NULL, 'currency' => NULL, 'client' => NULL, 'invoice' => NULL, 'memo' => NULL, 'details' => json_encode(array()), 'total' => NULL, 'discount' => NULL, 'gross_total' => NULL, 'type' => NULL, ); } } $this->data["quotation_data"] = $quotation_data; $this->data["marketers"] = fetch_table_branch('marketers'); $this->data["invoice_number"] = get_services_invoice_number(); $this->data["is_marketer"] = get_active_marketer(); $this->data["currencies"] = fetch_currencies(); $this->data["services_cat"] = fetch_table_branch('services_cat'); $this->data["clients"] = set_array_keys(std_obj_to_array(DB::table('accounts')->where('type','client')->where(function($query) use ($branch_id){ $query->where('shared','yes')->orWhere('branch',$branch_id); })->get()),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'services_mod_new_breadcrumb_title'); $this->data["pageToLoad"] = "services/add.php"; $this->data["activeLink"] = "services"; $this->load_view($this->data); } public function save(Request $request) { $items_details = array(); $items_ids = array(); $sic = 0; $invoice_num = (int)$request->invoice[0]; $invoice_num_exist = DB::table('services')->where('invoice',$invoice_num)->get(); if($invoice_num_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => 'Invoice Exist', 'message_body' => 'This invoice number already exist.')); die; } while($sic < count($request->title)) { if(empty($request->title[$sic])){ $sic++; continue; } $items_details[] = array( 'title' => $request->title[$sic], 'title_id' => $request->title_id[$sic], 'unit' => $request->unit[$sic], 'qty' => $request->qty[$sic], 'rate' => $request->rate[$sic], 'discount' => $request->discount[$sic], 'total' => $request->total[$sic], ); $items_ids[] = '-++-'.$request->title_id[$sic].'-++-'; $sic++; } $uid = getUniqueId('SERVICES', 'services', 'uid'); $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); $marketer_db_data = fetch_table_where('marketers','uid',$request->marketer[0],true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'quotation_id' => $request->quotation_id, 'service_date' => $request->sdate[0], 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->client[0], 'marketer' => $request->marketer[0], 'commission_type' => isset($marketer_db_data['commission_type']) ? $marketer_db_data['commission_type'] : null , 'marketer_commission' => isset($marketer_db_data['commission']) ? (float)$marketer_db_data['commission'] : 0, 'invoice' => $invoice_num, 'memo' => $request->memo[0], 'details' => json_encode($items_details), 'total' => (float)$request->totals, 'discount' => (float)$request->discounts, 'gross_total' => (float)$request->gross_totals, 'cash_paid_account' => $request->cash_received_account, 'cash_paid' => (float)$request->cash_received, 'pending_amount' => (float)$request->remaining_amount, 'service_ids' => implode(',', $items_ids), 'type' => $request->type[0], ); insert_table('services',$db_array); _handle_services_ledger_effects(['uid' => $uid, 'state' => 'new']); if(!empty($request->quotation_id)) { $qdb_array = array('converted' => 'yes', 'service_id' => $uid); update_table('services_quotation','uid',$request->quotation_id,$qdb_array); } $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_services'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/services/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['gross_total']), ); set_activity_alert($_activity_details); $invoice_url = url('/services/invoice').'/'.$uid; $invoice_number = get_services_invoice_number(); echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_number' => $invoice_number, 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'services_mod_service_added'), 'message_body' => print_lang($this->data["app_lang"],'services_mod_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_services_sales_rights') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $this->data["editing_data"] = fetch_table_where('services','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/services')->send(); } $this->data["marketers"] = fetch_table_branch('marketers'); $this->data["currencies"] = fetch_currencies(); $this->data["services_cat"] = fetch_table_branch('services_cat'); $this->data["clients"] = set_array_keys(std_obj_to_array(DB::table('accounts')->where('type','client')->where(function($query) use ($branch_id){ $query->where('shared','yes')->orWhere('branch',$branch_id); })->get()),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'services_mod_edit_breadcrumb_title'); $this->data["pageToLoad"] = "services/edit.php"; $this->data["activeLink"] = "services"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_details = array(); $items_ids = array(); $sic = 0; $commission_type = NULL; $marketer_commission = NULL; while($sic < count($request->title)) { if(empty($request->title[$sic])){ $sic++; continue; } $items_details[] = array( 'title' => $request->title[$sic], 'title_id' => $request->title_id[$sic], 'unit' => $request->unit[$sic], 'qty' => $request->qty[$sic], 'rate' => $request->rate[$sic], 'discount' => $request->discount[$sic], 'total' => $request->total[$sic], ); $items_ids[] = '-++-'.$request->title_id[$sic].'-++-'; $sic++; } $last_service = fetch_table_where('services','uid',$uid,true); $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); if($request->marketer[0] == $last_service['marketer']) { $commission_type = $last_service['commission_type']; $marketer_commission = (float)$last_service['marketer_commission']; } else { $marketer_db_data = fetch_table_where('marketers','uid',$request->marketer[0],true); if(!empty($marketer_db_data)) { $commission_type = isset($marketer_db_data['commission_type']) ? $marketer_db_data['commission_type'] : null ; $marketer_commission = isset($marketer_db_data['commission']) ? (float)$marketer_db_data['commission'] : 0; } } $db_array = array( 'service_date' => $request->sdate[0], 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->client[0], 'marketer' => $request->marketer[0], 'commission_type' => $commission_type, 'marketer_commission' => $marketer_commission, 'memo' => $request->memo[0], 'details' => json_encode($items_details), 'total' => (float)$request->totals, 'discount' => (float)$request->discounts, 'gross_total' => (float)$request->gross_totals, 'cash_paid_account' => $request->cash_received_account, 'cash_paid' => (float)$request->cash_received, 'pending_amount' => (float)$request->remaining_amount, 'service_ids' => implode(',', $items_ids), 'type' => $request->type[0], ); update_table('services','uid',$uid,$db_array); _handle_services_ledger_effects(['uid' => $uid, 'state' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_services'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/services/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$request['invoice'][0].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['gross_total']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'services_mod_update'), 'message_body' => print_lang($this->data["app_lang"],'services_mod_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_services_sales_rights') === FALSE){ Redirect::to('/')->send(); } $sale_data = fetch_table_where('services','uid',$uid,true); if(!empty($sale_data['quotation_id'])) { $qdb_array = array('converted' => 'no', 'service_id' => NULL); update_table('services_quotation','uid',$sale_data['quotation_id'],$qdb_array); } $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_services'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$sale_data['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($sale_data['gross_total']), ); set_activity_alert($_activity_details); delete_table('services','uid',$uid); _handle_services_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }