<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; class Services_cat extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_services_right') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $services = DB::table('services_cat')->where('branch',$branch_id); if(!empty($request->currency)){ $services->where('currency',$request->currency); } if(!empty($request->from)){ $services->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $services->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $services = json_decode(json_encode($services->get()),true); $this->data["pageData"] = $services; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'services_cat_view_breadcrumb'); $this->data["pageToLoad"] = "services_cat/view.php"; $this->data["activeLink"] = "services"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_services_right') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["title"] = print_lang($this->data["app_lang"],'services_cat_add_title'); $this->data["pageToLoad"] = "services_cat/add.php"; $this->data["activeLink"] = "services"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'unit' => 'required', 'currency' => 'required', 'rate' => 'required', ]); $validator->validate(); $uid = getUniqueId('SERVICESCAT', 'services_cat', 'uid'); $currency_db_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $request->currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'name' => $request->name, 'unit' => $request->unit, 'rate' => (float)$request->rate, ); insert_table('services_cat',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'services_cat_service_added'), 'message_body' => print_lang($this->data["app_lang"],'services_cat_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_services_right') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('services_cat','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/services-cat')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["title"] = print_lang($this->data["app_lang"],'services_cat_edit_title'); $this->data["pageToLoad"] = "services_cat/edit.php"; $this->data["activeLink"] = "services"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'unit' => 'required', 'currency' => 'required', 'rate' => 'required', ]); $validator->validate(); $currency_db_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'currency' => $request->currency, 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'name' => $request->name, 'unit' => $request->unit, 'rate' => (float)$request->rate, ); update_table('services_cat','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'services_cat_update'), 'message_body' => print_lang($this->data["app_lang"],'services_cat_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_services_right') === FALSE){ Redirect::to('/')->send(); } delete_table('services_cat','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }