<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; class Services_quotation extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_services_quotation_rights') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $services = DB::table('services_quotation')->where('branch',$branch_id)->where("converted","no"); if(!empty($request->currency)){ $services->where('currency',$request->currency); } if(!empty($request->client)){ $services->where('client',$request->client); } if(!empty($request->from)){ $services->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $services->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $services = json_decode(json_encode($services->get()),true); $this->data["pageData"] = $services; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'services_qut_mod_breadcrumb_title'); $this->data["pageToLoad"] = "services_quotation/view.php"; $this->data["activeLink"] = "services_quotation"; $this->load_view($this->data); } public function view_converted(Request $request) { if(check_user_access('converted_services_quotation_rights') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $services = DB::table('services_quotation')->where('branch',$branch_id)->where("converted","yes"); if(!empty($request->currency)){ $services->where('currency',$request->currency); } if(!empty($request->client)){ $services->where('client',$request->client); } if(!empty($request->from)){ $services->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $services->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $services = json_decode(json_encode($services->get()),true); $this->data["pageData"] = $services; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'services_qut_mod_breadcrumb_title'); $this->data["pageToLoad"] = "services_quotation/view_converted.php"; $this->data["activeLink"] = "services_quotation_converted"; $this->load_view($this->data); } public function invoice(Request $request, $uid) { if(check_user_access('invoice_services_quotation_rights') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('services_quotation','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'services_qut_mod_invoice_title'); $this->data["pageToLoad"] = "services_quotation/invoice.php"; $this->data["activeLink"] = "services_quotation"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_services_quotation_rights') === FALSE){ Redirect::to('/')->send(); } $quotation_uid = $request->quotation; if(empty($quotation_uid)) { $quotation_data = array( 'uid' => NULL, 'currency' => NULL, 'client' => NULL, 'invoice' => NULL, 'memo' => NULL, 'items_details' => json_encode(array()), 'total_sales_amount' => NULL, 'total_discount_amount' => NULL, 'gross_total_amount' => NULL, 'total_profit_amount' => NULL, 'cash_client_name' => NULL, 'cash_client_mobile' => NULL, ); } else { $quotation_data = DB::table('quotations')->where('uid',$quotation_uid)->get(); if($quotation_data->count() > 0) { $quotation_data = json_decode(json_encode($quotation_data[0]),true); } else { $quotation_data = array( 'uid' => NULL, 'currency' => NULL, 'client' => NULL, 'invoice' => NULL, 'memo' => NULL, 'items_details' => json_encode(array()), 'total_sales_amount' => NULL, 'total_discount_amount' => NULL, 'gross_total_amount' => NULL, 'total_profit_amount' => NULL, 'cash_client_name' => NULL, 'cash_client_mobile' => NULL, ); } } $this->data["quotation_data"] = $quotation_data; $this->data["invoice_number"] = get_services_quotation_invoice_number(); $this->data["services_cat"] = fetch_table_branch('services_cat'); $this->data["currencies"] = fetch_currencies(); $this->data["clients"] = fetch_table_where_branch('accounts','type','client'); $this->data["expenses"] = fetch_table_where_branch('accounts','type','expense'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'services_qut_mod_new_breadcrumb_title'); $this->data["pageToLoad"] = "services_quotation/add.php"; $this->data["activeLink"] = "services_quotation"; $this->load_view($this->data); } public function save(Request $request) { $items_details = array(); $items_ids = array(); $sic = 0; $invoice_num = (int)$request->invoice[0]; $invoice_num_exist = DB::table('services_quotation')->where('invoice',$invoice_num)->get(); if($invoice_num_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => 'Invoice Exist', 'message_body' => 'This invoice number already exist.')); die; } while($sic < count($request->title)) { if(empty($request->title[$sic])){ $sic++; continue; } $items_details[] = array( 'title' => $request->title[$sic], 'title_id' => $request->title_id[$sic], 'unit' => $request->unit[$sic], 'qty' => $request->qty[$sic], 'rate' => $request->rate[$sic], 'discount' => $request->discount[$sic], 'total' => $request->total[$sic], ); $items_ids[] = '-++-'.$request->title_id[$sic].'-++-'; $sic++; } $uid = getUniqueId('SERVICESQUT', 'services', 'uid'); $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'service_date' => $request->sdate[0], 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->client[0], 'invoice' => $invoice_num, 'memo' => $request->memo[0], 'details' => json_encode($items_details), 'total' => (float)$request->totals, 'discount' => (float)$request->discounts, 'gross_total' => (float)$request->gross_totals, 'service_ids' => implode(',', $items_ids), 'type' => $request->type[0], ); insert_table('services_quotation',$db_array); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_services_quotation'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/services-quotation/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['gross_total']), ); set_activity_alert($_activity_details); $invoice_url = url('/services_quotation/invoice').'/'.$uid; $invoice_number = get_services_quotation_invoice_number(); echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_number' => $invoice_number, 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'services_mod_service_added'), 'message_body' => print_lang($this->data["app_lang"],'services_mod_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_services_quotation_rights') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('services_quotation','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/services-quotation')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["services_cat"] = fetch_table_branch('services_cat'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["expenses"] = fetch_table_where_branch('accounts','type','expense'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'services_mod_edit_breadcrumb_title'); $this->data["pageToLoad"] = "services_quotation/edit.php"; $this->data["activeLink"] = "services_quotation"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_details = array(); $items_ids = array(); $sic = 0; while($sic < count($request->title)) { if(empty($request->title[$sic])){ $sic++; continue; } $items_details[] = array( 'title' => $request->title[$sic], 'title_id' => $request->title_id[$sic], 'unit' => $request->unit[$sic], 'qty' => $request->qty[$sic], 'rate' => $request->rate[$sic], 'discount' => $request->discount[$sic], 'total' => $request->total[$sic], ); $items_ids[] = '-++-'.$request->title_id[$sic].'-++-'; $sic++; } $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); $db_array = array( 'service_date' => $request->sdate[0], 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->client[0], 'memo' => $request->memo[0], 'details' => json_encode($items_details), 'total' => (float)$request->totals, 'discount' => (float)$request->discounts, 'gross_total' => (float)$request->gross_totals, 'cash_paid_account' => $request->cash_received_account, 'cash_paid' => (float)$request->cash_received, 'pending_amount' => (float)$request->remaining_amount, 'service_ids' => implode(',', $items_ids), 'type' => $request->type[0], ); update_table('services_quotation','uid',$uid,$db_array); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_services_quotation'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/services-quotation/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$request['invoice'][0].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['gross_total']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'services_mod_update'), 'message_body' => print_lang($this->data["app_lang"],'services_mod_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_services_quotation_rights') === FALSE){ Redirect::to('/')->send(); } $sale_data = fetch_table_where('services_quotation','uid',$uid,true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_services_quotation'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$sale_data['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($sale_data['gross_total']), ); set_activity_alert($_activity_details); delete_table('services_quotation','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }