<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; use View; class Sets extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_sets_right') === FALSE){ Redirect::to('/')->send(); } $this->data["pageData"] = fetch_table_branch('sets'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_items_sets_view_title'); $this->data["pageToLoad"] = "sets/view.php"; $this->data["activeLink"] = "sets"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_sets_right') === FALSE){ Redirect::to('/')->send(); } $this->data["items"] = fetch_table_branch('items'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_items_sets_add_title'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["pageToLoad"] = "sets/add.php"; $this->data["activeLink"] = "sets"; $this->load_view($this->data); } public function get_items_appended_data(Request $request) { $this->data["post_data"] = $request->all(); $this->data["items"] = fetch_table_branch('items'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $appended_view = (string)View::make('user.sets.appended_view',$this->data); echo json_encode(array('status' => 'success', 'html' => $appended_view)); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', ]); $validator->validate(); $items_details = []; $sic = 0; while($sic < count($request->item)) { if(empty($request->item[$sic])){ $sic++; continue; } $items_details[] = array( 'item' => $request->item[$sic], 'warehouse' => $request->warehouse[$sic], 'batch' => $request->batch[$sic], 'unit' => $request->unit[$sic], 'qty' => (float)$request->qty[$sic], ); $sic++; } $uid = getUniqueId('sets', 'sets', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $request->name, 'items_details' => json_encode($items_details), ); insert_table('sets',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_items_sets_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_items_sets_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_sets_right') === FALSE){ Redirect::to('/')->send(); } $this->data["items"] = fetch_table_branch('items'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["editing_data"] = fetch_table_where('sets','uid',$uid,true); $this->data["title"] = print_lang($this->data["app_lang"],'mod_items_sets_edit_title'); $this->data["pageToLoad"] = "sets/edit.php"; $this->data["activeLink"] = "sets"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', ]); $validator->validate(); $items_details = []; $sic = 0; while($sic < count($request->item)) { if(empty($request->item[$sic])){ $sic++; continue; } $items_details[] = array( 'item' => $request->item[$sic], 'warehouse' => $request->warehouse[$sic], 'batch' => $request->batch[$sic], 'unit' => $request->unit[$sic], 'qty' => (float)$request->qty[$sic], ); $sic++; } $db_array = array( 'name' => $request->name, 'items_details' => json_encode($items_details), ); update_table('sets','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_items_sets_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_items_sets_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_sets_right') === FALSE){ Redirect::to('/')->send(); } delete_table('sets','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }