<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Share_capitals extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_share_capital_right') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $capitals = DB::table('capitals')->where('branch',$branch_id); if(!empty($request->currency)){ $capitals->where('currency',$request->currency); } if(!empty($request->type)){ $capitals->where('type',$request->type); } if(!empty($request->from)){ $capitals->where('event_date','>=',get_true_date($request->from)); } if(!empty($request->to)){ $capitals->where('event_date','<=',get_true_date($request->to)); } $capitals = $capitals->get(); $capitals = json_decode(json_encode($capitals),true); $this->data["pageData"] = $capitals; $this->data["search_currency"] = $request->currency; $this->data["search_type"] = $request->type; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["capitals_categories"] = set_array_keys(fetch_table_branch('capitals_categories'),'uid'); $this->data["shareholder"] = set_array_keys(fetch_table_branch('shareholder'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_table_where_branch('accounts','type','cashbook'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_share_capitals_view_title'); $this->data["pageToLoad"] = "capitals/view.php"; $this->data["activeLink"] = "capitals"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_share_capital_right') === FALSE){ Redirect::to('/')->send(); } $this->data["capitals_categories"] = fetch_table_branch('capitals_categories'); $this->data["shareholder"] = fetch_table_branch('shareholder'); $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = set_array_keys(fetch_table_where_branch('accounts','type','cashbook'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_share_capitals_add_title'); $this->data["pageToLoad"] = "capitals/add.php"; $this->data["activeLink"] = "capitals"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'event_date' => 'required', 'type' => 'required', 'account' => 'required', 'currency' => 'required', 'amount' => 'required', ]); $validator->validate(); $uid = getUniqueId('CAP', 'capitals', 'uid'); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $type_data = fetch_table_where('capitals_categories','uid',$request->type,true); $account_data = fetch_table_where('accounts','uid',$request->account,true); if($request->account == 'simple_capital') { $account_data['name'] = print_lang($this->data["app_lang"],'mod_share_capitals_add_input_account_simple_capital'); } $shareholder_data = fetch_table_where('shareholder','uid',$request->shareholder,true); $shareholder_first_name = isset($shareholder_data['name']) ? $shareholder_data['name'] : null; $shareholder_last_name = isset($shareholder_data['last_name']) ? $shareholder_data['last_name'] : null; $shareholder_name = $shareholder_first_name.' '.$shareholder_last_name; $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'event_date' => get_true_date($request->event_date), 'type' => $request->type, 'type_name' => isset($type_data['name']) ? $type_data['name'] : null, 'account' => $request->account, 'account_name' => isset($account_data['name']) ? $account_data['name'] : null, 'shareholder' => $request->shareholder, 'shareholder_name' => $shareholder_name, 'currency' => $request->currency, 'currency_usd_equalance' => $currency_data['usd_equalance'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'amount' => $request->amount, 'percentage' => $request->percentage, 'details' => $request->details, ); insert_table('capitals',$db_array); _handle_capitals_shareholder_ledger_effects(['uid' => $uid, 'state' => 'new']); _handle_capitals_ledger_effects(['uid' => $uid, 'state' => 'new']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_capitals'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/capitals/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_type').': '.$db_array['type_name'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_share_capitals_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_share_capitals_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_share_capital_right') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('capitals','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/capitals')->send(); } $this->data["capitals_categories"] = fetch_table_branch('capitals_categories'); $this->data["shareholder"] = fetch_table_branch('shareholder'); $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = set_array_keys(fetch_table_where_branch('accounts','type','cashbook'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_share_capitals_edit_title'); $this->data["pageToLoad"] = "capitals/edit.php"; $this->data["activeLink"] = "capitals"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'event_date' => 'required', 'type' => 'required', 'account' => 'required', 'currency' => 'required', 'amount' => 'required', ]); $validator->validate(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $type_data = fetch_table_where('capitals_categories','uid',$request->type,true); $account_data = fetch_table_where('accounts','uid',$request->account,true); if($request->account == 'simple_capital') { $account_data['name'] = print_lang($this->data["app_lang"],'mod_share_capitals_add_input_account_simple_capital'); } $shareholder_data = fetch_table_where('shareholder','uid',$request->shareholder,true); $shareholder_first_name = isset($shareholder_data['name']) ? $shareholder_data['name'] : null; $shareholder_last_name = isset($shareholder_data['last_name']) ? $shareholder_data['last_name'] : null; $shareholder_name = $shareholder_first_name.' '.$shareholder_last_name; $db_array = array( 'event_date' => get_true_date($request->event_date), 'type' => $request->type, 'type_name' => isset($type_data['name']) ? $type_data['name'] : null, 'account' => $request->account, 'account_name' => isset($account_data['name']) ? $account_data['name'] : null, 'shareholder' => $request->shareholder, 'shareholder_name' => $shareholder_name, 'currency' => $request->currency, 'currency_usd_equalance' => $currency_data['usd_equalance'], 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'amount' => $request->amount, 'percentage' => $request->percentage, 'details' => $request->details, ); update_table('capitals','uid',$uid,$db_array); _handle_capitals_shareholder_ledger_effects(['uid' => $uid, 'state' => 'update']); _handle_capitals_ledger_effects(['uid' => $uid, 'state' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_capitals'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/capitals/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_type').': '.$db_array['type_name'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['amount']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_share_capitals_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_share_capitals_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_share_capital_right') === FALSE){ Redirect::to('/')->send(); } $capital_data = fetch_table_where('capitals','uid',$uid,true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_capitals'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_type').': '.$capital_data['type_name'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($capital_data['amount']), ); set_activity_alert($_activity_details); delete_table('capitals','uid',$uid); _handle_capitals_shareholder_ledger_effects(['uid' => $uid, 'state' => 'delete']); _handle_capitals_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }