<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Shareholder extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_shareholder') === FALSE){ Redirect::to('/')->send(); } $this->data["pageData"] = fetch_table_branch('shareholder'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_shareholder_view_title'); $this->data["pageToLoad"] = "shareholder/view.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_shareholder') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'mod_shareholder_add_breadcrumb'); $this->data["pageToLoad"] = "shareholder/add.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'last_name' => 'required', 'nic' => 'required', 'percentage' => 'required', 'address' => 'required', ]); $validator->validate(); $uid = getUniqueId('SHRHL', 'shareholder', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $request->name, 'last_name' => $request->last_name, 'mobile' => $request->mobile, 'nic' => $request->nic, 'address' => $request->address, 'percentage' => $request->percentage, 'comments' => $request->comments, ); insert_table('shareholder',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_shareholder_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_shareholder_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_shareholder') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('shareholder','uid',$uid,true); $this->data["title"] = print_lang($this->data["app_lang"],'mod_shareholder_edit_title'); $this->data["pageToLoad"] = "shareholder/edit.php"; $this->data["activeLink"] = "settings"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'last_name' => 'required', 'nic' => 'required', 'percentage' => 'required', 'address' => 'required', ]); $validator->validate(); $db_array = array( 'name' => $request->name, 'last_name' => $request->last_name, 'mobile' => $request->mobile, 'nic' => $request->nic, 'address' => $request->address, 'percentage' => $request->percentage, 'comments' => $request->comments, ); $shareholder_name = $db_array['name'].' '.$db_array['last_name']; update_table('shareholder','uid',$uid,$db_array); update_table('capitals','shareholder',$uid,['shareholder_name' => $shareholder_name]); update_table('shareholder_credit','shareholder',$uid,['shareholder_name' => $shareholder_name]); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_shareholder_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_shareholder_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_shareholder') === FALSE){ Redirect::to('/')->send(); } delete_table('shareholder','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }