<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Shareholder_credit extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_shareholder_credit') === FALSE){ Redirect::to('/')->send(); } $this->data["pageData"] = fetch_table_branch('shareholder_credit'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_shareholder_credit_view_title'); $this->data["pageToLoad"] = "shareholder_credit/view.php"; $this->data["activeLink"] = "shareholder_credit"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_shareholder_credit') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'mod_shareholder_credit_add_breadcrumb'); $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = fetch_nested_accounts(); $this->data["shareholder"] = fetch_table_branch('shareholder'); $this->data["pageToLoad"] = "shareholder_credit/add.php"; $this->data["activeLink"] = "shareholder_credit"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'event_date' => 'required', 'shareholder' => 'required', 'credit_account' => 'required', 'currency' => 'required', 'amount' => 'required', 'percentage' => 'required', ]); $validator->validate(); $uid = getUniqueId('SHRHLC', 'shareholder_credit', 'uid'); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $account_data = fetch_table_where('accounts','uid',$request->credit_account,true); $shareholder_data = fetch_table_where('shareholder','uid',$request->shareholder,true); $shareholder_first_name = isset($shareholder_data['name']) ? $shareholder_data['name'] : null; $shareholder_last_name = isset($shareholder_data['last_name']) ? $shareholder_data['last_name'] : null; $shareholder_name = $shareholder_first_name.' '.$shareholder_last_name; $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'event_date' => get_true_date($request->event_date), 'currency' => $request->currency, 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'shareholder' => $request->shareholder, 'shareholder_name' => $shareholder_name, 'percentage' => $request->percentage, 'amount' => $request->amount, 'credit_account' => $request->credit_account, 'credit_account_name' => isset($account_data['name']) ? $account_data['name'] : null, 'details' => $request->details, ); insert_table('shareholder_credit',$db_array); _handle_shareholder_credit_ledger_effects(['uid' => $uid, 'state' => 'new']); _handle_shareholder_credit_account_ledger_effects(['uid' => $uid, 'state' => 'new']); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_shareholder_credit_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_shareholder_credit_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_shareholder_credit') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('shareholder_credit','uid',$uid,true); $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = fetch_nested_accounts(); $this->data["shareholder"] = fetch_table_branch('shareholder'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_shareholder_credit_edit_title'); $this->data["pageToLoad"] = "shareholder_credit/edit.php"; $this->data["activeLink"] = "shareholder_credit"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'event_date' => 'required', 'shareholder' => 'required', 'credit_account' => 'required', 'currency' => 'required', 'amount' => 'required', 'percentage' => 'required', ]); $validator->validate(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $account_data = fetch_table_where('accounts','uid',$request->credit_account,true); $shareholder_data = fetch_table_where('shareholder','uid',$request->shareholder,true); $shareholder_first_name = isset($shareholder_data['name']) ? $shareholder_data['name'] : null; $shareholder_last_name = isset($shareholder_data['last_name']) ? $shareholder_data['last_name'] : null; $shareholder_name = $shareholder_first_name.' '.$shareholder_last_name; $db_array = array( 'event_date' => get_true_date($request->event_date), 'currency' => $request->currency, 'currency_name' => $currency_data['name'], 'currency_symbol' => $currency_data['symbol'], 'shareholder' => $request->shareholder, 'shareholder_name' => $shareholder_name, 'percentage' => $request->percentage, 'amount' => $request->amount, 'credit_account' => $request->credit_account, 'credit_account_name' => isset($account_data['name']) ? $account_data['name'] : null, 'details' => $request->details, ); update_table('shareholder_credit','uid',$uid,$db_array); _handle_shareholder_credit_ledger_effects(['uid' => $uid, 'state' => 'update']); _handle_shareholder_credit_account_ledger_effects(['uid' => $uid, 'state' => 'update']); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_shareholder_credit_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_shareholder_credit_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_shareholder_credit') === FALSE){ Redirect::to('/')->send(); } delete_table('shareholder_credit','uid',$uid); _handle_shareholder_credit_ledger_effects(['uid' => $uid, 'state' => 'delete']); _handle_shareholder_credit_account_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }