<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Showroom extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('showroom_list_view') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $showroom_data = DB::table('car_purchases_details')->where('branch',$branch_id); if(!empty($request->currency)){ $showroom_data->where('currency',$request->currency); } if(!empty($request->from)){ $showroom_data->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $showroom_data->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($showroom_data->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'showroom'); $this->data["pageToLoad"] = "showroom/view.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function upload_images(Request $request) { $car_new_uploads = array(); $car_uid = $request->car_uid; $car_data = fetch_table_where('car_purchases_details','uid',$car_uid,true); if(is_array($car_data)) { $car_images = empty($car_data['images']) ? array() : explode(',',$car_data['images']); if($request->hasFile('images')) { $files = $request->file('images'); foreach($files as $file) { $extension = $file->getClientOriginalExtension(); $file_name = 'SCIMG'.generate_uid().'.'.$extension; $file->move('uploads/cars/',$file_name); $car_images[] = $file_name; $car_new_uploads[] = $file_name; } $car_images = implode(',',$car_images); $car_new_uploads = implode(',',$car_new_uploads); update_table('car_purchases_details','uid',$car_uid,array('images' => $car_images)); echo json_encode(array('status' => 'success', 'mode' => 'approved', 'uid' => $car_uid, 'new_uploads' => $car_new_uploads, 'images' => $car_images)); } else { echo json_encode(array('status' => 'warning', 'mode' => 'uploads')); } } } public function delete_images(Request $request) { $car_new_uploads = array(); $car_uid = $request->car_uid; $car_image = $request->car_image; $car_data = fetch_table_where('car_purchases_details','uid',$car_uid,true); if(isset($car_data['images'])) { $car_images = explode(',',$car_data['images']); $car_new_images = array(); foreach($car_images as $img) { if($car_image != $img){ $car_new_images[] = $img; } } $car_new_images = implode(',',$car_new_images); update_table('car_purchases_details','uid',$car_uid,array('images' => $car_new_images)); if(!empty($car_image)){ File::delete('uploads/cars/'.$car_image); } echo json_encode(array('status' => 'success', 'mode' => 'deleted', 'uid' => $car_uid, 'images' => $car_new_images)); } } }