<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Showroom_sales extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('car_purchase_sold_view') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $showroom_sales = DB::table('showroom_sales')->where('branch',$branch_id); if(!empty($request->currency)){ $showroom_sales->where('currency',$request->currency); } if(!empty($request->client)){ $showroom_sales->where('client',$request->client); } if(!empty($request->from)){ $showroom_sales->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $showroom_sales->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $this->data["pageData"] = json_decode(json_encode($showroom_sales->get()),true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["car_details"] = set_array_keys(fetch_table_where_branch('car_purchases_details','sold','sold'),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'showroom_sales'); $this->data["pageToLoad"] = "showroom_sales/view.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function invoice(Request $request,$uid) { if(check_user_access('add_purchase') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('car_purchases','uid',$uid,true); $this->data["invoice_details"] = fetch_table_where('car_purchases_details','purchase_id',$this->data["invoice_data"]['uid']); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["car_details"] = set_array_keys(fetch_table_where_branch('car_purchases_details','sold','sold'),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'car_purchase_invoice'); $this->data["pageToLoad"] = "custom_charges/invoice.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function add(Request $request, $uid) { if(check_user_access('sale_add_shor_car_purchases') === FALSE){ Redirect::to('/')->send(); } $this->data["car_details"] = fetch_table_where('car_purchases_details','uid',$uid,true); if(!is_array($this->data["car_details"])){ Redirect::to('/showroom-sales')->send(); } if($this->data["car_details"]['sold'] == 'sold'){ Redirect::to('/showroom-sales')->send(); } $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["title"] = print_lang($this->data["app_lang"],'new_showroom_sale'); $this->data["pageToLoad"] = "showroom_sales/add.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'client' => 'required', 'invoice' => 'required|unique:showroom_sales', 'sale_price' => 'required', ]); $validator->validate(); $uid = getUniqueId('SRSL', 'showroom_sales', 'uid'); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $request->currency, 'currency_usd_equalance' => (float)$currency_data['usd_equalance'], 'invoice' => $request->invoice, 'car' => $request->car_uid, 'real_cost' => (float)$request->real_cost, 'client' => $request->client, 'sale_price' => (float)$request->sale_price, 'profit' => (float)$request->profit, 'total' => (float)$request->total, 'discount' => (float)$request->discount, 'gross_total' => (float)$request->gross_total, 'cash_paid_account' => $request->cash_paid_account, 'cash_paid' => (float)$request->cash_paid, 'pending_amount' => (float)$request->pending_amount, 'name' => $request->name, 'father_name' => $request->father_name, 'tazkira' => $request->tazkira, 'mobile' => $request->mobile, 'address' => $request->address, ); if($request->hasFile('buyer_image')) { $file = $request->file('buyer_image'); $extension = $file->getClientOriginalExtension(); $file_name = 'BCSIMG'.generate_uid().'.'.$extension; $file->move('uploads/showroom_sale/',$file_name); $db_array['buyer_image'] = $file_name; } if($request->hasFile('document')) { $file = $request->file('document'); $extension = $file->getClientOriginalExtension(); $file_name = 'BCSIMG'.generate_uid().'.'.$extension; $file->move('uploads/showroom_sale/',$file_name); $db_array['document'] = $file_name; } insert_table('showroom_sales',$db_array); _handle_showroom_sales_ledger_effects(['uid' => $uid, 'state' => 'new']); update_table('car_purchases_details','uid',$db_array['car'],array('sold' => 'sold')); $redirect_url = url('/showroom-sales'); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_showroom_sales'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/showroom-sales/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['gross_total']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'redirect_url' => $redirect_url, 'message_head' => print_lang($this->data["app_lang"],'showroom_sales_saved'), 'message_body' => print_lang($this->data["app_lang"],'showroom_sales_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('sale_edit_shor_car_purchases') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('showroom_sales','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/showroom-sales')->send(); } $this->data["car_details"] = fetch_table_where('car_purchases_details','uid',$this->data["editing_data"]['car'],true); $this->data["accounts"] = fetch_nested_accounts(); $this->data["currencies"] = fetch_currencies(); $this->data["title"] = print_lang($this->data["app_lang"],'edit_showroom_sale'); $this->data["pageToLoad"] = "showroom_sales/edit.php"; $this->data["activeLink"] = "showroom"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'currency' => 'required', 'client' => 'required', 'invoice' => ['required',Rule::unique('showroom_sales')->ignore($uid, 'uid')], 'sale_price' => 'required', ]); $validator->validate(); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $db_array = array( 'currency' => $request->currency, 'currency_usd_equalance' => (float)$currency_data['usd_equalance'], 'invoice' => $request->invoice, 'car' => $request->car_uid, 'real_cost' => (float)$request->real_cost, 'client' => $request->client, 'sale_price' => (float)$request->sale_price, 'profit' => (float)$request->profit, 'total' => (float)$request->total, 'discount' => (float)$request->discount, 'gross_total' => (float)$request->gross_total, 'cash_paid_account' => $request->cash_paid_account, 'cash_paid' => (float)$request->cash_paid, 'pending_amount' => (float)$request->pending_amount, 'name' => $request->name, 'father_name' => $request->father_name, 'tazkira' => $request->tazkira, 'mobile' => $request->mobile, 'address' => $request->address, ); $car_buy_data = fetch_table_where('showroom_sales','uid',$uid,true); if($request->hasFile('buyer_image')) { $file = $request->file('buyer_image'); $extension = $file->getClientOriginalExtension(); $file_name = 'BCSIMG'.generate_uid().'.'.$extension; $file->move('uploads/showroom_sales/',$file_name); $db_array['buyer_image'] = $file_name; File::delete('uploads/showroom_sales/'.$car_buy_data['buyer_image']); } if($request->hasFile('document')) { $file = $request->file('document'); $extension = $file->getClientOriginalExtension(); $file_name = 'BCSIMG'.generate_uid().'.'.$extension; $file->move('uploads/showroom_sales/',$file_name); $db_array['document'] = $file_name; File::delete('uploads/showroom_sales/'.$car_buy_data['document']); } update_table('showroom_sales','uid',$uid,$db_array); _handle_showroom_sales_ledger_effects(['uid' => $uid, 'state' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_showroom_sales'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/showroom-sales/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['gross_total']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'showroom_sales_updated'), 'message_body' => print_lang($this->data["app_lang"],'showroom_sales_updated_successfully'))); } public function delete($uid) { if(check_user_access('sale_delete_shor_car_purchases') === FALSE){ Redirect::to('/')->send(); } $showroom_sale_data = fetch_table_where('showroom_sales','uid',$uid,TRUE); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_showroom_sales'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$showroom_sale_data['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($showroom_sale_data['gross_total']), ); set_activity_alert($_activity_details); delete_table('showroom_sales','uid',$uid); update_table('car_purchases_details','uid',$showroom_sale_data['car'],array('sold' => NULL)); _handle_showroom_sales_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }