<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Stock_in extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_stock_in') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $stock_in = DB::table('stock_in')->where('branch',$branch_id); if(!empty($request->client)){ $stock_in->where('client',$request->client); } if(!empty($request->from)){ $stock_in->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $stock_in->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $stock_in = $stock_in->get(); $stock_in = json_decode(json_encode($stock_in),true); $this->data["pageData"] = $stock_in; $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'stock_in'); $this->data["pageToLoad"] = "stock_in/view.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function invoice(Request $request, $uid) { if(check_user_access('add_stock_in') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_data"] = fetch_table_where('stock_in','uid',$uid,true); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'stock_in_invoice'); $this->data["pageToLoad"] = "stock_in/invoice.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_stock_in') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_number"] = get_stock_in_invoice_number(); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["clients"] = fetch_table_where_branch('accounts','type','client'); $this->data["title"] = print_lang($this->data["app_lang"],'add_stock_in'); $this->data["pageToLoad"] = "stock_in/add.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function save(Request $request) { $items_details = array(); $items = array(); $warehouse = array(); $sic = 0; $invoice_num = (int)$request->invoice[0]; $invoice_num_exist = DB::table('stock_in')->where('invoice',$invoice_num)->get(); if($invoice_num_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => 'Invoice Exist', 'message_body' => 'This invoice number already exist.')); die; } $uid = getUniqueId('STOCKIN', 'stock_in', 'uid'); while($sic < count($request->item)) { if(empty($request->item[$sic])){ $sic++; continue; } $item_id = generate_uid(); $items_details[] = array( 'item_id'=>$item_id, 'item' => $request->item[$sic], 'unit' => $request->unit[$sic], 'qty' => (float)$request->qty[$sic], 'mark' => $request->mark[$sic], 'remark' => $request->remark[$sic], ); $item_ids[] = '-++-'.$item_id.'-++-'; $sic++; } $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'client' => $request->client[0], 'warehouse' => $request->warehouse[0], 'agent' => $request->agent[0], 'stock_date' => $request->stock_date[0], 'invoice' => $invoice_num, 'total_qty' => $request->total_qty, 'item_ids' => implode(',', $item_ids), 'items_details' => json_encode($items_details), ); insert_table('stock_in',$db_array); $invoice_url = url('/stock-in/invoice').'/'.$uid; $invoice_number = get_stock_in_invoice_number(); echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_number' => $invoice_number, 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'stock_in_added'), 'message_body' => print_lang($this->data["app_lang"],'new_stock_in_added_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_stock_in') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('stock_in','uid',$uid,true); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'stock_in_edit'); $this->data["pageToLoad"] = "stock_in/edit.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_details = array(); $items = array(); $warehouse = array(); $sic = 0; $invoice_num = (int)$request->invoice[0]; $invoice_num_exist = DB::table('stock_in')->where('uid','!=',$uid)->where('invoice',$invoice_num)->get(); if($invoice_num_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'update', 'message_head' => 'Invoice Exist', 'message_body' => 'This invoice number already exist.')); die; } while($sic < count($request->item)) { if(empty($request->item[$sic])){ $sic++; continue; } $item_id = $request->item_id[$sic]; if(empty($item_id)) { $item_id = generate_uid(); } $items_details[] = array( 'item_id'=>$item_id, 'item' => $request->item[$sic], 'unit' => $request->unit[$sic], 'qty' => (float)$request->qty[$sic], 'mark' => $request->mark[$sic], 'remark' => $request->remark[$sic], ); $item_ids[] = '-++-'.$item_id.'-++-'; $sic++; } $db_array = array( 'client' => $request->client[0], 'warehouse' => $request->warehouse[0], 'agent' => $request->agent[0], 'stock_date' => $request->stock_date[0], 'invoice' => $invoice_num, 'total_qty' => $request->total_qty, 'item_ids' => implode(',', $item_ids), 'items_details' => json_encode($items_details), ); update_table('stock_in','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'stock_in_updated'), 'message_body' => print_lang($this->data["app_lang"],'stock_in_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_stock_in') === FALSE){ Redirect::to('/')->send(); } delete_table('stock_in','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }