<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Stock_out extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_stock_out') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $stock_out = DB::table('stock_out')->where('branch',$branch_id); if(!empty($request->currency)){ $stock_out->where('currency',$request->currency); } if(!empty($request->client)){ $stock_out->where('client',$request->client); } if(!empty($request->from)){ $stock_out->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $stock_out->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $stock_out = $stock_out->get(); $stock_out = json_decode(json_encode($stock_out),true); $this->data["pageData"] = $stock_out; $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'stock_out'); $this->data["pageToLoad"] = "stock_out/view.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function get_stock_in_receipts(Request $request) { $client = $request->client; $receipts = fetch_table_where('stock_in','client',$client); $options = '<option disabled="" selected="">-- Select --</option>'; foreach($receipts as $row) { $options .= '<option value="'.$row['uid'].'" >'.$row['invoice'].'</option>'; } echo json_encode(array('status' => 'success', 'options' => $options)); } public function get_stock_in_data(Request $request) { $invoice_html = ''; $items_html = ''; $client = $request->client; $receipt = $request->receipt; $stock_record = get_stock_record($receipt); $invoice = get_stock_out_invoice_number(); $client_name = fetch_table_column_by_uid('accounts','name',$stock_record['invoice_data']['client']); $warehouse_name = fetch_table_column_by_uid('warehouse','name',$stock_record['invoice_data']['warehouse']); $invoice_html = '<tr>'; $invoice_html .= '<input type="hidden" name="client" value="'.$stock_record['invoice_data']['client'].'">'; $invoice_html .= '<input type="hidden" name="warehouse" value="'.$stock_record['invoice_data']['warehouse'].'">'; $invoice_html .= '<input type="hidden" name="agent" value="'.$stock_record['invoice_data']['agent'].'">'; $invoice_html .= '<input type="hidden" name="stock_in_id" value="'.$stock_record['invoice_data']['uid'].'">'; $invoice_html .= '<input type="hidden" name="stock_in_date" value="'.$stock_record['invoice_data']['stock_date'].'">'; $invoice_html .= '<input type="hidden" name="invoice" value="'.$invoice.'">'; $invoice_html .= '<td class="text-center"><span>'.$client_name.'</span></td>'; $invoice_html .= '<td class="text-center"><span>'.$stock_record['invoice_data']['agent'].'</span></td>'; $invoice_html .= '<td class="text-center"><span>'.$warehouse_name.'</span></td>'; $invoice_html .= '<td class="text-center"><span>'.display_true_date($stock_record['invoice_data']['stock_date']).'</span></td>'; $invoice_html .= '<td class="text-center"><span>'.$invoice.'</span></td>'; $invoice_html .= '</tr>'; foreach($stock_record['items_data'] as $items) { if($items['available'] <= 0) { $pointer_none = "pointer-none"; } else { $pointer_none = ''; } $items_html .= '<tr >'; $items_html .= '<td class="text-center"><span>'.$items['item'].'</span></td>'; $items_html .= '<td class="text-center"><span>'.$items['unit'].'</span></td>'; $items_html .= '<td class="text-center"><span>'.$items['qty'].'</span></td>'; $items_html .= '<td class="text-center"><span>'.$items['stock_out'].'</span></td>'; $items_html .= '<td class="text-center"><span>'.$items['available'].'</span></td>'; $items_html .= '<td class="text-center"><span>'.$items['mark'].'</span></td>'; $items_html .= '<td class="text-center"><span>'.$items['remark'].'</span></td>'; $items_html .= '<td class="text-center '.$pointer_none.'"><a href="javascript:void(0);" id="stock-out-btn-trigger-'.$items['item_id'].'" class="btn btn-xs btn-outline btn-danger stock-out-btn-trigger" data-uid="'.$items['item_id'].'" data-name="'.$items['item'].'" data-unit="'.$items['unit'].'" data-qty="'.$items['qty'].'" data-mark="'.$items['mark'].'" data-remark="'.$items['remark'].'" data-ava="'.$items['available'].'"><i class="fa fa-trash"></i>&nbsp;'.print_lang($this->data["app_lang"],'out_stock_btn').'</a></td>'; $items_html .= '</tr>'; } echo json_encode(array('status' => 'success', 'invoice_html' => $invoice_html, 'items_html' => $items_html)); } public function invoice(Request $request, $uid) { if(check_user_access('add_sale') === FALSE){ Redirect::to('/')->send(); } $stock_out = fetch_table_where('stock_out','uid',$uid,true); $this->data["invoice_data"] = $stock_out; $this->data["stock_in_data"] = fetch_table_where('stock_in','uid',$stock_out['stock_in_id'],true); $stock_record = get_stock_record($stock_out['stock_in_id']); $this->data["stock_in_data"] = $stock_record; $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'stock_out_invoice'); $this->data["pageToLoad"] = "stock_out/invoice.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_stock_out') === FALSE){ Redirect::to('/')->send(); } $this->data["invoice_number"] = get_stock_out_invoice_number(); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'add_stock_out'); $this->data["pageToLoad"] = "stock_out/add.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function save(Request $request) { $items_details = array(); $items = array(); $warehouse = array(); $sic = 0; $invoice_num = (int)$request->invoice; $invoice_num_exist = DB::table('stock_out')->where('invoice',$invoice_num)->get(); if($invoice_num_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => 'Invoice Exist', 'message_body' => 'This invoice number already exist.')); die; } $uid = getUniqueId('STOCKOUT', 'stock_out', 'uid'); while($sic < count($request->item_name)) { if(empty($request->item_name[$sic])){ $sic++; continue; } $items_details[] = array( 'item_id'=>$request->item_id[$sic], 'item' => $request->item_name[$sic], 'unit' => $request->unit[$sic], 'qty' => (float)$request->stock_out_item[$sic], 'mark' => $request->mark[$sic], 'remark' => $request->remark[$sic], ); $item_ids[] = '-++-'.$request->item_id[$sic].'-++-'; $sic++; } $client_old_balance = get_account_balance($request->client,$request->currency); $pending = $request->gross_total - $request->cash_paid; $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $request->currency, 'client' => $request->client, 'client_old_balance' => $client_old_balance, 'warehouse' => $request->warehouse, 'agent' => $request->agent, 'stock_in_id' => $request->stock_in_id, 'stock_date_out' => date("Y-m-d"), 'invoice' => $invoice_num, 'total_qty' => $request->total_out_qty, 'rent' => $request->rent, 'discount' => $request->discount, 'cash_paid' => $request->paid, 'gross_total' => $request->gross_total, 'pending' => $pending, 'account' => $request->account, 'memo' => $request->memo, 'item_ids' => implode(',', $item_ids), 'items_details' => json_encode($items_details), ); insert_table('stock_out',$db_array); $options = '<option disabled="" selected="">-- Select --</option>'; $invoice_url = url('/stock-out/invoice').'/'.$uid; $invoice_number = get_stock_out_invoice_number(); echo json_encode(array('status' => 'success', 'mood' => 'new', 'options'=>$options, 'invoice_number' => $invoice_number, 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'stock_out_added'), 'message_body' => print_lang($this->data["app_lang"],'new_stock_out_added_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_stock_out') === FALSE){ Redirect::to('/')->send(); } $stock_out = fetch_table_where('stock_out','uid',$uid,true); $this->data["editing_data"] = $stock_out; $this->data["stock_in_data"] = fetch_table_where('stock_in','uid',$stock_out['stock_in_id'],true); $stock_record = get_stock_record($stock_out['stock_in_id']); $this->data["stock_in_data"] = $stock_record; $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["clients"] = set_array_keys(fetch_table_where_branch('accounts','type','client'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'stock_out_edit'); $this->data["pageToLoad"] = "stock_out/edit.php"; $this->data["activeLink"] = "stock"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_details = array(); $items = array(); $warehouse = array(); $sic = 0; $invoice_num = (int)$request->invoice; $invoice_num_exist = DB::table('stock_out')->where('uid','!=',$uid)->where('invoice',$invoice_num)->get(); if($invoice_num_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'update', 'message_head' => 'Invoice Exist', 'message_body' => 'This invoice number already exist.')); die; } while($sic < count($request->item_name)) { if(empty($request->item_name[$sic])){ $sic++; continue; } $items_details[] = array( 'item_id'=>$request->item_id[$sic], 'item' => $request->item_name[$sic], 'unit' => $request->unit[$sic], 'qty' => (float)$request->stock_out_item[$sic], 'mark' => $request->mark[$sic], 'remark' => $request->remark[$sic], ); $item_ids[] = '-++-'.$request->item_id[$sic].'-++-'; $sic++; } $pending = $request->gross_total - $request->paid; $db_array = array( 'currency' => $request->currency, 'total_qty' => $request->total_out_qty, 'rent' => $request->rent, 'discount' => $request->discount, 'cash_paid' => $request->paid, 'gross_total' => $request->gross_total, 'pending' => $pending, 'account' => $request->account, 'memo' => $request->memo, 'item_ids' => implode(',', $item_ids), 'items_details' => json_encode($items_details), ); update_table('stock_out','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'stock_out_updated'), 'message_body' => print_lang($this->data["app_lang"],'stock_out_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_stock_out') === FALSE){ Redirect::to('/')->send(); } delete_table('stock_out','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }