<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; use Hash; class System_approvals extends Setup { public function __construct() { parent::__construct(); } public function approvals(Request $request) { if(check_user_access('sub_approval') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $pageData = []; $table_name = null; if($request->module == 'expenses'){ $table_name = 'expenses'; } if($request->module == 'stock_in'){ $table_name = 'item_stock_in'; } if($request->module == 'stock_out'){ $table_name = 'item_stock_out'; } if($request->module == 'journal'){ $table_name = 'journal'; } if($request->module == 'sales'){ $table_name = 'sales'; } if($request->module == 'purchases'){ $table_name = 'purchases'; } if(!empty($table_name)) { $pageData = DB::table($table_name)->where('branch',$branch_id); if($request->type == 'sub_approval'){ $pageData->where('sub_approval','pending'); } if($request->type == 'main_approval'){ $pageData->where('sub_approval','approved')->where('main_approval','pending'); } $pageData = std_obj_to_array($pageData->get()); } $this->data["pageData"] = $pageData; $this->data["search_module"] = $request->module; $this->data["search_type"] = $request->type; $this->data["expenses_types"] = set_array_keys(fetch_table_branch('expenses_types'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_nested_accounts(),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_approvals_view_title'); $this->data["pageToLoad"] = "system_approvals/approvals.php"; if($request->type == 'sub_approval') { $this->data["activeLink"] = "sub_approval"; } else if($request->type == 'main_approval') { $this->data["activeLink"] = "main_approval"; } $this->load_view($this->data); } public function process(Request $request) { $module_name = $request->module_name; $status = $request->status; $approval_status = $request->approval_status; $uids = $request->uids; if(empty($module_name) OR empty($status) OR empty($approval_status) OR empty($uids)) { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_approvals_data_missing_head'), 'message_body' => print_lang($this->data["app_lang"],'mod_approvals_data_missing_message'))); die; } $db_array = [ $approval_status => $status, $approval_status.'_user' => get_logged_user_data('uid'), $approval_status.'_user_name' => get_logged_user_data('name'), ]; foreach($uids as $uid) { if($module_name == 'expenses') { update_table('expenses','uid',$uid,$db_array); if($status == 'approved' AND $approval_status == 'main_approval') { _handle_expenses_ledger_effects(['uid' => $uid, 'state' => 'new']); } } if($module_name == 'stock_in') { $stock_in_data = fetch_table_where('item_stock_in','uid',$uid,true); update_table('item_stock_in','uid',$uid,$db_array); if($status == 'approved' AND $approval_status == 'main_approval') { _handle_item_stock_in_balance_effects(['uid' => $uid, 'state' => 'new']); handle_item_stock_stats($stock_in_data['item']); _handle_item_stock_in_ledger_effects(['uid' => $uid, 'state' => 'new']); } } if($module_name == 'stock_out') { $stock_out_data = fetch_table_where('item_stock_out','uid',$uid,true); update_table('item_stock_out','uid',$uid,$db_array); if($status == 'approved' AND $approval_status == 'main_approval') { _handle_item_stock_out_balance_effects(['uid' => $uid, 'state' => 'new']); handle_item_stock_stats($stock_out_data['item']); $item_data = fetch_table_where('item_stock','uid',$request->item,true); $item_currency = isset($item_data['currency']) ? $item_data['currency'] : null; $cost = isset($item_data['avg_cost']) ? $item_data['avg_cost'] : null; $total = (float)$stock_out_data['out_quantity'] * $cost; $currency_data = fetch_table_where('currency','uid',$item_currency,true); $euid = getUniqueId('EXPE', 'expenses', 'uid'); $edb_array = array( 'uid' => $euid, 'branch' => $stock_out_data['branch'], 'serial_id' => get_serial_id('expenses'), 'type' => $stock_out_data['expense_type'], 'exp_date' => date('Y-m-d',strtotime($stock_out_data['event_date'])), 'account' => 'Stock In', 'amount' => $total, 'currency' => $item_currency, 'currency_usd_equalance' => $currency_data['usd_equalance'], 'narration' => $stock_out_data['details'], 'stock_uid' => $uid, ); insert_table('expenses',$edb_array); } } if($module_name == 'journal') { $journal_data = fetch_table_where('journal','uid',$uid,true); update_table('journal','uid',$uid,$db_array); if($status == 'approved' AND $approval_status == 'main_approval') { _handle_journal_ledger_effects(['uid' => $uid, 'state' => 'new']); message_from_journal($uid); } } if($module_name == 'purchases') { $purchases_data = fetch_table_where('purchases','uid',$uid,true); update_table('purchases','uid',$uid,$db_array); if($status == 'approved' AND $approval_status == 'main_approval') { _handle_purchases_ledger_effects(['uid' => $uid, 'state' => 'new']); _handle_items_inventory_stats_from_purchases(['uid' => $uid, 'entry_status' => 'new']); } } if($module_name == 'sales') { $sales_data = fetch_table_where('sales','uid',$uid,true); update_table('sales','uid',$uid,$db_array); if($status == 'approved' AND $approval_status == 'main_approval') { _handle_sales_ledger_effects(['uid' => $uid, 'state' => 'new']); _handle_items_inventory_stats_from_sales(['uid' => $uid, 'entry_status' => 'new']); message_from_sales($uid); } } } echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_approvals_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_approvals_save_successfully'))); } }