<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Tokens extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { $extractions = DB::table('tokens')->where('branch',active_branch_id())->where('client',$request->client)->where('item',$request->item)->get(); $extractions = std_obj_to_array($extractions); $token_rate = 0; $item_data = fetch_table_where('items','uid',$request->item,true); if(!empty($item_data)) { $token_rate = (float)$item_data['token_rate']; } $sold_qty = DB::table('items_inventory_stats')->sum('item_token_out'); $purchased_qty = DB::table('tokens')->sum('purchase_qty'); $available_qty = $sold_qty - $purchased_qty; $this->data["search_client"] = $request->client; $this->data["search_item"] = $request->item; $this->data["pageData"] = $extractions; $this->data["token_rate"] = $token_rate; $this->data["sold_qty"] = $sold_qty; $this->data["purchased_qty"] = $purchased_qty; $this->data["available_qty"] = $available_qty; $this->data["items"] = fetch_table_branch('items'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_items_token_view_title'); $this->data["pageToLoad"] = "tokens/view.php"; $this->data["activeLink"] = "tokens"; $this->load_view($this->data); } public function add(Request $request) { $this->data["currencies"] = fetch_currencies(); $this->data["items"] = fetch_table_branch('items'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["banks"] = set_array_keys(fetch_table_where_branch('accounts','type','bank'),'uid'); $this->data["cash"] = set_array_keys(fetch_table_where_branch('accounts','type','cashbook'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_items_token_add_title'); $this->data["pageToLoad"] = "tokens/add.php"; $this->data["activeLink"] = "tokens"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'client' => 'required', 'item' => 'required', 'purchase_qty' => 'required', 'currency' => 'required', 'account' => 'required', ]); $validator->validate(); $uid = getUniqueId('TKN', 'tokens', 'uid'); $item_db_data = fetch_table_where('items','uid',$request->item,true); $currency_db_data = fetch_table_where('currency','uid',$request->currency,true); $client_db_data = fetch_table_where('accounts','uid',$request->client,true); $account_db_data = fetch_table_where('accounts','uid',$request->account,true); $currency_usd_equalance = isset($currency_db_data['usd_equalance']) ? $currency_db_data['usd_equalance'] : null; $currency_symbol = isset($currency_db_data['symbol']) ? $currency_db_data['symbol'] : null; $currency_name = isset($currency_db_data['name']) ? $currency_db_data['name'] : null; $client_name = isset($client_db_data['name']) ? $client_db_data['name'] : null; $account_name = isset($account_db_data['name']) ? $account_db_data['name'] : null; $item_name = isset($item_db_data['name']) ? $item_db_data['name'] : null; $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'client' => $request->client, 'client_name' => $client_name, 'item' => $request->item, 'item_name' => $item_name, 'currency' => $request->currency, 'currency_usd_equalance' => $currency_usd_equalance, 'currency_symbol' => $currency_symbol, 'currency_name' => $currency_name, 'token_date' => date('Y-m-d H:i:s'), 'sold_qty' => $request->sold_qty, 'sold_amount' => $request->sold_amount, 'purchase_qty' => $request->purchase_qty, 'purchase_amount' => $request->purchase_amount, 'balance' => $request->sold_qty - $request->purchase_qty, 'account' => $request->account, 'account_name' => $account_name, ); insert_table('tokens',$db_array); _handle_tokens_ledger_effects(['uid' => $uid, 'state' => 'new']); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_items_token_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_items_token_save_successfully'))); } public function edit(Request $request, $uid) { $this->data["editing_data"] = fetch_table_where('tokens','uid',$uid,true); $this->data["currencies"] = fetch_currencies(); $this->data["items"] = fetch_table_branch('items'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["suppliers"] = set_array_keys(fetch_table_where_branch('accounts','type','supplier'),'uid'); $this->data["banks"] = set_array_keys(fetch_table_where_branch('accounts','type','bank'),'uid'); $this->data["cash"] = set_array_keys(fetch_table_where_branch('accounts','type','cashbook'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_items_token_edit_title'); $this->data["pageToLoad"] = "tokens/edit.php"; $this->data["activeLink"] = "tokens"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'client' => 'required', 'item' => 'required', 'purchase_qty' => 'required', 'currency' => 'required', 'account' => 'required', ]); $validator->validate(); $item_db_data = fetch_table_where('items','uid',$request->item,true); $currency_db_data = fetch_table_where('currency','uid',$request->currency,true); $client_db_data = fetch_table_where('accounts','uid',$request->client,true); $account_db_data = fetch_table_where('accounts','uid',$request->account,true); $currency_usd_equalance = isset($currency_db_data['usd_equalance']) ? $currency_db_data['usd_equalance'] : null; $currency_symbol = isset($currency_db_data['symbol']) ? $currency_db_data['symbol'] : null; $currency_name = isset($currency_db_data['name']) ? $currency_db_data['name'] : null; $client_name = isset($client_db_data['name']) ? $client_db_data['name'] : null; $account_name = isset($account_db_data['name']) ? $account_db_data['name'] : null; $item_name = isset($item_db_data['name']) ? $item_db_data['name'] : null; $db_array = array( 'client' => $request->client, 'client_name' => $client_name, 'item' => $request->item, 'item_name' => $item_name, 'currency' => $request->currency, 'currency_usd_equalance' => $currency_usd_equalance, 'currency_symbol' => $currency_symbol, 'currency_name' => $currency_name, 'sold_qty' => $request->sold_qty, 'sold_amount' => $request->sold_amount, 'purchase_qty' => $request->purchase_qty, 'purchase_amount' => $request->purchase_amount, 'balance' => $request->sold_qty - $request->purchase_qty, 'account' => $request->account, 'account_name' => $account_name, ); update_table('tokens','uid',$uid,$db_array); _handle_tokens_ledger_effects(['uid' => $uid, 'state' => 'update']); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_items_token_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_items_token_update_successfully'))); } public function delete($uid) { delete_table('tokens','uid',$uid); _handle_tokens_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } public function get_client_sold_data(Request $request) { $sold_qty = DB::table('items_inventory_stats')->where('account',$request->client)->where('item',$request->item)->sum('item_token_out'); $purchased_qty = DB::table('tokens')->where('client',$request->client)->where('item',$request->item)->sum('purchase_qty'); $available_qty = $sold_qty - $purchased_qty; echo json_encode(array('status' => 'success', 'sold_qty' => $sold_qty, 'purchased_qty' => $purchased_qty, 'available_qty' => $available_qty)); } }