<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Transfer extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_warehouse_transfer') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $transfer = DB::table('transfer')->where('branch',$branch_id); if(!empty($request->item)){ $transfer->where('item',$request->item); } if(!empty($request->warehouse)){ $transfer->where(function($query) use ($request){ $query->where('sending_warehouse',$request->warehouse)->orWhere('receiving_warehouse',$request->warehouse); }); } if(!empty($request->from)){ $transfer->where('created_at','>=',$request->from.' 00:00:00'); } if(!empty($request->to)){ $transfer->where('created_at','<=',$request->to.' 23:59:59'); } $transfer = $transfer->get(); $transfer = json_decode(json_encode($transfer),true); $this->data["pageData"] = $transfer; $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["search_item"] = $request->item; $this->data["search_warehouse"] = $request->warehouse; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'transfer'); $this->data["pageToLoad"] = "transfer/view.php"; $this->data["activeLink"] = "transfer"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_warehouse_transfer') === FALSE){ Redirect::to('/')->send(); } if(empty($request->warehouse)){ Redirect::to('/')->send(); } if(empty($request->item)){ Redirect::to('/')->send(); } $this->data["sending_warehouse"] = $request->warehouse; $this->data["item"] = $request->item; $this->data["item_data"] = fetch_table_where('items','uid',$request->item,true); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["warehouse"] = fetch_table_branch('warehouse'); $this->data["title"] = print_lang($this->data["app_lang"],'transfer_item'); $this->data["pageToLoad"] = "transfer/add.php"; $this->data["activeLink"] = "transfer"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'sending_warehouse' => 'required', 'item' => 'required', 'receiving_warehouse' => 'required', 'qty' => 'required', 'unit' => 'required', 'batch' => 'required', ]); $validator->validate(); $uid = getUniqueId('TSFR', 'transfer', 'uid'); $item_record = fetch_table_where('items','uid',$request->item,true); $item_stats = json_decode($item_record['stats'],true); $cost = (float)$item_stats['last_cost']; $profit = (float)$item_stats['last_profit']; $sale_price = $cost + $profit; $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'batch' => $request->batch, 'item' => $request->item, 'sending_warehouse' => $request->sending_warehouse, 'receiving_warehouse' => $request->receiving_warehouse, 'cost' => $cost, 'profit' => $profit, 'sale_price' => $sale_price, 'qty' => $request->qty, 'bundle' => $request->bundle, 'toop' => $request->toop, 'unit' => $request->unit, 'narration' => $request->narration, ); insert_table('transfer',$db_array); _handle_items_inventory_stats_from_transfer(['uid' => $uid, 'entry_status' => 'new']); $items = fetch_table_where('items','uid',$db_array['item'],true); $item_name = isset($items['name']) ? $items['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_warehouse_transfer'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/transfer/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_item').': '.$item_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_qty').': '.amount_number_format($db_array['qty']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'item_transferred'), 'message_body' => print_lang($this->data["app_lang"],'item_transferred_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_warehouse_transfer') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('transfer','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/transfer')->send(); } $this->data["item_data"] = fetch_table_where('items','uid',$this->data["editing_data"]['item'],true); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["warehouse"] = fetch_table_branch('warehouse'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_transfer'); $this->data["pageToLoad"] = "transfer/edit.php"; $this->data["activeLink"] = "transfer"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'receiving_warehouse' => 'required', 'qty' => 'required', 'unit' => 'required', 'batch' => 'required', ]); $validator->validate(); $db_array = array( 'receiving_warehouse' => $request->receiving_warehouse, 'qty' => $request->qty, 'unit' => $request->unit, 'narration' => $request->narration, ); $transfer_data = fetch_table_where('transfer','uid',$uid,true); $item_record = fetch_table_where('items','uid',$transfer_data['item'],true); $item_stats = json_decode($item_record['stats'],true); $cost = (float)$item_stats['last_cost']; $profit = (float)$item_stats['last_profit']; $sale_price = $cost + $profit; $db_array = array( 'batch' => $request->batch, 'receiving_warehouse' => $request->receiving_warehouse, 'cost' => $cost, 'profit' => $profit, 'sale_price' => $sale_price, 'qty' => $request->qty, 'bundle' => $request->bundle, 'toop' => $request->toop, 'unit' => $request->unit, 'narration' => $request->narration, ); update_table('transfer','uid',$uid,$db_array); $transfer_data = fetch_table_where('transfer','uid',$uid,true); _handle_items_inventory_stats_from_transfer(['uid' => $uid, 'entry_status' => 'update']); _calculate_item_wise_stats(['item' => $transfer_data['item']]); $items = fetch_table_where('items','uid',$transfer_data['item'],true); $item_name = isset($items['name']) ? $items['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_warehouse_transfer'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/transfer/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_item').': '.$item_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_qty').': '.amount_number_format($db_array['qty']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'transfer_updated'), 'message_body' => print_lang($this->data["app_lang"],'transfer_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_warehouse_transfer') === FALSE){ Redirect::to('/')->send(); } $transfer_data = fetch_table_where('transfer','uid',$uid,true); $items = fetch_table_where('items','uid',$transfer_data['item'],true); $item_name = isset($items['name']) ? $items['name'] : NULL; $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_warehouse_transfer'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_item').': '.$item_name.', '.print_lang($this->data["app_lang"],'dashboard_activities_text_qty').': '.amount_number_format($transfer_data['qty']), ); set_activity_alert($_activity_details); delete_table('transfer','uid',$uid); _handle_items_inventory_stats_from_transfer(['uid' => $uid, 'entry_status' => 'delete']); _calculate_item_wise_stats(['item' => $transfer_data['item']]); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }