<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use File; class Transfer_in extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_transfer_in_ph') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $transfer_in = DB::table('transfer_in')->where('branch',$branch_id); if(!empty($request->currency)){ $transfer_in->where('currency',$request->currency); } if(!empty($request->client)){ $transfer_in->where('client',$request->client); } if(!empty($request->from)){ $transfer_in->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $transfer_in->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $transfer_in = $transfer_in->get(); $transfer_in = json_decode(json_encode($transfer_in),true); $this->data["pageData"] = $transfer_in; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_status"] = $request->status; $this->data["search_currency"] = $request->currency; $this->data["search_convert_currency"] = $request->convert_currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'mod_trans_in_view_title'); $this->data["pageToLoad"] = "transfer_in/view.php"; $this->data["activeLink"] = "transfer_new"; $this->load_view($this->data); } public function invoice(Request $request,$uid) { if(is_customer_user() === false){ if(check_user_access('invoice_transfer_in_ph') === FALSE){ Redirect::to('/')->send(); } } $this->data["invoice_data"] = fetch_table_where('transfer_in','uid',$uid,true); $this->data["items"] = set_array_keys(fetch_table('items'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_trans_in_invoice_title'); $this->data["pageToLoad"] = "transfer_in/invoice.php"; $this->data["activeLink"] = "transfer_new"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_transfer_in_ph') === FALSE){ Redirect::to('/')->send(); } $batch_valid = array(); $batch_wise_stock = std_obj_to_array(DB::table('batch_wise_stock')->select('batch','item')->distinct()->get()); foreach($batch_wise_stock as $_batch) { $batch_valid[$_batch['batch']] = $_batch['item']; } $batch_valid = json_encode($batch_valid); $this->data["batch_valid"] = $batch_valid; $this->data["items"] = fetch_table_branch('items'); $this->data["invoice_number"] = get_transfer_in_invoice_number(); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["warehouse"] = fetch_table_branch('warehouse'); $this->data["batch"] = fetch_table_branch('batch'); $this->data["clients"] = fetch_all_clients(); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'mod_trans_in_add_title'); $this->data["pageToLoad"] = "transfer_in/add.php"; $this->data["activeLink"] = "transfer_new"; $this->load_view($this->data); } public function save(Request $request) { $items_found = false; $active_branch_id = active_branch_id(); $_items_effected = array(); $purchase_collection_of_items = array(); $purchase_collection_of_items_uid = array(); $purchase_collection_of_warehouses_uid = array(); $purchase_collection_of_batch_uid = array(); $invoice_num = (int)$request->invoice[0]; $invoice_num_exist = DB::table('transfer_in')->where('branch',active_branch_id())->where('invoice',$invoice_num)->get(); if($invoice_num_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => 'Invoice Exist', 'message_body' => 'This invoice number already exist.')); die; } $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); if(count($request->item) > 0) { $items_count = 0; while($items_count < count($request->item)) { if(empty($request->item[$items_count])){ continue; } $items_found = true; $mfg_item = NULL; if(!empty($request->mfg[$items_count])) { $mfg_item = get_true_date($request->mfg[$items_count]); } $expiry_item = NULL; if(!empty($request->expiry[$items_count])) { $expiry_item = get_true_date($request->expiry[$items_count]); } $item_array = array( 'item' => $request->item[$items_count], 'warehouse' => $request->warehouse[$items_count], 'first_cost' => (float)$request->first_cost[$items_count], 'cost' => (float)$request->cost[$items_count], 'qty' => (float)$request->qty[$items_count], 'bonus' => (float)$request->bonus[$items_count], 'unit' => $request->unit[$items_count], 'profit' => (float)$request->profit[$items_count], 'tp' => (float)$request->tp[$items_count], 'batch' => empty($request->batch[$items_count]) ? env('APP_BATCH') : $request->batch[$items_count], 'mfg' => $mfg_item, 'expiry' => $expiry_item, 'sale_price' => (float)$request->sale_price[$items_count], 'discount' => (float)$request->discount[$items_count], 'discount_2' => (float)$request->discount_2[$items_count], 'total' => (float)$request->total[$items_count], ); $purchase_collection_of_items[] = $item_array; $purchase_collection_of_items_uid[] = '-++-'.$request->item[$items_count].'-++-'; $_items_effected[] = $request->item[$items_count]; $purchase_collection_of_warehouses_uid[] = '-++-'.$request->warehouse[$items_count].'-++-'; $purchase_collection_of_batch_uid[] = '-++-'.$request->batch[$items_count].'-++-'; $items_count++; } } if($items_found == true) { $client_old_balance = get_account_balance($request->client[0],$request->currency[0]); $uid = getUniqueId('TRIN', 'transfer_in', 'uid'); $created_at = get_true_date( empty($request->pdate[0]) ? date('Y-m-d') : $request->pdate[0] ); $time_cr = date('H:i:s'); $created_at = $created_at." ".$time_cr; $db_array = array( 'uid' => $uid, 'branch' => $active_branch_id, 'serial_id' => get_serial_id('transfer_in'), 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->client[0], 'old_balance' => $client_old_balance, 'invoice' => $request->invoice[0], 'memo' => $request->memo[0], 'grand_total' => $request->grand_total, 'total_discount_amount' => (float)$request->total_discount_amount, 'total_discount_amount_1' => (float)$request->total_discount_amount_1, 'total_discount_amount_2' => (float)$request->total_discount_amount_2, 'sub_total' => (float)$request->sub_total, 'cash_paid_amount' => (float)$request->paid_amount, 'pending_amount' => (float)$request->pending_amount, 'cash_paid_account' => $request->cash_paid_account, 'items' => json_encode($purchase_collection_of_items), 'items_uid' => implode(',', $purchase_collection_of_items_uid), 'warehouses_uid' => implode(',', $purchase_collection_of_warehouses_uid), 'batch_uid' => implode(',', $purchase_collection_of_batch_uid), 'created_at' => $created_at, ); insert_table('transfer_in',$db_array); _handle_transfer_in_ledger_effects(['uid' => $uid, 'state' => 'new']); _handle_items_inventory_stats_from_transfer_in(['uid' => $uid, 'entry_status' => 'new']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_transfer_in'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/transfer-in/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['grand_total']), ); set_activity_alert($_activity_details); $invoice_url = url('/transfer-in/invoice').'/'.$uid; $invoice_number = get_transfer_in_invoice_number(); echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_url' => $invoice_url, 'invoice_number' => $invoice_number, 'message_head' => print_lang($this->data["app_lang"],'mod_trans_in_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_trans_in_save_successfully'))); } else { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'item_not_found'), 'message_body' => print_lang($this->data["app_lang"],'add_items_to_proceed'))); } } public function edit(Request $request, $uid) { if(check_user_access('edit_transfer_in_ph') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('transfer_in','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/transfer_in')->send(); } $batch_valid = array(); $batch_wise_stock = std_obj_to_array(DB::table('batch_wise_stock')->select('batch','item')->distinct()->get()); foreach($batch_wise_stock as $_batch) { $batch_valid[$_batch['batch']] = $_batch['item']; } $batch_valid = json_encode($batch_valid); $this->data["batch_valid"] = $batch_valid; $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["currencies"] = fetch_currencies(); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["batch"] = set_array_keys(fetch_table_branch('batch'),'uid'); $this->data["clients"] = fetch_all_clients(); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["accounts"] = fetch_nested_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'mod_trans_in_edit_title'); $this->data["pageToLoad"] = "transfer_in/edit.php"; $this->data["activeLink"] = "transfer_new"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_found = false; $active_branch_id = active_branch_id(); $_items_effected = array(); $purchase_collection_of_items = array(); $purchase_collection_of_items_uid = array(); $purchase_collection_of_warehouses_uid = array(); $purchase_collection_of_batch_uid = array(); $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); if(count($request->item) > 0) { $items_count = 0; while($items_count < count($request->item)) { if(empty($request->item[$items_count])){ continue; } $items_found = true; $mfg_item = NULL; if(!empty($request->mfg[$items_count])) { $mfg_item = get_true_date($request->mfg[$items_count]); } $expiry_item = NULL; if(!empty($request->expiry[$items_count])) { $expiry_item = get_true_date($request->expiry[$items_count]); } $item_array = array( 'item' => $request->item[$items_count], 'warehouse' => $request->warehouse[$items_count], 'first_cost' => (float)$request->first_cost[$items_count], 'discount' => (float)$request->discount[$items_count], 'discount_2' => (float)$request->discount_2[$items_count], 'cost' => (float)$request->cost[$items_count], 'qty' => (float)$request->qty[$items_count], 'bonus' => (float)$request->bonus[$items_count], 'unit' => $request->unit[$items_count], 'profit' => (float)$request->profit[$items_count], 'tp' => (float)$request->tp[$items_count], 'batch' => empty($request->batch[$items_count]) ? env('APP_BATCH') : $request->batch[$items_count], 'mfg' => $mfg_item, 'expiry' => $expiry_item, 'sale_price' => (float)$request->sale_price[$items_count], 'total' => (float)$request->total[$items_count], 'first_cost' => (float)$request->first_cost[$items_count], 'discount' => (float)$request->discount[$items_count], 'discount_2' => (float)$request->discount_2[$items_count], ); $purchase_collection_of_items[] = $item_array; $purchase_collection_of_items_uid[] = '-++-'.$request->item[$items_count].'-++-'; $_items_effected[] = $request->item[$items_count]; $purchase_collection_of_warehouses_uid[] = '-++-'.$request->warehouse[$items_count].'-++-'; $purchase_collection_of_batch_uid[] = '-++-'.$request->batch[$items_count].'-++-'; $items_count++; } } if($items_found == true) { $last_purchase = fetch_table_where('transfer_in','uid',$uid,true); $last_created_at = $last_purchase['created_at']; $last_time = date("H:i:s",strtotime($last_created_at)); $created_at = get_true_date( empty($request->pdate[0]) ? date('Y-m-d') : $request->pdate[0] ); $created_at = $created_at." ".$last_time; $db_array = array( 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->client[0], 'invoice' => $request->invoice[0], 'memo' => $request->memo[0], 'grand_total' => $request->grand_total, 'total_discount_amount' => (float)$request->total_discount_amount, 'total_discount_amount_1' => (float)$request->total_discount_amount_1, 'total_discount_amount_2' => (float)$request->total_discount_amount_2, 'sub_total' => (float)$request->sub_total, 'cash_paid_amount' => (float)$request->paid_amount, 'pending_amount' => (float)$request->pending_amount, 'cash_paid_account' => $request->cash_paid_account, 'items' => json_encode($purchase_collection_of_items), 'items_uid' => implode(',', $purchase_collection_of_items_uid), 'warehouses_uid' => implode(',', $purchase_collection_of_warehouses_uid), 'batch_uid' => implode(',', $purchase_collection_of_batch_uid), 'created_at' => $created_at, ); $transfer_in_before_update = fetch_table_where('transfer_in','uid',$uid,true); update_table('transfer_in','uid',$uid,$db_array); _handle_items_inventory_stats_from_transfer_in(['uid' => $uid, 'entry_status' => 'update']); $transfer_in_items_before_update = empty($transfer_in_before_update['items']) ? array() : json_decode($transfer_in_before_update['items'],true); if(!empty($transfer_in_items_before_update)) { foreach($transfer_in_items_before_update as $old_item) { if(!empty($old_item['item'])) { _calculate_item_wise_stats(['item' => $old_item['item']]); } } } _handle_transfer_in_ledger_effects(['uid' => $uid, 'state' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_transfer_in'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/transfer-in/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['grand_total']), ); set_activity_alert($_activity_details); $invoice_url = url('/transfer-in/invoice').'/'.$uid; echo json_encode(array('status' => 'success', 'mood' => 'update', 'invoice_url' => $invoice_url, 'message_head' => print_lang($this->data["app_lang"],'mod_trans_in_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_trans_in_update_successfully'))); } else { echo json_encode(array('status' => 'error', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'item_not_found'), 'message_body' => print_lang($this->data["app_lang"],'add_items_to_proceed'))); } } public function delete($uid) { if(check_user_access('delete_transfer_in_ph') === FALSE){ Redirect::to('/')->send(); } $transfer_in_before_update = fetch_table_where('transfer_in','uid',$uid,true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_transfer_in'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$transfer_in_before_update['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($transfer_in_before_update['grand_total']), ); set_activity_alert($_activity_details); delete_table('transfer_in','uid',$uid); _handle_transfer_in_ledger_effects(['uid' => $uid, 'state' => 'delete']); _handle_items_inventory_stats_from_transfer_in(['uid' => $uid, 'entry_status' => 'delete']); $transfer_in_items_before_update = empty($transfer_in_before_update['items']) ? array() : json_decode($transfer_in_before_update['items'],true); if(!empty($transfer_in_items_before_update)) { foreach($transfer_in_items_before_update as $old_item) { if(!empty($old_item['item'])) { _calculate_item_wise_stats(['item' => $old_item['item']]); } } } echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }