<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; class Transfer_out extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_transfer_out_ph') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $transfer_out = DB::table('transfer_out')->where('branch',$branch_id); if(!empty($request->currency)){ $transfer_out->where('currency',$request->currency); } if(!empty($request->client)){ $transfer_out->where('client',$request->client); } if(!empty($request->from)){ $transfer_out->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $transfer_out->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $transfer_out = $transfer_out->get(); $transfer_out = json_decode(json_encode($transfer_out),true); $this->data["pageData"] = $transfer_out; $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["search_status"] = $request->status; $this->data["search_currency"] = $request->currency; $this->data["search_convert_currency"] = $request->convert_currency; $this->data["search_client"] = $request->client; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'mod_trans_out_view_title'); $this->data["pageToLoad"] = "transfer_out/view.php"; $this->data["activeLink"] = "transfer_new"; $this->load_view($this->data); } public function invoice(Request $request, $uid) { if(is_customer_user() === false){ if(check_user_access('invoice_transfer_out_ph') === FALSE){ Redirect::to('/')->send(); } } $this->data["invoice_data"] = fetch_table_where('transfer_out','uid',$uid,true); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["clients"] = set_array_keys(fetch_all_clients(),'uid'); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_trans_out_invoice_title'); $this->data["pageToLoad"] = 'transfer_out/invoice.php'; $this->data["activeLink"] = "transfer_out"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_transfer_out_ph') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["invoice_number"] = get_transfer_out_invoice_number(); $this->data["is_marketer"] = get_active_marketer(); $this->data["marketers"] = fetch_table_branch('marketers'); $this->data["clients"] = fetch_all_clients(); $this->data["accounts"] = fetch_nested_accounts(); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["items"] = fetch_table_branch('items'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_trans_out_add_title'); $this->data["pageToLoad"] = "transfer_out/add.php"; $this->data["activeLink"] = "transfer_new"; $this->load_view($this->data); } public function save(Request $request) { $items_details = array(); $_items_effected = array(); $items = array(); $warehouse = array(); $batch = array(); $sic = 0; $invoice_num = (int)$request->invoice[0]; $invoice_num_exist = DB::table('transfer_out')->where('branch',active_branch_id())->where('invoice',$invoice_num)->get(); if($invoice_num_exist->count() > 0) { echo json_encode(array('status' => 'error', 'mood' => 'new', 'message_head' => 'Invoice Exist', 'message_body' => 'This invoice number already exist.')); die; } while($sic < count($request->item)) { if(empty($request->item[$sic])){ $sic++; continue; } $items_details[] = array( 'item' => $request->item[$sic], 'warehouse' => $request->warehouse[$sic], 'batch' => $request->batch[$sic], 'mfg' => $request->mfg[$sic], 'expiry' => $request->expiry[$sic], 'narration' => $request->narration[$sic], 'cost' => (float)$request->cost[$sic], 'sale_price' => (float)$request->sale_price[$sic], 'qty' => (float)$request->qty[$sic], 'bonus' => (float)$request->bonus[$sic], 'unit' => $request->unit[$sic], 'discount' => (float)$request->discount[$sic], 'discount_2' => (float)$request->discount_2[$sic], 'profit' => (float)$request->profit[$sic], 'item_total' => (float)$request->item_total[$sic], ); $_items_effected[] = $request->item[$sic]; $items[] = '-++-'.$request->item[$sic].'-++-'; $warehouse[] = '-++-'.$request->warehouse[$sic].'-++-'; $batch[] = '-++-'.$request->batch[$sic].'-++-'; $sic++; } $uid = getUniqueId('TRNOUT', 'transfer_out', 'uid'); $client_old_balance = get_account_balance($request->client[0],$request->currency[0]); $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); $marketer_db_data = fetch_table_where('marketers','uid',$request->marketer[0],true); if(empty($marketer_db_data)) { $marketer_db_data['commission'] = null; } $created_at = get_true_date( empty($request->sdate[0]) ? date('y-m-d') : $request->sdate[0] ); $time_cr = date('H:i:s'); $created_at = $created_at." ".$time_cr; $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'serial_id' => get_serial_id('transfer_out'), 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->client[0], 'old_balance' => $client_old_balance, 'marketer' => $request->marketer[0], 'marketer_commission' => (float)$marketer_db_data['commission'], 'invoice' => $invoice_num, 'memo' => $request->memo[0], 'grand_total' => (float)$request->grand_total, 'total_discount_amount' => (float)$request->total_discount_amount, 'total_discount_amount_1' => (float)$request->total_discount_amount_1, 'total_discount_amount_2' => (float)$request->total_discount_amount_2, 'profit' => (float)$request->total_profit, 'gross_total_amount' => (float)$request->gross_total_amount, 'items' => json_encode($items_details), 'items_uid' => implode(',', $items), 'warehouses_uid' => implode(',', $warehouse), 'batch_uid' => implode(',', $batch), 'cash_received' => $request->cash_received, 'cash_received_account' => $request->cash_received_account, 'pending_amount' => $request->pending_amount, 'created_at' => $created_at, ); insert_table('transfer_out',$db_array); _handle_transfer_out_ledger_effects(['uid' => $uid, 'state' => 'new']); _handle_items_inventory_stats_from_transfer_out(['uid' => $uid, 'entry_status' => 'new']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_transfer_out'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/transfer-out/edit/'.$db_array['uid'], 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['gross_total_amount']), ); set_activity_alert($_activity_details); $invoice_url = url('/transfer-out/invoice').'/'.$uid; $invoice_number = get_transfer_out_invoice_number(); echo json_encode(array('status' => 'success', 'mood' => 'new', 'invoice_url' => $invoice_url, 'invoice_number' => $invoice_number, 'message_head' => print_lang($this->data["app_lang"],'mod_trans_out_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_trans_out_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_transfer_out_ph') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('transfer_out','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/transfer-out')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["is_marketer"] = get_active_marketer(); $this->data["marketers"] = fetch_table_branch('marketers'); $this->data["clients"] = fetch_all_clients(); $this->data["accounts"] = fetch_nested_accounts(); $this->data["units"] = set_array_keys(fetch_table('units'),'uid'); $this->data["items"] = set_array_keys(fetch_table_branch('items'),'uid'); $this->data["warehouse"] = set_array_keys(fetch_table_branch('warehouse'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_trans_out_edit_title'); $this->data["pageToLoad"] = "transfer_out/edit.php"; $this->data["activeLink"] = "transfer_new"; $this->load_view($this->data); } public function update(Request $request, $uid) { $items_details = array(); $_items_effected = array(); $items = array(); $warehouse = array(); $batch = array(); $sic = 0; while($sic < count($request->item)) { if(empty($request->item[$sic])){ $sic++; continue; } $items_details[] = array( 'item' => $request->item[$sic], 'warehouse' => $request->warehouse[$sic], 'batch' => $request->batch[$sic], 'mfg' => $request->mfg[$sic], 'expiry' => $request->expiry[$sic], 'narration' => $request->narration[$sic], 'cost' => (float)$request->cost[$sic], 'sale_price' => (float)$request->sale_price[$sic], 'qty' => (float)$request->qty[$sic], 'bonus' => (float)$request->bonus[$sic], 'discount' => (float)$request->discount[$sic], 'discount_2' => (float)$request->discount_2[$sic], 'unit' => $request->unit[$sic], 'profit' => (float)$request->profit[$sic], 'item_total' => (float)$request->item_total[$sic], ); $_items_effected[] = $request->item[$sic]; $items[] = '-++-'.$request->item[$sic].'-++-'; $warehouse[] = '-++-'.$request->warehouse[$sic].'-++-'; $batch[] = '-++-'.$request->batch[$sic].'-++-'; $sic++; } $currency_db_data = fetch_table_where('currency','uid',$request->currency[0],true); $marketer_db_data = fetch_table_where('marketers','uid',$request->marketer[0],true); if(empty($marketer_db_data)) { $marketer_db_data['commission'] = null; } $last_sale = fetch_table_where('transfer_out','uid',$uid,true); $last_created_at = $last_sale['created_at']; $last_time = date("H:i:s",strtotime($last_created_at)); $created_at = get_true_date( empty($request->sdate[0]) ? date('y-m-d') : $request->sdate[0] ); $created_at = $created_at." ".$last_time; $db_array = array( 'currency' => $request->currency[0], 'currency_usd_equalance' => $currency_db_data['usd_equalance'], 'client' => $request->client[0], 'marketer' => $request->marketer[0], 'marketer_commission' => (float)$marketer_db_data['commission'], 'invoice' => (int)$request->invoice[0], 'memo' => $request->memo[0], 'grand_total' => (float)$request->grand_total, 'total_discount_amount' => (float)$request->total_discount_amount, 'total_discount_amount_1' => (float)$request->total_discount_amount_1, 'total_discount_amount_2' => (float)$request->total_discount_amount_2, 'gross_total_amount' => (float)$request->gross_total_amount, 'profit' => (float)$request->total_profit, 'items' => json_encode($items_details), 'items_uid' => implode(',', $items), 'warehouses_uid' => implode(',', $warehouse), 'batch_uid' => implode(',', $batch), 'cash_received' => $request->cash_received, 'cash_received_account' => $request->cash_received_account, 'pending_amount' => $request->pending_amount, 'created_at' => $created_at, ); $data_before_update = fetch_table_where('transfer_out','uid',$uid,true); update_table('transfer_out','uid',$uid,$db_array); _handle_transfer_out_ledger_effects(['uid' => $uid, 'state' => 'update']); _handle_items_inventory_stats_from_transfer_out(['uid' => $uid, 'entry_status' => 'update']); $transfer_out_items_before_update = empty($data_before_update['items']) ? array() : json_decode($data_before_update['items'],true); if(!empty($transfer_out_items_before_update)) { foreach($transfer_out_items_before_update as $old_item) { if(!empty($old_item['item'])) { _calculate_item_wise_stats(['item' => $old_item['item']]); } } } $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_transfer_out'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/transfer-out/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$db_array['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['gross_total_amount']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_trans_out_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_trans_out_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_transfer_out_ph') === FALSE){ Redirect::to('/')->send(); } $data_before_update = fetch_table_where('transfer_out','uid',$uid,true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_transfer_out'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_invoice').' '.$data_before_update['invoice'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($data_before_update['gross_total_amount']), ); set_activity_alert($_activity_details); delete_table('transfer_out','uid',$uid); _handle_transfer_out_ledger_effects(['uid' => $uid, 'state' => 'delete']); _handle_items_inventory_stats_from_transfer_out(['uid' => $uid, 'entry_status' => 'delete']); $transfer_out_items_before_update = empty($data_before_update['items']) ? array() : json_decode($data_before_update['items'],true); if(!empty($transfer_out_items_before_update)) { foreach($transfer_out_items_before_update as $old_item) { if(!empty($old_item['item'])) { _calculate_item_wise_stats(['item' => $old_item['item']]); } } } echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }