<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Transit extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_transit') === FALSE){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $transit = DB::table('transit')->where('branch',$branch_id); if(!empty($request->currency)){ $transit->where('currency',$request->currency); } if(!empty($request->company)){ $transit->where('company','like','%'.$request->company.'%'); } if(!empty($request->from)){ $transit->where('transit_date','>=',get_true_date($request->from)); } if(!empty($request->to)){ $transit->where('transit_date','<=',get_true_date($request->to)); } $transits = json_decode(json_encode($transit->get()),true); $this->data["pageData"] = fetch_transits_with_stats($transits); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["search_currency"] = $request->currency; $this->data["search_company"] = $request->company; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["title"] = print_lang($this->data["app_lang"],'transit'); $this->data["pageToLoad"] = "transit/view.php"; $this->data["activeLink"] = "transit"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_transit') === FALSE){ Redirect::to('/')->send(); } $this->data["currencies"] = fetch_currencies(); $this->data["accounts"] = fetch_table_where_branch('accounts','type','transit'); $this->data["transit_serial"] = get_transit_id(); $this->data["title"] = print_lang($this->data["app_lang"],'new_transit'); $this->data["pageToLoad"] = "transit/add.php"; $this->data["activeLink"] = "transit"; $this->load_view($this->data); } public function save(Request $request) { $transit_date = $request->transit_date[0]; $base_currency = $request->base_currency[0]; $base_currency_usd_equalance = $request->base_currency_usd_equalance[0]; $serial_num = $request->serial_num[0]; $builty_num = $request->builty_num[0]; $company = $request->company[0]; $data_for_serial_num = DB::table('transit')->where('serial_num',$serial_num)->get(); if($data_for_serial_num->count() > 0){ $serial_num = get_transit_id(); } $transit_accounts_info = array(); $transit_accounts = array(); $transit_accounts_posted = $request->account; $tcount = 0; foreach($transit_accounts_posted as $row) { $transit_accounts[] = '-++-'.$request->account[$tcount].'-++-'; $transit_accounts_info[] = array( 'account' => $request->account[$tcount], 'currency' => $request->currency[$tcount], 'rate' => $request->rate[$tcount], 'rate_type' => $request->rate_type[$tcount], 'amount' => $request->amount[$tcount], 'by_base_currency' => $request->by_base_currency[$tcount], 'expense_narration' => $request->expense_narration[$tcount], ); $tcount++; } $uid = getUniqueId('TRST', 'transit', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $base_currency, 'currency_usd_equalance' => $base_currency_usd_equalance, 'transit_date' => get_true_date($transit_date), 'serial_num' => $serial_num, 'builty_num' => $builty_num, 'company' => $company, 'accounts_info' => json_encode($transit_accounts_info), 'accounts' => implode(',',$transit_accounts), 'total_exp' => (float)$request->total_amount_by_base_currency, ); insert_table('transit',$db_array); _handle_transit_ledger_effects(['uid' => $uid, 'state' => 'new']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_transit'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_added'), 'url' => '/transit/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_builty').' '.$db_array['builty_num'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['total_exp']), ); set_activity_alert($_activity_details); $serial_num = get_transit_id(); echo json_encode(array('status' => 'success', 'mood' => 'new', 'serial_num' => $serial_num, 'message_head' => print_lang($this->data["app_lang"],'transit_saved'), 'message_body' => print_lang($this->data["app_lang"],'transit_saved_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_transit') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('transit','uid',$uid,true); if(!is_array($this->data["editing_data"])){ Redirect::to('/transit')->send(); } $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["accounts"] = set_array_keys(fetch_table_where_branch('accounts','type','transit'),'uid'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_transit'); $this->data["pageToLoad"] = "transit/edit.php"; $this->data["activeLink"] = "transit"; $this->load_view($this->data); } public function update(Request $request, $uid) { $base_currency = $request->base_currency[0]; $base_currency_usd_equalance = $request->base_currency_usd_equalance[0]; $transit_date = $request->transit_date[0]; $serial_num = $request->serial_num[0]; $builty_num = $request->builty_num[0]; $company = $request->company[0]; $transit_accounts_info = array(); $transit_accounts = array(); $transit_accounts_posted = $request->account; $tcount = 0; foreach($transit_accounts_posted as $row) { $transit_accounts[] = '-++-'.$request->account[$tcount].'-++-'; $transit_accounts_info[] = array( 'account' => $request->account[$tcount], 'currency' => $request->currency[$tcount], 'rate' => $request->rate[$tcount], 'rate_type' => $request->rate_type[$tcount], 'amount' => $request->amount[$tcount], 'by_base_currency' => $request->by_base_currency[$tcount], 'expense_narration' => $request->expense_narration[$tcount], ); $tcount++; } $db_array = array( 'currency' => $base_currency, 'currency_usd_equalance' => $base_currency_usd_equalance, 'transit_date' => get_true_date($transit_date), 'builty_num' => $builty_num, 'company' => $company, 'accounts_info' => json_encode($transit_accounts_info), 'accounts' => implode(',',$transit_accounts), 'total_exp' => (float)$request->total_amount_by_base_currency, ); update_table('transit','uid',$uid,$db_array); _handle_transit_ledger_effects(['uid' => $uid, 'state' => 'update']); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_transit'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_update'), 'url' => '/transit/edit/'.$uid, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_builty').' '.$db_array['builty_num'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($db_array['total_exp']), ); set_activity_alert($_activity_details); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'transit_updated'), 'message_body' => print_lang($this->data["app_lang"],'transit_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_transit') === FALSE){ Redirect::to('/')->send(); } $transit_data = fetch_table_where('transit','uid',$uid,true); $_activity_details = array( 'module' => print_lang($this->data["app_lang"],'dashboard_activities_module_text_transit'), 'activity' => print_lang($this->data["app_lang"],'dashboard_activities_text_delete'), 'url' => NULL, 'details' => print_lang($this->data["app_lang"],'dashboard_activities_text_builty').' '.$transit_data['builty_num'].', '.print_lang($this->data["app_lang"],'dashboard_activities_text_amount').': '.amount_number_format($transit_data['total_exp']), ); set_activity_alert($_activity_details); delete_table('transit','uid',$uid); _handle_transit_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }