<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Turnover extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_turnover') === FALSE){ Redirect::to('/')->send(); } $this->data["pageData"] = fetch_table_branch('turnover'); $this->data["title"] = print_lang($this->data["app_lang"],'mod_turnover_view_title'); $this->data["pageToLoad"] = "turnover/view.php"; $this->data["activeLink"] = "turnover"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_turnover') === FALSE){ Redirect::to('/')->send(); } $active_branch_id = active_branch_id(); $item_settings = get_item_settings(); $currencies = fetch_currencies(); $calander_db = fetch_calander_name(); if(empty($request->from)){ $request->from = date('Y-m-d'); if($calander_db == 'persian'){ $request->from = get_persian_date(date('Y/m/d')); } } if(empty($request->to)){ $request->to = date('Y-m-d'); if($calander_db == 'persian'){ $request->to = get_persian_date(date('Y/m/d')); } } if(empty($request->currency)){ $request->currency = 'usd'; } $requested_currency_data = fetch_table_where('currency','uid',$request->currency,true); $requested_currency_data_usd_equalance = isset($requested_currency_data['usd_equalance']) ? (float)$requested_currency_data['usd_equalance'] : 1; $earnings_all_in_main_currency = array(); $other_income_all_in_main_currency = array(); $sales_all_in_main_currency = array(); $services_all_in_main_currency = array(); $lots_sales_all_in_main_currency = array(); $cars_sales_all_in_main_currency = array(); $salaries_all_in_main_currency = array(); $types_wise_expenses = array(); $types_wise_assets = array(); $expenses_all_in_main_currency = array(); $assets_all_in_main_currency = array(); $account_types = null; foreach($currencies as $currency) { $shared_uids_currencies = std_obj_to_array(DB::table('currency')->where('branch_equalance',$currency['branch_equalance'])->pluck('uid')->toArray()); $lots_profits = DB::table('lot_sold')->where('branch',active_branch_id())->select((DB::raw('sum(total_profit) as balance, sum(gross_amount) as lot_sold_amount')))->whereIn('currency',$shared_uids_currencies); if(!empty($request->from)){ $lots_profits->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $lots_profits->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $lots_profits = $lots_profits->get()->first(); $lots_profits_balance = $lots_profits->balance; $lot_sold_amount = $lots_profits->lot_sold_amount; $net_lot_sold_amount = $lot_sold_amount - $lots_profits_balance; $earnings_all_in_main_currency[] = amount_conversion($lots_profits_balance, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $lots_sales_all_in_main_currency[] = amount_conversion($net_lot_sold_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $cars_profit = DB::table('showroom_sales')->where('branch',active_branch_id())->select((DB::raw('sum(profit) as balance, sum(gross_total) as cars_sold_amount')))->whereIn('currency',$shared_uids_currencies); if(!empty($request->from)){ $cars_profit->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $cars_profit->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $cars_profit = $cars_profit->get()->first(); $cars_profit_balance = $cars_profit->balance; $cars_sold_amount = $cars_profit->cars_sold_amount; $net_cars_sold_amount = $cars_sold_amount - $cars_profit_balance; $earnings_all_in_main_currency[] = amount_conversion($cars_profit_balance, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $cars_sales_all_in_main_currency[] = amount_conversion($net_cars_sold_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $transfer_out_profit = DB::table('transfer_out')->where('branch',active_branch_id())->select((DB::raw('sum(profit) as balance')))->whereIn('currency',$shared_uids_currencies); if(!empty($request->from)){ $transfer_out_profit->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $transfer_out_profit->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $transfer_out_profit = $transfer_out_profit->get()->first(); $transfer_out_profit_balance = $transfer_out_profit->balance; $earnings_all_in_main_currency[] = amount_conversion($transfer_out_profit_balance, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $sales_profit = DB::table('sales')->where('branch',active_branch_id())->select((DB::raw('sum(total_profit_amount) as balance, sum(gross_total_amount) as sales_amount')))->whereIn('currency',$shared_uids_currencies); if(!empty($request->from)){ $sales_profit->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $sales_profit->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $sales_profit = $sales_profit->get()->first(); $sales_profit_balance = $sales_profit->balance; $sales_total_amount = $sales_profit->sales_amount; $sales_return_profit = DB::table('sales_return')->where('branch',active_branch_id())->select((DB::raw('sum(total_profit_amount) as balance, sum(refund_total) as return_amount')))->whereIn('currency',$shared_uids_currencies); if(!empty($request->from)){ $sales_return_profit->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $sales_return_profit->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $sales_return_profit = $sales_return_profit->get()->first(); $sales_return_profit_balance = $sales_return_profit->balance; $sales_return_amount = $sales_return_profit->return_amount; $net_sales_profit = $sales_profit_balance - $sales_return_profit_balance; $net_sales_amount = $sales_total_amount - $sales_return_amount - $net_sales_profit; $earnings_all_in_main_currency[] = amount_conversion($net_sales_profit, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $sales_all_in_main_currency[] = amount_conversion($net_sales_amount, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $other_income = DB::table('extra_income')->where('branch',active_branch_id())->select((DB::raw('sum(amount) as balance')))->whereIn('currency',$shared_uids_currencies); if(!empty($request->from)){ $other_income->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $other_income->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $other_income = $other_income->get()->first(); $other_income_balance = $other_income->balance; $other_income_all_in_main_currency[] = amount_conversion($other_income_balance, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $services = DB::table('services')->where('branch',active_branch_id())->select((DB::raw('sum(gross_total) as balance')))->whereIn('currency',$shared_uids_currencies); if(!empty($request->from)){ $services->where('service_date','>=',get_true_date($request->from)); } if(!empty($request->to)){ $services->where('service_date','<=',get_true_date($request->to)); } $services = $services->get()->first(); $services_balance = $services->balance; $services_all_in_main_currency[] = amount_conversion($services_balance, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $expenses = DB::table('expenses')->where('branch',active_branch_id())->select((DB::raw('sum(amount) as balance')))->whereIn('currency',$shared_uids_currencies); if(!empty($request->from)){ $expenses->where('exp_date','>=',get_true_date($request->from)); } if(!empty($request->to)){ $expenses->where('exp_date','<=',get_true_date($request->to)); } $expenses = $expenses->get()->first(); $expenses_balance = $expenses->balance; $expenses_all_in_main_currency[] = amount_conversion($expenses_balance, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $assets = DB::table('assets')->where('branch',active_branch_id())->select((DB::raw('sum(total) as balance')))->whereIn('currency',$shared_uids_currencies); if(!empty($request->from)){ $assets->where('created_at','>=',get_true_date($request->from).' 00:00:00'); } if(!empty($request->to)){ $assets->where('created_at','<=',get_true_date($request->to).' 23:59:59'); } $assets = $assets->get()->first(); $assets_balance = $assets->balance; $assets_all_in_main_currency[] = amount_conversion($assets_balance, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); $payslips = DB::table('payslips')->where('branch',active_branch_id())->select((DB::raw('sum(net_salary) as balance')))->where('status','confirmed')->whereIn('currency',$shared_uids_currencies); if(!empty($request->from)){ $payslips->where('pay_date','>=',get_true_date($request->from)); } if(!empty($request->to)){ $payslips->where('pay_date','<=',get_true_date($request->to)); } $payslips = $payslips->get()->first(); $payslips_balance = $payslips->balance; $advances = DB::table('advances')->where('branch',active_branch_id())->select((DB::raw('sum(new_advance) as balance')))->whereIn('currency',$shared_uids_currencies); if(!empty($request->from)){ $advances->where('advance_date','>=',get_true_date($request->from)); } if(!empty($request->to)){ $advances->where('advance_date','<=',get_true_date($request->to)); } $advances = $advances->get()->first(); $advances_balance = $advances->balance; $net_salaries = $payslips_balance + $advances_balance; $salaries_all_in_main_currency[] = amount_conversion($net_salaries, (float)$currency['usd_equalance'], $requested_currency_data_usd_equalance); } $data_bucket['earnings_all_in_main_currency'] = array_sum($earnings_all_in_main_currency); $data_bucket['other_income_all_in_main_currency'] = array_sum($other_income_all_in_main_currency); $data_bucket['sales_all_in_main_currency'] = array_sum($sales_all_in_main_currency); $data_bucket['services_all_in_main_currency'] = array_sum($services_all_in_main_currency); $data_bucket['lots_sales_all_in_main_currency'] = array_sum($lots_sales_all_in_main_currency); $data_bucket['cars_sales_all_in_main_currency'] = array_sum($cars_sales_all_in_main_currency); $data_bucket['costs_of_goods_sold'] = array_sum($sales_all_in_main_currency); $data_bucket['salaries_all_in_main_currency'] = array_sum($salaries_all_in_main_currency); $data_bucket['expenses_all_in_main_currency'] = array_sum($expenses_all_in_main_currency); $data_bucket['assets_all_in_main_currency'] = array_sum($assets_all_in_main_currency); $this->data["pageData"] = $data_bucket; $this->data["shareholders"] = fetch_table_branch('shareholder'); $this->data["currencies"] = $currencies; $this->data["search_currency"] = $request->currency; $this->data["search_from"] = $request->from; $this->data["search_to"] = $request->to; $this->data["requested_currency_data"] = $requested_currency_data; $this->data["title"] = print_lang($this->data["app_lang"],'mod_turnover_add_breadcrumb'); $this->data["pageToLoad"] = "turnover/add.php"; $this->data["activeLink"] = "turnover"; $this->load_view($this->data); } public function save(Request $request) { $uid = getUniqueId('TRN', 'turnover', 'uid'); $currency_data = fetch_table_where('currency','uid',$request->currency,true); $currency_name = isset($currency_data['name']) ? $currency_data['name'] : null; $currency_symbol = isset($currency_data['symbol']) ? $currency_data['symbol'] : null; $currency_usd_equalance = isset($currency_data['usd_equalance']) ? $currency_data['usd_equalance'] : null; $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'currency' => $request->currency, 'currency_name' => $currency_name, 'currency_symbol' => $currency_symbol, 'currency_usd_equalance' => $currency_usd_equalance, 'from' => get_true_date($request->from_date), 'to' => get_true_date($request->to_date), 'sales_income' => $request->sales_income, 'services_income' => $request->services_income, 'other_income' => $request->other_income, 'total_revenue' => $request->total_revenue, 'salaries' => $request->salaries, 'costs_of_goods_sold' => $request->costs_of_goods_sold, 'expenses' => $request->expenses, 'assets' => $request->assets, 'total_expenses' => $request->total_expenses, 'net_income' => $request->net_income, ); if(!empty($request->shareholder)) { foreach($request->shareholder as $key => $row) { $shareholder_data = fetch_table_where('shareholder','uid',$row,true); $shareholder_first_name = isset($shareholder_data['name']) ? $shareholder_data['name'] : null; $shareholder_last_name = isset($shareholder_data['last_name']) ? $shareholder_data['last_name'] : null; $shareholder_name = $shareholder_first_name.' '.$shareholder_last_name; $t_uid = getUniqueId('TRNDT', 'turnover_details', 'uid'); $details_db_array = array( 'uid' => $t_uid, 'turnover_id' => $uid, 'branch' => active_branch_id(), 'currency' => $request->currency, 'currency_name' => $currency_name, 'currency_symbol' => $currency_symbol, 'currency_usd_equalance' => $currency_usd_equalance, 'from' => get_true_date($request->from_date), 'to' => get_true_date($request->to_date), 'sales_income' => $request->sales_income, 'services_income' => $request->services_income, 'other_income' => $request->other_income, 'total_revenue' => $request->total_revenue, 'salaries' => $request->salaries, 'costs_of_goods_sold' => $request->costs_of_goods_sold, 'expenses' => $request->expenses, 'assets' => $request->assets, 'total_expenses' => $request->total_expenses, 'net_income' => $request->net_income, 'shareholder' => $row, 'shareholder_name' => $shareholder_name, 'percentage' => isset($request->percentage[$key]) ? (float)$request->percentage[$key] : 0, 'amount' => isset($request->amount[$key]) ? (float)$request->amount[$key] : 0, ); insert_table('turnover_details',$details_db_array); } } insert_table('turnover',$db_array); _handle_turnover_ledger_effects(['uid' => $uid, 'state' => 'new']); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'mod_turnover_added'), 'message_body' => print_lang($this->data["app_lang"],'mod_turnover_save_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_turnover') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('turnover','uid',$uid,true); $this->data["title"] = print_lang($this->data["app_lang"],'mod_turnover_edit_title'); $this->data["pageToLoad"] = "turnover/edit.php"; $this->data["activeLink"] = "turnover"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'last_name' => 'required', 'nic' => 'required', 'address' => 'required', ]); $validator->validate(); $db_array = array( 'name' => $request->name, 'last_name' => $request->last_name, 'mobile' => $request->mobile, 'nic' => $request->nic, 'address' => $request->address, 'comments' => $request->comments, ); update_table('turnover','uid',$uid,$db_array); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'mod_turnover_update'), 'message_body' => print_lang($this->data["app_lang"],'mod_turnover_update_successfully'))); } public function delete($uid) { if(check_user_access('delete_turnover') === FALSE){ Redirect::to('/')->send(); } delete_table('turnover','uid',$uid); delete_table('turnover_details','turnover_id',$uid); _handle_turnover_ledger_effects(['uid' => $uid, 'state' => 'delete']); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }