<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; class Units extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_units') === FALSE){ Redirect::to('/')->send(); } $this->data["pageData"] = fetch_table('units'); $this->data["title"] = print_lang($this->data["app_lang"],'units'); $this->data["pageToLoad"] = "units/view.php"; $this->data["activeLink"] = "units"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_units') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'add_unit'); $this->data["pageToLoad"] = "units/add.php"; $this->data["activeLink"] = "units"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'short' => 'required', ]); $validator->validate(); $uid = getUniqueId('UNIT', 'units', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $request->name, 'short' => $request->short, ); insert_table('units',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'unit_created'), 'message_body' => print_lang($this->data["app_lang"],'new_unit_created_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_units') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('units','uid',$uid,true); $this->data["title"] = print_lang($this->data["app_lang"],'unit_edit'); $this->data["pageToLoad"] = "units/edit.php"; $this->data["activeLink"] = "units"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'short' => 'required', ]); $validator->validate(); $db_array = array( 'name' => $request->name, 'short' => $request->short, ); update_table('units','uid',$uid,$db_array); update_table('items','purchase_unit',$uid,['purchase_unit_name' => $request->name]); update_table('items','sale_unit',$uid,['sale_unit_name' => $request->name]); update_table('items','production_unit',$uid,['production_unit_name' => $request->name]); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'unit_updated'), 'message_body' => print_lang($this->data["app_lang"],'unit_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_units') === FALSE){ Redirect::to('/')->send(); } delete_table('units','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }