<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use File; use Hash; use Mail; use View; use Config; use Validator; use Redirect; class Users extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_user') === FALSE){ Redirect::to('/')->send(); } $this->data["pageData"] = std_obj_to_array(DB::table('users')->where('is_customer','no')->where('is_sales_man','no')->get()); $this->data["title"] = print_lang($this->data["app_lang"],'users'); $this->data["pageToLoad"] = "users/view.php"; $this->data["activeLink"] = "users"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_user') === FALSE){ Redirect::to('/')->send(); } $this->data["branches"] = fetch_table('branches'); $this->data["root_accounts"] = fetch_root_accounts(); $this->data["title"] = print_lang($this->data["app_lang"],'add_user'); $this->data["pageToLoad"] = "users/add.php"; $this->data["activeLink"] = "users"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'email' => 'required|unique:users', 'phone' => 'required|numeric', 'username' => 'required|min:3|unique:users', 'password' => 'required|min:3', 'address' => 'required', ]); $validator->sometimes('branch','required',function($input){ if($input->role == 'USER'){ return true; }else{ return false; } } ); $validator->validate(); $uid = getUniqueId('USR', 'users', 'uid'); $hashed_password = Hash::make($request->password); if($request->role == 'ADMIN') { $request->rights = array(); $request->branch = NULL; } else { if($request->rights == NULL){ $request->rights = array(); } } $db_array = array( 'uid' => $uid, 'name' => $request->name, 'email' => $request->email, 'phone' => $request->phone, 'branch' => $request->branch, 'username' => $request->username, 'password' => $hashed_password, 'address' => $request->address, 'role' => $request->role, 'rights' => json_encode($request->rights), ); insert_table('users',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'user_added'), 'message_body' => print_lang($this->data["app_lang"],'new_user_added_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_user') === FALSE){ Redirect::to('/')->send(); } $this->data["user"] = fetch_table_where('users','uid',$uid,true); $this->data["root_accounts"] = fetch_root_accounts(); $this->data["branches"] = fetch_table('branches'); $this->data["title"] = print_lang($this->data["app_lang"],'edit_user'); $this->data["pageToLoad"] = "users/edit.php"; $this->data["activeLink"] = "users"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'email' => ['required','email', Rule::unique('users')->ignore($uid, 'uid')], 'username' => ['required','min:3',Rule::unique('users')->ignore($uid, 'uid')], 'phone' => 'required|numeric', 'address' => 'required', ]); $validator->sometimes('password','min:3',function($input){ return !empty($input->password); } ); $validator->sometimes('branch','required',function($input){ if($input->role == 'USER'){ return true; }else{ return false; } } ); $validator->validate(); if($request->role == 'ADMIN') { $request->rights = array(); $request->branch = NULL; } else { if($request->rights == NULL){ $request->rights = array(); } } $record = fetch_table_where('users','uid',$uid,true); if($record['role'] === 'SUPERADMIN') { $request->role = 'SUPERADMIN'; $request->rights = array(); $request->branch = NULL; } $db_array = array( 'name' => $request->name, 'phone' => $request->phone, 'branch' => $request->branch, 'username' => $request->username, 'email' => $request->email, 'address' => $request->address, 'role' => $request->role, 'rights' => json_encode($request->rights), ); if(!empty($request->password)){ $db_array['password'] = Hash::make($request->password); } update_table('users','uid',$uid,$db_array); update_table('activity_alerts','user',$uid,['user_name' => $db_array['name']]); update_table('purchases','user',$uid,['user_name' => $db_array['name']]); update_table('sales','user',$uid,['user_name' => $db_array['name']]); update_table('sales','sub_approval_user',$uid,['sub_approval_user_name' => $db_array['name']]); update_table('sales','main_approval_user',$uid,['main_approval_user_name' => $db_array['name']]); update_table('purchases','sub_approval_user',$uid,['sub_approval_user_name' => $db_array['name']]); update_table('purchases','main_approval_user',$uid,['main_approval_user_name' => $db_array['name']]); update_table('item_stock_in','sub_approval_user',$uid,['sub_approval_user_name' => $db_array['name']]); update_table('item_stock_in','main_approval_user',$uid,['main_approval_user_name' => $db_array['name']]); update_table('item_stock_out','sub_approval_user',$uid,['sub_approval_user_name' => $db_array['name']]); update_table('item_stock_out','main_approval_user',$uid,['main_approval_user_name' => $db_array['name']]); update_table('journal','sub_approval_user',$uid,['sub_approval_user_name' => $db_array['name']]); update_table('journal','main_approval_user',$uid,['main_approval_user_name' => $db_array['name']]); update_table('expenses','sub_approval_user',$uid,['sub_approval_user_name' => $db_array['name']]); update_table('expenses','main_approval_user',$uid,['main_approval_user_name' => $db_array['name']]); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'user_updated'), 'message_body' => print_lang($this->data["app_lang"],'user_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_user') === FALSE){ Redirect::to('/')->send(); } delete_table('users','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }