<?php
 namespace App\Http\Controllers; use Illuminate\Http\Request; use Illuminate\Support\Facades\DB; use Illuminate\Validation\Rule; use Session; use Validator; use Redirect; use View; class Warehouse extends Setup { public function __construct() { parent::__construct(); } public function view(Request $request) { if(check_user_access('view_warehouse') === FALSE){ Redirect::to('/')->send(); } $this->data["pageData"] = fetch_table_branch('warehouse'); $this->data["title"] = print_lang($this->data["app_lang"],'warehouse'); $this->data["pageToLoad"] = "warehouse/view.php"; $this->data["activeLink"] = "warehouse"; $this->load_view($this->data); } public function details(Request $request, $warehouse) { if(check_user_access('warehouse_details') === FALSE){ Redirect::to('/')->send(); } if(empty($warehouse)){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $transfer_items = DB::table('transfer')->where('branch',$branch_id)->where(function($query) use ($warehouse) { $query->where('sending_warehouse',$warehouse); $query->orWhere('receiving_warehouse',$warehouse); }); $transfer_items = $transfer_items->get(); $transfer_items = json_decode(json_encode($transfer_items),true); $transfer_items = array_column($transfer_items, 'item'); $branch_transfer_in_items = DB::table('branch_transfer_in')->where('branch',$branch_id)->where(function($query) use ($warehouse) { $query->where('to_warehouse',$warehouse); $query->orWhere('from_warehouse',$warehouse); }); $branch_transfer_in_items = $branch_transfer_in_items->get(); $branch_transfer_in_items = json_decode(json_encode($branch_transfer_in_items),true); $branch_transfer_in_items = array_column($branch_transfer_in_items, 'item'); $branch_transfer_out_items = DB::table('branch_transfer_out')->where('branch',$branch_id)->where(function($query) use ($warehouse) { $query->where('warehouse',$warehouse); $query->orWhere('to_warehouse',$warehouse); }); $branch_transfer_out_items = $branch_transfer_out_items->get(); $branch_transfer_out_items = json_decode(json_encode($branch_transfer_out_items),true); $branch_transfer_out_items = array_column($branch_transfer_out_items, 'item'); $purchase_items = DB::table('purchases')->where('branch',$branch_id)->where('warehouses_uid','like','%-++-'.$warehouse.'-++-%')->get(); $purchase_items = json_decode(json_encode($purchase_items),true); foreach($purchase_items as $purchase_item) { $items_uids = explode(',', $purchase_item['items_uid']); foreach($items_uids as $_item_uid) { $transfer_items[] = str_replace('-++-', '', $_item_uid); } } $items = DB::table('items')->where('branch',$branch_id); $purchases = DB::table('purchases')->where('branch',$branch_id); $production = DB::table('production_details')->where('branch',$branch_id); $sales = DB::table('sales')->where('branch',$branch_id); $sales_return = DB::table('sales_return')->where('branch',$branch_id); $transfer_in = DB::table('transfer_in')->where('branch',$branch_id); $transfer_out = DB::table('transfer_out')->where('branch',$branch_id); $branch_to_branch_transfer = DB::table('branch_to_branch_transfer'); $damage = DB::table('damage')->where('branch',$branch_id); $transfer = DB::table('transfer')->where('branch',$branch_id); $branch_transfer_in = DB::table('branch_transfer_in')->where('branch',$branch_id); $branch_transfer_out = DB::table('branch_transfer_out')->where('branch',$branch_id); $expenses_deductions = DB::table('expenses_deductions')->where('branch',$branch_id)->where('expenses_mood','inventory_expenses')->where('status','approved'); $bundle_toop = DB::table('items_bundle_toop_stock')->where('branch',$branch_id); if(!empty($request->category)){ $items->where('category',$request->category); } $items->where(function($query) use ($warehouse,$transfer_items,$branch_transfer_in_items,$branch_transfer_out_items) { $query->where('warehouse',$warehouse); $query->orWhere('warehouse_uids','like','%-++-'.$warehouse.'-++-%'); $query->orWhereIn('uid', $transfer_items); $query->orWhereIn('uid', $branch_transfer_in_items); $query->orWhereIn('uid', $branch_transfer_out_items); }); if(!empty($request->_search)) { $items->where(function($query) use ($request) { $query->where('name','like','%'.$request->_search.'%'); }); } $items = json_decode(json_encode($items->get()),true); $purchases = json_decode(json_encode($purchases->get()),true); $production = json_decode(json_encode($production->get()),true); $sales = json_decode(json_encode($sales->get()),true); $sales_return = json_decode(json_encode($sales_return->get()),true); $transfer_in = json_decode(json_encode($transfer_in->get()),true); $transfer_out = json_decode(json_encode($transfer_out->get()),true); $branch_to_branch_transfer = json_decode(json_encode($branch_to_branch_transfer->get()),true); $damage = json_decode(json_encode($damage->get()),true); $transfer = json_decode(json_encode($transfer->get()),true); $branch_transfer_in = json_decode(json_encode($branch_transfer_in->get()),true); $branch_transfer_out = json_decode(json_encode($branch_transfer_out->get()),true); $expenses_deductions = json_decode(json_encode($expenses_deductions->get()),true); $bundle_toop = json_decode(json_encode($bundle_toop->get()),true); $this->data["pageData"] = get_warehouse_details($warehouse,$items,$purchases,$production,$sales,$sales_return,$transfer_in,$transfer_out,$branch_to_branch_transfer,$damage,$transfer,$branch_transfer_in,$branch_transfer_out,$expenses_deductions,$bundle_toop); $this->data["active_warehouse"] = $warehouse; $this->data["warehouse_data"] = fetch_table_where('warehouse','uid',$warehouse,true); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["product_categories"] = set_array_keys(fetch_table_branch('product_category'),'uid'); $this->data["search_category"] = $request->category; $this->data["search_currency"] = $request->currency; $this->data["search_unit"] = $request->unit; $this->data["_search"] = $request->_search; $this->data["live_search_data"] = 'no'; $this->data["title"] = print_lang($this->data["app_lang"],'warehouse_details'); $this->data["pageToLoad"] = "warehouse/details.php"; $this->data["activeLink"] = "warehouse"; $this->load_view($this->data); } public function details_print(Request $request, $warehouse) { if(check_user_access('warehouse_details') === FALSE){ Redirect::to('/')->send(); } if(empty($warehouse)){ Redirect::to('/')->send(); } $branch_id = active_branch_id(); $transfer_items = DB::table('transfer')->where('branch',$branch_id)->where(function($query) use ($warehouse) { $query->where('sending_warehouse',$warehouse); $query->orWhere('receiving_warehouse',$warehouse); }); $transfer_items = $transfer_items->get(); $transfer_items = json_decode(json_encode($transfer_items),true); $transfer_items = array_column($transfer_items, 'item'); $branch_transfer_in_items = DB::table('branch_transfer_in')->where('branch',$branch_id)->where(function($query) use ($warehouse) { $query->where('to_warehouse',$warehouse); $query->orWhere('from_warehouse',$warehouse); }); $branch_transfer_in_items = $branch_transfer_in_items->get(); $branch_transfer_in_items = json_decode(json_encode($branch_transfer_in_items),true); $branch_transfer_in_items = array_column($branch_transfer_in_items, 'item'); $branch_transfer_out_items = DB::table('branch_transfer_out')->where('branch',$branch_id)->where(function($query) use ($warehouse) { $query->where('warehouse',$warehouse); $query->orWhere('to_warehouse',$warehouse); }); $branch_transfer_out_items = $branch_transfer_out_items->get(); $branch_transfer_out_items = json_decode(json_encode($branch_transfer_out_items),true); $branch_transfer_out_items = array_column($branch_transfer_out_items, 'item'); $purchase_items = DB::table('purchases')->where('branch',$branch_id)->where('warehouses_uid','like','%-++-'.$warehouse.'-++-%')->get(); $purchase_items = json_decode(json_encode($purchase_items),true); foreach($purchase_items as $purchase_item) { $items_uids = explode(',', $purchase_item['items_uid']); foreach($items_uids as $_item_uid) { $transfer_items[] = str_replace('-++-', '', $_item_uid); } } $items = DB::table('items')->where('branch',$branch_id); $purchases = DB::table('purchases')->where('branch',$branch_id); $production = DB::table('production_details')->where('branch',$branch_id); $sales = DB::table('sales')->where('branch',$branch_id); $sales_return = DB::table('sales_return')->where('branch',$branch_id); $transfer_in = DB::table('transfer_in')->where('branch',$branch_id); $transfer_out = DB::table('transfer_out')->where('branch',$branch_id); $branch_to_branch_transfer = DB::table('branch_to_branch_transfer'); $damage = DB::table('damage')->where('branch',$branch_id); $transfer = DB::table('transfer')->where('branch',$branch_id); $branch_transfer_in = DB::table('branch_transfer_in')->where('branch',$branch_id); $branch_transfer_out = DB::table('branch_transfer_out')->where('branch',$branch_id); $expenses_deductions = DB::table('expenses_deductions')->where('branch',$branch_id)->where('expenses_mood','inventory_expenses')->where('status','approved'); $bundle_toop = DB::table('items_bundle_toop_stock')->where('branch',$branch_id); if(!empty($request->category)){ $items->where('category',$request->category); } $items->where(function($query) use ($warehouse,$transfer_items,$branch_transfer_in_items,$branch_transfer_out_items) { $query->where('warehouse',$warehouse); $query->orWhere('warehouse_uids','like','%-++-'.$warehouse.'-++-%'); $query->orWhereIn('uid', $transfer_items); $query->orWhereIn('uid', $branch_transfer_in_items); $query->orWhereIn('uid', $branch_transfer_out_items); }); if(!empty($request->_search)) { $items->where(function($query) use ($request) { $query->where('name','like','%'.$request->_search.'%'); }); } $items = json_decode(json_encode($items->get()),true); $purchases = json_decode(json_encode($purchases->get()),true); $production = json_decode(json_encode($production->get()),true); $sales = json_decode(json_encode($sales->get()),true); $sales_return = json_decode(json_encode($sales_return->get()),true); $transfer_in = json_decode(json_encode($transfer_in->get()),true); $transfer_out = json_decode(json_encode($transfer_out->get()),true); $branch_to_branch_transfer = json_decode(json_encode($branch_to_branch_transfer->get()),true); $damage = json_decode(json_encode($damage->get()),true); $transfer = json_decode(json_encode($transfer->get()),true); $branch_transfer_in = json_decode(json_encode($branch_transfer_in->get()),true); $branch_transfer_out = json_decode(json_encode($branch_transfer_out->get()),true); $expenses_deductions = json_decode(json_encode($expenses_deductions->get()),true); $bundle_toop = json_decode(json_encode($bundle_toop->get()),true); $this->data["pageData"] = get_warehouse_details($warehouse,$items,$purchases,$production,$sales,$sales_return,$transfer_in,$transfer_out,$branch_to_branch_transfer,$damage,$transfer,$branch_transfer_in,$branch_transfer_out,$expenses_deductions,$bundle_toop); $this->data["active_warehouse"] = $warehouse; $this->data["warehouse_data"] = fetch_table_where('warehouse','uid',$warehouse,true); $this->data["units"] = set_array_keys(fetch_table_branch('units'),'uid'); $this->data["currencies"] = set_array_keys(fetch_currencies(),'uid'); $this->data["product_categories"] = set_array_keys(fetch_table_branch('product_category'),'uid'); $this->data["search_category"] = $request->category; $this->data["search_currency"] = $request->currency; $this->data["search_unit"] = $request->unit; $this->data["title"] = print_lang($this->data["app_lang"],'warehouse_details'); $this->data["pageToLoad"] = "warehouse/print.php"; $this->data["activeLink"] = "warehouse"; $this->load_view($this->data); } public function add(Request $request) { if(check_user_access('add_warehouse') === FALSE){ Redirect::to('/')->send(); } $this->data["title"] = print_lang($this->data["app_lang"],'add_warehouse'); $this->data["pageToLoad"] = "warehouse/add.php"; $this->data["activeLink"] = "warehouse"; $this->load_view($this->data); } public function save(Request $request) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'type' => 'required', 'manager' => 'required', 'address' => 'required', ]); $validator->validate(); $uid = getUniqueId('WRHS', 'warehouse', 'uid'); $db_array = array( 'uid' => $uid, 'branch' => active_branch_id(), 'name' => $request->name, 'type' => $request->type, 'manager' => $request->manager, 'address' => $request->address, ); insert_table('warehouse',$db_array); echo json_encode(array('status' => 'success', 'mood' => 'new', 'message_head' => print_lang($this->data["app_lang"],'warehouse_created'), 'message_body' => print_lang($this->data["app_lang"],'new_warehouse_created_successfully'))); } public function edit(Request $request, $uid) { if(check_user_access('edit_warehouse') === FALSE){ Redirect::to('/')->send(); } $this->data["editing_data"] = fetch_table_where('warehouse','uid',$uid,true); $this->data["title"] = print_lang($this->data["app_lang"],'edit_warehouse'); $this->data["pageToLoad"] = "warehouse/edit.php"; $this->data["activeLink"] = "warehouse"; $this->load_view($this->data); } public function update(Request $request, $uid) { $validator = Validator::make($request->request->all(), [ 'name' => 'required', 'type' => 'required', 'manager' => 'required', 'address' => 'required', ]); $validator->validate(); $db_array = array( 'name' => $request->name, 'type' => $request->type, 'manager' => $request->manager, 'address' => $request->address, ); update_table('warehouse','uid',$uid,$db_array); update_table('items','warehouse',$uid,['warehouse_name' => $request->name]); echo json_encode(array('status' => 'success', 'mood' => 'update', 'message_head' => print_lang($this->data["app_lang"],'warehouse_updated'), 'message_body' => print_lang($this->data["app_lang"],'warehouse_updated_successfully'))); } public function delete($uid) { if(check_user_access('delete_warehouse') === FALSE){ Redirect::to('/')->send(); } delete_table('warehouse','uid',$uid); echo json_encode(array('status' => 'success', 'mode' => 'deleted')); } }