

// user performance graph initiator
function init_user_performance_graph(graph_data)
{
    graph_data = JSON.parse(graph_data);
    const monthNames = ["", "Jan", "Feb", "Mar", "Apr", "May", "Jun","Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    Morris.Area({
        element: 'user-performance-chart',
        data: graph_data,
        xkey: 'y',
        parseTime: false,
        ykeys: ['a'],
        xLabelFormat: function (x) {
            var index = parseInt(x.src.y);
            return monthNames[index];
        },
        xLabels: "month",
        labels: ['Salary'],
        lineColors: ['#a0d0e0'], // '#a0d0e0',#3dbeee','#1ab394'
        resize: true,
        hideHover: 'auto'
    });
}

// user performance graph initiator
function init_admin_performance_graph(graph_data)
{
    graph_data = JSON.parse(graph_data);
    const monthNames = ["", "Jan", "Feb", "Mar", "Apr", "May", "Jun","Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    Morris.Line({
        element: 'admin-performance-chart',
        data: graph_data,
        xkey: 'y',
        parseTime: false,
        ykeys: ['a', 'b', 'c'],
        xLabelFormat: function (x) {
            var index = parseInt(x.src.y);
            return monthNames[index];
        },
        xLabels: "month",
        labels: ['Project Budget', 'User Cost', 'Profil/Loss'],
        hideHover: 'auto',
        resize: true,
        lineColors: ['#54cdb4', '#ed5565', '#f8ac59'],
    });
}

/*$(function() {

    const monthNames = ["", "Jan", "Feb", "Mar", "Apr", "May", "Jun","Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    Morris.Line({
        element: 'user-performance-chart',
        data: [
            {y: 1, a: 10, b: 90, c: 50},
            {y: 2, a: 40, b: 40, c: 10},
            {y: 3, a: 20, b: 60, c: 30},
            {y: 4, a: 60, b: 20, c: 70},
            {y: 5, a: 80, b: 50, c: 50},
            {y: 6, a: 20, b: 70, c: 30}
        ],
        xkey: 'y',
        parseTime: false,
        ykeys: ['a', 'b', 'c'],
        xLabelFormat: function (x) {
            var index = parseInt(x.src.y);
            return monthNames[index];
        },
        xLabels: "month",
        labels: ['Project Budget', 'User Cost', 'Profil/Loss'],
        hideHover: 'auto',
        resize: true,
        lineColors: ['#54cdb4', '#3dbeee', '#1ab394'],
    });

    const monthNames = ["", "Jan", "Feb", "Mar", "Apr", "May", "Jun","Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    Morris.Area({
        element: 'user-performance-chart',
        data: [
            {y: 1, a: 10},
            {y: 2, a: 40},
            {y: 3, a: 20},
            {y: 4, a: 60},
            {y: 5, a: 80},
            {y: 6, a: 20}
        ],
        xkey: 'y',
        parseTime: false,
        ykeys: ['a'],
        xLabelFormat: function (x) {
            var index = parseInt(x.src.y);
            return monthNames[index];
        },
        xLabels: "month",
        labels: ['Salary'],
        lineColors: ['#a0d0e0'], // '#a0d0e0',#3dbeee','#1ab394'
        resize: true,
        hideHover: 'auto'
    });

});*/
