



DROP TABLE IF EXISTS departments;



CREATE TABLE `departments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(100) DEFAULT NULL,
  `name` varchar(300) DEFAULT NULL,
  `reffered` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4;



INSERT INTO `departments` (id,uid,name,reffered,created_at) VALUES ('3','DEP5E41595DB05A57','OPD',NULL,'2020-02-10 18:23:41'),('4','DEP5E415962408311','LAB','yes','2020-02-10 18:23:46'),('5','DEP5E415967ED7721','Delivery',NULL,'2020-02-10 18:23:51'),('6','DEP5E450FD3146394','Xray','yes','2020-02-13 13:58:59'),('7','DEP5E451216046D58','OPD Without Reffered',NULL,'2020-02-13 14:08:38'),('8','DEP5E45122E32F093','Xray Reffered By','yes','2020-02-13 14:09:02');



DROP TABLE IF EXISTS medicines;



CREATE TABLE `medicines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(100) DEFAULT NULL,
  `id_number` varchar(100) DEFAULT NULL,
  `name` varchar(300) DEFAULT NULL,
  `generic_name` varchar(300) DEFAULT NULL,
  `cost` float(25,2) NOT NULL,
  `profit` float(19,2) NOT NULL,
  `expiry_date` date DEFAULT NULL,
  `expiry_alert` int(11) NOT NULL,
  `qty_alert` int(15) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;



INSERT INTO `medicines` (id,uid,id_number,name,generic_name,cost,profit,expiry_date,expiry_alert,qty_alert,created_at) VALUES ('1','MED891273JKHJKHK987239','12345','Panadol Extra','Panadol','20','5','2020-02-15','2','10','2020-02-11 13:51:17'),('2','MED5E427E36AD17A1','1122','Nims','Nims','10','4','2020-02-15','2','10','2020-02-11 15:13:10'),('3','MED5E43E45A392FE1','11446','CAC2+','Calcium Tablet','25','6','2020-02-15','1','50','2020-02-12 16:41:14'),('4','MED5E4524B28F22D4','123','Serbix','Serbix Z','10','5','2020-02-15','2','20','2020-02-13 15:28:02');



DROP TABLE IF EXISTS purchases;



CREATE TABLE `purchases` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(100) NOT NULL,
  `medicine` varchar(100) DEFAULT NULL,
  `qty` int(15) DEFAULT NULL,
  `cost` float(25,2) NOT NULL,
  `profit` float(25,2) NOT NULL,
  `vender_name` varchar(300) DEFAULT NULL,
  `invoice_number` varchar(300) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4;



INSERT INTO `purchases` (id,uid,medicine,qty,cost,profit,vender_name,invoice_number,created_at) VALUES ('1','MEDP78236JKHKJH78788889JKJK','MED891273JKHJKHK987239','100','5','2','Ali Shah','11225','2020-02-11 13:52:50'),('2','MEDP5E428717D3E359','MED891273JKHJKHK987239','200','10','1','Ali Shah','112233','2020-02-11 15:51:03'),('8','MEDP5E43C400A91D84','MED891273JKHJKHK987239','100','10','2','Ali Shah','10023','2020-02-12 14:23:12'),('9','MEDP5E43C4120F9EC2','MED5E427E36AD17A1','200','15','2','Ali Shah','100028','2020-02-12 14:23:30'),('10','MEDP5E43E72C3F7459','MED891273JKHJKHK987239','100','20','5','Ali Shah','asdasd','2020-02-12 16:53:16'),('11','MEDP5E43E7631EEC41','MED5E427E36AD17A1','200','10','4','Ali Shah','asdasd','2020-02-12 16:54:11'),('12','MEDP5E43E77BC26DA9','MED5E43E45A392FE1','250','25','6','Ali Shah','chasjh','2020-02-12 16:54:35'),('13','MEDP5E45254B6246D0','MED5E4524B28F22D4','200','10','5','Ali Shah','12345','2020-02-13 15:30:35');



DROP TABLE IF EXISTS reception;



CREATE TABLE `reception` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(100) NOT NULL,
  `patient_id` int(25) NOT NULL,
  `name` varchar(300) DEFAULT NULL,
  `father_name` varchar(300) DEFAULT NULL,
  `age` int(11) NOT NULL,
  `gender` varchar(100) DEFAULT NULL,
  `department` varchar(100) DEFAULT NULL,
  `sub_department` text,
  `discount` float(20,2) NOT NULL,
  `total_amount` float(30,2) NOT NULL,
  `paid_amount` float(30,2) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4;



INSERT INTO `reception` (id,uid,patient_id,name,father_name,age,gender,department,sub_department,discount,total_amount,paid_amount,created_at) VALUES ('1','REC5E45533F447F08','1','Patient 1','PF 1','20','Male','DEP5E415962408311','{"sub_departments":["DEP5E415A3CEEBC99","DEP5E415A452B8B57","DEP5E415A4E3AEE80"],"reffered_by":["DEP5E43B9DD9F40B6","DEP5E43B9DD9F40B6","DEP5E43B9DD9F40B6"]}','10','600','540','2020-02-13 18:46:39'),('2','REC5E4553D0DF2382','2','Patient 2','PF 2','21','Female','DEP5E41595DB05A57','{"sub_departments":["DEP5E415A15432BA1"],"reffered_by":[null]}','2','1000','980','2020-02-13 18:49:04'),('3','REC5E455415B9B063','3','Patient 3','PF 3','22','Male','DEP5E415962408311','{"sub_departments":["DEP5E415A3CEEBC99","DEP5E415A452B8B57","DEP5E415A4E3AEE80"],"reffered_by":["DEP5E415A15432BA1","DEP5E415A15432BA1","DEP5E43B9DD9F40B6"]}','5','600','570','2020-02-13 18:50:13'),('4','REC5E47C63E9C8951','4','Patient 4','PF 4','30','Male','DEP5E41595DB05A57','{"sub_departments":["DEP5E415A15432BA1"],"reffered_by":[null]}','10','1000','900','2020-02-15 15:21:50'),('5','REC5E47C6761E77A7','5','Patient 5','PT 5','20','Female','DEP5E415967ED7721','{"sub_departments":["DEP5E43B9DD9F40B6"],"reffered_by":[null]}','5','5000','4750','2020-02-15 15:22:46'),('7','REC5E480B5E57E0D3','6','Patient 6','p6','10','Male','DEP5E415962408311','{"sub_departments":["DEP5E415A3CEEBC99","DEP5E415A452B8B57","DEP5E415A4E3AEE80"],"reffered_by":["DEP5E415A15432BA1","DEP5E415A1DDAF3D4","DEP5E415A27C0F232"]}','10','600','540','2020-02-15 20:16:46'),('8','REC5E480C94A5CCA3','8','Patient 8','p8','30','Male','DEP5E41595DB05A57','{"sub_departments":["DEP5E415A1DDAF3D4"],"reffered_by":[null]}','10','2000','1800','2020-02-15 20:21:56');



DROP TABLE IF EXISTS sales;



CREATE TABLE `sales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(100) DEFAULT NULL,
  `reffered_person` varchar(100) DEFAULT NULL,
  `patient_name` varchar(300) DEFAULT NULL,
  `medicines` text,
  `total_amount` float(25,2) NOT NULL,
  `discount` float(25,2) NOT NULL,
  `paid_amount` float(25,2) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;



INSERT INTO `sales` (id,uid,reffered_person,patient_name,medicines,total_amount,discount,paid_amount,created_at) VALUES ('2','SAL5E43D703E9D5D7','DEP5E43B9DD9F40B6','Patient 1','[{"medicine":"MED891273JKHJKHK987239","qty":"10","price":"10"},{"medicine":"MED5E427E36AD17A1","qty":"10","price":"15"},{"medicine":"MED891273JKHJKHK987239","qty":"20","price":"10"}]','450','50','400','2020-02-12 15:44:19'),('3','SAL5E43DC2D8E9002','DEP5E415A15432BA1','Patient 2','[{"medicine":"MED891273JKHJKHK987239","qty":"5","price":"10"},{"medicine":"MED5E427E36AD17A1","qty":"10","price":"15"}]','200','50','150','2020-02-12 16:06:21'),('4','SAL5E4525EF7B4A79','DEP5E45124C75A096','Ali','[{"medicine":"MED5E4524B28F22D4","qty":"50","price":"10"}]','500','50','450','2020-02-13 15:33:19');



DROP TABLE IF EXISTS sub_departments;



CREATE TABLE `sub_departments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(100) DEFAULT NULL,
  `name` varchar(300) DEFAULT NULL,
  `department` varchar(100) DEFAULT NULL,
  `fee` float(30,2) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4;



INSERT INTO `sub_departments` (id,uid,name,department,fee,created_at) VALUES ('2','DEP5E415A15432BA1','OPD SUB 1','DEP5E41595DB05A57','1000','2020-02-10 18:26:45'),('3','DEP5E415A1DDAF3D4','OPD SUB 2','DEP5E41595DB05A57','2000','2020-02-10 18:26:53'),('4','DEP5E415A27C0F232','OPD SUB 3','DEP5E41595DB05A57','3000','2020-02-10 18:27:03'),('5','DEP5E415A3CEEBC99','LAB Test 1','DEP5E415962408311','100','2020-02-10 18:27:24'),('6','DEP5E415A452B8B57','LAB Test 2','DEP5E415962408311','200','2020-02-10 18:27:33'),('7','DEP5E415A4E3AEE80','LAB Test 3','DEP5E415962408311','300','2020-02-10 18:27:42'),('8','DEP5E43B9DD9F40B6','Delivery 1','DEP5E415967ED7721','5000','2020-02-12 13:39:57'),('9','DEP5E450FFDCA83E2','Sub Xray 1','DEP5E450FD3146394','500','2020-02-13 13:59:41'),('10','DEP5E45100EA339F2','Sub Xray 2','DEP5E450FD3146394','1000','2020-02-13 13:59:58'),('11','DEP5E45124C75A096','OPD Wout Reffered 01','DEP5E451216046D58','200','2020-02-13 14:09:32'),('12','DEP5E45126B2C9F70','Xray Reffered 01','DEP5E45122E32F093','500','2020-02-13 14:10:03'),('13','DEP5E47D015EB0A70','Sub Xray 2','DEP5E450FD3146394','100','2020-02-15 16:03:49'),('14','DEP5E47D067F0A584','Sub Xray 3','DEP5E450FD3146394','200','2020-02-15 16:05:11');



DROP TABLE IF EXISTS turnover;



CREATE TABLE `turnover` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(100) DEFAULT NULL,
  `reception_income` float(40,2) NOT NULL,
  `turnover_amount` float(40,2) NOT NULL,
  `reception_remaining` float(40,2) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4;



INSERT INTO `turnover` (id,uid,reception_income,turnover_amount,reception_remaining,created_at) VALUES ('3','TVR5E468DE32D01A6','2090','290','1800','2020-02-14 17:09:07'),('4','TVR5E468F236691F0','1800','100','1700','2020-02-14 17:14:27'),('13','TVR5E47EBBCBAC805','7350','350','7000','2020-02-15 18:01:48');



DROP TABLE IF EXISTS users;



CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(100) DEFAULT NULL,
  `name` varchar(300) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  `email` varchar(300) DEFAULT NULL,
  `username` varchar(200) DEFAULT NULL,
  `password` varchar(200) DEFAULT NULL,
  `address` text,
  `role` varchar(50) DEFAULT NULL,
  `rights` text,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4;



INSERT INTO `users` (id,uid,name,phone,email,username,password,address,role,rights,created_at) VALUES ('1','ADMIN127H8JL7T45FEHH943!','Ali Shah','03087492790','alishah.ue@gmail.com','admin','$2y$10$1gtNFjZsLxziWx2.JwEAQ.B.Zb6CVCNTRdyDar7k1zx/FO5cGxM5u','Maulana Shaukat Ali Road, Mohammadpura Muhammadpura, Lahore, Punjab 54600','ADMIN',NULL,'2020-02-10 14:29:41'),('3','USR5E47E50D079BA9','Ali Testy','03087492790','alitest1@gmail.com','alitest','$2y$10$6yt1ujE8iwdqhRR5gNlGP.jsnhlvQ7lJ2qVSfW8dIXNnqbPLZmnMu','Lahore Pakistan','USER','["departments","sub_departments","reception","purchases"]','2020-02-15 17:33:17');



