<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'accounts'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'accounts'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <?php if(check_user_access('add_account') === TRUE){ ?>
                <a href="<?php echo url('/accounts/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'add_new_account'); ?></a>
            <?php } ?>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">

    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">
                    <form id="accounts-search-form" action="<?= url('/accounts'); ?>">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'accounts_root_filter'); ?></label>
                                    <select class="form-control chosen-select" name="root">
                                        <option value="" selected="">-- <?= print_lang($app_lang,'accounts_root_filter'); ?> --</option>
                                        <?php foreach($root_accounts as $row){ ?>
                                            <option value="<?= $row['uid']; ?>" <?php if($search_root == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4 text-right m-0" style="margin-top: 23px;">
                                <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'accounts_listing'); ?></h2>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'code'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'email'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'under_ac'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'memo'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'opening_balance'); ?></th>
                                    <th class="text-center" style="min-width:120px;"><?= print_lang($app_lang,'action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; foreach($records as $row){ ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= $row['code']; ?></td>

                                        <!-- handle general accounts names according to language -->
                                        <?php
                                        if($row['branch'] == 'general')
                                        {
                                            $account_name = print_lang($app_lang,'builtin_account_'.$row['uid']);
                                        }
                                        else
                                        {
                                            $account_name = $row['name'];
                                        }
                                        ?>

                                        <td><?= $account_name; ?></td>
                                        <td><?= $row['email']; ?></td>


                                        <?php
                                        if($row['type'] == 'root')
                                        {
                                            $account_type = 'Root';
                                        }
                                        else
                                        {
                                            $account_type = array_key_exists($row['type'], $pageData) ? $pageData[$row['type']]['name'] : 'Unknown';
                                            if(array_key_exists($row['type'], $pageData))
                                            {
                                                if($pageData[$row['type']]['branch'] == 'general')
                                                {
                                                    $account_type = print_lang($app_lang,'builtin_account_'.$pageData[$row['type']]['uid']);
                                                }
                                                else
                                                {
                                                    $account_type = $pageData[$row['type']]['name'];
                                                }
                                            }
                                            else
                                            {
                                                $account_type = 'Unknown';
                                            }
                                        }
                                        ?>

                                        <td><?= $account_type; ?></td>
                                        <td><?= $row['memo']; ?></td>

                                        <?php
                                        if(empty($row['opening_balance']))
                                        {
                                            $opening_balances = array();
                                        }
                                        else
                                        {
                                            $opening_balances = json_decode($row['opening_balance'],true);
                                        }
                                        ?>

                                        <td>
                                            <?php foreach($opening_balances as $obrow){ ?>
                                                <span>Debit: <?= $obrow['ob_debit']; ?></span>&nbsp;
                                                <span>Credit: <?= $obrow['ob_credit']; ?></span>&nbsp;
                                                <span>Currency: <?= array_key_exists($obrow['currency'], $currencies) ? $currencies[$obrow['currency']]['name'] : NULL; ?></span>
                                                <br>
                                            <?php } ?>
                                        </td>
                                        
                                        <td>
                                            <?php if($row['branch'] == 'general'){ echo '<span class="label label-primary">System Defined</span>'; }else{ ?>
                                                <?php if(check_user_access('edit_account') === TRUE){ ?>
                                                    <a href="<?= url('/accounts/edit').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-primary url-elem"><i class="fa fa-pencil">&nbsp; </i><?= print_lang($app_lang,'edit'); ?></a>
                                                <?php } ?>
                                                <?php if(empty($row['employee_uid'])){?>
                                                    <?php if(strpos($row['uid'],"SAFEACCOUNT") === FALSE){ ?>
                                                    <?php if(strpos($row['uid'],"CASHSALE") === FALSE){ ?>
                                                        <?php if(check_user_access('delete_account') === TRUE){ ?>
                                                            <a href="<?= url('/accounts/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                                        <?php } ?>
                                                    <?php } ?>
                                                <?php } ?>
                                                <?php } ?>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>