<?php if(is_sales_man_user() === true){ ?>
<style type="text/css">
  .navbar-default.navbar-static-side{display: none !important;}
  #page-wrapper{width: 100%; margin: 0;}
  .footer.fixed{margin: 0;}
</style>
<?php } ?>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'activity_view_title'); ?></h2>
                    <hr>
                    <form id="activities-search-form" action="<?= url('/activities'); ?>">
                    <div class="row">
                        <div class="col-md-3" style="padding: 2px;">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'currency'); ?></label>
                                <select class="form-control chosen-select" name="currency">
                                    <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                    <?php foreach($currencies as $row){ ?>
                                        <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2" style="padding: 2px;">
                            <div class="form-group">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'from'); ?></label>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                <?php } ?>
                            </div>
                            </div>
                        </div>
                        <div class="col-md-2" style="padding: 2px;">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'to'); ?></label>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-2" style="padding: 2px;">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'activity_view_thead_status'); ?></label>
                                <select class="form-control chosen-select" name="status">
                                    <option value="" selected="">-- <?= print_lang($app_lang,'activity_view_thead_status'); ?> --</option>
                                    <option value="pending" <?php if($search_status == 'pending'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'activity_view_thead_status_pending'); ?></option>
                                    <option value="approved" <?php if($search_status == 'approved'){ echo 'selected="selected"'; } ?>><?= print_lang($app_lang,'activity_view_thead_status_approved'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width:40px;"><?= print_lang($app_lang,'activity_view_thead_num'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activity_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activity_view_thead_currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activity_view_thead_amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activity_view_thead_narration'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activity_view_thead_status'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activity_view_thead_action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; $total = array(); foreach($pageData as $row){
                                    $currency_symbol = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['symbol'] : NULL;
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $currency_symbol; ?></td>
                                        <td><?= amount_number_format((float)$row['amount']); $total[] = (float)$row['amount']; ?></td>
                                        <td><?= ucfirst($row['narration']); ?></td>
                                        <?php
                                            if($row['status'] == 'pending'){ $class_span = 'badge badge-warning'; }
                                            if($row['status'] == 'approved'){ $class_span = 'badge badge-primary'; }
                                        ?>
                                        <td>
                                            <span class="<?= $class_span; ?>"><?= print_lang($app_lang,'activity_view_thead_status_'.$row['status']); ?></span>
                                        </td>
                                        <td>
                                            <?php
                                            if($row['status'] == 'pending'){ ?>
                                                <a href="<?= url('/activities/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                    <tr class="text-center">
                                        <td></td>
                                        <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                        <td></td>
                                        <td><strong><?= amount_number_format(array_sum($total)); ?></strong></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>