<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'receipts_approved_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'receipts_approved_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'receipts_approved_view_title'); ?></h2>
                    
                    <form id="receipts-approvad-search-form" action="<?= url('/approved'); ?>">
                    <div class="row">
                        <div class="col-md-11">
                            <div class="row">
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'receipts_approval_view_filter_account'); ?></label>
                                        <select class="form-control chosen-select" name="account">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'receipts_approval_view_filter_account'); ?> --</option>
                                            <?php foreach($sales_man as $row){ ?>
                                                <option <?php if($search_account == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name'].' '.$row['last_name'].'(sales man)'; ?></option>
                                            <?php } ?>
                                            <?php foreach($marketers as $row){ ?>
                                                <option <?php if($search_account == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name'].' '.$row['last_name'].'(marketer)'; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?></label>
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'select_currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'convert_currency'); ?></label>
                                        <select class="form-control chosen-select" name="convert_currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'convert_currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_convert_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'from'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'to'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>

                                <div class="col-md-2 text-right" style="margin-top: 23px;">
                                    <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-1" style="margin-top: 23px;">
                            <a target="_blank" href="<?= url('/approved-print').'?'.'account='.$search_account.'&currency='.$search_currency.'&from='.$search_from.'&to='.$search_to.'&convert_currency='.$search_convert_currency.''; ?>" class="btn btn-outline btn-primary dim"><i class="fa fa-print"></i></a>
                        </div>
                    </div>
                    </form>
                    <hr>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-custom" style="width: 140%;">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'receipts_approved_view_thead_sr'); ?></th>
                                    <th class="text-center" style="width: 100px; min-width: 100px;"><?= print_lang($app_lang,'receipts_approved_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'receipts_approved_view_thead_client'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'receipts_approved_view_thead_details'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'receipts_approved_view_thead_amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'receipts_approved_view_thead_rate'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'receipts_approved_view_thead_ex_amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'receipts_approved_view_thead_db_account'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'receipts_approved_view_thead_requested_by'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'receipts_approved_view_submitted_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'receipts_approved_view_approved_date'); ?></th>
                                    <th class="text-center" style="width: 120px; min-width: 120px;"><?= print_lang($app_lang,'receipts_approved_view_thead_approved_by'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $i = 1; 
                                $total = array(); 
                                $total_ex = array(); 
                                foreach($pageData as $row){
                                    $currency_show = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['symbol'] : NULL;
                                    $currency_exchange_show = array_key_exists($row['exchange_currency'], $currencies) ? $currencies[$row['exchange_currency']]['symbol'] : NULL;
                                    $amount = $row['amount'];
                                    $amount_ex = $row['exchange_amount'];
                                    if(!empty($search_convert_currency))
                                    {
                                        $convert_currency_record = fetch_table_where('currency','uid',$search_convert_currency,true);
                                        $currency_show = $convert_currency_record['symbol'];
                                        $amount_currency_equalance = $row['currency_usd_equalance'];
                                        $convert_currency_equalance = $convert_currency_record['usd_equalance'];
                                        if($row['currency'] == $search_convert_currency)
                                        {
                                            $amount_currency_equalance = 1;
                                            $convert_currency_equalance = 1;
                                        }
                                        $amount = amount_conversion($row['amount'], $amount_currency_equalance, $convert_currency_equalance);
                                    }
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date($row['created_at']); ?></td>
                                        <td><?= array_key_exists($row['client'], $clients) ? $clients[$row['client']]['name'] : NULL; ?></td>
                                        <td><?= 'Receipt #'.$row['invoice'].' '.ucfirst($row['details']); ?></td>
                                        <td><?= $currency_show.' '.amount_number_format($amount); $total[] = $amount; ?></td>
                                        <td><?= amount_number_format($row['rate']); ?></td>
                                        <td><?= $currency_exchange_show.' '.amount_number_format($amount_ex); $total_ex[] = $amount_ex; ?></td>
                                        <td><?php echo array_key_exists($row['debit_account'], $accounts) ? $accounts[$row['debit_account']]['name'] : NULL;?></td>
                                        
                                        <?php

                                            if($row['user_type'] == 'marketer')
                                            {
                                                $requested_by = array_key_exists($row['marketer'], $marketers) ? $marketers[$row['marketer']]['name'].' (marketer)' : NULL;
                                            }
                                            else
                                            {
                                                $requested_by = array_key_exists($row['sales_man'], $sales_man) ? $sales_man[$row['sales_man']]['name'].' (sales man)' : NULL;
                                            }

                                        ?>
                                        <td><?= $requested_by; ?></td>
                                        
                                        <td><?= display_true_date($row['submitted_date']); ?><br><?php echo date('H:i:s',strtotime($row['submitted_date'])); ?></td>
                                        <td><?= display_true_date($row['approved_date']); ?><br><?php echo date('H:i:s',strtotime($row['approved_date'])); ?></td>
                                        <td><?= array_key_exists($row['approved_by'], $users) ? $users[$row['approved_by']]['name'] : NULL; ?></td>
                                        
                                    </tr>
                                <?php } ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(date('Y-m-d')); ?></td>
                                        <td></td>
                                        <td></td>
                                        <td><strong><?= amount_number_format(array_sum($total));?></strong></td>
                                        <td></td>
                                        <td><strong><?= amount_number_format(array_sum($total_ex));?></strong></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>