<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'activities_approval_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'activities_approval_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'activities_approval_view_title'); ?></h2>
                    
                    <form id="activities-approval-search-form" action="<?= url('/approvals/activities'); ?>">
                        <div class="row">

                            <div class="col-md-3 pd2">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'activities_approval_view_filter_account'); ?></label>
                                    <select class="form-control chosen-select" name="account">
                                        <option value="" selected="">-- <?= print_lang($app_lang,'activities_approval_view_filter_account'); ?> --</option>
                                        <?php foreach($sales_man as $row){ ?>
                                            <option <?php if($search_account == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name'].' '.$row['last_name'].'(sales man)'; ?></option>
                                        <?php } ?>
                                        <?php foreach($marketers as $row){ ?>
                                            <option <?php if($search_account == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name'].' '.$row['last_name'].'(marketer)'; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-2 pd2">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'currency'); ?></label>
                                    <select class="form-control chosen-select" name="currency">
                                        <?php foreach($currencies as $row){ ?>
                                            <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                            <?php 
                            $search_exchange_currency = isset($search_exchange_currency) ? $search_exchange_currency : $search_currency;
                            ?>
                            <div class="col-md-2 pd2">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'activities_approval_view_thead_exchange_currency'); ?></label>
                                    <select class="form-control chosen-select activities-approval-exchange-currency" name="exchange_currency">
                                        <?php foreach($currencies as $row){ ?>
                                            <option value="<?= $row['uid']; ?>" <?php if($search_exchange_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-2 pd2">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'activities_approval_view_thead_exchange_rate'); ?> <strong class="text-danger">*</strong></label>
                                    <input type="text" class="form-control" name="rate" id="activities-rate" value="1" placeholder="<?= print_lang($app_lang,'activities_approval_view_thead_exchange_rate'); ?>">
                                </div>
                            </div>

                            <div class="col-md-3 pd2">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'activities_approval_view_thead_exchange_formula'); ?></label>
                                    <div style="margin-top: 10px;">
                                        <label class="checkbox-inline i-checks">
                                            <input type="radio" name="activities_formula" value="multiply" checked> &nbsp;&nbsp;&nbsp; <?= print_lang($app_lang,'activities_approval_view_thead_exchange_formula_multiply'); ?>
                                        </label>
                                        <label class="checkbox-inline i-checks" style="margin-left: 30px;">
                                            <input type="radio" name="activities_formula" value="divide"> &nbsp;&nbsp;&nbsp; <?= print_lang($app_lang,'activities_approval_view_thead_exchange_formula_divide'); ?>
                                        </label>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><?= print_lang($app_lang,'activities_approval_view_thead_cr_account'); ?></label>
                                    <select class="form-control chosen-select" name="debit_account" id="activities-default-account">
                                        <option value="" selected="">-- <?= print_lang($app_lang,'activities_approval_view_thead_cr_account'); ?> --</option>
                                        <?php foreach($accounts as $row){ ?>
                                            <option value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-2 text-right" style="margin-top: 23px;">
                                <button class="btn btn-w-m btn-danger activities-pending-item" type="button" data-url="<?= url('/approvals/update-status'); ?>"><?= print_lang($app_lang,'activities_approval_view_thead_approve_btn'); ?></button>
                            </div>

                            <div class="col-md-2 text-right" style="margin-top: 23px;">
                                <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            </div>
                        </div>
                    </form>
                    
                    <hr>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width: 50px;"> <input type="checkbox" id="activities-check-all" style="margin: 5px;" name=""><?= print_lang($app_lang,'activities_approval_view_thead_sr'); ?></th>
                                    <th class="text-center" style="min-width: 80px;"><?= print_lang($app_lang,'activities_approval_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activities_approval_view_thead_requested_by'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activities_approval_view_thead_amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activities_approval_view_thead_narration'); ?></th>
                                    <th class="text-center" style="min-width:120px;"><?= print_lang($app_lang,'activities_approval_view_thead_action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; $total = array(); foreach($pageData as $row){
                                    $currency_show = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['symbol'] : NULL;
                                ?>
                                    <tr class="text-center activities-approval-row">
                                        <td><input type="checkbox" style="margin: 5px;" class="activities-approval-checkbox" name="approval_checkbox" value="<?= $row['uid']; ?>"><?= $i++; ?></td>
                                        <td><?= display_true_date($row['created_at']); ?></td>
                                        <?php

                                            if($row['user_type'] == 'marketer')
                                            {
                                                $requested_by = array_key_exists($row['marketer'], $marketers) ? $marketers[$row['marketer']]['name'].' '.$marketers[$row['marketer']]['last_name'].' (marketer)' : NULL;
                                            }
                                            else
                                            {
                                                $requested_by = array_key_exists($row['salesman'], $sales_man) ? $sales_man[$row['salesman']]['name'].' '.$sales_man[$row['salesman']]['last_name'].' (sales man)' : NULL;
                                            }

                                        ?>
                                        <td><?= $requested_by; ?></td>
                                        <td><?= $currency_show.' '.amount_number_format((float)$row['amount']); $total[] = (float)$row['amount']; ?></td>
                                        <td><?= ucfirst($row['narration']); ?></td>
                                        <td>
                                            <?php if(check_user_access('delete_account') === TRUE){ ?>
                                                <a href="<?= url('/activities/delete').'/'.$row['uid']; ?>" class="btn btn-xs btn-outline btn-danger delete-btn-trigger" data-msg="You will not be able to revert this" data-mood="Delete"><i class="fa fa-trash"></i>&nbsp; <?= print_lang($app_lang,'delete'); ?></a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                    <tr class="text-center">
                                        <td>--</td>
                                        <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                        <td>--</td>
                                        <td><strong><?= amount_number_format(array_sum($total));?></strong></td>
                                        <td>--</td>
                                        <td>--</td>
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>