<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'activities_approved_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'activities_approved_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'activities_approved_view_title'); ?></h2>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <form id="activities-approvad-search-form" action="<?= url('/approvals/activities-approved'); ?>">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'activities_approved_view_filter_account'); ?></label>
                                        <select class="form-control chosen-select" name="account">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'activities_approved_view_filter_account'); ?> --</option>
                                            <?php foreach($sales_man as $row){ ?>
                                                <option <?php if($search_account == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name'].' '.$row['last_name'].'(sales man)'; ?></option>
                                            <?php } ?>
                                            <?php foreach($marketers as $row){ ?>
                                                <option <?php if($search_account == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['name'].' '.$row['last_name'].'(marketer)'; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?></label>
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'from'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-2" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'to'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-2 text-right" style="margin-top: 23px;">
                                    <button class="btn btn-w-m btn-primary custom-font-btn-search" style="width: 100%;" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                                </div>
                            </div>
                            </form>
                        </div>
                    </div>
                    <hr>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center" style="min-width: 50px;"><?= print_lang($app_lang,'activities_approved_view_thead_sr'); ?></th>
                                    <th class="text-center" style="min-width: 80px;"><?= print_lang($app_lang,'activities_approved_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activities_approved_view_thead_requested_by'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activities_approved_view_thead_approved_by'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activities_approved_view_thead_approved_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activities_approved_view_thead_amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activities_approved_view_thead_rate'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activities_approved_view_thead_ex_amount'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'activities_approved_view_thead_narration'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; $total = array(); $total_ex = array(); foreach($pageData as $row){
                                    $currency_show = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['symbol'] : NULL;
                                    $currency_show_exchange = array_key_exists($row['exchange_currency'], $currencies) ? $currencies[$row['exchange_currency']]['symbol'] : NULL;
                                ?>
                                    <tr class="text-center activities-approval-row">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date($row['created_at']); ?></td>
                                        <?php

                                            if($row['user_type'] == 'marketer')
                                            {
                                                $requested_by = array_key_exists($row['marketer'], $marketers) ? $marketers[$row['marketer']]['name'].' '.$marketers[$row['marketer']]['last_name'].' (marketer)' : NULL;
                                            }
                                            else
                                            {
                                                $requested_by = array_key_exists($row['salesman'], $sales_man) ? $sales_man[$row['salesman']]['name'].' '.$sales_man[$row['salesman']]['last_name'].' (sales man)' : NULL;
                                            }

                                        ?>
                                        <td><?= $requested_by; ?></td>
                                        <td><?= array_key_exists($row['approved_by'], $users) ? $users[$row['approved_by']]['name'] : NULL; ?></td>
                                        <td><?= display_true_date($row['approved_date']); ?>&nbsp;&nbsp;<?php echo date('H:i:s',strtotime($row['approved_date'])); ?></td>
                                        <td><?= $currency_show.' '.amount_number_format((float)$row['amount']); $total[] = (float)$row['amount']; ?></td>
                                        <td><?= amount_number_format((float)$row['rate']); ?></td>
                                        <td><?= $currency_show_exchange.' '.amount_number_format((float)$row['exchange_amount']); $total_ex[] = (float)$row['exchange_amount']; ?></td>
                                        <td><?= ucfirst($row['narration']); ?></td>
                                    </tr>
                                <?php } ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                        <td>--</td>
                                        <td>--</td>
                                        <td>--</td>
                                        <td><strong><?= amount_number_format(array_sum($total));?></strong></td>
                                        <td>--</td>
                                        <td><strong><?= amount_number_format(array_sum($total_ex));?></strong></td>
                                        <td>--</td>
                                    </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>