<?php if(is_customer_user() === true){ ?>
<style type="text/css">
  .navbar-default.navbar-static-side{display: none !important;}
  #page-wrapper{width: 100%; margin: 0;}
  .footer.fixed{margin: 0;}
</style>
<?php } ?>
<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-8">
        <h2><?= print_lang($app_lang,'mod_bookings_view_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_bookings_view_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-4">
        <div class="title-action">
            <a href="<?= url('/bookings/add'); ?>" class="btn btn-primary btn-sm custom-font-btn"><i class="fa fa-plus"></i>&nbsp; <?= print_lang($app_lang,'mod_bookings_view_add_btn'); ?></a>
        </div>
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= print_lang($app_lang,'mod_bookings_view_title'); ?></h2>

                    <form id="bookings-search-form" action="<?= url('/bookings/processed'); ?>">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-4" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'currency'); ?></label>
                                        <select class="form-control chosen-select" name="currency">
                                            <option value="" selected="">-- <?= print_lang($app_lang,'currency'); ?> --</option>
                                            <?php foreach($currencies as $row){ ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_currency == $row['uid']){ echo 'selected="selected"'; } ?>><?= $row['name']; ?> (<?= $row['symbol']; ?>)</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4" style="padding: 2px;">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label><?= print_lang($app_lang,'from'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_from); ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= true_date_for_inputs($search_from); ?>">
                                        <?php } ?>
                                    </div>
                                    </div>
                                </div>
                                <div class="col-md-4" style="padding: 2px;">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'to'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= true_date_for_inputs($search_to); ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= true_date_for_inputs($search_to); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_bookings_view_thead_sr'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_bookings_view_thead_date'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_bookings_view_thead_invoice'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_bookings_view_thead_currency'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_bookings_view_thead_total'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_bookings_view_thead_total_p'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'mod_bookings_view_thead_status'); ?></th>
                                    <th class="text-center" style="min-width:190px; max-width:190px;"><?= print_lang($app_lang,'mod_bookings_view_thead_action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $total = array();
                                $total_p = array();
                                ?>
                                <?php $i = 1; foreach($pageData as $row){
                                    $currency_show = array_key_exists($row['currency'], $currencies) ? $currencies[$row['currency']]['name'] : NULL;
                                ?>
                                    <tr class="text-center">
                                        <td><?= $i++; ?></td>
                                        <td><?= display_true_date(explode(' ',$row['created_at'])[0]); ?></td>
                                        <td><?= $row['invoice']; ?></td>
                                        <td><?= $currency_show; ?></td>
                                        <td><?= round_decimels_digits($row['total']); $total[] = (float)$row['total']; ?></td>
                                        <td><?= round_decimels_digits($row['total_p']); $total_p[] = (float)$row['total_p']; ?></td>
                                        <td>
                                            <span class="badge badge-primary"><?php echo print_lang($app_lang,'mod_bookings_add_status_processed'); ?></span>
                                        </td>

                                        <td>
                                            <a href="<?= url('/bookings/invoice-process').'/'.$row['uid']; ?>" target="_blank" class="btn btn-xs btn-outline btn-warning url-elem"><i class="fa fa-external-link"></i>&nbsp;<?= print_lang($app_lang,'invoice'); ?></a>
                                        </td>
                                    </tr>
                                <?php } ?>
                                <tr class="text-center">
                                    <td></td>
                                    <td><strong><?= display_true_date(date('Y-m-d')); ?></strong></td>
                                    <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                    <td></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total)); ?></strong></td>
                                    <td><strong><?= round_decimels_digits(array_sum($total_p)); ?></strong></td>
                                    <td>---</td>
                                    <td>---</td>
                                </tr>
                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>