<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'new_branch_transfer_out'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/branch-transfer-out'); ?>"><?= print_lang($app_lang,'branch_transfer_out'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'new_branch_transfer_out'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="branch-transfer-out-form" action="<?php echo url('/branch-transfer-out/save'); ?>">

                    <div class="row extra-mar-botm">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'item'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="item" id="branch-transfer-out-items">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'item'); ?> --</option>
                                    <?php foreach($items as $row){ ?>
                                        <?php
                                        $row['stats'] = empty($row['stats']) ? array() : json_decode($row['stats'],true);
                                        $ri_warehouse_wise_avail_units = $row['stats']['avail_units'];
                                        // foreach($row['stats']['avail_units'] as $warehouse_uid => $wau){
                                        foreach($ri_warehouse_wise_avail_units as $warehouse_uid => $wau){
                                            $ri_warehouse_name = array_key_exists($warehouse_uid, $warehouses) ? $warehouses[$warehouse_uid]['name'] : NULL;
                                        ?>
                                            <option value="<?= $row['uid']; ?>" data-purchase-unit-equalance="<?= $row['purchase_unit_equalance']; ?>" data-sale-unit-equalance="<?= $row['sale_unit_equalance']; ?>" data-production-unit-equalance="<?= $row['production_unit_equalance']; ?>" data-purchase-unit="<?= array_key_exists($row['purchase_unit'],$units) ? $units[$row['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($row['sale_unit'],$units) ? $units[$row['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($row['production_unit'],$units) ? $units[$row['production_unit']]['name'] : NULL; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>" data-item-name="<?= $row['name']; ?>" data-warehouse="<?= $warehouse_uid; ?>" data-warehouse-name="<?= $ri_warehouse_name; ?>" data-profit="<?= $row['stats']['last_profit']; ?>" data-cost="<?= $row['stats']['avg_cost']; ?>" data-avail-units="<?= $wau; ?>"><?= $row['name']; ?> | <?= $ri_warehouse_name; ?> (AU: <?= $wau; ?>)</option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3 pointer-none">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'warehouse'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="warehouse" id="branch-transfer-out-warehouse">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'warehouse'); ?> --</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'unit'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="unit" id="branch-transfer-out-units">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'unit'); ?> --</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'batch'); ?></label>
                                <select class="form-control chosen-select" name="batch">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_batch'); ?> --</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'qty'); ?> <strong class="text-danger">*</strong></label>
                                <input type="text" class="form-control" name="qty" placeholder="<?= print_lang($app_lang,'qty'); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'to_branch'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="to_branch" id="branch-transfer-out-branch">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'branch'); ?> --</option>
                                    <?php foreach($branches as $row){ if($row['uid'] == $active_branch_id){ continue; } ?>
                                        <option value="<?= $row['uid']; ?>"><?= $row['branch_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'to_warehouse'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="to_warehouse" id="branch-transfer-out-to-warehouse">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'warehouse'); ?> --</option>
                                    <?php foreach($warehouses as $row){ if($row['branch'] == $active_branch_id){ continue; } ?>
                                        <option class="display-none" value="<?= $row['uid']; ?>" data-branch="<?= $row['branch']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'narration'); ?></label>
                                <textarea class="form-control" name="narration" rows="3" placeholder="<?= print_lang($app_lang,'narration'); ?>"></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/branch-transfer-out'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'save'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>