<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/b-to-b-transfer'); ?>"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_breadcrumb'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="b-to-b-transfer-items-form">

                    <div class="row">

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_date'); ?><strong class="text-danger">*</strong> </label>
                                <?php $edate = display_true_date( date('y-m-d') ); ?>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" name="temp_t_date" value="<?= true_date_for_inputs($edate); ?>" placeholder="<?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="temp_t_date" value="<?= date("Y-m-d",strtotime(true_date_for_inputs($edate))); ?>">
                                <?php } ?>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_item'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="temp_item">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                    <?php $icount = 1; foreach($items as $row){ ?>
                                        <?php
                                        $row['stats'] = empty($row['stats']) ? array() : json_decode($row['stats'],true);
                                        $ri_warehouse_wise_avail_units = $row['stats']['avail_units'];
                                        foreach($ri_warehouse_wise_avail_units as $warehouse_uid => $wau){
                                            $ri_warehouse_name = array_key_exists($warehouse_uid, $warehouses) ? $warehouses[$warehouse_uid]['name'] : NULL;
                                        ?>
                                            <option value="<?= $row['uid']; ?>" data-name="<?= $row['name']; ?>" data-width="<?= $row['width']; ?>" data-height="<?= $row['height']; ?>" data-purchase-unit-equalance="<?= $row['purchase_unit_equalance']; ?>" data-sale-unit-equalance="<?= $row['sale_unit_equalance']; ?>" data-production-unit-equalance="<?= $row['production_unit_equalance']; ?>" data-purchase-unit="<?= array_key_exists($row['purchase_unit'],$units) ? $units[$row['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($row['sale_unit'],$units) ? $units[$row['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($row['production_unit'],$units) ? $units[$row['production_unit']]['name'] : NULL; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>" data-item-currency="<?= $row['currency']; ?>" data-opt-ref="item-opt-<?= $icount++; ?>" data-item-name="<?= $row['name']; ?>" data-warehouse="<?= $warehouse_uid; ?>" data-warehouse-name="<?= $ri_warehouse_name; ?>" data-profit="<?= $row['stats']['last_profit']; ?>" data-last-cost="<?= $row['stats']['last_cost']; ?>" data-last-profit="<?= $row['stats']['last_profit']; ?>" data-cost="<?= $row['stats']['avg_cost']; ?>" data-avail-units="<?= $wau; ?>"><?= $row['name'].', '.$row['item_id']; ?> | <?= $ri_warehouse_name; ?> (Avail Units: <?= $wau; ?>)</option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>


                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_batch'); ?></label>
                                <select class="form-control chosen-select" name="temp_batch">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_batch'); ?> --</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_unit'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="temp_unit">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_unit'); ?> --</option>
                                </select>
                            </div>
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_to_branch'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="temp_to_branch">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_to_branch'); ?> --</option>
                                    <?php foreach($branches as $row){
                                        if($row['uid'] == active_branch_id()){continue;}
                                    ?>
                                        <option value="<?= $row['uid']; ?>"><?= $row['branch_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_to_warehouse'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="temp_to_warehouse">
                                    <option disabled="" selected="" data-opt-branch="default">-- <?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_to_warehouse'); ?> --</option>
                                    <?php foreach($warehouses as $row){
                                    ?>
                                        <option class="display-none" data-opt-branch="<?= $row['branch']; ?>" value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_qty'); ?> <strong class="text-danger">*</strong></label>
                                <input type="number" class="form-control" name="temp_qty" placeholder="<?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_qty'); ?>">
                            </div>
                        </div>


                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_details'); ?> </label>
                                <input type="text" class="form-control" name="temp_details" placeholder="<?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_details'); ?>">
                            </div>
                        </div>

                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <button class="btn btn-w-m btn-primary" style="width: 100%;" type="submit"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_to_list'); ?></button>
                        </div>
                    </div>

                </form>


                <form role="form" id="b-to-b-transfer-form" action="<?php echo url('/b-to-b-transfer/save'); ?>">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_table_date'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_table_item'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_table_warehouse'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_table_unit'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_table_batch'); ?></th>
                                            <th class="text-center" style="width: 100px;"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_table_qty'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_table_to_branch'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_table_to_warehouse'); ?></th>
                                            <th class="text-center"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_table_details'); ?></th>
                                            <th class="text-center" style="width: 60px;"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_table_del'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody id="b-to-b-transfer-items-table-body">
                                        
                                    </tbody>
                                </table>    
                            </div>
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-12 text-right">
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'save'); ?></button>
                        </div>
                    </div>

                </form>





            </div>
        </div>
    </div>

</div>
