<div class="row wrapper border-bottom white-bg page-heading">
    <div class="col-lg-10">
        <h2><?= print_lang($app_lang,'mod_branch_to_branch_transfer_edit_breadcrumb'); ?></h2>
        <ol class="breadcrumb">
            <li>
                <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
            </li>
            <li>
                <a class="url-elem" href="<?php echo url('/b-to-b-transfer'); ?>"><?= print_lang($app_lang,'mod_branch_to_branch_transfer_view_breadcrumb'); ?></a>
            </li>
            <li class="active">
                <strong><?= print_lang($app_lang,'mod_branch_to_branch_transfer_edit_breadcrumb'); ?></strong>
            </li>
        </ol>
    </div>
    <div class="col-lg-2">
    </div>
</div>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="ibox-title">
        <h5><?= print_lang($app_lang,'fields_with'); ?> <strong class="text-danger">*</strong> <?= print_lang($app_lang,'are_mandatory'); ?></h5>
    </div>
    <div class="ibox-content">
        <!-- spinner -->
        <div class="sk-spinner sk-spinner-three-bounce">
            <div class="sk-bounce1"></div>
            <div class="sk-bounce2"></div>
            <div class="sk-bounce3"></div>
        </div>
        <!-- spinner -->
        <div class="row">
            <div class="col-sm-12 b-r">
                <form role="form" id="b-to-b-transfer-update-form" action="<?php echo url('/b-to-b-transfer/update').'/'.$editing_data['uid']; ?>">
                    <input type="hidden" name="warehouse" value="<?= $editing_data['warehouse']; ?>">
                    <input type="hidden" name="cost" value="<?= $editing_data['cost']; ?>">
                    <input type="hidden" name="profit" value="<?= $editing_data['profit']; ?>">
                    <div class="row">

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_date'); ?></label>
                                <?php $t_date = display_true_date( explode(' ',$editing_data['t_date'])[0] ); //$t_date = date('Y-m-d',strtotime($t_date)); ?>
                                <?php if($branch_calander == 'persian'){ ?>
                                    <input type="text" class="form-control persian-date" name="t_date" value="<?= true_date_for_inputs($t_date); ?>" placeholder="<?= print_lang($app_lang,'date'); ?>" readonly="" style="background: #fff;">
                                <?php }else{ ?>
                                    <input type="date" class="form-control" name="t_date" value="<?= date("Y-m-d",strtotime(true_date_for_inputs($t_date))); ?>">
                                <?php } ?>
                            </div>

                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_item'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="item">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'select_item'); ?> --</option>
                                    <?php $icount = 1; foreach($items as $row){ ?>
                                        <?php
                                        $row['stats'] = empty($row['stats']) ? array() : json_decode($row['stats'],true);
                                        $ri_warehouse_wise_avail_units = $row['stats']['avail_units'];
                                        foreach($ri_warehouse_wise_avail_units as $warehouse_uid => $wau){
                                            $ri_warehouse_name = array_key_exists($warehouse_uid, $warehouses) ? $warehouses[$warehouse_uid]['name'] : NULL;
                                        ?>
                                            <option <?php if($editing_data['item'] == $row['uid'] AND $editing_data['warehouse'] == $warehouse_uid){echo "selected='selected'";}?> value="<?= $row['uid']; ?>" data-name="<?= $row['name']; ?>" data-width="<?= $row['width']; ?>" data-height="<?= $row['height']; ?>" data-purchase-unit-equalance="<?= $row['purchase_unit_equalance']; ?>" data-sale-unit-equalance="<?= $row['sale_unit_equalance']; ?>" data-production-unit-equalance="<?= $row['production_unit_equalance']; ?>" data-purchase-unit="<?= array_key_exists($row['purchase_unit'],$units) ? $units[$row['purchase_unit']]['name'] : NULL; ?>" data-sale-unit="<?= array_key_exists($row['sale_unit'],$units) ? $units[$row['sale_unit']]['name'] : NULL; ?>" data-production-unit="<?= array_key_exists($row['production_unit'],$units) ? $units[$row['production_unit']]['name'] : NULL; ?>" data-usd-equalance="<?= $row['currency_usd_equalance']; ?>" data-item-currency="<?= $row['currency']; ?>" data-opt-ref="item-opt-<?= $icount++; ?>" data-item-name="<?= $row['name']; ?>" data-warehouse="<?= $warehouse_uid; ?>" data-warehouse-name="<?= $ri_warehouse_name; ?>" data-profit="<?= $row['stats']['last_profit']; ?>" data-last-cost="<?= $row['stats']['last_cost']; ?>" data-last-profit="<?= $row['stats']['last_profit']; ?>" data-cost="<?= $row['stats']['avg_cost']; ?>" data-avail-units="<?= $wau; ?>"><?= $row['name'].', '.$row['item_id']; ?> | <?= $ri_warehouse_name; ?> (Avail Units: <?= $wau; ?>)</option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_batch'); ?></label>
                                <select class="form-control chosen-select" name="batch">
                                    <?php 
                                    $items_batch = get_item_warehouse_wise_batch($editing_data['item'],$editing_data['warehouse']);
                                    ?>
                                    
                                    <?php foreach($items_batch as $row){ ?>
                                        <option <?php if($editing_data['batch'] == $row['batch']){ echo 'selected="selected"'; } ?> value="<?= $row['batch']; ?>"><?= $row['batch'].' ('.$row['stock_ava'].')'; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <?php
                            $item_data = fetch_table_where('items','uid',$editing_data['item'],true);
                            $item_purchase_unit = fetch_table_where('units','uid',$item_data['purchase_unit'],true);
                            $item_sale_unit = fetch_table_where('units','uid',$item_data['sale_unit'],true);
                            $item_production_unit = fetch_table_where('units','uid',$item_data['production_unit'],true);
                        ?>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_unit'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="unit">
                                    <option <?php if($editing_data['unit'] == 'purchase'){echo "selected='selected'";}?> value="purchase"><?= $item_purchase_unit['name']; ?></option>
                                    <option <?php if($editing_data['unit'] == 'sale'){echo "selected='selected'";}?> value="sale"><?= $item_sale_unit['name']; ?></option>
                                    <option <?php if($editing_data['unit'] == 'production'){echo "selected='selected'";}?> value="production"><?= $item_production_unit['name']; ?></option>
                                </select>
                            </div>
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_to_branch'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="to_branch">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_to_branch'); ?> --</option>
                                    <?php foreach($branches as $row){
                                        if($row['uid'] == active_branch_id()){continue;}
                                    ?>
                                        <option <?php if($editing_data['to_branch'] == $row['uid']){echo "selected='selected'";}?> value="<?= $row['uid']; ?>"><?= $row['branch_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_to_warehouse'); ?> <strong class="text-danger">*</strong></label>
                                <select class="form-control chosen-select" name="to_warehouse">
                                    <option disabled="" selected="">-- <?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_to_warehouse'); ?> --</option>
                                    <?php foreach($warehouses as $row){
                                    ?>
                                        <option <?php if($editing_data['to_warehouse'] == $row['uid']){echo "selected='selected'";}?> <?php if($editing_data['to_branch'] != $row['branch']){echo 'class="display-none"';}?> data-opt-branch="<?= $row['branch']; ?>" value="<?= $row['uid']; ?>"><?= $row['name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_qty'); ?> <strong class="text-danger">*</strong></label>
                                <input type="number" class="form-control" name="qty" value="<?= $editing_data['qty']; ?>" placeholder="<?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_qty'); ?>">
                            </div>
                        </div>


                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_details'); ?> </label>
                                <input type="text" class="form-control" name="details" value="<?= $editing_data['details']; ?>" placeholder="<?= print_lang($app_lang,'mod_branch_to_branch_transfer_add_details'); ?>">
                            </div>
                        </div>

                    </div>

                    <div class="row extra-mar-botm">
                        <div class="col-md-12 text-right">
                            <a class="btn btn-w-m btn-outline btn-danger url-elem" href="<?php echo url('/b-to-b-transfer'); ?>"><?= print_lang($app_lang,'cancel'); ?></a>
                            <button class="btn btn-w-m btn-primary" type="submit"><?= print_lang($app_lang,'update'); ?></button>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

</div>
